/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.kubernetes.KubernetesClient;
import com.hazelcast.kubernetes.RetryUtils;
import java.util.concurrent.Callable;

class RetryKubernetesClient
implements KubernetesClient {
    private static final int DEFAULT_RETRIES = 10;
    private final KubernetesClient kubernetesClient;
    private final int retries;

    RetryKubernetesClient(KubernetesClient kubernetesClient, int retries) {
        this.kubernetesClient = kubernetesClient;
        this.retries = retries;
    }

    RetryKubernetesClient(KubernetesClient kubernetesClient) {
        this(kubernetesClient, 10);
    }

    @Override
    public KubernetesClient.Endpoints endpoints(final String namespace) {
        return RetryUtils.retry(new Callable<KubernetesClient.Endpoints>(){

            @Override
            public KubernetesClient.Endpoints call() throws Exception {
                return RetryKubernetesClient.this.kubernetesClient.endpoints(namespace);
            }
        }, this.retries);
    }

    @Override
    public KubernetesClient.Endpoints endpointsByLabel(final String namespace, final String serviceLabel, final String serviceLabelValue) {
        return RetryUtils.retry(new Callable<KubernetesClient.Endpoints>(){

            @Override
            public KubernetesClient.Endpoints call() throws Exception {
                return RetryKubernetesClient.this.kubernetesClient.endpointsByLabel(namespace, serviceLabel, serviceLabelValue);
            }
        }, this.retries);
    }

    @Override
    public KubernetesClient.Endpoints endpointsByName(final String namespace, final String endpointName) {
        return RetryUtils.retry(new Callable<KubernetesClient.Endpoints>(){

            @Override
            public KubernetesClient.Endpoints call() throws Exception {
                return RetryKubernetesClient.this.kubernetesClient.endpointsByName(namespace, endpointName);
            }
        }, this.retries);
    }
}

