/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spark.connector.rdd;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spark.connector.conf.SerializableConf;
import com.hazelcast.spark.connector.iterator.CacheIterator;
import com.hazelcast.spark.connector.iterator.MapIterator;
import com.hazelcast.spark.connector.rdd.PartitionLocationInfo;
import com.hazelcast.spark.connector.util.ConnectionUtil$;
import com.hazelcast.spark.connector.util.HazelcastUtil$;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u00015\u0011A\u0002S1{K2\u001c\u0017m\u001d;S\t\u0012S!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\u0013!\f'0\u001a7dCN$(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0016\u00079\t3f\u0005\u0002\u0001\u001fA\u0019\u0001cF\r\u000e\u0003EQ!a\u0001\n\u000b\u0005\u001d\u0019\"B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001eL!\u0001G\t\u0003\u0007I#E\t\u0005\u0003\u001b;}QS\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\rQ+\b\u000f\\33!\t\u0001\u0013\u0005\u0004\u0001\u0005\u000b\t\u0002!\u0019A\u0012\u0003\u0003-\u000b\"\u0001J\u0014\u0011\u0005i)\u0013B\u0001\u0014\u001c\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0007\u0015\n\u0005%Z\"aA!osB\u0011\u0001e\u000b\u0003\u0006Y\u0001\u0011\ra\t\u0002\u0002-\"Aa\u0006\u0001BC\u0002\u0013\u0005q&\u0001\u0002tGV\t\u0001\u0007\u0005\u00022e5\t!#\u0003\u00024%\ta1\u000b]1sW\u000e{g\u000e^3yi\"AQ\u0007\u0001B\u0001B\u0003%\u0001'A\u0002tG\u0002B#\u0001N\u001c\u0011\u0005iA\u0014BA\u001d\u001c\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005<\u0001\t\u0015\r\u0011\"\u0001=\u0003\u0019A'PT1nKV\tQ\b\u0005\u0002?\u0003:\u0011!dP\u0005\u0003\u0001n\ta\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001i\u0007\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005{\u00059\u0001N\u001f(b[\u0016\u0004\u0003\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\u0002\u000f%\u001c8)Y2iKV\t\u0011\n\u0005\u0002\u001b\u0015&\u00111j\u0007\u0002\b\u0005>|G.Z1o\u0011!i\u0005A!A!\u0002\u0013I\u0015\u0001C5t\u0007\u0006\u001c\u0007.\u001a\u0011\t\u0011=\u0003!Q1A\u0005\u0002A\u000baaY8oM&<W#A)\u0011\u0005I+V\"A*\u000b\u0005Q#\u0011\u0001B2p]\u001aL!AV*\u0003!M+'/[1mSj\f'\r\\3D_:4\u0007\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002\u000f\r|gNZ5hA!)!\f\u0001C\u00017\u00061A(\u001b8jiz\"R\u0001\u00180`A\u0006\u0004B!\u0018\u0001 U5\t!\u0001C\u0003/3\u0002\u0007\u0001\u0007C\u0003<3\u0002\u0007Q\bC\u0003H3\u0002\u0007\u0011\nC\u0003P3\u0002\u0007\u0011\u000b\u0003\u0005d\u0001!\u0015\r\u0011\"\u0001e\u0003MA\u0017M_3mG\u0006\u001cH\u000fU1si&$\u0018n\u001c8t+\u0005)\u0007\u0003\u00024l[vj\u0011a\u001a\u0006\u0003Q&\fq!\\;uC\ndWM\u0003\u0002k7\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051<'aA'baB\u0011!D\\\u0005\u0003_n\u00111!\u00138u\u0011!\t\b\u0001#A!B\u0013)\u0017\u0001\u00065bu\u0016d7-Y:u!\u0006\u0014H/\u001b;j_:\u001c\b\u0005\u000b\u0002qo!)A\u000f\u0001C!k\u000691m\\7qkR,G#\u0002<\u0002\u0006\u0005=\u0001cA<\u000039\u0011\u00010 \b\u0003srl\u0011A\u001f\u0006\u0003w2\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005y\\\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\t\u0019A\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\tq8\u0004C\u0004\u0002\bM\u0004\r!!\u0003\u0002\u000bM\u0004H.\u001b;\u0011\u0007E\nY!C\u0002\u0002\u000eI\u0011\u0011\u0002U1si&$\u0018n\u001c8\t\u000f\u0005E1\u000f1\u0001\u0002\u0014\u000591m\u001c8uKb$\bcA\u0019\u0002\u0016%\u0019\u0011q\u0003\n\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0015\u0004g\u0006m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005\"#\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002 \taA)\u001a<fY>\u0004XM]!qS\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012aD2p[B,H/Z%oi\u0016\u0014h.\u00197\u0015\u0007Y\fi\u0003\u0003\u0005\u0002\b\u0005\u001d\u0002\u0019AA\u0005\u0011\u001d\t\t\u0004\u0001C)\u0003g\tQbZ3u!\u0006\u0014H/\u001b;j_:\u001cXCAA\u001b!\u0015Q\u0012qGA\u0005\u0013\r\tId\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003{\u0001A\u0011KA \u0003U9W\r\u001e)sK\u001a,'O]3e\u0019>\u001c\u0017\r^5p]N$B!!\u0011\u0002HA!q/a\u0011>\u0013\u0011\t)%a\u0001\u0003\u0007M+\u0017\u000f\u0003\u0005\u0002\b\u0005m\u0002\u0019AA\u0005\u0001")
public class HazelcastRDD<K, V>
extends RDD<Tuple2<K, V>> {
    private final transient SparkContext sc;
    private final String hzName;
    private final boolean isCache;
    private final SerializableConf config;
    private transient Map<Object, String> hazelcastPartitions;
    private volatile transient boolean bitmap$trans$0;

    /*
     * WARNING - void declaration
     */
    private Map hazelcastPartitions$lzycompute() {
        HazelcastRDD hazelcastRDD = this;
        synchronized (hazelcastRDD) {
            if (!this.bitmap$trans$0) {
                void var3_3;
                HazelcastInstance client = ConnectionUtil$.MODULE$.getHazelcastConnection(this.config().serverAddresses(), this.id(), this.config());
                Map partitions = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                JavaConversions$.MODULE$.asScalaSet(client.getPartitionService().getPartitions()).foreach((Function1)new Serializable(this, partitions){
                    public static final long serialVersionUID = 0L;
                    private final Map partitions$1;

                    public final Option<String> apply(com.hazelcast.core.Partition p) {
                        return this.partitions$1.put((Object)BoxesRunTime.boxToInteger((int)p.getPartitionId()), (Object)new StringBuilder().append((Object)p.getOwner().getAddress().getHost()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)p.getOwner().getAddress().getPort())).toString());
                    }
                    {
                        this.partitions$1 = partitions$1;
                    }
                });
                ConnectionUtil$.MODULE$.closeHazelcastConnection(this.config().serverAddresses(), this.id());
                this.hazelcastPartitions = var3_3;
                this.bitmap$trans$0 = true;
            }
            return this.hazelcastPartitions;
        }
    }

    public SparkContext sc() {
        return this.sc;
    }

    public String hzName() {
        return this.hzName;
    }

    public boolean isCache() {
        return this.isCache;
    }

    public SerializableConf config() {
        return this.config;
    }

    public Map<Object, String> hazelcastPartitions() {
        return this.bitmap$trans$0 ? this.hazelcastPartitions : this.hazelcastPartitions$lzycompute();
    }

    @DeveloperApi
    public Iterator<Tuple2<K, V>> compute(Partition split, TaskContext context) {
        return (Iterator)Try$.MODULE$.apply((Function0)new Serializable(this, split){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HazelcastRDD $outer;
            private final Partition split$1;

            public final Iterator<Tuple2<K, V>> apply() {
                return this.$outer.computeInternal(this.split$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.split$1 = split$1;
            }
        }).recover((PartialFunction)new Serializable(this, split){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HazelcastRDD $outer;
            private final Partition split$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Iterator<Tuple2<K, V>> iterator = A1 instanceof HazelcastClientNotActiveException ? this.$outer.computeInternal(this.split$1) : function1.apply(x1);
                return (B1)iterator;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof HazelcastClientNotActiveException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.split$1 = split$1;
            }
        }).get();
    }

    public Iterator<Tuple2<K, V>> computeInternal(Partition split) {
        Object object;
        PartitionLocationInfo partitionLocationInfo = (PartitionLocationInfo)split;
        HazelcastInstance client = ConnectionUtil$.MODULE$.getHazelcastConnection(partitionLocationInfo.location(), this.id(), this.config());
        if (this.isCache()) {
            ClientCacheProxy cache = HazelcastUtil$.MODULE$.getClientCacheProxy(this.hzName(), client);
            object = new CacheIterator(cache.iterator(this.config().readBatchSize(), split.index(), this.config().valueBatchingEnabled()));
        } else {
            ClientMapProxy map = HazelcastUtil$.MODULE$.getClientMapProxy(this.hzName(), client);
            object = new MapIterator(map.iterator(this.config().readBatchSize(), split.index(), this.config().valueBatchingEnabled()));
        }
        return object;
    }

    public Partition[] getPartitions() {
        ObjectRef array = ObjectRef.create((Object)((Partition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Partition.class))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.hazelcastPartitions().size()).foreach$mVc$sp((Function1)new Serializable(this, array){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HazelcastRDD $outer;
            private final ObjectRef array$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.array$1.elem = (Partition[])Predef$.MODULE$.refArrayOps((Object[])((Partition[])this.array$1.elem)).$colon$plus((Object)new PartitionLocationInfo(i, (String)this.$outer.hazelcastPartitions().get((Object)BoxesRunTime.boxToInteger((int)i)).get()), ClassTag$.MODULE$.apply(Partition.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.array$1 = array$1;
            }
        });
        return (Partition[])array.elem;
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.hazelcastPartitions().get((Object)BoxesRunTime.boxToInteger((int)split.index())).get()}));
    }

    public HazelcastRDD(SparkContext sc, String hzName, boolean isCache, SerializableConf config) {
        this.sc = sc;
        this.hzName = hzName;
        this.isCache = isCache;
        this.config = config;
        super(sc, (Seq)Seq$.MODULE$.empty(), ClassTag$.MODULE$.apply(Tuple2.class));
    }
}

