/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.core.HazelcastInstance;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastInstanceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private final String methodName;

    public HazelcastInstanceBeanDefinitionParser(String type) {
        this.methodName = "get" + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handle(element);
        BeanDefinitionBuilder builder = springXmlBuilder.getBuilder();
        builder.setFactoryMethod(this.methodName);
        return builder.getBeanDefinition();
    }

    private static class SpringXmlBuilder
    extends AbstractXmlConfigHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder builder;

        public SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastInstance.class);
        }

        public BeanDefinitionBuilder getBuilder() {
            return this.builder;
        }

        public void handle(Element element) {
            NamedNodeMap atts = element.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = att.getNodeName();
                    String value = att.getNodeValue();
                    if ("name".equals(name)) {
                        this.builder.addConstructorArgValue((Object)value);
                        continue;
                    }
                    if (!"instance-ref".equals(name)) continue;
                    this.builder.getRawBeanDefinition().setFactoryBeanName(value);
                }
            }
        }
    }
}

