/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.spring.context.SpringManagedContext;
import java.util.ArrayList;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastClientBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handleClient(element);
        return springXmlBuilder.getBeanDefinition();
    }

    private class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder builder;
        private ManagedMap nearCacheConfigMap;

        public SpringXmlBuilder(ParserContext parserContext) {
            super(HazelcastClientBeanDefinitionParser.this);
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastClient.class);
            this.builder.setFactoryMethod("newHazelcastClient");
            this.builder.setDestroyMethodName("shutdown");
            this.nearCacheConfigMap = new ManagedMap();
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(ClientConfig.class);
            this.configBuilder.addPropertyValue("nearCacheConfigMap", (Object)this.nearCacheConfigMap);
            BeanDefinitionBuilder managedContextBeanBuilder = this.createBeanBuilder(SpringManagedContext.class);
            this.configBuilder.addPropertyValue("managedContext", (Object)managedContextBeanBuilder.getBeanDefinition());
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.builder.getBeanDefinition();
        }

        public void handleClient(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            NamedNodeMap attrs = element.getAttributes();
            if (attrs != null) {
                for (int a = 0; a < attrs.getLength(); ++a) {
                    Node att = attrs.item(a);
                    String name = att.getNodeName();
                    String value = att.getNodeValue();
                    if ("executor-pool-size".equals(name)) {
                        this.configBuilder.addPropertyValue("executorPoolSize", (Object)value);
                        continue;
                    }
                    if (!"credentials-ref".equals(name)) continue;
                    this.configBuilder.addPropertyReference("credentials", value);
                }
            }
            for (Node node : new AbstractXmlConfigHelper.IterableNodeList((Node)element, 1)) {
                String nodeName = SpringXmlBuilder.cleanNodeName((String)node.getNodeName());
                if ("group".equals(nodeName)) {
                    this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
                    continue;
                }
                if ("network".equals(nodeName)) {
                    this.handleNetwork(node);
                    continue;
                }
                if ("listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                    this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("serialization".equals(nodeName)) {
                    this.handleSerialization(node);
                    continue;
                }
                if ("proxy-factories".equals(nodeName)) {
                    ManagedList list = this.parseProxyFactories(node, ProxyFactoryConfig.class);
                    this.configBuilder.addPropertyValue("proxyFactoryConfigs", (Object)list);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(node, this.configBuilder);
                    continue;
                }
                if ("load-balancer".equals(nodeName)) {
                    this.handleLoadBalacer(node);
                    continue;
                }
                if (!"near-cache".equals(nodeName)) continue;
                this.handleNearCache(node);
            }
            this.builder.addConstructorArgValue((Object)this.configBuilder.getBeanDefinition());
        }

        private void handleNetwork(Node node) {
            ArrayList<String> members = new ArrayList<String>(10);
            this.fillAttributeValues(node, this.configBuilder, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String nodeName = this.cleanNodeName(child);
                if ("member".equals(nodeName)) {
                    members.add(this.getTextContent(child));
                    continue;
                }
                if (!"socket-options".equals(nodeName)) continue;
                this.createAndFillBeanBuilder(child, SocketOptions.class, "socketOptions", this.configBuilder, new String[0]);
            }
            this.configBuilder.addPropertyValue("addresses", members);
        }

        private void handleLoadBalacer(Node node) {
            String type = this.getAttribute(node, "type");
            if ("random".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RandomLB());
            } else if ("round-robin".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RoundRobinLB());
            }
        }

        private void handleNearCache(Node node) {
            this.createAndFillListedBean(node, NearCacheConfig.class, "name", this.nearCacheConfigMap, "name");
        }
    }
}

