/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.nio.ssl.TestKeyStoreUtil;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.DummyDiscoveryStrategy;
import com.hazelcast.spring.DummyDiscoveryStrategyFactory;
import com.hazelcast.spring.DummyNodeFilter;
import com.hazelcast.spring.DummySocketInterceptor;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"clientNetworkConfig-applicationContext.xml"})
@Category(value={QuickTest.class})
public class TestClientNetworkConfig {
    @Resource(name="client")
    private HazelcastClientProxy client;

    @BeforeClass
    @AfterClass
    public static void start() {
        String keyStoreFilePath = TestKeyStoreUtil.getKeyStoreFilePath();
        String trustStoreFilePath = TestKeyStoreUtil.getTrustStoreFilePath();
        System.setProperty("test.keyStore", keyStoreFilePath);
        System.setProperty("test.trustStore", trustStoreFilePath);
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void smokeMember() {
        int memberCountInConfigurationXml = 2;
        ClientConfig config = this.client.getClientConfig();
        Assert.assertEquals((long)memberCountInConfigurationXml, (long)config.getNetworkConfig().getAddresses().size());
    }

    @Test
    public void smokeSocketOptions() {
        int bufferSizeInConfigurationXml = 32;
        ClientConfig config = this.client.getClientConfig();
        Assert.assertEquals((long)bufferSizeInConfigurationXml, (long)config.getNetworkConfig().getSocketOptions().getBufferSize());
    }

    @Test
    public void smokeSocketInterceptor() {
        ClientConfig config = this.client.getClientConfig();
        SocketInterceptorConfig socketInterceptorConfig = config.getNetworkConfig().getSocketInterceptorConfig();
        Assert.assertFalse((boolean)socketInterceptorConfig.isEnabled());
        Assert.assertEquals((Object)DummySocketInterceptor.class.getName(), (Object)socketInterceptorConfig.getClassName());
    }

    @Test
    public void smokeSSLConfig() {
        ClientConfig config = this.client.getClientConfig();
        Assert.assertEquals((Object)"com.hazelcast.nio.ssl.BasicSSLContextFactory", (Object)config.getNetworkConfig().getSSLConfig().getFactoryClassName());
    }

    @Test
    public void smokeDiscoverySpiConfig() {
        DiscoveryConfig discoveryConfig = this.client.getClientConfig().getNetworkConfig().getDiscoveryConfig();
        Assert.assertNull((Object)discoveryConfig.getDiscoveryServiceProvider());
        Assert.assertTrue((boolean)(discoveryConfig.getNodeFilter() instanceof DummyNodeFilter));
        List discoveryStrategyConfigs = (List)discoveryConfig.getDiscoveryStrategyConfigs();
        Assert.assertEquals((long)4L, (long)discoveryStrategyConfigs.size());
        DiscoveryStrategyConfig discoveryStrategyConfig = (DiscoveryStrategyConfig)discoveryStrategyConfigs.get(0);
        Assert.assertTrue((boolean)(discoveryStrategyConfig.getDiscoveryStrategyFactory() instanceof DummyDiscoveryStrategyFactory));
        Assert.assertEquals((long)3L, (long)discoveryStrategyConfig.getProperties().size());
        Assert.assertEquals((Object)"foo", discoveryStrategyConfig.getProperties().get("key-string"));
        Assert.assertEquals((Object)"123", discoveryStrategyConfig.getProperties().get("key-int"));
        Assert.assertEquals((Object)"true", discoveryStrategyConfig.getProperties().get("key-boolean"));
        DiscoveryStrategyConfig discoveryStrategyConfig2 = (DiscoveryStrategyConfig)discoveryStrategyConfigs.get(1);
        Assert.assertEquals((Object)DummyDiscoveryStrategy.class.getName(), (Object)discoveryStrategyConfig2.getClassName());
        Assert.assertEquals((long)1L, (long)discoveryStrategyConfig2.getProperties().size());
        Assert.assertEquals((Object)"foo2", discoveryStrategyConfig2.getProperties().get("key-string"));
        DiscoveryStrategyConfig discoveryStrategyConfig3 = (DiscoveryStrategyConfig)discoveryStrategyConfigs.get(2);
        Assert.assertEquals((Object)DummyDiscoveryStrategy.class.getName(), (Object)discoveryStrategyConfig3.getClassName());
        DiscoveryStrategyConfig discoveryStrategyConfig4 = (DiscoveryStrategyConfig)discoveryStrategyConfigs.get(3);
        Assert.assertTrue((boolean)(discoveryStrategyConfig4.getDiscoveryStrategyFactory() instanceof DummyDiscoveryStrategyFactory));
    }

    @Test
    public void smokeOutboundPorts() {
        Collection allowedPorts = this.client.getClientConfig().getNetworkConfig().getOutboundPortDefinitions();
        Assert.assertEquals((long)2L, (long)allowedPorts.size());
        Assert.assertTrue((boolean)allowedPorts.contains("34600"));
        Assert.assertTrue((boolean)allowedPorts.contains("34700-34710"));
    }
}

