/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.cache.JCacheCacheEntryListener;
import com.hazelcast.spring.cache.JCacheCacheEntryListenerFactory;
import com.hazelcast.spring.cache.JCacheCacheLoader;
import com.hazelcast.spring.cache.JCacheCacheLoaderFactory;
import com.hazelcast.spring.cache.JCacheCacheWriter;
import com.hazelcast.spring.cache.JCacheCacheWriterFactory;
import com.hazelcast.spring.cache.JCacheExpiryPolicy;
import com.hazelcast.spring.cache.JCacheExpiryPolicyFactory;
import com.hazelcast.spring.cache.JCachePartitionLostListener;
import com.hazelcast.test.annotation.QuickTest;
import javax.annotation.Resource;
import javax.cache.Cache;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"jCacheCacheManager-applicationContext-DI.xml"})
@Category(value={QuickTest.class})
public class JCacheCacheManagerDITest {
    @Resource(name="cacheManager")
    private JCacheCacheManager springCacheManager;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Test
    public void testCacheWithCacheLoaderFactory_dependenciesInjected() {
        Cache cacheWithLoader = this.springCacheManager.getCacheManager().getCache("cacheWithLoader");
        cacheWithLoader.get((Object)1);
        Assert.assertTrue((String)"HazelcastInstance not injected to HazelcastInstanceAware object", (boolean)JCacheCacheLoaderFactory.HAZELCAST_INSTANCE_INJECTED.get());
        Assert.assertTrue((String)"Node not injected to NodeAware object", (boolean)JCacheCacheLoaderFactory.NODE_INJECTED.get());
        Assert.assertNotNull((String)"Spring bean not injected to @SpringAware object", (Object)JCacheCacheLoaderFactory.INSTANCE.getDummyBean());
        Assert.assertTrue((String)"HazelcastInstance not injected to HazelcastInstanceAware object", (boolean)JCacheCacheLoader.HAZELCAST_INSTANCE_INJECTED.get());
        Assert.assertTrue((String)"Node not injected to NodeAware object", (boolean)JCacheCacheLoader.NODE_INJECTED.get());
        Assert.assertNotNull((String)"Spring bean not injected to @SpringAware object", (Object)JCacheCacheLoader.INSTANCE.getDummyBean());
    }

    @Test
    public void testCacheWithCacheWriterFactory_dependenciesInjected() {
        Cache cacheWithWriter = this.springCacheManager.getCacheManager().getCache("cacheWithWriter");
        cacheWithWriter.put((Object)1, (Object)"1");
        Assert.assertTrue((String)"HazelcastInstance not injected to HazelcastInstanceAware object", (boolean)JCacheCacheWriterFactory.HAZELCAST_INSTANCE_INJECTED.get());
        Assert.assertTrue((String)"Node not injected to NodeAware object", (boolean)JCacheCacheWriterFactory.NODE_INJECTED.get());
        Assert.assertNotNull((String)"Spring bean not injected to @SpringAware object", (Object)JCacheCacheWriterFactory.INSTANCE.getDummyBean());
        Assert.assertTrue((String)"HazelcastInstance not injected to HazelcastInstanceAware object", (boolean)JCacheCacheWriter.HAZELCAST_INSTANCE_INJECTED.get());
        Assert.assertTrue((String)"Node not injected to NodeAware object", (boolean)JCacheCacheWriter.NODE_INJECTED.get());
        Assert.assertNotNull((String)"Spring bean not injected to @SpringAware object", (Object)JCacheCacheWriter.INSTANCE.getDummyBean());
    }

    @Test
    public void testCacheWithExpiryPolicyFactory_dependenciesInjected() {
        Cache cacheWithExpiryPolicy = this.springCacheManager.getCacheManager().getCache("cacheWithExpiryPolicy");
        cacheWithExpiryPolicy.put((Object)1, (Object)"1");
        Assert.assertTrue((String)"HazelcastInstance not injected to HazelcastInstanceAware object", (boolean)JCacheExpiryPolicyFactory.HAZELCAST_INSTANCE_INJECTED.get());
        Assert.assertTrue((String)"Node not injected to NodeAware object", (boolean)JCacheExpiryPolicyFactory.NODE_INJECTED.get());
        Assert.assertNotNull((String)"Spring bean not injected to @SpringAware object", (Object)JCacheExpiryPolicyFactory.INSTANCE.getDummyBean());
        Assert.assertTrue((String)"HazelcastInstance not injected to HazelcastInstanceAware object", (boolean)JCacheExpiryPolicy.HAZELCAST_INSTANCE_INJECTED.get());
        Assert.assertTrue((String)"Node not injected to NodeAware object", (boolean)JCacheExpiryPolicy.NODE_INJECTED.get());
        Assert.assertNotNull((String)"Spring bean not injected to @SpringAware object", (Object)JCacheExpiryPolicy.INSTANCE.getDummyBean());
    }

    @Test
    public void testCacheWithListeners_dependenciesInjected() {
        Cache cacheWithPartitionLostListener = this.springCacheManager.getCacheManager().getCache("cacheWithListeners");
        cacheWithPartitionLostListener.get((Object)1);
        Assert.assertTrue((String)"HazelcastInstance not injected to HazelcastInstanceAware object", (boolean)JCachePartitionLostListener.HAZELCAST_INSTANCE_INJECTED.get());
        Assert.assertTrue((String)"Node not injected to NodeAware object", (boolean)JCachePartitionLostListener.NODE_INJECTED.get());
        Assert.assertNotNull((String)"Spring bean not injected to @SpringAware object", (Object)JCachePartitionLostListener.INSTANCE.getDummyBean());
        Assert.assertTrue((String)"HazelcastInstance not injected to HazelcastInstanceAware object", (boolean)JCacheCacheEntryListenerFactory.HAZELCAST_INSTANCE_INJECTED.get());
        Assert.assertTrue((String)"Node not injected to NodeAware object", (boolean)JCacheCacheEntryListenerFactory.NODE_INJECTED.get());
        Assert.assertNotNull((String)"Spring bean not injected to @SpringAware object", (Object)JCacheCacheEntryListenerFactory.INSTANCE.getDummyBean());
        Assert.assertTrue((String)"HazelcastInstance not injected to HazelcastInstanceAware object", (boolean)JCacheCacheEntryListener.HAZELCAST_INSTANCE_INJECTED.get());
        Assert.assertTrue((String)"Node not injected to NodeAware object", (boolean)JCacheCacheEntryListener.NODE_INJECTED.get());
        Assert.assertNotNull((String)"Spring bean not injected to @SpringAware object", (Object)JCacheCacheEntryListener.INSTANCE.getDummyBean());
    }
}

