/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.context;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.context.DummyTransactionManager;
import com.hazelcast.spring.context.SomeBean;
import com.hazelcast.spring.context.SomeCallableTask;
import com.hazelcast.spring.context.SomeEntryProcessor;
import com.hazelcast.spring.context.SomeRunnableTask;
import com.hazelcast.spring.context.SomeTask;
import com.hazelcast.spring.context.SomeTransactionalRunnableTask;
import com.hazelcast.spring.context.SomeTransactionalTask;
import com.hazelcast.spring.context.SomeValue;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.ExceptionUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"managedContext-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestManagedContext {
    @Resource(name="instance1")
    private HazelcastInstance instance1;
    @Resource(name="instance2")
    private HazelcastInstance instance2;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private DummyTransactionManager transactionManager;
    @Autowired
    private SomeBean bean;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Test
    public void testSerialization() {
        this.instance1.getMap("test").put((Object)1L, (Object)new SomeValue());
        SomeValue value = (SomeValue)this.instance1.getMap("test").get((Object)1L);
        Assert.assertNotNull((Object)value.context);
        Assert.assertNotNull((Object)value.someBean);
        Assert.assertEquals((Object)this.context, (Object)value.context);
        Assert.assertEquals((Object)this.bean, (Object)value.someBean);
        Assert.assertTrue((boolean)value.init);
    }

    @Test
    public void testDistributedTask() throws Exception {
        SomeTask task = (SomeTask)this.context.getBean("someTask");
        Future future1 = this.instance1.getExecutorService("test").submit((Callable)task);
        Assert.assertEquals((long)this.bean.value, (long)((Long)future1.get()));
        Future future2 = this.instance1.getExecutorService("test").submitToMember((Callable)new SomeTask(), this.instance2.getCluster().getLocalMember());
        Assert.assertEquals((long)this.bean.value, (long)((Long)future2.get()));
    }

    @Test
    public void testTransactionalTask() throws Exception {
        Future future = this.instance1.getExecutorService("test").submitToMember((Callable)new SomeTransactionalTask(), this.instance2.getCluster().getLocalMember());
        future.get();
        Assert.assertTrue((String)"transaction manager could not proxy the submitted task.", (boolean)this.transactionManager.isCommitted());
    }

    @Test
    public void testRunnableTask() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        this.instance1.getExecutorService("test").submitToMember((Runnable)new SomeRunnableTask(), this.instance2.getCluster().getLocalMember(), new ExecutionCallback(){

            public void onResponse(Object response) {
                latch.countDown();
            }

            public void onFailure(Throwable t) {
                error.set(t);
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Throwable throwable = (Throwable)error.get();
        if (throwable != null) {
            ExceptionUtil.sneakyThrow((Throwable)throwable);
        }
    }

    @Test
    public void testRunnableTask_withScheduledExecutor_onLocalMember() throws Exception {
        this.instance1.getScheduledExecutorService("test").scheduleOnMember((Runnable)new SomeRunnableTask(), this.instance1.getCluster().getLocalMember(), 0L, TimeUnit.SECONDS).get();
    }

    @Test
    public void testRunnableTask_withScheduledExecutor_onRemoteMember() throws Exception {
        this.instance1.getScheduledExecutorService("test").scheduleOnMember((Runnable)new SomeRunnableTask(), this.instance2.getCluster().getLocalMember(), 0L, TimeUnit.SECONDS).get();
    }

    @Test
    public void testCallableTask_withScheduledExecutor_onLocalMember() throws Exception {
        this.instance1.getScheduledExecutorService("test").scheduleOnMember((Callable)new SomeCallableTask(), this.instance1.getCluster().getLocalMember(), 0L, TimeUnit.SECONDS).get();
    }

    @Test
    public void testCallableTask_withScheduledExecutor_onRemoteMember() throws Exception {
        this.instance1.getScheduledExecutorService("test").scheduleOnMember((Callable)new SomeCallableTask(), this.instance2.getCluster().getLocalMember(), 0L, TimeUnit.SECONDS).get();
    }

    @Test
    public void testTransactionalRunnableTask() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.instance1.getExecutorService("test").submitToMember((Runnable)new SomeTransactionalRunnableTask(), this.instance2.getCluster().getLocalMember(), new ExecutionCallback(){

            public void onResponse(Object response) {
                latch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        latch.await(1L, TimeUnit.MINUTES);
        Assert.assertTrue((String)"transaction manager could not proxy the submitted task.", (boolean)this.transactionManager.isCommitted());
    }

    @Test
    public void testEntryProcessor() {
        IMap map = this.instance1.getMap("testEntryProcessor");
        map.put((Object)"key1", (Object)"value1");
        map.put((Object)"key2", (Object)"value2");
        map.put((Object)"key3", (Object)"value3");
        map.put((Object)"key4", (Object)"value4");
        map.put((Object)"key5", (Object)"value5");
        Map objectMap = map.executeOnEntries((EntryProcessor)new SomeEntryProcessor());
        Assert.assertEquals((long)5L, (long)objectMap.size());
        for (Object o : objectMap.values()) {
            Assert.assertEquals((Object)"notNull", o);
        }
        Object result = map.executeOnKey((Object)"key8", (EntryProcessor)new SomeEntryProcessor());
        Assert.assertEquals((Object)"notNull", (Object)result);
    }
}

