/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"client-network-defaults-context.xml"})
@Category(value={QuickTest.class})
public class TestClientConfigAndSpringDefaults {
    private ClientConfig clientConfig;
    @Resource(name="client")
    private HazelcastClientProxy client;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Before
    public void before() {
        this.clientConfig = this.client.getClientConfig();
    }

    @Test
    public void testDefaults() {
        ClientConfig defaults = new ClientConfig();
        Assert.assertEquals((Object)defaults.isSmartRouting(), (Object)this.clientConfig.isSmartRouting());
        Assert.assertEquals((Object)defaults.getNetworkConfig().isSmartRouting(), (Object)this.clientConfig.getNetworkConfig().isSmartRouting());
        Assert.assertEquals((long)defaults.getNetworkConfig().getConnectionTimeout(), (long)this.clientConfig.getNetworkConfig().getConnectionTimeout());
    }
}

