/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.replicatedmap;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"replicatedMap-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestReplicatedMapApplicationContext {
    @Resource(name="instance")
    private HazelcastInstance instance;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Test
    public void testReplicatedMapConfig() {
        ReplicatedMapConfig replicatedMapConfig = this.instance.getConfig().getReplicatedMapConfig("replicatedMap");
        Assert.assertNotNull((Object)replicatedMapConfig);
        Assert.assertEquals((long)3L, (long)replicatedMapConfig.getConcurrencyLevel());
        Assert.assertEquals((Object)"OBJECT", (Object)InMemoryFormat.OBJECT.name());
        Assert.assertTrue((boolean)replicatedMapConfig.isAsyncFillup());
        Assert.assertFalse((boolean)replicatedMapConfig.isStatisticsEnabled());
        Assert.assertEquals((long)10L, (long)replicatedMapConfig.getReplicationDelayMillis());
        List listenerConfigs = replicatedMapConfig.getListenerConfigs();
        Assert.assertEquals((long)1L, (long)listenerConfigs.size());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyEntryListener", (Object)((ListenerConfig)listenerConfigs.get(0)).getClassName());
    }
}

