/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AtomicLongConfig;
import com.hazelcast.config.AtomicReferenceConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.CountDownLatchConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.HotRestartClusterDataRecoveryPolicy;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LockConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapAttributeConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.config.QuorumListenerConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WANQueueFullBehavior;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.MapStore;
import com.hazelcast.core.MapStoreFactory;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.QueueStore;
import com.hazelcast.core.QueueStoreFactory;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.core.RingbufferStore;
import com.hazelcast.core.RingbufferStoreFactory;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.quorum.impl.ProbabilisticQuorumFunction;
import com.hazelcast.quorum.impl.RecentlyActiveQuorumFunction;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.DummyDiscoveryServiceProvider;
import com.hazelcast.spring.DummyDiscoveryStrategy;
import com.hazelcast.spring.DummyDiscoveryStrategyFactory;
import com.hazelcast.spring.DummyMapEvictionPolicy;
import com.hazelcast.spring.DummyMembershipListener;
import com.hazelcast.spring.DummyNodeFilter;
import com.hazelcast.spring.DummyQueueStore;
import com.hazelcast.spring.DummyQueueStoreFactory;
import com.hazelcast.spring.DummyRingbufferStore;
import com.hazelcast.spring.DummyRingbufferStoreFactory;
import com.hazelcast.spring.DummySSLContextFactory;
import com.hazelcast.spring.DummySocketInterceptor;
import com.hazelcast.spring.DummyWanConsumer;
import com.hazelcast.spring.MyService;
import com.hazelcast.spring.MyServiceConfig;
import com.hazelcast.spring.serialization.DummyDataSerializableFactory;
import com.hazelcast.spring.serialization.DummyPortableFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.wan.WanReplicationEndpoint;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"fullConfig-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestFullApplicationContext
extends HazelcastTestSupport {
    private Config config;
    @Resource(name="instance")
    private HazelcastInstance instance;
    @Resource(name="map1")
    private IMap<Object, Object> map1;
    @Resource(name="map2")
    private IMap<Object, Object> map2;
    @Resource(name="multiMap")
    private MultiMap multiMap;
    @Resource(name="replicatedMap")
    private ReplicatedMap replicatedMap;
    @Resource(name="queue")
    private IQueue queue;
    @Resource(name="topic")
    private ITopic topic;
    @Resource(name="set")
    private ISet set;
    @Resource(name="list")
    private IList list;
    @Resource(name="executorService")
    private ExecutorService executorService;
    @Resource(name="idGenerator")
    private IdGenerator idGenerator;
    @Resource(name="flakeIdGenerator")
    private FlakeIdGenerator flakeIdGenerator;
    @Resource(name="atomicLong")
    private IAtomicLong atomicLong;
    @Resource(name="atomicReference")
    private IAtomicReference atomicReference;
    @Resource(name="countDownLatch")
    private ICountDownLatch countDownLatch;
    @Resource(name="semaphore")
    private ISemaphore semaphore;
    @Resource(name="lock")
    private ILock lock;
    @Resource(name="dummyMapStore")
    private MapStore dummyMapStore;
    @Autowired
    private MapStoreFactory dummyMapStoreFactory;
    @Resource(name="dummyQueueStore")
    private QueueStore dummyQueueStore;
    @Autowired
    private QueueStoreFactory dummyQueueStoreFactory;
    @Resource(name="dummyRingbufferStore")
    private RingbufferStore dummyRingbufferStore;
    @Autowired
    private RingbufferStoreFactory dummyRingbufferStoreFactory;
    @Autowired
    private WanReplicationEndpoint wanReplication;
    @Autowired
    private MembershipListener membershipListener;
    @Autowired
    private EntryListener entryListener;
    @Resource
    private SSLContextFactory sslContextFactory;
    @Resource
    private SocketInterceptor socketInterceptor;
    @Resource
    private StreamSerializer dummySerializer;
    @Resource(name="pnCounter")
    private PNCounter pnCounter;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Before
    public void before() {
        this.config = this.instance.getConfig();
    }

    @Test
    public void testCacheConfig() {
        Assert.assertNotNull((Object)this.config);
        Assert.assertEquals((long)1L, (long)this.config.getCacheConfigs().size());
        CacheSimpleConfig cacheConfig = this.config.getCacheConfig("testCache");
        Assert.assertEquals((Object)"testCache", (Object)cacheConfig.getName());
        Assert.assertTrue((boolean)cacheConfig.isDisablePerEntryInvalidationEvents());
        Assert.assertTrue((boolean)cacheConfig.getHotRestartConfig().isEnabled());
        Assert.assertTrue((boolean)cacheConfig.getHotRestartConfig().isFsync());
        WanReplicationRef wanRef = cacheConfig.getWanReplicationRef();
        Assert.assertEquals((Object)"testWan", (Object)wanRef.getName());
        Assert.assertEquals((Object)"PUT_IF_ABSENT", (Object)wanRef.getMergePolicy());
        Assert.assertEquals((long)1L, (long)wanRef.getFilters().size());
        Assert.assertEquals((Object)"com.example.SampleFilter", wanRef.getFilters().get(0));
        Assert.assertFalse((boolean)wanRef.isRepublishingEnabled());
    }

    @Test
    public void testMapConfig() {
        Assert.assertNotNull((Object)this.config);
        Assert.assertEquals((long)26L, (long)this.config.getMapConfigs().size());
        MapConfig testMapConfig = this.config.getMapConfig("testMap");
        Assert.assertNotNull((Object)testMapConfig);
        Assert.assertEquals((Object)"testMap", (Object)testMapConfig.getName());
        Assert.assertEquals((long)2L, (long)testMapConfig.getBackupCount());
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)testMapConfig.getEvictionPolicy());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)testMapConfig.getMaxSizeConfig().getSize());
        Assert.assertEquals((long)30L, (long)testMapConfig.getEvictionPercentage());
        Assert.assertEquals((long)0L, (long)testMapConfig.getTimeToLiveSeconds());
        Assert.assertTrue((boolean)testMapConfig.getHotRestartConfig().isEnabled());
        Assert.assertTrue((boolean)testMapConfig.getHotRestartConfig().isFsync());
        Assert.assertEquals((long)1000L, (long)testMapConfig.getMinEvictionCheckMillis());
        Assert.assertTrue((boolean)testMapConfig.isReadBackupData());
        Assert.assertEquals((long)2L, (long)testMapConfig.getMapIndexConfigs().size());
        for (MapIndexConfig index : testMapConfig.getMapIndexConfigs()) {
            if ("name".equals(index.getAttribute())) {
                Assert.assertFalse((boolean)index.isOrdered());
                continue;
            }
            if ("age".equals(index.getAttribute())) {
                Assert.assertTrue((boolean)index.isOrdered());
                continue;
            }
            Assert.fail((String)"unknown index!");
        }
        Assert.assertEquals((long)2L, (long)testMapConfig.getMapAttributeConfigs().size());
        for (MapAttributeConfig attribute : testMapConfig.getMapAttributeConfigs()) {
            if ("power".equals(attribute.getName())) {
                Assert.assertEquals((Object)"com.car.PowerExtractor", (Object)attribute.getExtractor());
                continue;
            }
            if ("weight".equals(attribute.getName())) {
                Assert.assertEquals((Object)"com.car.WeightExtractor", (Object)attribute.getExtractor());
                continue;
            }
            Assert.fail((String)"unknown attribute!");
        }
        Assert.assertEquals((Object)"my-quorum", (Object)testMapConfig.getQuorumName());
        MergePolicyConfig mergePolicyConfig = testMapConfig.getMergePolicyConfig();
        Assert.assertNotNull((Object)mergePolicyConfig);
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
        MapStoreConfig testMapStoreConfig = testMapConfig.getMapStoreConfig();
        Assert.assertNotNull((Object)testMapStoreConfig);
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyStore", (Object)testMapStoreConfig.getClassName());
        Assert.assertTrue((boolean)testMapStoreConfig.isEnabled());
        Assert.assertEquals((long)0L, (long)testMapStoreConfig.getWriteDelaySeconds());
        Assert.assertEquals((long)10L, (long)testMapStoreConfig.getWriteBatchSize());
        Assert.assertTrue((boolean)testMapStoreConfig.isWriteCoalescing());
        Assert.assertEquals((Object)MapStoreConfig.InitialLoadMode.EAGER, (Object)testMapStoreConfig.getInitialLoadMode());
        NearCacheConfig testNearCacheConfig = testMapConfig.getNearCacheConfig();
        Assert.assertNotNull((Object)testNearCacheConfig);
        Assert.assertEquals((long)0L, (long)testNearCacheConfig.getTimeToLiveSeconds());
        Assert.assertEquals((long)60L, (long)testNearCacheConfig.getMaxIdleSeconds());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)testNearCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((long)5000L, (long)testNearCacheConfig.getEvictionConfig().getSize());
        Assert.assertTrue((boolean)testNearCacheConfig.isInvalidateOnChange());
        Assert.assertFalse((boolean)testNearCacheConfig.isSerializeKeys());
        MapConfig testMapConfig2 = this.config.getMapConfig("testMap2");
        Assert.assertNotNull((Object)testMapConfig2.getMapStoreConfig().getImplementation());
        Assert.assertEquals((Object)this.dummyMapStore, (Object)testMapConfig2.getMapStoreConfig().getImplementation());
        Assert.assertEquals((Object)MapStoreConfig.InitialLoadMode.LAZY, (Object)testMapConfig2.getMapStoreConfig().getInitialLoadMode());
        WanReplicationRef wanReplicationRef = testMapConfig2.getWanReplicationRef();
        Assert.assertEquals((Object)"testWan", (Object)wanReplicationRef.getName());
        Assert.assertEquals((Object)"PUT_IF_ABSENT", (Object)wanReplicationRef.getMergePolicy());
        Assert.assertTrue((boolean)wanReplicationRef.isRepublishingEnabled());
        Assert.assertEquals((long)1000L, (long)testMapConfig2.getMaxSizeConfig().getSize());
        Assert.assertEquals((Object)MaxSizeConfig.MaxSizePolicy.PER_NODE, (Object)testMapConfig2.getMaxSizeConfig().getMaxSizePolicy());
        Assert.assertEquals((long)2L, (long)testMapConfig2.getEntryListenerConfigs().size());
        for (EntryListenerConfig listener : testMapConfig2.getEntryListenerConfigs()) {
            if (listener.getClassName() != null) {
                Assert.assertNull((Object)listener.getImplementation());
                Assert.assertTrue((boolean)listener.isIncludeValue());
                Assert.assertFalse((boolean)listener.isLocal());
                continue;
            }
            Assert.assertNotNull((Object)listener.getImplementation());
            Assert.assertEquals((Object)this.entryListener, (Object)listener.getImplementation());
            Assert.assertTrue((boolean)listener.isLocal());
            Assert.assertTrue((boolean)listener.isIncludeValue());
        }
        MapConfig simpleMapConfig = this.config.getMapConfig("simpleMap");
        Assert.assertNotNull((Object)simpleMapConfig);
        Assert.assertEquals((Object)"simpleMap", (Object)simpleMapConfig.getName());
        Assert.assertEquals((long)3L, (long)simpleMapConfig.getBackupCount());
        Assert.assertEquals((long)1L, (long)simpleMapConfig.getAsyncBackupCount());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)simpleMapConfig.getEvictionPolicy());
        Assert.assertEquals((long)10L, (long)simpleMapConfig.getMaxSizeConfig().getSize());
        Assert.assertEquals((long)50L, (long)simpleMapConfig.getEvictionPercentage());
        Assert.assertEquals((long)1L, (long)simpleMapConfig.getTimeToLiveSeconds());
        Assert.assertNull((Object)simpleMapConfig.getNearCacheConfig());
        MapConfig testMapConfig3 = this.config.getMapConfig("testMap3");
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyStoreFactory", (Object)testMapConfig3.getMapStoreConfig().getFactoryClassName());
        Assert.assertFalse((boolean)testMapConfig3.getMapStoreConfig().getProperties().isEmpty());
        Assert.assertEquals((Object)testMapConfig3.getMapStoreConfig().getProperty("dummy.property"), (Object)"value");
        MapConfig testMapConfig4 = this.config.getMapConfig("testMap4");
        Assert.assertEquals((Object)this.dummyMapStoreFactory, (Object)testMapConfig4.getMapStoreConfig().getFactoryImplementation());
        MapConfig mapWithOptimizedQueriesConfig = this.config.getMapConfig("mapWithOptimizedQueries");
        Assert.assertEquals((Object)CacheDeserializedValues.ALWAYS, (Object)mapWithOptimizedQueriesConfig.getCacheDeserializedValues());
        MapConfig mapWithValueCachingSetToNever = this.config.getMapConfig("mapWithValueCachingSetToNever");
        Assert.assertEquals((Object)CacheDeserializedValues.NEVER, (Object)mapWithValueCachingSetToNever.getCacheDeserializedValues());
        MapConfig mapWithValueCachingSetToAlways = this.config.getMapConfig("mapWithValueCachingSetToAlways");
        Assert.assertEquals((Object)CacheDeserializedValues.ALWAYS, (Object)mapWithValueCachingSetToAlways.getCacheDeserializedValues());
        MapConfig mapWithNotOptimizedQueriesConfig = this.config.getMapConfig("mapWithNotOptimizedQueries");
        Assert.assertEquals((Object)CacheDeserializedValues.INDEX_ONLY, (Object)mapWithNotOptimizedQueriesConfig.getCacheDeserializedValues());
        MapConfig mapWithDefaultOptimizedQueriesConfig = this.config.getMapConfig("mapWithDefaultOptimizedQueries");
        Assert.assertEquals((Object)CacheDeserializedValues.INDEX_ONLY, (Object)mapWithDefaultOptimizedQueriesConfig.getCacheDeserializedValues());
        MapConfig testMapWithPartitionLostListenerConfig = this.config.getMapConfig("mapWithPartitionLostListener");
        List partitionLostListenerConfigs = testMapWithPartitionLostListenerConfig.getPartitionLostListenerConfigs();
        Assert.assertEquals((long)1L, (long)partitionLostListenerConfigs.size());
        Assert.assertEquals((Object)"DummyMapPartitionLostListenerImpl", (Object)((MapPartitionLostListenerConfig)partitionLostListenerConfigs.get(0)).getClassName());
        MapConfig testMapWithPartitionStrategyConfig = this.config.getMapConfig("mapWithPartitionStrategy");
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyPartitionStrategy", (Object)testMapWithPartitionStrategyConfig.getPartitioningStrategyConfig().getPartitioningStrategyClass());
    }

    @Test
    public void testMemberFlakeIdGeneratorConfig() {
        FlakeIdGeneratorConfig c = this.instance.getConfig().findFlakeIdGeneratorConfig("flakeIdGenerator");
        Assert.assertEquals((long)3L, (long)c.getPrefetchCount());
        Assert.assertEquals((long)10L, (long)c.getPrefetchValidityMillis());
        Assert.assertEquals((long)20L, (long)c.getIdOffset());
        Assert.assertEquals((long)30L, (long)c.getNodeIdOffset());
        Assert.assertEquals((Object)"flakeIdGenerator*", (Object)c.getName());
        Assert.assertFalse((boolean)c.isStatisticsEnabled());
    }

    @Test
    public void testQueueConfig() {
        QueueConfig testQConfig = this.config.getQueueConfig("testQ");
        Assert.assertNotNull((Object)testQConfig);
        Assert.assertEquals((Object)"testQ", (Object)testQConfig.getName());
        Assert.assertEquals((long)1000L, (long)testQConfig.getMaxSize());
        Assert.assertEquals((long)1L, (long)testQConfig.getItemListenerConfigs().size());
        Assert.assertTrue((boolean)testQConfig.isStatisticsEnabled());
        ItemListenerConfig listenerConfig = (ItemListenerConfig)testQConfig.getItemListenerConfigs().get(0);
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyItemListener", (Object)listenerConfig.getClassName());
        Assert.assertTrue((boolean)listenerConfig.isIncludeValue());
        QueueConfig qConfig = this.config.getQueueConfig("queueWithSplitBrainConfig");
        Assert.assertNotNull((Object)qConfig);
        Assert.assertEquals((Object)"queueWithSplitBrainConfig", (Object)qConfig.getName());
        Assert.assertEquals((long)2500L, (long)qConfig.getMaxSize());
        Assert.assertFalse((boolean)qConfig.isStatisticsEnabled());
        Assert.assertEquals((long)100L, (long)qConfig.getEmptyQueueTtl());
        Assert.assertEquals((Object)"my-quorum", (Object)qConfig.getQuorumName());
        MergePolicyConfig mergePolicyConfig = qConfig.getMergePolicyConfig();
        Assert.assertEquals((Object)"DiscardMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
        QueueConfig queueWithStore1 = this.config.getQueueConfig("queueWithStore1");
        Assert.assertNotNull((Object)queueWithStore1);
        QueueStoreConfig storeConfig1 = queueWithStore1.getQueueStoreConfig();
        Assert.assertNotNull((Object)storeConfig1);
        Assert.assertEquals((Object)DummyQueueStore.class.getName(), (Object)storeConfig1.getClassName());
        QueueConfig queueWithStore2 = this.config.getQueueConfig("queueWithStore2");
        Assert.assertNotNull((Object)queueWithStore2);
        QueueStoreConfig storeConfig2 = queueWithStore2.getQueueStoreConfig();
        Assert.assertNotNull((Object)storeConfig2);
        Assert.assertEquals((Object)DummyQueueStoreFactory.class.getName(), (Object)storeConfig2.getFactoryClassName());
        QueueConfig queueWithStore3 = this.config.getQueueConfig("queueWithStore3");
        Assert.assertNotNull((Object)queueWithStore3);
        QueueStoreConfig storeConfig3 = queueWithStore3.getQueueStoreConfig();
        Assert.assertNotNull((Object)storeConfig3);
        Assert.assertEquals((Object)this.dummyQueueStore, (Object)storeConfig3.getStoreImplementation());
        QueueConfig queueWithStore4 = this.config.getQueueConfig("queueWithStore4");
        Assert.assertNotNull((Object)queueWithStore4);
        QueueStoreConfig storeConfig4 = queueWithStore4.getQueueStoreConfig();
        Assert.assertNotNull((Object)storeConfig4);
        Assert.assertEquals((Object)this.dummyQueueStoreFactory, (Object)storeConfig4.getFactoryImplementation());
    }

    @Test
    public void testLockConfig() {
        LockConfig lockConfig = this.config.getLockConfig("lock");
        Assert.assertNotNull((Object)lockConfig);
        Assert.assertEquals((Object)"lock", (Object)lockConfig.getName());
        Assert.assertEquals((Object)"my-quorum", (Object)lockConfig.getQuorumName());
    }

    @Test
    public void testRingbufferConfig() {
        RingbufferConfig testRingbuffer = this.config.getRingbufferConfig("testRingbuffer");
        Assert.assertNotNull((Object)testRingbuffer);
        Assert.assertEquals((Object)"testRingbuffer", (Object)testRingbuffer.getName());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)testRingbuffer.getInMemoryFormat());
        Assert.assertEquals((long)100L, (long)testRingbuffer.getCapacity());
        Assert.assertEquals((long)1L, (long)testRingbuffer.getBackupCount());
        Assert.assertEquals((long)1L, (long)testRingbuffer.getAsyncBackupCount());
        Assert.assertEquals((long)20L, (long)testRingbuffer.getTimeToLiveSeconds());
        RingbufferStoreConfig store1 = testRingbuffer.getRingbufferStoreConfig();
        Assert.assertNotNull((Object)store1);
        Assert.assertEquals((Object)DummyRingbufferStore.class.getName(), (Object)store1.getClassName());
        MergePolicyConfig mergePolicyConfig = testRingbuffer.getMergePolicyConfig();
        Assert.assertNotNull((Object)mergePolicyConfig);
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
        RingbufferConfig testRingbuffer2 = this.config.getRingbufferConfig("testRingbuffer2");
        Assert.assertNotNull((Object)testRingbuffer2);
        RingbufferStoreConfig store2 = testRingbuffer2.getRingbufferStoreConfig();
        Assert.assertNotNull((Object)store2);
        Assert.assertEquals((Object)DummyRingbufferStoreFactory.class.getName(), (Object)store2.getFactoryClassName());
        Assert.assertFalse((boolean)store2.getProperties().isEmpty());
        Assert.assertEquals((Object)"value", (Object)store2.getProperty("dummy.property"));
        Assert.assertEquals((Object)"value2", (Object)store2.getProperty("dummy.property.2"));
        RingbufferConfig testRingbuffer3 = this.config.getRingbufferConfig("testRingbuffer3");
        Assert.assertNotNull((Object)testRingbuffer3);
        RingbufferStoreConfig store3 = testRingbuffer3.getRingbufferStoreConfig();
        Assert.assertNotNull((Object)store3);
        Assert.assertEquals((Object)this.dummyRingbufferStore, (Object)store3.getStoreImplementation());
        RingbufferConfig testRingbuffer4 = this.config.getRingbufferConfig("testRingbuffer4");
        Assert.assertNotNull((Object)testRingbuffer4);
        RingbufferStoreConfig store4 = testRingbuffer4.getRingbufferStoreConfig();
        Assert.assertNotNull((Object)store4);
        Assert.assertEquals((Object)this.dummyRingbufferStoreFactory, (Object)store4.getFactoryImplementation());
    }

    @Test
    public void testPNCounterConfig() {
        PNCounterConfig testPNCounter = this.config.getPNCounterConfig("testPNCounter");
        Assert.assertNotNull((Object)testPNCounter);
        Assert.assertEquals((Object)"testPNCounter", (Object)testPNCounter.getName());
        Assert.assertEquals((long)100L, (long)testPNCounter.getReplicaCount());
        Assert.assertEquals((Object)"my-quorum", (Object)testPNCounter.getQuorumName());
        Assert.assertFalse((boolean)testPNCounter.isStatisticsEnabled());
    }

    @Test
    public void testSecurity() {
        Set clientPermissionConfigs = this.config.getSecurityConfig().getClientPermissionConfigs();
        Assert.assertFalse((boolean)this.config.getSecurityConfig().getClientBlockUnmappedActions());
        Assert.assertTrue((boolean)CollectionUtil.isNotEmpty((Collection)clientPermissionConfigs));
        Assert.assertEquals((long)1L, (long)clientPermissionConfigs.size());
        PermissionConfig pnCounterPermission = new PermissionConfig(PermissionConfig.PermissionType.PN_COUNTER, "pnCounterPermission", "*").addAction("create").setEndpoints(Collections.emptySet());
        TestFullApplicationContext.assertContains((Collection)clientPermissionConfigs, (Object)pnCounterPermission);
    }

    @Test
    public void testAtomicLongConfig() {
        AtomicLongConfig testAtomicLong = this.config.getAtomicLongConfig("testAtomicLong");
        Assert.assertNotNull((Object)testAtomicLong);
        Assert.assertEquals((Object)"testAtomicLong", (Object)testAtomicLong.getName());
        MergePolicyConfig mergePolicyConfig = testAtomicLong.getMergePolicyConfig();
        Assert.assertEquals((Object)"DiscardMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testAtomicReferenceConfig() {
        AtomicReferenceConfig testAtomicReference = this.config.getAtomicReferenceConfig("testAtomicReference");
        Assert.assertNotNull((Object)testAtomicReference);
        Assert.assertEquals((Object)"testAtomicReference", (Object)testAtomicReference.getName());
        MergePolicyConfig mergePolicyConfig = testAtomicReference.getMergePolicyConfig();
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)4223L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testCountDownLatchConfig() {
        CountDownLatchConfig testCountDownLatch = this.config.getCountDownLatchConfig("testCountDownLatch");
        Assert.assertNotNull((Object)testCountDownLatch);
        Assert.assertEquals((Object)"testCountDownLatch", (Object)testCountDownLatch.getName());
        Assert.assertEquals((Object)"my-quorum", (Object)testCountDownLatch.getQuorumName());
    }

    @Test
    public void testSemaphoreConfig() {
        SemaphoreConfig testSemaphore = this.config.getSemaphoreConfig("testSemaphore");
        Assert.assertNotNull((Object)testSemaphore);
        Assert.assertEquals((Object)"testSemaphore", (Object)testSemaphore.getName());
        Assert.assertEquals((long)1L, (long)testSemaphore.getBackupCount());
        Assert.assertEquals((long)1L, (long)testSemaphore.getAsyncBackupCount());
        Assert.assertEquals((long)10L, (long)testSemaphore.getInitialPermits());
    }

    @Test
    public void testReliableTopicConfig() {
        ReliableTopicConfig testReliableTopic = this.config.getReliableTopicConfig("testReliableTopic");
        Assert.assertNotNull((Object)testReliableTopic);
        Assert.assertEquals((Object)"testReliableTopic", (Object)testReliableTopic.getName());
        Assert.assertEquals((long)1L, (long)testReliableTopic.getMessageListenerConfigs().size());
        Assert.assertFalse((boolean)testReliableTopic.isStatisticsEnabled());
        ListenerConfig listenerConfig = (ListenerConfig)testReliableTopic.getMessageListenerConfigs().get(0);
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyMessageListener", (Object)listenerConfig.getClassName());
        Assert.assertEquals((long)10L, (long)testReliableTopic.getReadBatchSize());
        Assert.assertEquals((Object)TopicOverloadPolicy.BLOCK, (Object)testReliableTopic.getTopicOverloadPolicy());
    }

    @Test
    public void testMultimapConfig() {
        MultiMapConfig testMultiMapConfig = this.config.getMultiMapConfig("testMultimap");
        Assert.assertEquals((Object)MultiMapConfig.ValueCollectionType.LIST, (Object)testMultiMapConfig.getValueCollectionType());
        Assert.assertEquals((long)2L, (long)testMultiMapConfig.getEntryListenerConfigs().size());
        Assert.assertFalse((boolean)testMultiMapConfig.isBinary());
        Assert.assertFalse((boolean)testMultiMapConfig.isStatisticsEnabled());
        for (EntryListenerConfig listener : testMultiMapConfig.getEntryListenerConfigs()) {
            if (listener.getClassName() != null) {
                Assert.assertNull((Object)listener.getImplementation());
                Assert.assertTrue((boolean)listener.isIncludeValue());
                Assert.assertFalse((boolean)listener.isLocal());
                continue;
            }
            Assert.assertNotNull((Object)listener.getImplementation());
            Assert.assertEquals((Object)this.entryListener, (Object)listener.getImplementation());
            Assert.assertTrue((boolean)listener.isLocal());
            Assert.assertTrue((boolean)listener.isIncludeValue());
        }
        MergePolicyConfig mergePolicyConfig = testMultiMapConfig.getMergePolicyConfig();
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)1234L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testListConfig() {
        ListConfig testListConfig = this.config.getListConfig("testList");
        Assert.assertNotNull((Object)testListConfig);
        Assert.assertEquals((Object)"testList", (Object)testListConfig.getName());
        Assert.assertEquals((long)9999L, (long)testListConfig.getMaxSize());
        Assert.assertEquals((long)1L, (long)testListConfig.getBackupCount());
        Assert.assertEquals((long)1L, (long)testListConfig.getAsyncBackupCount());
        Assert.assertFalse((boolean)testListConfig.isStatisticsEnabled());
        MergePolicyConfig mergePolicyConfig = testListConfig.getMergePolicyConfig();
        Assert.assertEquals((Object)"DiscardMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testSetConfig() {
        SetConfig testSetConfig = this.config.getSetConfig("testSet");
        Assert.assertNotNull((Object)testSetConfig);
        Assert.assertEquals((Object)"testSet", (Object)testSetConfig.getName());
        Assert.assertEquals((long)7777L, (long)testSetConfig.getMaxSize());
        Assert.assertEquals((long)0L, (long)testSetConfig.getBackupCount());
        Assert.assertEquals((long)0L, (long)testSetConfig.getAsyncBackupCount());
        Assert.assertFalse((boolean)testSetConfig.isStatisticsEnabled());
        MergePolicyConfig mergePolicyConfig = testSetConfig.getMergePolicyConfig();
        Assert.assertEquals((Object)"DiscardMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testTopicConfig() {
        TopicConfig testTopicConfig = this.config.getTopicConfig("testTopic");
        Assert.assertNotNull((Object)testTopicConfig);
        Assert.assertEquals((Object)"testTopic", (Object)testTopicConfig.getName());
        Assert.assertEquals((long)1L, (long)testTopicConfig.getMessageListenerConfigs().size());
        Assert.assertTrue((boolean)testTopicConfig.isGlobalOrderingEnabled());
        Assert.assertFalse((boolean)testTopicConfig.isStatisticsEnabled());
        ListenerConfig listenerConfig = (ListenerConfig)testTopicConfig.getMessageListenerConfigs().get(0);
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyMessageListener", (Object)listenerConfig.getClassName());
    }

    @Test
    public void testServiceConfig() {
        ServiceConfig serviceConfig = this.config.getServicesConfig().getServiceConfig("my-service");
        Assert.assertEquals((Object)"com.hazelcast.spring.MyService", (Object)serviceConfig.getClassName());
        Assert.assertEquals((Object)"prop1-value", (Object)serviceConfig.getProperties().getProperty("prop1"));
        Assert.assertEquals((Object)"prop2-value", (Object)serviceConfig.getProperties().getProperty("prop2"));
        MyServiceConfig configObject = (MyServiceConfig)serviceConfig.getConfigObject();
        Assert.assertNotNull((Object)configObject);
        Assert.assertEquals((Object)"prop1", (Object)configObject.stringProp);
        Assert.assertEquals((long)123L, (long)configObject.intProp);
        Assert.assertTrue((boolean)configObject.boolProp);
        Object impl = serviceConfig.getImplementation();
        Assert.assertNotNull((Object)impl);
        Assert.assertTrue((String)("expected service of class com.hazelcast.spring.MyService but it is " + impl.getClass().getName()), (boolean)(impl instanceof MyService));
    }

    @Test
    public void testGroupConfig() {
        GroupConfig groupConfig = this.config.getGroupConfig();
        Assert.assertNotNull((Object)groupConfig);
        Assert.assertEquals((Object)"spring-group", (Object)groupConfig.getName());
        Assert.assertEquals((Object)"spring-group-pass", (Object)groupConfig.getPassword());
    }

    @Test
    public void testExecutorConfig() {
        ExecutorConfig testExecConfig = this.config.getExecutorConfig("testExec");
        Assert.assertNotNull((Object)testExecConfig);
        Assert.assertEquals((Object)"testExec", (Object)testExecConfig.getName());
        Assert.assertEquals((long)2L, (long)testExecConfig.getPoolSize());
        Assert.assertEquals((long)100L, (long)testExecConfig.getQueueCapacity());
        Assert.assertTrue((boolean)testExecConfig.isStatisticsEnabled());
        ExecutorConfig testExec2Config = this.config.getExecutorConfig("testExec2");
        Assert.assertNotNull((Object)testExec2Config);
        Assert.assertEquals((Object)"testExec2", (Object)testExec2Config.getName());
        Assert.assertEquals((long)5L, (long)testExec2Config.getPoolSize());
        Assert.assertEquals((long)300L, (long)testExec2Config.getQueueCapacity());
        Assert.assertFalse((boolean)testExec2Config.isStatisticsEnabled());
    }

    @Test
    public void testDurableExecutorConfig() {
        DurableExecutorConfig testExecConfig = this.config.getDurableExecutorConfig("durableExec");
        Assert.assertNotNull((Object)testExecConfig);
        Assert.assertEquals((Object)"durableExec", (Object)testExecConfig.getName());
        Assert.assertEquals((long)10L, (long)testExecConfig.getPoolSize());
        Assert.assertEquals((long)5L, (long)testExecConfig.getDurability());
        Assert.assertEquals((long)200L, (long)testExecConfig.getCapacity());
    }

    @Test
    public void testScheduledExecutorConfig() {
        ScheduledExecutorConfig testExecConfig = this.config.getScheduledExecutorConfig("scheduledExec");
        Assert.assertNotNull((Object)testExecConfig);
        Assert.assertEquals((Object)"scheduledExec", (Object)testExecConfig.getName());
        Assert.assertEquals((long)10L, (long)testExecConfig.getPoolSize());
        Assert.assertEquals((long)5L, (long)testExecConfig.getDurability());
        MergePolicyConfig mergePolicyConfig = testExecConfig.getMergePolicyConfig();
        Assert.assertNotNull((Object)mergePolicyConfig);
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)101L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testCardinalityEstimatorConfig() {
        CardinalityEstimatorConfig estimatorConfig = this.config.getCardinalityEstimatorConfig("estimator");
        Assert.assertNotNull((Object)estimatorConfig);
        Assert.assertEquals((Object)"estimator", (Object)estimatorConfig.getName());
        Assert.assertEquals((long)4L, (long)estimatorConfig.getBackupCount());
        Assert.assertEquals((Object)"DiscardMergePolicy", (Object)estimatorConfig.getMergePolicyConfig().getPolicy());
        Assert.assertEquals((long)44L, (long)estimatorConfig.getMergePolicyConfig().getBatchSize());
    }

    @Test
    public void testNetworkConfig() {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Assert.assertNotNull((Object)networkConfig);
        Assert.assertEquals((long)5700L, (long)networkConfig.getPort());
        Assert.assertFalse((boolean)networkConfig.isPortAutoIncrement());
        Collection allowedPorts = networkConfig.getOutboundPortDefinitions();
        Assert.assertEquals((long)2L, (long)allowedPorts.size());
        Iterator portIter = allowedPorts.iterator();
        Assert.assertEquals((Object)"35000-35100", portIter.next());
        Assert.assertEquals((Object)"36000,36100", portIter.next());
        Assert.assertFalse((boolean)networkConfig.getJoin().getMulticastConfig().isEnabled());
        Assert.assertEquals((long)networkConfig.getJoin().getMulticastConfig().getMulticastTimeoutSeconds(), (long)8L);
        Assert.assertEquals((long)networkConfig.getJoin().getMulticastConfig().getMulticastTimeToLive(), (long)16L);
        Assert.assertFalse((boolean)networkConfig.getJoin().getMulticastConfig().isLoopbackModeEnabled());
        Set tis = networkConfig.getJoin().getMulticastConfig().getTrustedInterfaces();
        Assert.assertEquals((long)1L, (long)tis.size());
        Assert.assertEquals((Object)"10.10.10.*", tis.iterator().next());
        Assert.assertFalse((boolean)networkConfig.getInterfaces().isEnabled());
        Assert.assertEquals((long)1L, (long)networkConfig.getInterfaces().getInterfaces().size());
        Assert.assertEquals((Object)"10.10.1.*", networkConfig.getInterfaces().getInterfaces().iterator().next());
        TcpIpConfig tcp = networkConfig.getJoin().getTcpIpConfig();
        Assert.assertNotNull((Object)tcp);
        Assert.assertTrue((boolean)tcp.isEnabled());
        SymmetricEncryptionConfig symmetricEncryptionConfig = networkConfig.getSymmetricEncryptionConfig();
        Assert.assertFalse((boolean)symmetricEncryptionConfig.isEnabled());
        Assert.assertEquals((Object)"PBEWithMD5AndDES", (Object)symmetricEncryptionConfig.getAlgorithm());
        Assert.assertEquals((Object)"thesalt", (Object)symmetricEncryptionConfig.getSalt());
        Assert.assertEquals((Object)"thepass", (Object)symmetricEncryptionConfig.getPassword());
        Assert.assertEquals((long)19L, (long)symmetricEncryptionConfig.getIterationCount());
        List members = tcp.getMembers();
        Assert.assertEquals((String)members.toString(), (long)2L, (long)members.size());
        Assert.assertEquals((Object)"127.0.0.1:5700", members.get(0));
        Assert.assertEquals((Object)"127.0.0.1:5701", members.get(1));
        Assert.assertEquals((Object)"127.0.0.1:5700", (Object)tcp.getRequiredMember());
        this.assertAwsConfig(networkConfig.getJoin().getAwsConfig());
        Assert.assertTrue((String)"reuse-address", (boolean)networkConfig.isReuseAddress());
        this.assertDiscoveryConfig(networkConfig.getJoin().getDiscoveryConfig());
        MemberAddressProviderConfig memberAddressProviderConfig = networkConfig.getMemberAddressProviderConfig();
        Assert.assertFalse((boolean)memberAddressProviderConfig.isEnabled());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyMemberAddressProvider", (Object)memberAddressProviderConfig.getClassName());
        Assert.assertFalse((boolean)memberAddressProviderConfig.getProperties().isEmpty());
        Assert.assertEquals((Object)"value", (Object)memberAddressProviderConfig.getProperties().getProperty("dummy.property"));
        Assert.assertEquals((Object)"value2", (Object)memberAddressProviderConfig.getProperties().getProperty("dummy.property.2"));
        IcmpFailureDetectorConfig icmpFailureDetectorConfig = networkConfig.getIcmpFailureDetectorConfig();
        Assert.assertFalse((boolean)icmpFailureDetectorConfig.isEnabled());
        Assert.assertTrue((boolean)icmpFailureDetectorConfig.isParallelMode());
        Assert.assertTrue((boolean)icmpFailureDetectorConfig.isFailFastOnStartup());
        Assert.assertEquals((long)500L, (long)icmpFailureDetectorConfig.getTimeoutMilliseconds());
        Assert.assertEquals((long)1002L, (long)icmpFailureDetectorConfig.getIntervalMilliseconds());
        Assert.assertEquals((long)2L, (long)icmpFailureDetectorConfig.getMaxAttempts());
        Assert.assertEquals((long)1L, (long)icmpFailureDetectorConfig.getTtl());
    }

    private void assertAwsConfig(AwsConfig aws) {
        Assert.assertFalse((boolean)aws.isEnabled());
        Assert.assertEquals((Object)"sample-access-key", (Object)aws.getAccessKey());
        Assert.assertEquals((Object)"sample-secret-key", (Object)aws.getSecretKey());
        Assert.assertEquals((Object)"sample-region", (Object)aws.getRegion());
        Assert.assertEquals((Object)"sample-header", (Object)aws.getHostHeader());
        Assert.assertEquals((Object)"sample-group", (Object)aws.getSecurityGroupName());
        Assert.assertEquals((Object)"sample-tag-key", (Object)aws.getTagKey());
        Assert.assertEquals((Object)"sample-tag-value", (Object)aws.getTagValue());
        Assert.assertEquals((Object)"sample-role", (Object)aws.getIamRole());
    }

    private void assertDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        Assert.assertTrue((boolean)(discoveryConfig.getDiscoveryServiceProvider() instanceof DummyDiscoveryServiceProvider));
        Assert.assertTrue((boolean)(discoveryConfig.getNodeFilter() instanceof DummyNodeFilter));
        List discoveryStrategyConfigs = (List)discoveryConfig.getDiscoveryStrategyConfigs();
        Assert.assertEquals((long)2L, (long)discoveryStrategyConfigs.size());
        DiscoveryStrategyConfig discoveryStrategyConfig = (DiscoveryStrategyConfig)discoveryStrategyConfigs.get(0);
        Assert.assertTrue((boolean)(discoveryStrategyConfig.getDiscoveryStrategyFactory() instanceof DummyDiscoveryStrategyFactory));
        Assert.assertEquals((long)3L, (long)discoveryStrategyConfig.getProperties().size());
        Assert.assertEquals((Object)"foo", discoveryStrategyConfig.getProperties().get("key-string"));
        Assert.assertEquals((Object)"123", discoveryStrategyConfig.getProperties().get("key-int"));
        Assert.assertEquals((Object)"true", discoveryStrategyConfig.getProperties().get("key-boolean"));
        DiscoveryStrategyConfig discoveryStrategyConfig2 = (DiscoveryStrategyConfig)discoveryStrategyConfigs.get(1);
        Assert.assertEquals((Object)DummyDiscoveryStrategy.class.getName(), (Object)discoveryStrategyConfig2.getClassName());
        Assert.assertEquals((long)1L, (long)discoveryStrategyConfig2.getProperties().size());
        Assert.assertEquals((Object)"foo2", discoveryStrategyConfig2.getProperties().get("key-string"));
    }

    @Test
    public void testProperties() {
        Properties properties = this.config.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((Object)"5", (Object)properties.get(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName()));
        Assert.assertEquals((Object)"5", (Object)properties.get(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName()));
        Assert.assertEquals((Object)"277", (Object)properties.get(GroupProperty.PARTITION_COUNT.getName()));
        Config config2 = this.instance.getConfig();
        Properties properties2 = config2.getProperties();
        Assert.assertNotNull((Object)properties2);
        Assert.assertEquals((Object)"5", (Object)properties2.get(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName()));
        Assert.assertEquals((Object)"5", (Object)properties2.get(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName()));
        Assert.assertEquals((Object)"277", (Object)properties2.get(GroupProperty.PARTITION_COUNT.getName()));
    }

    @Test
    public void testInstance() {
        Assert.assertNotNull((Object)this.instance);
        Set members = this.instance.getCluster().getMembers();
        Assert.assertEquals((long)1L, (long)members.size());
        Member member = (Member)members.iterator().next();
        InetSocketAddress inetSocketAddress = member.getSocketAddress();
        Assert.assertEquals((long)5700L, (long)inetSocketAddress.getPort());
        Assert.assertEquals((Object)"test-instance", (Object)this.config.getInstanceName());
        Assert.assertEquals((Object)"HAZELCAST_ENTERPRISE_LICENSE_KEY", (Object)this.config.getLicenseKey());
        Assert.assertEquals((long)277L, (long)this.instance.getPartitionService().getPartitions().size());
    }

    @Test
    public void testHazelcastInstances() {
        Assert.assertNotNull(this.map1);
        Assert.assertNotNull(this.map2);
        Assert.assertNotNull((Object)this.multiMap);
        Assert.assertNotNull((Object)this.replicatedMap);
        Assert.assertNotNull((Object)this.queue);
        Assert.assertNotNull((Object)this.topic);
        Assert.assertNotNull((Object)this.set);
        Assert.assertNotNull((Object)this.list);
        Assert.assertNotNull((Object)this.executorService);
        Assert.assertNotNull((Object)this.idGenerator);
        Assert.assertNotNull((Object)this.flakeIdGenerator);
        Assert.assertNotNull((Object)this.atomicLong);
        Assert.assertNotNull((Object)this.atomicReference);
        Assert.assertNotNull((Object)this.countDownLatch);
        Assert.assertNotNull((Object)this.semaphore);
        Assert.assertNotNull((Object)this.lock);
        Assert.assertNotNull((Object)this.pnCounter);
        Assert.assertEquals((Object)"map1", (Object)this.map1.getName());
        Assert.assertEquals((Object)"map2", (Object)this.map2.getName());
        Assert.assertEquals((Object)"testMultimap", (Object)this.multiMap.getName());
        Assert.assertEquals((Object)"replicatedMap", (Object)this.replicatedMap.getName());
        Assert.assertEquals((Object)"testQ", (Object)this.queue.getName());
        Assert.assertEquals((Object)"testTopic", (Object)this.topic.getName());
        Assert.assertEquals((Object)"set", (Object)this.set.getName());
        Assert.assertEquals((Object)"list", (Object)this.list.getName());
        Assert.assertEquals((Object)"idGenerator", (Object)this.idGenerator.getName());
        Assert.assertEquals((Object)"flakeIdGenerator", (Object)this.flakeIdGenerator.getName());
        Assert.assertEquals((Object)"testAtomicLong", (Object)this.atomicLong.getName());
        Assert.assertEquals((Object)"testAtomicReference", (Object)this.atomicReference.getName());
        Assert.assertEquals((Object)"countDownLatch", (Object)this.countDownLatch.getName());
        Assert.assertEquals((Object)"semaphore", (Object)this.semaphore.getName());
    }

    @Test
    public void testWanReplicationConfig() {
        WanReplicationConfig wcfg = this.config.getWanReplicationConfig("testWan");
        Assert.assertNotNull((Object)wcfg);
        WanPublisherConfig publisherConfig = (WanPublisherConfig)wcfg.getWanPublisherConfigs().get(0);
        Assert.assertEquals((Object)"tokyo", (Object)publisherConfig.getGroupName());
        Assert.assertEquals((Object)"com.hazelcast.enterprise.wan.replication.WanBatchReplication", (Object)publisherConfig.getClassName());
        Assert.assertEquals((Object)WANQueueFullBehavior.THROW_EXCEPTION, (Object)publisherConfig.getQueueFullBehavior());
        Assert.assertEquals((long)1000L, (long)publisherConfig.getQueueCapacity());
        Map publisherProps = publisherConfig.getProperties();
        Assert.assertEquals((Object)"50", publisherProps.get("batch.size"));
        Assert.assertEquals((Object)"3000", publisherProps.get("batch.max.delay.millis"));
        Assert.assertEquals((Object)"false", publisherProps.get("snapshot.enabled"));
        Assert.assertEquals((Object)"5000", publisherProps.get("response.timeout.millis"));
        Assert.assertEquals((Object)WanAcknowledgeType.ACK_ON_OPERATION_COMPLETE.name(), publisherProps.get("ack.type"));
        Assert.assertEquals((Object)"pass", publisherProps.get("group.password"));
        WanPublisherConfig customPublisher = (WanPublisherConfig)wcfg.getWanPublisherConfigs().get(1);
        Assert.assertEquals((Object)"istanbul", (Object)customPublisher.getGroupName());
        Assert.assertEquals((Object)"com.hazelcast.wan.custom.CustomPublisher", (Object)customPublisher.getClassName());
        Assert.assertEquals((Object)WANQueueFullBehavior.THROW_EXCEPTION_ONLY_IF_REPLICATION_ACTIVE, (Object)customPublisher.getQueueFullBehavior());
        Map customPublisherProps = customPublisher.getProperties();
        Assert.assertEquals((Object)"prop.publisher", customPublisherProps.get("custom.prop.publisher"));
        Assert.assertEquals((Object)"5", customPublisherProps.get("discovery.period"));
        Assert.assertEquals((Object)"2", customPublisherProps.get("maxEndpoints"));
        this.assertAwsConfig(customPublisher.getAwsConfig());
        this.assertDiscoveryConfig(customPublisher.getDiscoveryConfig());
        WanPublisherConfig publisherPlaceHolderConfig = (WanPublisherConfig)wcfg.getWanPublisherConfigs().get(2);
        Assert.assertEquals((long)5000L, (long)publisherPlaceHolderConfig.getQueueCapacity());
        WanConsumerConfig consumerConfig = wcfg.getWanConsumerConfig();
        Assert.assertEquals((Object)"com.hazelcast.wan.custom.WanConsumer", (Object)consumerConfig.getClassName());
        Map consumerProps = consumerConfig.getProperties();
        Assert.assertEquals((Object)"prop.consumer", consumerProps.get("custom.prop.consumer"));
        WanReplicationConfig config2 = this.config.getWanReplicationConfig("testWan2");
        WanConsumerConfig consumerConfig2 = config2.getWanConsumerConfig();
        consumerConfig2.setProperties(consumerProps);
        TestFullApplicationContext.assertInstanceOf(DummyWanConsumer.class, (Object)consumerConfig2.getImplementation());
        Assert.assertEquals((Object)"prop.consumer", consumerConfig2.getProperties().get("custom.prop.consumer"));
    }

    @Test
    public void testConfigListeners() {
        Assert.assertNotNull((Object)this.membershipListener);
        List list = this.config.getListenerConfigs();
        Assert.assertEquals((long)2L, (long)list.size());
        for (ListenerConfig lc : list) {
            if (lc.getClassName() != null) {
                Assert.assertNull((Object)lc.getImplementation());
                Assert.assertEquals((Object)DummyMembershipListener.class.getName(), (Object)lc.getClassName());
                continue;
            }
            Assert.assertNotNull((Object)lc.getImplementation());
            Assert.assertEquals((Object)this.membershipListener, (Object)lc.getImplementation());
        }
    }

    @Test
    public void testPartitionGroupConfig() {
        PartitionGroupConfig pgc = this.config.getPartitionGroupConfig();
        Assert.assertTrue((boolean)pgc.isEnabled());
        Assert.assertEquals((Object)PartitionGroupConfig.MemberGroupType.CUSTOM, (Object)pgc.getGroupType());
        Assert.assertEquals((long)2L, (long)pgc.getMemberGroupConfigs().size());
        for (MemberGroupConfig mgc : pgc.getMemberGroupConfigs()) {
            Assert.assertEquals((long)2L, (long)mgc.getInterfaces().size());
        }
    }

    @Test
    public void testCRDTReplicationConfig() {
        CRDTReplicationConfig replicationConfig = this.config.getCRDTReplicationConfig();
        Assert.assertEquals((long)10L, (long)replicationConfig.getMaxConcurrentReplicationTargets());
        Assert.assertEquals((long)2000L, (long)replicationConfig.getReplicationPeriodMillis());
    }

    @Test
    public void testSSLConfig() {
        SSLConfig sslConfig = this.config.getNetworkConfig().getSSLConfig();
        Assert.assertNotNull((Object)sslConfig);
        Assert.assertFalse((boolean)sslConfig.isEnabled());
        Assert.assertEquals((Object)DummySSLContextFactory.class.getName(), (Object)sslConfig.getFactoryClassName());
        Assert.assertEquals((Object)this.sslContextFactory, (Object)sslConfig.getFactoryImplementation());
    }

    @Test
    public void testSocketInterceptorConfig() {
        SocketInterceptorConfig socketInterceptorConfig = this.config.getNetworkConfig().getSocketInterceptorConfig();
        Assert.assertNotNull((Object)socketInterceptorConfig);
        Assert.assertFalse((boolean)socketInterceptorConfig.isEnabled());
        Assert.assertEquals((Object)DummySocketInterceptor.class.getName(), (Object)socketInterceptorConfig.getClassName());
        Assert.assertEquals((Object)this.socketInterceptor, (Object)socketInterceptorConfig.getImplementation());
    }

    @Test
    public void testManagementCenterConfig() {
        ManagementCenterConfig managementCenterConfig = this.config.getManagementCenterConfig();
        Assert.assertNotNull((Object)managementCenterConfig);
        Assert.assertTrue((boolean)managementCenterConfig.isEnabled());
        Assert.assertEquals((Object)"myserver:80", (Object)managementCenterConfig.getUrl());
        Assert.assertEquals((long)2L, (long)managementCenterConfig.getUpdateInterval());
        Assert.assertTrue((boolean)managementCenterConfig.getMutualAuthConfig().isEnabled());
        Assert.assertEquals((long)1L, (long)managementCenterConfig.getMutualAuthConfig().getProperties().size());
        Assert.assertEquals((Object)"who.let.the.cat.out.class", (Object)managementCenterConfig.getMutualAuthConfig().getFactoryClassName());
    }

    @Test
    public void testMemberAttributesConfig() {
        MemberAttributeConfig memberAttributeConfig = this.config.getMemberAttributeConfig();
        Assert.assertNotNull((Object)memberAttributeConfig);
        Assert.assertEquals((Object)"spring-group", (Object)memberAttributeConfig.getStringAttribute("cluster.group.name"));
        Assert.assertEquals((Object)new Integer(5700), (Object)memberAttributeConfig.getIntAttribute("cluster.port.int"));
        Assert.assertEquals((Object)new Long(5700L), (Object)memberAttributeConfig.getLongAttribute("cluster.port.long"));
        Assert.assertEquals((Object)new Short("5700"), (Object)memberAttributeConfig.getShortAttribute("cluster.port.short"));
        Assert.assertEquals((Object)new Byte("111"), (Object)memberAttributeConfig.getByteAttribute("attribute.byte"));
        Assert.assertTrue((boolean)memberAttributeConfig.getBooleanAttribute("attribute.boolean"));
        Assert.assertEquals((double)0.0, (double)memberAttributeConfig.getDoubleAttribute("attribute.double"), (double)1.0E-4);
        Assert.assertEquals((double)1234.5678, (double)memberAttributeConfig.getFloatAttribute("attribute.float").floatValue(), (double)1.0E-4);
    }

    @Test
    public void testSerializationConfig() {
        SerializationConfig serializationConfig = this.config.getSerializationConfig();
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)serializationConfig.getByteOrder());
        Assert.assertFalse((boolean)serializationConfig.isCheckClassDefErrors());
        Assert.assertEquals((long)13L, (long)serializationConfig.getPortableVersion());
        Map dataSerializableFactoryClasses = serializationConfig.getDataSerializableFactoryClasses();
        Assert.assertFalse((boolean)dataSerializableFactoryClasses.isEmpty());
        Assert.assertEquals((Object)DummyDataSerializableFactory.class.getName(), dataSerializableFactoryClasses.get(1));
        Map dataSerializableFactories = serializationConfig.getDataSerializableFactories();
        Assert.assertFalse((boolean)dataSerializableFactories.isEmpty());
        Assert.assertEquals(DummyDataSerializableFactory.class, ((DataSerializableFactory)dataSerializableFactories.get(2)).getClass());
        Map portableFactoryClasses = serializationConfig.getPortableFactoryClasses();
        Assert.assertFalse((boolean)portableFactoryClasses.isEmpty());
        Assert.assertEquals((Object)DummyPortableFactory.class.getName(), portableFactoryClasses.get(1));
        Map portableFactories = serializationConfig.getPortableFactories();
        Assert.assertFalse((boolean)portableFactories.isEmpty());
        Assert.assertEquals(DummyPortableFactory.class, ((PortableFactory)portableFactories.get(2)).getClass());
        Collection serializerConfigs = serializationConfig.getSerializerConfigs();
        Assert.assertFalse((boolean)serializerConfigs.isEmpty());
        GlobalSerializerConfig globalSerializerConfig = serializationConfig.getGlobalSerializerConfig();
        Assert.assertNotNull((Object)globalSerializerConfig);
        Assert.assertEquals((Object)this.dummySerializer, (Object)globalSerializerConfig.getImplementation());
    }

    @Test
    public void testNativeMemoryConfig() {
        NativeMemoryConfig nativeMemoryConfig = this.config.getNativeMemoryConfig();
        Assert.assertFalse((boolean)nativeMemoryConfig.isEnabled());
        Assert.assertEquals((Object)MemoryUnit.MEGABYTES, (Object)nativeMemoryConfig.getSize().getUnit());
        Assert.assertEquals((long)256L, (long)nativeMemoryConfig.getSize().getValue());
        Assert.assertEquals((long)20L, (long)nativeMemoryConfig.getPageSize());
        Assert.assertEquals((Object)NativeMemoryConfig.MemoryAllocatorType.POOLED, (Object)nativeMemoryConfig.getAllocatorType());
        Assert.assertEquals((double)10.2, (double)nativeMemoryConfig.getMetadataSpacePercentage(), (double)0.1);
        Assert.assertEquals((long)10L, (long)nativeMemoryConfig.getMinBlockSize());
    }

    @Test
    public void testReplicatedMapConfig() {
        Assert.assertNotNull((Object)this.config);
        Assert.assertEquals((long)1L, (long)this.config.getReplicatedMapConfigs().size());
        ReplicatedMapConfig replicatedMapConfig = this.config.getReplicatedMapConfig("replicatedMap");
        Assert.assertNotNull((Object)replicatedMapConfig);
        Assert.assertEquals((Object)"replicatedMap", (Object)replicatedMapConfig.getName());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)replicatedMapConfig.getInMemoryFormat());
        Assert.assertEquals((long)200L, (long)replicatedMapConfig.getReplicationDelayMillis());
        Assert.assertEquals((long)16L, (long)replicatedMapConfig.getConcurrencyLevel());
        Assert.assertFalse((boolean)replicatedMapConfig.isAsyncFillup());
        Assert.assertFalse((boolean)replicatedMapConfig.isStatisticsEnabled());
        Assert.assertEquals((Object)"my-quorum", (Object)replicatedMapConfig.getQuorumName());
        MergePolicyConfig mergePolicyConfig = replicatedMapConfig.getMergePolicyConfig();
        Assert.assertNotNull((Object)mergePolicyConfig);
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
        replicatedMapConfig.getListenerConfigs();
        for (ListenerConfig listener : replicatedMapConfig.getListenerConfigs()) {
            if (listener.getClassName() != null) {
                Assert.assertNull((Object)listener.getImplementation());
                Assert.assertTrue((boolean)listener.isIncludeValue());
                Assert.assertFalse((boolean)listener.isLocal());
                continue;
            }
            Assert.assertNotNull((Object)listener.getImplementation());
            Assert.assertEquals((Object)this.entryListener, (Object)listener.getImplementation());
            Assert.assertTrue((boolean)listener.isLocal());
            Assert.assertTrue((boolean)listener.isIncludeValue());
        }
    }

    @Test
    public void testQuorumConfig() {
        Assert.assertNotNull((Object)this.config);
        Assert.assertEquals((long)3L, (long)this.config.getQuorumConfigs().size());
        QuorumConfig quorumConfig = this.config.getQuorumConfig("my-quorum");
        Assert.assertNotNull((Object)quorumConfig);
        Assert.assertEquals((Object)"my-quorum", (Object)quorumConfig.getName());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyQuorumFunction", (Object)quorumConfig.getQuorumFunctionClassName());
        Assert.assertTrue((boolean)quorumConfig.isEnabled());
        Assert.assertEquals((long)2L, (long)quorumConfig.getSize());
        Assert.assertEquals((long)2L, (long)quorumConfig.getListenerConfigs().size());
        Assert.assertEquals((Object)QuorumType.READ, (Object)quorumConfig.getType());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyQuorumListener", (Object)((QuorumListenerConfig)quorumConfig.getListenerConfigs().get(0)).getClassName());
        Assert.assertNotNull((Object)((QuorumListenerConfig)quorumConfig.getListenerConfigs().get(1)).getImplementation());
    }

    @Test
    public void testProbabilisticQuorumConfig() {
        QuorumConfig probabilisticQuorumConfig = this.config.getQuorumConfig("probabilistic-quorum");
        Assert.assertNotNull((Object)probabilisticQuorumConfig);
        Assert.assertEquals((Object)"probabilistic-quorum", (Object)probabilisticQuorumConfig.getName());
        Assert.assertNotNull((Object)probabilisticQuorumConfig.getQuorumFunctionImplementation());
        TestFullApplicationContext.assertInstanceOf(ProbabilisticQuorumFunction.class, (Object)probabilisticQuorumConfig.getQuorumFunctionImplementation());
        Assert.assertTrue((boolean)probabilisticQuorumConfig.isEnabled());
        Assert.assertEquals((long)3L, (long)probabilisticQuorumConfig.getSize());
        Assert.assertEquals((long)2L, (long)probabilisticQuorumConfig.getListenerConfigs().size());
        Assert.assertEquals((Object)QuorumType.READ_WRITE, (Object)probabilisticQuorumConfig.getType());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyQuorumListener", (Object)((QuorumListenerConfig)probabilisticQuorumConfig.getListenerConfigs().get(0)).getClassName());
        Assert.assertNotNull((Object)((QuorumListenerConfig)probabilisticQuorumConfig.getListenerConfigs().get(1)).getImplementation());
        ProbabilisticQuorumFunction quorumFunction = (ProbabilisticQuorumFunction)probabilisticQuorumConfig.getQuorumFunctionImplementation();
        Assert.assertEquals((double)11.0, (double)quorumFunction.getSuspicionThreshold(), (double)0.001);
        Assert.assertEquals((long)31415L, (long)quorumFunction.getAcceptableHeartbeatPauseMillis());
        Assert.assertEquals((long)42L, (long)quorumFunction.getMaxSampleSize());
        Assert.assertEquals((long)77123L, (long)quorumFunction.getHeartbeatIntervalMillis());
        Assert.assertEquals((long)1000L, (long)quorumFunction.getMinStdDeviationMillis());
    }

    @Test
    public void testRecentlyActiveQuorumConfig() {
        QuorumConfig recentlyActiveQuorumConfig = this.config.getQuorumConfig("recently-active-quorum");
        Assert.assertNotNull((Object)recentlyActiveQuorumConfig);
        Assert.assertEquals((Object)"recently-active-quorum", (Object)recentlyActiveQuorumConfig.getName());
        Assert.assertNotNull((Object)recentlyActiveQuorumConfig.getQuorumFunctionImplementation());
        TestFullApplicationContext.assertInstanceOf(RecentlyActiveQuorumFunction.class, (Object)recentlyActiveQuorumConfig.getQuorumFunctionImplementation());
        Assert.assertTrue((boolean)recentlyActiveQuorumConfig.isEnabled());
        Assert.assertEquals((long)5L, (long)recentlyActiveQuorumConfig.getSize());
        Assert.assertEquals((Object)QuorumType.READ_WRITE, (Object)recentlyActiveQuorumConfig.getType());
        RecentlyActiveQuorumFunction quorumFunction = (RecentlyActiveQuorumFunction)recentlyActiveQuorumConfig.getQuorumFunctionImplementation();
        Assert.assertEquals((long)5123L, (long)quorumFunction.getHeartbeatToleranceMillis());
    }

    @Test
    public void testFullQueryCacheConfig() {
        MapConfig mapConfig = this.config.getMapConfig("map-with-query-cache");
        QueryCacheConfig queryCacheConfig = (QueryCacheConfig)mapConfig.getQueryCacheConfigs().get(0);
        EntryListenerConfig entryListenerConfig = (EntryListenerConfig)queryCacheConfig.getEntryListenerConfigs().get(0);
        Assert.assertTrue((boolean)entryListenerConfig.isIncludeValue());
        Assert.assertFalse((boolean)entryListenerConfig.isLocal());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyEntryListener", (Object)entryListenerConfig.getClassName());
        Assert.assertFalse((boolean)queryCacheConfig.isIncludeValue());
        Assert.assertEquals((Object)"my-query-cache-1", (Object)queryCacheConfig.getName());
        Assert.assertEquals((long)12L, (long)queryCacheConfig.getBatchSize());
        Assert.assertEquals((long)33L, (long)queryCacheConfig.getBufferSize());
        Assert.assertEquals((long)12L, (long)queryCacheConfig.getDelaySeconds());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)queryCacheConfig.getInMemoryFormat());
        Assert.assertTrue((boolean)queryCacheConfig.isCoalesce());
        Assert.assertFalse((boolean)queryCacheConfig.isPopulate());
        this.assertIndexesEqual(queryCacheConfig);
        Assert.assertEquals((Object)"__key > 12", (Object)queryCacheConfig.getPredicateConfig().getSql());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)queryCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT, (Object)queryCacheConfig.getEvictionConfig().getMaximumSizePolicy());
        Assert.assertEquals((long)111L, (long)queryCacheConfig.getEvictionConfig().getSize());
    }

    private void assertIndexesEqual(QueryCacheConfig queryCacheConfig) {
        for (MapIndexConfig mapIndexConfig : queryCacheConfig.getIndexConfigs()) {
            Assert.assertEquals((Object)"name", (Object)mapIndexConfig.getAttribute());
            Assert.assertFalse((boolean)mapIndexConfig.isOrdered());
        }
    }

    @Test
    public void testMapNativeMaxSizePolicy() {
        MapConfig mapConfig = this.config.getMapConfig("map-with-native-max-size-policy");
        MaxSizeConfig maxSizeConfig = mapConfig.getMaxSizeConfig();
        Assert.assertEquals((Object)MaxSizeConfig.MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE, (Object)maxSizeConfig.getMaxSizePolicy());
    }

    @Test
    public void testHotRestart() {
        File dir = new File("/mnt/hot-restart/");
        File hotBackupDir = new File("/mnt/hot-backup/");
        HotRestartPersistenceConfig hotRestartPersistenceConfig = this.config.getHotRestartPersistenceConfig();
        Assert.assertTrue((boolean)hotRestartPersistenceConfig.isEnabled());
        Assert.assertEquals((Object)dir.getAbsolutePath(), (Object)hotRestartPersistenceConfig.getBaseDir().getAbsolutePath());
        Assert.assertEquals((Object)hotBackupDir.getAbsolutePath(), (Object)hotRestartPersistenceConfig.getBackupDir().getAbsolutePath());
        Assert.assertEquals((long)1111L, (long)hotRestartPersistenceConfig.getValidationTimeoutSeconds());
        Assert.assertEquals((long)2222L, (long)hotRestartPersistenceConfig.getDataLoadTimeoutSeconds());
        Assert.assertEquals((Object)HotRestartClusterDataRecoveryPolicy.PARTIAL_RECOVERY_MOST_COMPLETE, (Object)hotRestartPersistenceConfig.getClusterDataRecoveryPolicy());
    }

    @Test
    public void testMapEvictionPolicies() {
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)this.config.getMapConfig("lfuEvictionMap").getEvictionPolicy());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)this.config.getMapConfig("lruEvictionMap").getEvictionPolicy());
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)this.config.getMapConfig("noneEvictionMap").getEvictionPolicy());
        Assert.assertEquals((Object)EvictionPolicy.RANDOM, (Object)this.config.getMapConfig("randomEvictionMap").getEvictionPolicy());
    }

    @Test
    public void testMemberNearCacheEvictionPolicies() {
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)this.getNearCacheEvictionPolicy("lfuNearCacheEvictionMap", this.config));
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)this.getNearCacheEvictionPolicy("lruNearCacheEvictionMap", this.config));
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)this.getNearCacheEvictionPolicy("noneNearCacheEvictionMap", this.config));
        Assert.assertEquals((Object)EvictionPolicy.RANDOM, (Object)this.getNearCacheEvictionPolicy("randomNearCacheEvictionMap", this.config));
    }

    private EvictionPolicy getNearCacheEvictionPolicy(String mapName, Config config) {
        return config.getMapConfig(mapName).getNearCacheConfig().getEvictionConfig().getEvictionPolicy();
    }

    @Test
    public void testMapEvictionPolicyClassName() {
        MapConfig mapConfig = this.config.getMapConfig("mapWithMapEvictionPolicyClassName");
        String expectedComparatorClassName = "com.hazelcast.map.eviction.LRUEvictionPolicy";
        Assert.assertEquals((Object)expectedComparatorClassName, (Object)mapConfig.getMapEvictionPolicy().getClass().getName());
    }

    @Test
    public void testMapEvictionPolicyImpl() {
        MapConfig mapConfig = this.config.getMapConfig("mapWithMapEvictionPolicyImpl");
        Assert.assertEquals(DummyMapEvictionPolicy.class, mapConfig.getMapEvictionPolicy().getClass());
    }

    @Test
    public void testWhenBothMapEvictionPolicyClassNameAndEvictionPolicySet() {
        MapConfig mapConfig = this.config.getMapConfig("mapBothMapEvictionPolicyClassNameAndEvictionPolicy");
        String expectedComparatorClassName = "com.hazelcast.map.eviction.LRUEvictionPolicy";
        Assert.assertEquals((Object)expectedComparatorClassName, (Object)mapConfig.getMapEvictionPolicy().getClass().getName());
    }

    @Test
    public void testMapEventJournalConfigIsWellParsed() {
        EventJournalConfig journalConfig = this.config.getMapEventJournalConfig("mapName");
        Assert.assertTrue((boolean)journalConfig.isEnabled());
        Assert.assertEquals((long)123L, (long)journalConfig.getCapacity());
        Assert.assertEquals((long)321L, (long)journalConfig.getTimeToLiveSeconds());
    }

    @Test
    public void testCacheEventJournalConfigIsWellParsed() {
        EventJournalConfig journalConfig = this.config.getCacheEventJournalConfig("cacheName");
        Assert.assertTrue((boolean)journalConfig.isEnabled());
        Assert.assertEquals((long)123L, (long)journalConfig.getCapacity());
        Assert.assertEquals((long)321L, (long)journalConfig.getTimeToLiveSeconds());
    }

    @Test
    public void testExplicitPortCountConfiguration() {
        int portCount = this.instance.getConfig().getNetworkConfig().getPortCount();
        Assert.assertEquals((long)42L, (long)portCount);
    }
}

