/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.core.IMap;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.spring.cache.HazelcastCache;
import com.hazelcast.spring.cache.IDummyTimeoutBean;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public abstract class AbstractHazelcastCacheReadTimeoutTest
extends HazelcastTestSupport {
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IDummyTimeoutBean dummyTimeoutBean;
    private Cache delay150;
    private Cache delay50;
    private Cache delayNo;
    private Cache delay100;

    @Before
    public void setup() {
        this.delay150 = this.cacheManager.getCache("delay150");
        this.delay50 = this.cacheManager.getCache("delay50");
        this.delayNo = this.cacheManager.getCache("delayNo");
        this.delay100 = this.cacheManager.getCache("delay100");
        ((IMap)this.delay150.getNativeCache()).addInterceptor((MapInterceptor)new DelayIMapGetInterceptor(200));
        ((IMap)this.delay50.getNativeCache()).addInterceptor((MapInterceptor)new DelayIMapGetInterceptor(2));
        ((IMap)this.delayNo.getNativeCache()).addInterceptor((MapInterceptor)new DelayIMapGetInterceptor(300));
    }

    @Test
    public void testCache_TimeoutConfig() {
        Assert.assertEquals((long)150L, (long)((HazelcastCache)this.delay150).getReadTimeout());
        Assert.assertEquals((long)50L, (long)((HazelcastCache)this.delay50).getReadTimeout());
        Assert.assertEquals((long)0L, (long)((HazelcastCache)this.delayNo).getReadTimeout());
        Assert.assertEquals((long)100L, (long)((HazelcastCache)this.delay100).getReadTimeout());
    }

    @Test(expected=OperationTimeoutException.class)
    public void testCache_delay150() {
        this.delay150.get((Object)this.createRandomKey());
    }

    @Test
    public void testCache_delay50() {
        String key = this.createRandomKey();
        long start = System.nanoTime();
        try {
            this.delay50.get((Object)key);
        }
        catch (OperationTimeoutException e) {
            long deltaMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            Assert.assertTrue((deltaMs >= 50L ? 1 : 0) != 0);
            return;
        }
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        Assert.assertTrue((time >= 2L ? 1 : 0) != 0);
    }

    @Test
    public void testCache_delayNo() {
        String key = this.createRandomKey();
        long start = System.nanoTime();
        this.delayNo.get((Object)key);
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        Assert.assertTrue((time >= 300L ? 1 : 0) != 0);
    }

    @Test(expected=OperationTimeoutException.class)
    public void testBean_delay150() {
        this.dummyTimeoutBean.getDelay150(this.createRandomKey());
    }

    @Test
    public void testBean_delay50() {
        String key = this.createRandomKey();
        long start = System.nanoTime();
        try {
            this.dummyTimeoutBean.getDelay50(key);
        }
        catch (OperationTimeoutException e) {
            long deltaMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            Assert.assertTrue((deltaMs >= 50L ? 1 : 0) != 0);
            return;
        }
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        Assert.assertTrue((time >= 2L ? 1 : 0) != 0);
    }

    @Test
    public void testBean_delayNo() {
        String key = this.createRandomKey();
        long start = System.nanoTime();
        this.dummyTimeoutBean.getDelayNo(key);
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        Assert.assertTrue((time >= 300L ? 1 : 0) != 0);
    }

    private String createRandomKey() {
        return UUID.randomUUID().toString();
    }

    public static class DummyTimeoutBean
    implements IDummyTimeoutBean {
        @Override
        public Object getDelay150(String key) {
            return null;
        }

        @Override
        public Object getDelay50(String key) {
            return null;
        }

        @Override
        public Object getDelayNo(String key) {
            return null;
        }

        @Override
        public String getDelay100(String key) {
            return null;
        }
    }

    public static class DelayIMapGetInterceptor
    implements MapInterceptor {
        private final int delay;

        public DelayIMapGetInterceptor(int delay) {
            this.delay = delay;
        }

        public Object interceptGet(Object value) {
            HazelcastTestSupport.sleepMillis((int)this.delay);
            return null;
        }

        public void afterGet(Object value) {
        }

        public Object interceptPut(Object oldValue, Object newValue) {
            return null;
        }

        public void afterPut(Object value) {
        }

        public Object interceptRemove(Object removedValue) {
            return null;
        }

        public void afterRemove(Object value) {
        }
    }
}

