/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.security;

import com.hazelcast.config.Config;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.security.IPermissionPolicy;
import com.hazelcast.security.SecurityInterceptor;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.security.DummySecurityInterceptor;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"secure-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class SecureApplicationContextTest {
    @Resource
    private Config config;
    private SecurityConfig securityConfig;
    @Resource
    private ICredentialsFactory dummyCredentialsFactory;
    @Resource
    private IPermissionPolicy dummyPermissionPolicy;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Before
    public void init() {
        this.securityConfig = this.config.getSecurityConfig();
    }

    @Test
    public void testBasics() {
        Assert.assertNotNull((Object)this.securityConfig);
        Assert.assertTrue((boolean)this.securityConfig.isEnabled());
        Assert.assertTrue((boolean)this.securityConfig.getClientBlockUnmappedActions());
        Assert.assertNotNull((Object)this.securityConfig.getClientLoginModuleConfigs());
        Assert.assertFalse((boolean)this.securityConfig.getClientLoginModuleConfigs().isEmpty());
        Assert.assertNotNull((Object)this.securityConfig.getClientPermissionConfigs());
        Assert.assertFalse((boolean)this.securityConfig.getClientPermissionConfigs().isEmpty());
        Assert.assertNotNull((Object)this.securityConfig.getMemberLoginModuleConfigs());
        Assert.assertFalse((boolean)this.securityConfig.getMemberLoginModuleConfigs().isEmpty());
        Assert.assertNotNull((Object)this.securityConfig.getClientPolicyConfig());
        Assert.assertNotNull((Object)this.securityConfig.getMemberCredentialsConfig());
        Assert.assertEquals((long)1L, (long)this.securityConfig.getSecurityInterceptorConfigs().size());
    }

    @Test
    public void testMemberLoginConfigs() {
        List list = this.securityConfig.getMemberLoginModuleConfigs();
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        LoginModuleConfig lm = (LoginModuleConfig)list.get(0);
        Assert.assertEquals((Object)"com.hazelcast.examples.MyRequiredLoginModule", (Object)lm.getClassName());
        Assert.assertFalse((boolean)lm.getProperties().isEmpty());
        Assert.assertEquals((Object)LoginModuleConfig.LoginModuleUsage.REQUIRED, (Object)lm.getUsage());
    }

    @Test
    public void testClientLoginConfigs() {
        List list = this.securityConfig.getClientLoginModuleConfigs();
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        LoginModuleConfig lm1 = (LoginModuleConfig)list.get(0);
        Assert.assertEquals((Object)"com.hazelcast.examples.MyOptionalLoginModule", (Object)lm1.getClassName());
        Assert.assertFalse((boolean)lm1.getProperties().isEmpty());
        Assert.assertEquals((Object)LoginModuleConfig.LoginModuleUsage.OPTIONAL, (Object)lm1.getUsage());
        LoginModuleConfig lm2 = (LoginModuleConfig)list.get(1);
        Assert.assertEquals((Object)"com.hazelcast.examples.MyRequiredLoginModule", (Object)lm2.getClassName());
        Assert.assertFalse((boolean)lm2.getProperties().isEmpty());
        Assert.assertEquals((Object)LoginModuleConfig.LoginModuleUsage.REQUIRED, (Object)lm2.getUsage());
    }

    @Test
    public void testCredentialsFactory() {
        Assert.assertEquals((Object)"com.hazelcast.examples.MyCredentialsFactory", (Object)this.securityConfig.getMemberCredentialsConfig().getClassName());
        Assert.assertFalse((boolean)this.securityConfig.getMemberCredentialsConfig().getProperties().isEmpty());
        Assert.assertEquals((Object)this.dummyCredentialsFactory, (Object)this.securityConfig.getMemberCredentialsConfig().getImplementation());
    }

    @Test
    public void testPermissionPolicy() {
        Assert.assertEquals((Object)"com.hazelcast.examples.MyPermissionPolicy", (Object)this.securityConfig.getClientPolicyConfig().getClassName());
        Assert.assertFalse((boolean)this.securityConfig.getClientPolicyConfig().getProperties().isEmpty());
        Assert.assertEquals((Object)this.dummyPermissionPolicy, (Object)this.securityConfig.getClientPolicyConfig().getImplementation());
    }

    @Test
    public void testPermissions() {
        Set perms = this.securityConfig.getClientPermissionConfigs();
        Assert.assertFalse((boolean)perms.isEmpty());
        for (PermissionConfig permConfig : perms) {
            switch (permConfig.getType()) {
                case ALL: {
                    Assert.assertEquals((Object)"admin", (Object)permConfig.getPrincipal());
                    Assert.assertEquals((long)1L, (long)permConfig.getEndpoints().size());
                    Assert.assertEquals((Object)"127.0.0.1", permConfig.getEndpoints().iterator().next());
                    break;
                }
                case MAP: {
                    Assert.assertEquals((Object)"customMap", (Object)permConfig.getName());
                    Assert.assertEquals((Object)"dev", (Object)permConfig.getPrincipal());
                    Assert.assertEquals((long)1L, (long)permConfig.getEndpoints().size());
                    Assert.assertEquals((Object)"127.0.0.1", permConfig.getEndpoints().iterator().next());
                    break;
                }
                case QUEUE: {
                    Assert.assertEquals((Object)"customQ", (Object)permConfig.getName());
                    Assert.assertEquals((Object)"dev", (Object)permConfig.getPrincipal());
                    Assert.assertEquals((long)1L, (long)permConfig.getEndpoints().size());
                    Assert.assertEquals((Object)"127.0.0.1", permConfig.getEndpoints().iterator().next());
                    break;
                }
                case CACHE: {
                    Assert.assertEquals((Object)"test-cache", (Object)permConfig.getName());
                    Assert.assertEquals((Object)"dev", (Object)permConfig.getPrincipal());
                    Assert.assertEquals((long)1L, (long)permConfig.getEndpoints().size());
                    Assert.assertEquals((Object)"127.0.0.1", permConfig.getEndpoints().iterator().next());
                    Assert.assertEquals((long)4L, (long)permConfig.getActions().size());
                    Object[] expectedActions = new String[]{"create", "add", "read", "destroy"};
                    Object[] actualActions = permConfig.getActions().toArray(new String[0]);
                    Assert.assertArrayEquals((Object[])expectedActions, (Object[])actualActions);
                    break;
                }
                case CONFIG: {
                    Assert.assertEquals((Object)"dev", (Object)permConfig.getPrincipal());
                    Assert.assertEquals((long)1L, (long)permConfig.getEndpoints().size());
                    Assert.assertEquals((Object)"127.0.0.1", permConfig.getEndpoints().iterator().next());
                }
            }
        }
    }

    @Test
    public void testSecurityInterceptors() {
        List interceptorConfigs = this.securityConfig.getSecurityInterceptorConfigs();
        Assert.assertEquals((long)1L, (long)interceptorConfigs.size());
        SecurityInterceptorConfig interceptorConfig = (SecurityInterceptorConfig)interceptorConfigs.get(0);
        String className = interceptorConfig.getClassName();
        Assert.assertEquals((Object)DummySecurityInterceptor.class.getName(), (Object)className);
        SecurityInterceptor securityInterceptor = interceptorConfig.getImplementation();
        Assert.assertTrue((boolean)(securityInterceptor instanceof DummySecurityInterceptor));
    }
}

