/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.springaware;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.context.SpringManagedContext;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"springAware-enabled-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestEnabledSpringAwareAnnotation {
    @Autowired
    private ApplicationContext context;

    @BeforeClass
    @AfterClass
    public static void cleanup() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testSpringManagedContext() {
        HazelcastInstance instance = (HazelcastInstance)this.context.getBean("instance");
        Assert.assertTrue((boolean)(instance.getConfig().getManagedContext() instanceof SpringManagedContext));
        HazelcastClientProxy client = (HazelcastClientProxy)this.context.getBean("client");
        Assert.assertTrue((boolean)(client.getClientConfig().getManagedContext() instanceof SpringManagedContext));
    }
}

