/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import javax.annotation.Resource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"node-client-applicationContext-failover-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestSpringClientFailoverContext {
    @Resource
    private ApplicationContext applicationContext;

    @After
    public void teardown() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testBlueGreenClient() {
        HazelcastClientProxy blueGreenClient = (HazelcastClientProxy)this.applicationContext.getBean("blueGreenClient", HazelcastClientProxy.class);
        ClientFailoverConfig failoverConfig = blueGreenClient.client.getFailoverConfig();
        List clientConfigs = failoverConfig.getClientConfigs();
        Assert.assertEquals((long)2L, (long)clientConfigs.size());
        Assert.assertEquals((Object)"spring-group", (Object)((ClientConfig)clientConfigs.get(0)).getGroupConfig().getName());
        Assert.assertEquals((Object)"alternativeClusterName", (Object)((ClientConfig)clientConfigs.get(1)).getGroupConfig().getName());
        Assert.assertEquals((long)5L, (long)failoverConfig.getTryCount());
        blueGreenClient.shutdown();
    }
}

