/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.DummySocketInterceptor;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"clientNetworkConfig-applicationContext.xml"})
@Category(value={QuickTest.class})
public class TestClientNetworkConfig {
    @Resource(name="client")
    private HazelcastClientProxy client;

    @BeforeClass
    @AfterClass
    public static void start() {
        System.setProperty("test.keyStore", "private.jks");
        System.setProperty("test.trustStore", "trust.jks");
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void smokeMember() {
        int memberCountInConfigurationXml = 2;
        ClientConfig config = this.client.getClientConfig();
        Assert.assertEquals((long)memberCountInConfigurationXml, (long)config.getNetworkConfig().getAddresses().size());
    }

    @Test
    public void smokeSocketOptions() {
        int bufferSizeInConfigurationXml = 32;
        ClientConfig config = this.client.getClientConfig();
        Assert.assertEquals((long)bufferSizeInConfigurationXml, (long)config.getNetworkConfig().getSocketOptions().getBufferSize());
    }

    @Test
    public void smokeSocketInterceptor() {
        ClientConfig config = this.client.getClientConfig();
        SocketInterceptorConfig socketInterceptorConfig = config.getNetworkConfig().getSocketInterceptorConfig();
        Assert.assertFalse((boolean)socketInterceptorConfig.isEnabled());
        Assert.assertEquals((Object)DummySocketInterceptor.class.getName(), (Object)socketInterceptorConfig.getClassName());
    }

    @Test
    public void smokeSSLConfig() {
        ClientConfig config = this.client.getClientConfig();
        Assert.assertEquals((Object)"com.hazelcast.nio.ssl.BasicSSLContextFactory", (Object)config.getNetworkConfig().getSSLConfig().getFactoryClassName());
    }

    @Test
    public void smokeAwsConfig() {
        ClientAwsConfig aws = this.client.getClientConfig().getNetworkConfig().getAwsConfig();
        Assert.assertFalse((boolean)aws.isEnabled());
        Assert.assertEquals((Object)"sample-access-key", (Object)aws.getAccessKey());
        Assert.assertEquals((Object)"sample-secret-key", (Object)aws.getSecretKey());
        Assert.assertEquals((Object)"sample-region", (Object)aws.getRegion());
        Assert.assertEquals((Object)"sample-header", (Object)aws.getHostHeader());
        Assert.assertEquals((Object)"sample-group", (Object)aws.getSecurityGroupName());
        Assert.assertEquals((Object)"sample-tag-key", (Object)aws.getTagKey());
        Assert.assertEquals((Object)"sample-tag-value", (Object)aws.getTagValue());
        Assert.assertEquals((Object)"sample-role", (Object)aws.getIamRole());
    }

    @Test
    public void smokeGcpConfig() {
        GcpConfig gcp = this.client.getClientConfig().getNetworkConfig().getGcpConfig();
        Assert.assertFalse((boolean)gcp.isEnabled());
        Assert.assertEquals((Object)"us-east1-b,us-east1-c", (Object)gcp.getProperty("zones"));
    }

    @Test
    public void smokeAzureConfig() {
        AzureConfig azure = this.client.getClientConfig().getNetworkConfig().getAzureConfig();
        Assert.assertFalse((boolean)azure.isEnabled());
        Assert.assertEquals((Object)"CLIENT_ID", (Object)azure.getProperty("client-id"));
        Assert.assertEquals((Object)"CLIENT_SECRET", (Object)azure.getProperty("client-secret"));
        Assert.assertEquals((Object)"TENANT_ID", (Object)azure.getProperty("tenant-id"));
        Assert.assertEquals((Object)"SUB_ID", (Object)azure.getProperty("subscription-id"));
        Assert.assertEquals((Object)"HZLCAST001", (Object)azure.getProperty("cluster-id"));
        Assert.assertEquals((Object)"GROUP-NAME", (Object)azure.getProperty("group-name"));
    }

    @Test
    public void smokeKubernetesConfig() {
        KubernetesConfig kubernetes = this.client.getClientConfig().getNetworkConfig().getKubernetesConfig();
        Assert.assertFalse((boolean)kubernetes.isEnabled());
        Assert.assertEquals((Object)"MY-KUBERNETES-NAMESPACE", (Object)kubernetes.getProperty("namespace"));
        Assert.assertEquals((Object)"MY-SERVICE-NAME", (Object)kubernetes.getProperty("service-name"));
        Assert.assertEquals((Object)"MY-SERVICE-LABEL-NAME", (Object)kubernetes.getProperty("service-label-name"));
        Assert.assertEquals((Object)"MY-SERVICE-LABEL-VALUE", (Object)kubernetes.getProperty("service-label-value"));
    }

    @Test
    public void smokeEurekaConfig() {
        EurekaConfig eureka = this.client.getClientConfig().getNetworkConfig().getEurekaConfig();
        Assert.assertFalse((boolean)eureka.isEnabled());
        Assert.assertEquals((Object)"true", (Object)eureka.getProperty("self-registration"));
        Assert.assertEquals((Object)"hazelcast", (Object)eureka.getProperty("namespace"));
    }

    @Test
    public void smokeOutboundPorts() {
        Collection allowedPorts = this.client.getClientConfig().getNetworkConfig().getOutboundPortDefinitions();
        Assert.assertEquals((long)2L, (long)allowedPorts.size());
        Assert.assertTrue((boolean)allowedPorts.contains("34600"));
        Assert.assertTrue((boolean)allowedPorts.contains("34700-34710"));
    }
}

