/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.context;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spring.context.SomeBean;
import com.hazelcast.spring.context.SpringAware;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@SpringAware(beanName="someTask")
@Component(value="someTask")
@Scope(value="prototype")
public class SomeTask
implements Callable<Long>,
ApplicationContextAware,
DataSerializable {
    private transient ApplicationContext context;
    private transient SomeBean someBean;

    @Override
    public Long call() throws Exception {
        SomeBean bean = (SomeBean)this.context.getBean("someBean");
        Assert.assertEquals((Object)bean, (Object)this.someBean);
        return bean.value;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Autowired
    public void setSomeBean(SomeBean someBean) {
        this.someBean = someBean;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
    }

    public void readData(ObjectDataInput in) throws IOException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SomeTask)) {
            return false;
        }
        SomeTask someTask = (SomeTask)o;
        if (this.context != null ? !this.context.equals(someTask.context) : someTask.context != null) {
            return false;
        }
        return !(this.someBean != null ? !this.someBean.equals(someTask.someBean) : someTask.someBean != null);
    }

    public int hashCode() {
        int result = this.context != null ? this.context.hashCode() : 0;
        result = 31 * result + (this.someBean != null ? this.someBean.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SomeTask{context=" + this.context + ", someBean=" + this.someBean + '}';
    }
}

