/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.TestLoggingUtils;
import java.util.Set;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

public class CustomSpringJUnit4ClassRunner
extends SpringJUnit4ClassRunner {
    public CustomSpringJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        String testName = this.testName(method);
        TestLoggingUtils.setThreadLocalTestMethodName((String)testName);
        try {
            super.runChild(method, notifier);
        }
        finally {
            TestLoggingUtils.removeThreadLocalTestMethodName();
        }
    }

    protected Statement withAfterClasses(Statement statement) {
        final Statement originalStatement = super.withAfterClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                originalStatement.evaluate();
                Set instances = Hazelcast.getAllHazelcastInstances();
                if (!instances.isEmpty()) {
                    String message = "Instances haven't been shut down: " + instances;
                    Hazelcast.shutdownAll();
                    throw new IllegalStateException(message);
                }
            }
        };
    }

    static {
        TestLoggingUtils.initializeLogging();
        System.setProperty("java.net.preferIPv4Stack", "true");
        GroupProperty.WAIT_SECONDS_BEFORE_JOIN.setSystemProperty("1");
        GroupProperty.PHONE_HOME_ENABLED.setSystemProperty("false");
        System.setProperty("hazelcast.local.localAddress", "127.0.0.1");
    }
}

