/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.MultiMap;
import com.hazelcast.security.Credentials;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.TopicOverloadPolicy;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"node-client-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestClientApplicationContext {
    @Resource(name="client")
    private HazelcastClientProxy client;
    @Resource(name="client2")
    private HazelcastClientProxy client2;
    @Resource(name="client3")
    private HazelcastClientProxy client3;
    @Resource(name="client4")
    private HazelcastClientProxy client4;
    @Resource(name="client5")
    private HazelcastClientProxy client5;
    @Resource(name="client6")
    private HazelcastClientProxy client6;
    @Resource(name="client7-empty-serialization-config")
    private HazelcastClientProxy client7;
    @Resource(name="client8")
    private HazelcastClientProxy client8;
    @Resource(name="client9-user-code-deployment-test")
    private HazelcastClientProxy userCodeDeploymentTestClient;
    @Resource(name="client10-flakeIdGenerator")
    private HazelcastClientProxy client10;
    @Resource(name="client11-icmp-ping")
    private HazelcastClientProxy icmpPingTestClient;
    @Resource(name="client12-hazelcast-cloud")
    private HazelcastClientProxy hazelcastCloudClient;
    @Resource(name="client13-exponential-connection-retry")
    private HazelcastClientProxy connectionRetryClient;
    @Resource(name="client14-reliable-topic")
    private HazelcastClientProxy hazelcastReliableTopic;
    @Resource(name="client15-credentials-factory")
    private HazelcastClientProxy credentialsFactory;
    @Resource(name="client16-name-and-labels")
    private HazelcastClientProxy namedClient;
    @Resource(name="instance")
    private HazelcastInstance instance;
    @Resource(name="map1")
    private IMap<Object, Object> map1;
    @Resource(name="map2")
    private IMap<Object, Object> map2;
    @Resource(name="multiMap")
    private MultiMap multiMap;
    @Resource(name="queue")
    private IQueue queue;
    @Resource(name="topic")
    private ITopic topic;
    @Resource(name="set")
    private ISet set;
    @Resource(name="list")
    private IList list;
    @Resource(name="executorService")
    private ExecutorService executorService;
    @Resource(name="idGenerator")
    private IdGenerator idGenerator;
    @Resource(name="atomicLong")
    private IAtomicLong atomicLong;
    @Resource(name="atomicReference")
    private IAtomicReference atomicReference;
    @Resource(name="countDownLatch")
    private ICountDownLatch countDownLatch;
    @Resource(name="semaphore")
    private ISemaphore semaphore;
    @Resource(name="reliableTopic")
    private ITopic reliableTopic;
    @Autowired
    private Credentials credentials;

    @BeforeClass
    @AfterClass
    public static void start() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testClient() {
        Assert.assertNotNull((Object)this.client);
        Assert.assertNotNull((Object)this.client2);
        Assert.assertNotNull((Object)this.client3);
        ClientConfig config = this.client.getClientConfig();
        Assert.assertEquals((Object)"13", (Object)config.getProperty("hazelcast.client.retry.count"));
        Assert.assertEquals((long)3L, (long)config.getNetworkConfig().getConnectionAttemptLimit());
        Assert.assertEquals((long)1000L, (long)config.getNetworkConfig().getConnectionTimeout());
        Assert.assertEquals((long)3000L, (long)config.getNetworkConfig().getConnectionAttemptPeriod());
        ClientConfig config2 = this.client2.getClientConfig();
        Assert.assertEquals((Object)this.credentials, (Object)config2.getSecurityConfig().getCredentials());
        this.client.getMap("default").put((Object)"Q", (Object)"q");
        this.client2.getMap("default").put((Object)"X", (Object)"x");
        IMap map = this.instance.getMap("default");
        Assert.assertEquals((Object)"q", (Object)map.get((Object)"Q"));
        Assert.assertEquals((Object)"x", (Object)map.get((Object)"X"));
        ClientConfig config3 = this.client3.getClientConfig();
        SerializationConfig serConf = config3.getSerializationConfig();
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)serConf.getByteOrder());
        Assert.assertFalse((boolean)serConf.isAllowUnsafe());
        Assert.assertFalse((boolean)serConf.isCheckClassDefErrors());
        Assert.assertFalse((boolean)serConf.isEnableCompression());
        Assert.assertFalse((boolean)serConf.isEnableSharedObject());
        Assert.assertFalse((boolean)serConf.isUseNativeByteOrder());
        Assert.assertEquals((long)10L, (long)serConf.getPortableVersion());
        Map map1 = serConf.getDataSerializableFactoryClasses();
        Assert.assertNotNull((Object)map1);
        Assert.assertTrue((boolean)map1.containsKey(1));
        Assert.assertEquals((Object)"com.hazelcast.spring.serialization.DummyDataSerializableFactory", map1.get(1));
        Map portableFactoryClasses = serConf.getPortableFactoryClasses();
        Assert.assertNotNull((Object)portableFactoryClasses);
        Assert.assertTrue((boolean)portableFactoryClasses.containsKey(2));
        Assert.assertEquals((Object)"com.hazelcast.spring.serialization.DummyPortableFactory", portableFactoryClasses.get(2));
        Collection serializerConfigs = serConf.getSerializerConfigs();
        Assert.assertNotNull((Object)serializerConfigs);
        SerializerConfig serializerConfig = (SerializerConfig)serializerConfigs.iterator().next();
        Assert.assertNotNull((Object)serializerConfig);
        Assert.assertEquals((Object)"com.hazelcast.nio.serialization.CustomSerializationTest$FooXmlSerializer", (Object)serializerConfig.getClassName());
        Assert.assertEquals((Object)"com.hazelcast.nio.serialization.CustomSerializationTest$Foo", (Object)serializerConfig.getTypeClassName());
        List proxyFactoryConfigs = config3.getProxyFactoryConfigs();
        Assert.assertNotNull((Object)proxyFactoryConfigs);
        ProxyFactoryConfig proxyFactoryConfig = (ProxyFactoryConfig)proxyFactoryConfigs.get(0);
        Assert.assertNotNull((Object)proxyFactoryConfig);
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyProxyFactory", (Object)proxyFactoryConfig.getClassName());
        Assert.assertEquals((Object)"MyService", (Object)proxyFactoryConfig.getService());
        LoadBalancer loadBalancer = config3.getLoadBalancer();
        Assert.assertNotNull((Object)loadBalancer);
        Assert.assertTrue((boolean)(loadBalancer instanceof RoundRobinLB));
        NearCacheConfig nearCacheConfig = config3.getNearCacheConfig("default");
        Assert.assertNotNull((Object)nearCacheConfig);
        Assert.assertEquals((long)1L, (long)nearCacheConfig.getTimeToLiveSeconds());
        Assert.assertEquals((long)70L, (long)nearCacheConfig.getMaxIdleSeconds());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)nearCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((long)4000L, (long)nearCacheConfig.getEvictionConfig().getSize());
        Assert.assertTrue((boolean)nearCacheConfig.isInvalidateOnChange());
        Assert.assertFalse((boolean)nearCacheConfig.isSerializeKeys());
        Assert.assertEquals((Object)NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE, (Object)nearCacheConfig.getLocalUpdatePolicy());
    }

    @Test
    public void testAwsClientConfig() {
        Assert.assertNotNull((Object)this.client4);
        ClientConfig config = this.client4.getClientConfig();
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        ClientAwsConfig awsConfig = networkConfig.getAwsConfig();
        Assert.assertFalse((boolean)awsConfig.isEnabled());
        Assert.assertTrue((boolean)awsConfig.isInsideAws());
        Assert.assertEquals((Object)"sample-access-key", (Object)awsConfig.getAccessKey());
        Assert.assertEquals((Object)"sample-secret-key", (Object)awsConfig.getSecretKey());
        Assert.assertEquals((Object)"sample-region", (Object)awsConfig.getRegion());
        Assert.assertEquals((Object)"sample-group", (Object)awsConfig.getSecurityGroupName());
        Assert.assertEquals((Object)"sample-tag-key", (Object)awsConfig.getTagKey());
        Assert.assertEquals((Object)"sample-tag-value", (Object)awsConfig.getTagValue());
    }

    @Test
    public void testUnlimitedConnectionAttempt() {
        Assert.assertNotNull((Object)this.client5);
        ClientConfig config = this.client5.getClientConfig();
        Assert.assertEquals((long)0L, (long)config.getNetworkConfig().getConnectionAttemptLimit());
    }

    @Test
    public void testHazelcastInstances() {
        Assert.assertNotNull(this.map1);
        Assert.assertNotNull(this.map2);
        Assert.assertNotNull((Object)this.multiMap);
        Assert.assertNotNull((Object)this.queue);
        Assert.assertNotNull((Object)this.topic);
        Assert.assertNotNull((Object)this.set);
        Assert.assertNotNull((Object)this.list);
        Assert.assertNotNull((Object)this.executorService);
        Assert.assertNotNull((Object)this.idGenerator);
        Assert.assertNotNull((Object)this.atomicLong);
        Assert.assertNotNull((Object)this.atomicReference);
        Assert.assertNotNull((Object)this.countDownLatch);
        Assert.assertNotNull((Object)this.semaphore);
        Assert.assertNotNull((Object)this.reliableTopic);
        Assert.assertEquals((Object)"map1", (Object)this.map1.getName());
        Assert.assertEquals((Object)"map2", (Object)this.map2.getName());
        Assert.assertEquals((Object)"multiMap", (Object)this.multiMap.getName());
        Assert.assertEquals((Object)"queue", (Object)this.queue.getName());
        Assert.assertEquals((Object)"topic", (Object)this.topic.getName());
        Assert.assertEquals((Object)"set", (Object)this.set.getName());
        Assert.assertEquals((Object)"list", (Object)this.list.getName());
        Assert.assertEquals((Object)"idGenerator", (Object)this.idGenerator.getName());
        Assert.assertEquals((Object)"atomicLong", (Object)this.atomicLong.getName());
        Assert.assertEquals((Object)"atomicReference", (Object)this.atomicReference.getName());
        Assert.assertEquals((Object)"countDownLatch", (Object)this.countDownLatch.getName());
        Assert.assertEquals((Object)"semaphore", (Object)this.semaphore.getName());
        Assert.assertEquals((Object)"reliableTopic", (Object)this.reliableTopic.getName());
    }

    @Test
    public void testDefaultSerializationConfig() {
        ClientConfig config7 = this.client7.getClientConfig();
        SerializationConfig serConf = config7.getSerializationConfig();
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)serConf.getByteOrder());
        Assert.assertFalse((boolean)serConf.isAllowUnsafe());
        Assert.assertTrue((boolean)serConf.isCheckClassDefErrors());
        Assert.assertFalse((boolean)serConf.isEnableCompression());
        Assert.assertTrue((boolean)serConf.isEnableSharedObject());
        Assert.assertFalse((boolean)serConf.isUseNativeByteOrder());
        Assert.assertEquals((long)0L, (long)serConf.getPortableVersion());
    }

    @Test
    public void testClientNearCacheEvictionPolicies() {
        ClientConfig config = this.client3.getClientConfig();
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)this.getNearCacheEvictionPolicy("lfuNearCacheEviction", config));
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)this.getNearCacheEvictionPolicy("lruNearCacheEviction", config));
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)this.getNearCacheEvictionPolicy("noneNearCacheEviction", config));
        Assert.assertEquals((Object)EvictionPolicy.RANDOM, (Object)this.getNearCacheEvictionPolicy("randomNearCacheEviction", config));
    }

    @Test
    public void testNearCachePreloader() {
        NearCachePreloaderConfig preloaderConfig = this.client3.getClientConfig().getNearCacheConfig("preloader").getPreloaderConfig();
        Assert.assertTrue((boolean)preloaderConfig.isEnabled());
        Assert.assertEquals((Object)"/tmp/preloader", (Object)preloaderConfig.getDirectory());
        Assert.assertEquals((long)23L, (long)preloaderConfig.getStoreInitialDelaySeconds());
        Assert.assertEquals((long)42L, (long)preloaderConfig.getStoreIntervalSeconds());
    }

    @Test
    public void testUserCodeDeploymentConfig() {
        ClientConfig config = this.userCodeDeploymentTestClient.getClientConfig();
        ClientUserCodeDeploymentConfig userCodeDeploymentConfig = config.getUserCodeDeploymentConfig();
        List classNames = userCodeDeploymentConfig.getClassNames();
        Assert.assertFalse((boolean)userCodeDeploymentConfig.isEnabled());
        Assert.assertEquals((long)2L, (long)classNames.size());
        Assert.assertTrue((boolean)classNames.contains("SampleClassName1"));
        Assert.assertTrue((boolean)classNames.contains("SampleClassName2"));
        List jarPaths = userCodeDeploymentConfig.getJarPaths();
        Assert.assertEquals((long)1L, (long)jarPaths.size());
        Assert.assertTrue((boolean)jarPaths.contains("/User/jar/path/test.jar"));
    }

    private EvictionPolicy getNearCacheEvictionPolicy(String mapName, ClientConfig clientConfig) {
        return clientConfig.getNearCacheConfig(mapName).getEvictionConfig().getEvictionPolicy();
    }

    @Test
    public void testFullQueryCacheConfig() throws Exception {
        ClientConfig config = this.client6.getClientConfig();
        QueryCacheConfig queryCacheConfig = TestClientApplicationContext.getQueryCacheConfig(config);
        EntryListenerConfig entryListenerConfig = (EntryListenerConfig)queryCacheConfig.getEntryListenerConfigs().get(0);
        Assert.assertTrue((boolean)entryListenerConfig.isIncludeValue());
        Assert.assertFalse((boolean)entryListenerConfig.isLocal());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyEntryListener", (Object)entryListenerConfig.getClassName());
        Assert.assertFalse((boolean)queryCacheConfig.isIncludeValue());
        Assert.assertEquals((Object)"my-query-cache-1", (Object)queryCacheConfig.getName());
        Assert.assertEquals((long)12L, (long)queryCacheConfig.getBatchSize());
        Assert.assertEquals((long)33L, (long)queryCacheConfig.getBufferSize());
        Assert.assertEquals((long)12L, (long)queryCacheConfig.getDelaySeconds());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)queryCacheConfig.getInMemoryFormat());
        Assert.assertTrue((boolean)queryCacheConfig.isCoalesce());
        Assert.assertFalse((boolean)queryCacheConfig.isPopulate());
        Assert.assertEquals((Object)"__key > 12", (Object)queryCacheConfig.getPredicateConfig().getSql());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)queryCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT, (Object)queryCacheConfig.getEvictionConfig().getMaximumSizePolicy());
        Assert.assertEquals((long)111L, (long)queryCacheConfig.getEvictionConfig().getSize());
    }

    @Test
    public void testClientConnectionStrategyConfig() {
        ClientConnectionStrategyConfig connectionStrategyConfig = this.client8.getClientConfig().getConnectionStrategyConfig();
        Assert.assertTrue((boolean)connectionStrategyConfig.isAsyncStart());
        Assert.assertEquals((Object)ClientConnectionStrategyConfig.ReconnectMode.ASYNC, (Object)connectionStrategyConfig.getReconnectMode());
    }

    @Test
    public void testFlakeIdGeneratorConfig() {
        Map configMap = this.client10.getClientConfig().getFlakeIdGeneratorConfigMap();
        Assert.assertEquals((long)1L, (long)configMap.size());
        ClientFlakeIdGeneratorConfig config = (ClientFlakeIdGeneratorConfig)configMap.values().iterator().next();
        Assert.assertEquals((Object)"gen1", (Object)config.getName());
        Assert.assertEquals((long)3L, (long)config.getPrefetchCount());
        Assert.assertEquals((long)3000L, (long)config.getPrefetchValidityMillis());
    }

    @Test
    public void testCredentialsFactory() {
        ClientSecurityConfig securityConfig = this.credentialsFactory.getClientConfig().getSecurityConfig();
        CredentialsFactoryConfig credentialsFactoryConfig = securityConfig.getCredentialsFactoryConfig();
        Assert.assertEquals((Object)"com.hazelcast.examples.MyCredentialsFactory", (Object)credentialsFactoryConfig.getClassName());
        Assert.assertEquals((Object)"value", (Object)credentialsFactoryConfig.getProperties().getProperty("property"));
        Assert.assertNotNull((Object)credentialsFactoryConfig.getImplementation());
    }

    @Test
    public void testClientIcmpConfig() {
        ClientIcmpPingConfig icmpPingConfig = this.icmpPingTestClient.getClientConfig().getNetworkConfig().getClientIcmpPingConfig();
        Assert.assertEquals((Object)false, (Object)icmpPingConfig.isEnabled());
        Assert.assertEquals((long)2000L, (long)icmpPingConfig.getTimeoutMilliseconds());
        Assert.assertEquals((long)3000L, (long)icmpPingConfig.getIntervalMilliseconds());
        Assert.assertEquals((long)50L, (long)icmpPingConfig.getTtl());
        Assert.assertEquals((long)5L, (long)icmpPingConfig.getMaxAttempts());
        Assert.assertEquals((Object)false, (Object)icmpPingConfig.isEchoFailFastOnStartup());
    }

    @Test
    public void testCloudConfig() {
        ClientCloudConfig cloudConfig = this.hazelcastCloudClient.getClientConfig().getNetworkConfig().getCloudConfig();
        Assert.assertEquals((Object)false, (Object)cloudConfig.isEnabled());
        Assert.assertEquals((Object)"EXAMPLE_TOKEN", (Object)cloudConfig.getDiscoveryToken());
    }

    @Test
    public void testConnectionRetry() {
        ConnectionRetryConfig connectionRetryConfig = this.connectionRetryClient.getClientConfig().getConnectionStrategyConfig().getConnectionRetryConfig();
        Assert.assertTrue((boolean)connectionRetryConfig.isEnabled());
        Assert.assertTrue((boolean)connectionRetryConfig.isFailOnMaxBackoff());
        Assert.assertEquals((double)0.5, (double)connectionRetryConfig.getJitter(), (double)0.0);
        Assert.assertEquals((long)2000L, (long)connectionRetryConfig.getInitialBackoffMillis());
        Assert.assertEquals((long)60000L, (long)connectionRetryConfig.getMaxBackoffMillis());
        Assert.assertEquals((double)3.0, (double)connectionRetryConfig.getMultiplier(), (double)0.0);
    }

    @Test
    public void testReliableTopicConfig() {
        ClientConfig clientConfig = this.hazelcastReliableTopic.getClientConfig();
        ClientReliableTopicConfig topicConfig = clientConfig.getReliableTopicConfig("rel-topic");
        Assert.assertEquals((long)100L, (long)topicConfig.getReadBatchSize());
        Assert.assertEquals((Object)TopicOverloadPolicy.DISCARD_NEWEST, (Object)topicConfig.getTopicOverloadPolicy());
    }

    private static QueryCacheConfig getQueryCacheConfig(ClientConfig config) {
        Map queryCacheConfigs = config.getQueryCacheConfigs();
        Collection values = queryCacheConfigs.values();
        for (Map value : values) {
            Set entries = value.entrySet();
            Iterator iterator = entries.iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = iterator.next();
            return (QueryCacheConfig)entry.getValue();
        }
        return null;
    }

    @Test
    public void testInstanceNameConfig() {
        Assert.assertEquals((Object)"clientName", (Object)this.namedClient.getName());
    }

    @Test
    public void testLabelsConfig() {
        Set labels = this.namedClient.getClientConfig().getLabels();
        Assert.assertEquals((long)1L, (long)labels.size());
        HazelcastTestSupport.assertContains((Collection)labels, (Object)"foo");
    }
}

