/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.transaction;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.transaction.DummyObject;
import com.hazelcast.spring.transaction.ServiceBeanWithTransactionalContext;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionalTaskContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionSuspensionNotSupportedException;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"transaction-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestSpringManagedHazelcastTransaction {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Autowired
    ServiceBeanWithTransactionalContext service;
    @Autowired
    TransactionalTaskContext transactionalContext;
    @Autowired
    HazelcastInstance instance;

    @BeforeClass
    @AfterClass
    public static void cleanup() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Before
    public void setUp() {
        this.instance.getMap("dummyObjectMap").clear();
    }

    @Test
    public void noTransactionContextWhenNoTransaction() {
        this.expectedException.expect(NoTransactionException.class);
        this.transactionalContext.getMap("magic");
    }

    @Test
    @Transactional
    public void noExceptionWhenTransaction() {
        TransactionalMap magic = this.transactionalContext.getMap("magic");
        Assert.assertNotNull((Object)magic);
    }

    @Test
    public void transactionalServiceBeanInvocation_commit() {
        this.service.put(new DummyObject(1L, "magic"));
        Assert.assertEquals((long)1L, (long)this.instance.getMap("dummyObjectMap").size());
    }

    @Test
    public void transactionalServiceBeanInvocation_rollback() {
        RuntimeException expectedEx = null;
        try {
            this.service.putWithException(new DummyObject(1L, "magic"));
        }
        catch (RuntimeException ex) {
            try {
                expectedEx = ex;
            }
            catch (Throwable throwable) {
                Assert.assertNotNull(expectedEx);
                Assert.assertEquals((long)0L, (long)this.instance.getMap("dummyObjectMap").size());
                throw throwable;
            }
            Assert.assertNotNull((Object)expectedEx);
            Assert.assertEquals((long)0L, (long)this.instance.getMap("dummyObjectMap").size());
        }
        Assert.assertNotNull((Object)expectedEx);
        Assert.assertEquals((long)0L, (long)this.instance.getMap("dummyObjectMap").size());
    }

    @Test
    public void transactionalServiceBeanInvocation_withNestedBeanThrowingException_rollback() {
        RuntimeException expectedEx = null;
        try {
            this.service.putUsingSameBean_thenOtherBeanThrowingException_sameTransaction(new DummyObject(1L, "magic"), new DummyObject(2L, "magic2"));
        }
        catch (RuntimeException ex) {
            try {
                expectedEx = ex;
            }
            catch (Throwable throwable) {
                Assert.assertNotNull(expectedEx);
                Assert.assertEquals((long)0L, (long)this.instance.getMap("dummyObjectMap").size());
                throw throwable;
            }
            Assert.assertNotNull((Object)expectedEx);
            Assert.assertEquals((long)0L, (long)this.instance.getMap("dummyObjectMap").size());
        }
        Assert.assertNotNull((Object)expectedEx);
        Assert.assertEquals((long)0L, (long)this.instance.getMap("dummyObjectMap").size());
    }

    @Test
    public void transactionalServiceBeanInvocation_withOwnBeanThrowingException_rollback() {
        RuntimeException expectedEx = null;
        try {
            this.service.putUsingOtherBean_thenSameBeanThrowingException_sameTransaction(new DummyObject(1L, "magic"), new DummyObject(2L, "magic2"));
        }
        catch (RuntimeException ex) {
            try {
                expectedEx = ex;
            }
            catch (Throwable throwable) {
                Assert.assertNotNull(expectedEx);
                Assert.assertEquals((long)0L, (long)this.instance.getMap("dummyObjectMap").size());
                throw throwable;
            }
            Assert.assertNotNull((Object)expectedEx);
            Assert.assertEquals((long)0L, (long)this.instance.getMap("dummyObjectMap").size());
        }
        Assert.assertNotNull((Object)expectedEx);
        Assert.assertEquals((long)0L, (long)this.instance.getMap("dummyObjectMap").size());
    }

    @Test
    public void transactionalServiceBeanInvocation_nestedWithPropagationRequired() {
        this.service.putUsingOtherBean_sameTransaction(new DummyObject(1L, "magic"));
        Assert.assertEquals((long)1L, (long)this.instance.getMap("dummyObjectMap").size());
    }

    @Test
    public void transactionalServiceBeanInvocation_nestedWithPropagationRequiresNew() {
        this.expectedException.expect(TransactionSuspensionNotSupportedException.class);
        this.service.putUsingOtherBean_newTransaction(new DummyObject(1L, "magic"));
    }
}

