/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JobTrackerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapAttributeConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.config.QuorumListenerConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.spi.ServiceConfigurationParser;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastConfigBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlConfigBuilder springXmlConfigBuilder = new SpringXmlConfigBuilder(parserContext);
        springXmlConfigBuilder.handleConfig(element);
        return springXmlConfigBuilder.getBeanDefinition();
    }

    private class SpringXmlConfigBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private ManagedMap mapConfigManagedMap;
        private ManagedMap cacheConfigManagedMap;
        private ManagedMap queueManagedMap;
        private ManagedMap listManagedMap;
        private ManagedMap setManagedMap;
        private ManagedMap topicManagedMap;
        private ManagedMap multiMapManagedMap;
        private ManagedMap executorManagedMap;
        private ManagedMap wanReplicationManagedMap;
        private ManagedMap jobTrackerManagedMap;
        private ManagedMap replicatedMapManagedMap;
        private ManagedMap quorumManagedMap;

        public SpringXmlConfigBuilder(ParserContext parserContext) {
            super(HazelcastConfigBeanDefinitionParser.this);
            this.parserContext = parserContext;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(Config.class);
            this.mapConfigManagedMap = this.createManagedMap("mapConfigs");
            this.cacheConfigManagedMap = this.createManagedMap("cacheConfigs");
            this.queueManagedMap = this.createManagedMap("queueConfigs");
            this.listManagedMap = this.createManagedMap("listConfigs");
            this.setManagedMap = this.createManagedMap("setConfigs");
            this.topicManagedMap = this.createManagedMap("topicConfigs");
            this.multiMapManagedMap = this.createManagedMap("multiMapConfigs");
            this.executorManagedMap = this.createManagedMap("executorConfigs");
            this.wanReplicationManagedMap = this.createManagedMap("wanReplicationConfigs");
            this.jobTrackerManagedMap = this.createManagedMap("jobTrackerConfigs");
            this.replicatedMapManagedMap = this.createManagedMap("replicatedMapConfigs");
            this.quorumManagedMap = this.createManagedMap("quorumConfigs");
        }

        private ManagedMap createManagedMap(String configName) {
            ManagedMap managedMap = new ManagedMap();
            this.configBuilder.addPropertyValue(configName, (Object)managedMap);
            return managedMap;
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.configBuilder.getBeanDefinition();
        }

        public void handleConfig(Element element) {
            if (element != null) {
                this.handleCommonBeanAttributes(element, this.configBuilder, this.parserContext);
                for (Node node : SpringXmlConfigBuilder.childElements((Node)element)) {
                    String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)node);
                    if ("network".equals(nodeName)) {
                        this.handleNetwork(node);
                        continue;
                    }
                    if ("group".equals(nodeName)) {
                        this.handleGroup(node);
                        continue;
                    }
                    if ("properties".equals(nodeName)) {
                        this.handleProperties(node);
                        continue;
                    }
                    if ("executor-service".equals(nodeName)) {
                        this.handleExecutor(node);
                        continue;
                    }
                    if ("queue".equals(nodeName)) {
                        this.handleQueue(node);
                        continue;
                    }
                    if ("map".equals(nodeName)) {
                        this.handleMap(node);
                        continue;
                    }
                    if ("cache".equals(nodeName)) {
                        this.handleCache(node);
                        continue;
                    }
                    if ("multimap".equals(nodeName)) {
                        this.handleMultiMap(node);
                        continue;
                    }
                    if ("list".equals(nodeName)) {
                        this.handleList(node);
                        continue;
                    }
                    if ("set".equals(nodeName)) {
                        this.handleSet(node);
                        continue;
                    }
                    if ("topic".equals(nodeName)) {
                        this.handleTopic(node);
                        continue;
                    }
                    if ("jobtracker".equals(nodeName)) {
                        this.handleJobTracker(node);
                        continue;
                    }
                    if ("replicatedmap".equals(nodeName)) {
                        this.handleReplicatedMap(node);
                        continue;
                    }
                    if ("wan-replication".equals(nodeName)) {
                        this.handleWanReplication(node);
                        continue;
                    }
                    if ("partition-group".equals(nodeName)) {
                        this.handlePartitionGroup(node);
                        continue;
                    }
                    if ("serialization".equals(nodeName)) {
                        this.handleSerialization(node);
                        continue;
                    }
                    if ("native-memory".equals(nodeName)) {
                        this.handleNativeMemory(node);
                        continue;
                    }
                    if ("security".equals(nodeName)) {
                        this.handleSecurity(node);
                        continue;
                    }
                    if ("member-attributes".equals(nodeName)) {
                        this.handleMemberAttributes(node);
                        continue;
                    }
                    if ("instance-name".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("listeners".equals(nodeName)) {
                        ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                        this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                        continue;
                    }
                    if ("lite-member".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("license-key".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("management-center".equals(nodeName)) {
                        this.handleManagementCenter(node);
                        continue;
                    }
                    if ("services".equals(nodeName)) {
                        this.handleServices(node);
                        continue;
                    }
                    if ("spring-aware".equals(nodeName)) {
                        this.handleSpringAware();
                        continue;
                    }
                    if ("quorum".equals(nodeName)) {
                        this.handleQuorum(node);
                        continue;
                    }
                    if (!"hot-restart".equals(nodeName)) continue;
                    this.handleHotRestart(node);
                }
            }
        }

        private void handleHotRestart(Node node) {
            BeanDefinitionBuilder hotRestartConfigBuilder = this.createBeanBuilder(HotRestartConfig.class);
            this.fillAttributeValues(node, hotRestartConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"home-dir".equals(name)) continue;
                String value = this.getTextContent(child);
                hotRestartConfigBuilder.addPropertyValue("homeDir", (Object)value);
            }
            this.configBuilder.addPropertyValue("hotRestartConfig", (Object)hotRestartConfigBuilder.getBeanDefinition());
        }

        private void handleQuorum(Node node) {
            BeanDefinitionBuilder quorumConfigBuilder = this.createBeanBuilder(QuorumConfig.class);
            AbstractBeanDefinition beanDefinition = quorumConfigBuilder.getBeanDefinition();
            String name = this.getAttribute(node, "name");
            quorumConfigBuilder.addPropertyValue("name", (Object)name);
            Node attrEnabled = node.getAttributes().getNamedItem("enabled");
            boolean enabled = attrEnabled != null ? SpringXmlConfigBuilder.getBooleanValue((String)this.getTextContent(attrEnabled)) : false;
            quorumConfigBuilder.addPropertyValue("enabled", (Object)enabled);
            for (Node n : SpringXmlConfigBuilder.childElements((Node)node)) {
                String value = this.getTextContent(n).trim();
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)n);
                if ("quorum-size".equals(nodeName)) {
                    quorumConfigBuilder.addPropertyValue("size", (Object)SpringXmlConfigBuilder.getIntegerValue((String)"quorum-size", (String)value));
                    continue;
                }
                if ("quorum-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(n, QuorumListenerConfig.class);
                    quorumConfigBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-type".equals(nodeName)) {
                    quorumConfigBuilder.addPropertyValue("type", (Object)QuorumType.valueOf((String)value));
                    continue;
                }
                if (!"quorum-function-class-name".equals(nodeName)) continue;
                quorumConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)value);
            }
            this.quorumManagedMap.put((Object)name, (Object)beanDefinition);
        }

        public void handleServices(Node node) {
            BeanDefinitionBuilder servicesConfigBuilder = this.createBeanBuilder(ServicesConfig.class);
            AbstractBeanDefinition beanDefinition = servicesConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, servicesConfigBuilder, new String[0]);
            ManagedList serviceConfigManagedList = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"service".equals(nodeName)) continue;
                serviceConfigManagedList.add((Object)this.handleService(child));
            }
            servicesConfigBuilder.addPropertyValue("serviceConfigs", (Object)serviceConfigManagedList);
            this.configBuilder.addPropertyValue("servicesConfig", (Object)beanDefinition);
        }

        private AbstractBeanDefinition handleService(Node node) {
            BeanDefinitionBuilder serviceConfigBuilder = this.createBeanBuilder(ServiceConfig.class);
            AbstractBeanDefinition beanDefinition = serviceConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, serviceConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if ("name".equals(nodeName)) {
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                    continue;
                }
                if ("class-name".equals(nodeName)) {
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(child, serviceConfigBuilder);
                    continue;
                }
                if (!"configuration".equals(nodeName)) continue;
                Node parser = child.getAttributes().getNamedItem("parser");
                String name = this.getTextContent(parser);
                try {
                    ServiceConfigurationParser serviceConfigurationParser = (ServiceConfigurationParser)ClassLoaderUtil.newInstance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)name);
                    Object obj = serviceConfigurationParser.parse((Element)child);
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName("config-object"), obj);
                }
                catch (Exception e) {
                    ExceptionUtil.sneakyThrow((Throwable)e);
                }
            }
            return beanDefinition;
        }

        public void handleReplicatedMap(Node node) {
            BeanDefinitionBuilder replicatedMapConfigBuilder = this.createBeanBuilder(ReplicatedMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, replicatedMapConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                if (!"entry-listeners".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                replicatedMapConfigBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
            }
            this.replicatedMapManagedMap.put((Object)name, (Object)replicatedMapConfigBuilder.getBeanDefinition());
        }

        public void handleNetwork(Node node) {
            BeanDefinitionBuilder networkConfigBuilder = this.createBeanBuilder(NetworkConfig.class);
            AbstractBeanDefinition beanDefinition = networkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, networkConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, networkConfigBuilder);
                    continue;
                }
                if ("interfaces".equals(nodeName)) {
                    this.handleInterfaces(child, networkConfigBuilder);
                    continue;
                }
                if ("symmetric-encryption".equals(nodeName)) {
                    this.handleSymmetricEncryption(child, networkConfigBuilder);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("outbound-ports".equals(nodeName)) {
                    this.handleOutboundPorts(child, networkConfigBuilder);
                    continue;
                }
                if (!"reuse-address".equals(nodeName)) continue;
                this.handleReuseAddress(child, networkConfigBuilder);
            }
            this.configBuilder.addPropertyValue("networkConfig", (Object)beanDefinition);
        }

        public void handleGroup(Node node) {
            this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
        }

        public void handleProperties(Node node) {
            this.handleProperties(node, this.configBuilder);
        }

        public void handleInterfaces(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(InterfacesConfig.class);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
            ManagedList interfacesSet = new ManagedList();
            for (Node n : SpringXmlConfigBuilder.childElements((Node)node)) {
                String name = this.xmlToJavaName(SpringXmlConfigBuilder.cleanNodeName((Node)n));
                String value = this.getTextContent(n);
                if (!"interface".equals(name)) continue;
                interfacesSet.add((Object)value);
            }
            builder.addPropertyValue("interfaces", (Object)interfacesSet);
            networkConfigBuilder.addPropertyValue("interfaces", (Object)beanDefinition);
        }

        public void handleJoin(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder joinConfigBuilder = this.createBeanBuilder(JoinConfig.class);
            AbstractBeanDefinition beanDefinition = joinConfigBuilder.getBeanDefinition();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if ("multicast".equals(name)) {
                    this.handleMulticast(child, joinConfigBuilder);
                    continue;
                }
                if ("tcp-ip".equals(name)) {
                    this.handleTcpIp(child, joinConfigBuilder);
                    continue;
                }
                if (!"aws".equals(name)) continue;
                this.handleAws(child, joinConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("join", (Object)beanDefinition);
        }

        private void handleOutboundPorts(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            ManagedList outboundPorts = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"ports".equals(name)) continue;
                String value = this.getTextContent(child);
                outboundPorts.add((Object)value);
            }
            networkConfigBuilder.addPropertyValue("outboundPortDefinitions", (Object)outboundPorts);
        }

        private void handleReuseAddress(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String value = node.getTextContent();
            networkConfigBuilder.addPropertyValue("reuseAddress", (Object)value);
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, "factory-implementation");
            Node implNode = node.getAttributes().getNamedItem("factory-implementation");
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), implementation);
            }
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        public void handleSymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, SymmetricEncryptionConfig.class, "symmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleExecutor(Node node) {
            this.createAndFillListedBean(node, ExecutorConfig.class, "name", this.executorManagedMap, new String[0]);
        }

        public void handleMulticast(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.createAndFillBeanBuilder(node, MulticastConfig.class, "multicastConfig", joinConfigBuilder, new String[0]);
        }

        public void handleTcpIp(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, TcpIpConfig.class, "tcpIpConfig", joinConfigBuilder, "interface", "member", "members");
            ManagedList members = new ManagedList();
            for (Node n : SpringXmlConfigBuilder.childElements((Node)node)) {
                String name = this.xmlToJavaName(SpringXmlConfigBuilder.cleanNodeName((Node)n));
                if (!"member".equals(name) && !"members".equals(name) && !"interface".equals(name)) continue;
                String value = this.getTextContent(n);
                members.add((Object)value);
            }
            builder.addPropertyValue("members", (Object)members);
        }

        public void handleAws(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.createAndFillBeanBuilder(node, AwsConfig.class, "awsConfig", joinConfigBuilder, new String[0]);
        }

        public void handleQueue(Node node) {
            BeanDefinitionBuilder queueConfigBuilder = this.createBeanBuilder(QueueConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, queueConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    queueConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
                    continue;
                }
                if (!"queue-store".equals(nodeName)) continue;
                this.handleQueueStoreConfig(childNode, queueConfigBuilder);
            }
            this.queueManagedMap.put((Object)name, (Object)queueConfigBuilder.getBeanDefinition());
        }

        public void handleQueueStoreConfig(Node node, BeanDefinitionBuilder queueConfigBuilder) {
            BeanDefinitionBuilder queueStoreConfigBuilder = this.createBeanBuilder(QueueStoreConfig.class);
            AbstractBeanDefinition beanDefinition = queueStoreConfigBuilder.getBeanDefinition();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                if (!"properties".equals(SpringXmlConfigBuilder.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, queueStoreConfigBuilder);
                break;
            }
            String implAttrName = "store-implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillAttributeValues(node, queueStoreConfigBuilder, "store-implementation", "factory-implementation");
            NamedNodeMap attributes = node.getAttributes();
            Node implRef = attributes.getNamedItem("store-implementation");
            Node factoryImplRef = attributes.getNamedItem("factory-implementation");
            if (factoryImplRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("store-implementation"), this.getTextContent(implRef));
            }
            queueConfigBuilder.addPropertyValue("queueStoreConfig", (Object)beanDefinition);
        }

        public void handleList(Node node) {
            BeanDefinitionBuilder listConfigBuilder = this.createBeanBuilder(ListConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, listConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                if (!"item-listeners".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                listConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
            }
            this.listManagedMap.put((Object)name, (Object)listConfigBuilder.getBeanDefinition());
        }

        public void handleSet(Node node) {
            BeanDefinitionBuilder setConfigBuilder = this.createBeanBuilder(SetConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, setConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                if (!"item-listeners".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                setConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
            }
            this.setManagedMap.put((Object)name, (Object)setConfigBuilder.getBeanDefinition());
        }

        public void handleMap(Node node) {
            Node maxSizePolicyNode;
            BeanDefinitionBuilder mapConfigBuilder = this.createBeanBuilder(MapConfig.class);
            AbstractBeanDefinition beanDefinition = mapConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            mapConfigBuilder.addPropertyValue("name", (Object)name);
            this.fillAttributeValues(node, mapConfigBuilder, "maxSize", "maxSizePolicy");
            BeanDefinitionBuilder maxSizeConfigBuilder = this.createBeanBuilder(MaxSizeConfig.class);
            AbstractBeanDefinition maxSizeConfigBeanDefinition = maxSizeConfigBuilder.getBeanDefinition();
            mapConfigBuilder.addPropertyValue("maxSizeConfig", (Object)maxSizeConfigBeanDefinition);
            Node maxSizeNode = node.getAttributes().getNamedItem("max-size");
            if (maxSizeNode != null) {
                maxSizeConfigBuilder.addPropertyValue("size", (Object)this.getTextContent(maxSizeNode));
            }
            if ((maxSizePolicyNode = node.getAttributes().getNamedItem("max-size-policy")) != null) {
                maxSizeConfigBuilder.addPropertyValue(this.xmlToJavaName(SpringXmlConfigBuilder.cleanNodeName((Node)maxSizePolicyNode)), (Object)MaxSizeConfig.MaxSizePolicy.valueOf((String)this.getTextContent(maxSizePolicyNode)));
            }
            for (Node childNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                ManagedList listeners;
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)childNode);
                if ("map-store".equals(nodeName)) {
                    this.handleMapStoreConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("near-cache".equals(nodeName)) {
                    this.handleNearCacheConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("wan-replication-ref".equals(nodeName)) {
                    this.handleWanReplicationRef(mapConfigBuilder, childNode);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : SpringXmlConfigBuilder.childElements((Node)childNode)) {
                        BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(MapIndexConfig.class);
                        this.fillAttributeValues(indexNode, indexConfBuilder, new String[0]);
                        indexes.add((Object)indexConfBuilder.getBeanDefinition());
                    }
                    mapConfigBuilder.addPropertyValue("mapIndexConfigs", (Object)indexes);
                    continue;
                }
                if ("attributes".equals(nodeName)) {
                    ManagedList attributes = new ManagedList();
                    for (Node attributeNode : SpringXmlConfigBuilder.childElements((Node)childNode)) {
                        BeanDefinitionBuilder attributeConfBuilder = this.createBeanBuilder(MapAttributeConfig.class);
                        this.fillAttributeValues(attributeNode, attributeConfBuilder, new String[0]);
                        attributes.add((Object)attributeConfBuilder.getBeanDefinition());
                    }
                    mapConfigBuilder.addPropertyValue("mapAttributeConfigs", (Object)attributes);
                    continue;
                }
                if ("entry-listeners".equals(nodeName)) {
                    listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    mapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    mapConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(node));
                    continue;
                }
                if ("query-caches".equals(nodeName)) {
                    ManagedList queryCaches = this.getQueryCaches(childNode);
                    mapConfigBuilder.addPropertyValue("queryCacheConfigs", (Object)queryCaches);
                    continue;
                }
                if (!"partition-lost-listeners".endsWith(nodeName)) continue;
                listeners = this.parseListeners(childNode, MapPartitionLostListenerConfig.class);
                mapConfigBuilder.addPropertyValue("partitionLostListenerConfigs", (Object)listeners);
            }
            this.mapConfigManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private ManagedList getQueryCaches(Node childNode) {
            ManagedList queryCaches = new ManagedList();
            for (Node queryCacheNode : SpringXmlConfigBuilder.childElements((Node)childNode)) {
                BeanDefinitionBuilder beanDefinitionBuilder = this.parseQueryCaches(queryCacheNode);
                queryCaches.add((Object)beanDefinitionBuilder.getBeanDefinition());
            }
            return queryCaches;
        }

        private BeanDefinitionBuilder parseQueryCaches(Node queryCacheNode) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(QueryCacheConfig.class);
            for (Node node : SpringXmlConfigBuilder.childElements((Node)queryCacheNode)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)node);
                String textContent = this.getTextContent(node);
                NamedNodeMap attrs = queryCacheNode.getAttributes();
                String cacheName = this.getTextContent(attrs.getNamedItem("name"));
                builder.addPropertyValue("name", (Object)cacheName);
                if ("predicate".equals(nodeName)) {
                    BeanDefinitionBuilder predicateBuilder = this.createBeanBuilder(PredicateConfig.class);
                    String predicateType = this.getTextContent(node.getAttributes().getNamedItem("type"));
                    if ("sql".equals(predicateType)) {
                        predicateBuilder.addPropertyValue("sql", (Object)textContent);
                    } else if ("class-name".equals(predicateType)) {
                        predicateBuilder.addPropertyValue("className", (Object)textContent);
                    }
                    builder.addPropertyValue("predicateConfig", (Object)predicateBuilder.getBeanDefinition());
                    continue;
                }
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList listeners = new ManagedList();
                    String implementationAttr = "implementation";
                    for (Node listenerNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                        BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(EntryListenerConfig.class);
                        this.fillAttributeValues(listenerNode, listenerConfBuilder, "implementation");
                        Node implementationNode = listenerNode.getAttributes().getNamedItem("implementation");
                        if (implementationNode != null) {
                            listenerConfBuilder.addPropertyReference("implementation", this.getTextContent(implementationNode));
                        }
                        listeners.add((Object)listenerConfBuilder.getBeanDefinition());
                    }
                    builder.addPropertyValue("entryListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("include-value".equals(nodeName)) {
                    boolean includeValue = SpringXmlConfigBuilder.getBooleanValue((String)textContent);
                    builder.addPropertyValue("includeValue", (Object)includeValue);
                    continue;
                }
                if ("batch-size".equals(nodeName)) {
                    int batchSize = SpringXmlConfigBuilder.getIntegerValue((String)"batch-size", (String)textContent.trim());
                    builder.addPropertyValue("batchSize", (Object)batchSize);
                    continue;
                }
                if ("buffer-size".equals(nodeName)) {
                    int bufferSize = SpringXmlConfigBuilder.getIntegerValue((String)"buffer-size", (String)textContent.trim());
                    builder.addPropertyValue("bufferSize", (Object)bufferSize);
                    continue;
                }
                if ("delay-seconds".equals(nodeName)) {
                    int delaySeconds = SpringXmlConfigBuilder.getIntegerValue((String)"delay-seconds", (String)textContent.trim());
                    builder.addPropertyValue("delaySeconds", (Object)delaySeconds);
                    continue;
                }
                if ("in-memory-format".equals(nodeName)) {
                    String value = textContent.trim();
                    builder.addPropertyValue("inMemoryFormat", (Object)InMemoryFormat.valueOf((String)StringUtil.upperCaseInternal((String)value)));
                    continue;
                }
                if ("coalesce".equals(nodeName)) {
                    boolean coalesce = SpringXmlConfigBuilder.getBooleanValue((String)textContent);
                    builder.addPropertyValue("coalesce", (Object)coalesce);
                    continue;
                }
                if ("populate".equals(nodeName)) {
                    boolean populate = SpringXmlConfigBuilder.getBooleanValue((String)textContent);
                    builder.addPropertyValue("populate", (Object)populate);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                        BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(MapIndexConfig.class);
                        this.fillAttributeValues(indexNode, indexConfBuilder, new String[0]);
                        indexes.add((Object)indexConfBuilder.getBeanDefinition());
                    }
                    builder.addPropertyValue("indexConfigs", (Object)indexes);
                    continue;
                }
                if (!"eviction".equals(nodeName)) continue;
                builder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node));
            }
            return builder;
        }

        public void handleCache(Node node) {
            BeanDefinitionBuilder cacheConfigBuilder = this.createBeanBuilder(CacheSimpleConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, cacheConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                ManagedList listeners;
                if ("eviction".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) {
                    EvictionConfig evictionConfig = this.getEvictionConfig(childNode);
                    EvictionPolicy evictionPolicy = evictionConfig.getEvictionPolicy();
                    if (evictionPolicy == null || evictionPolicy == EvictionPolicy.NONE) {
                        throw new InvalidConfigurationException("Eviction policy of cache cannot be null or \"NONE\"");
                    }
                    cacheConfigBuilder.addPropertyValue("evictionConfig", (Object)evictionConfig);
                    continue;
                }
                if ("expiry-policy-factory".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) {
                    cacheConfigBuilder.addPropertyValue("expiryPolicyFactoryConfig", (Object)this.getExpiryPolicyFactoryConfig(childNode));
                    continue;
                }
                if ("cache-entry-listeners".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) {
                    listeners = new ManagedList();
                    for (Node listenerNode : SpringXmlConfigBuilder.childElements((Node)childNode)) {
                        BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(CacheSimpleEntryListenerConfig.class);
                        this.fillAttributeValues(listenerNode, listenerConfBuilder, new String[0]);
                        listeners.add((Object)listenerConfBuilder.getBeanDefinition());
                    }
                    cacheConfigBuilder.addPropertyValue("cacheEntryListeners", (Object)listeners);
                    continue;
                }
                if ("wan-replication-ref".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) {
                    this.handleWanReplicationRef(cacheConfigBuilder, childNode);
                    continue;
                }
                if ("partition-lost-listeners".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) {
                    listeners = this.parseListeners(childNode, CachePartitionLostListenerConfig.class);
                    cacheConfigBuilder.addPropertyValue("partitionLostListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) {
                    cacheConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("partition-lost-listeners".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) {
                    listeners = this.parseListeners(childNode, CachePartitionLostListenerConfig.class);
                    cacheConfigBuilder.addPropertyValue("partitionLostListenerConfigs", (Object)listeners);
                    continue;
                }
                if (!"merge-policy".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) continue;
                cacheConfigBuilder.addPropertyValue("mergePolicy", (Object)this.getTextContent(childNode));
            }
            this.cacheConfigManagedMap.put((Object)name, (Object)cacheConfigBuilder.getBeanDefinition());
        }

        public void handleWanReplication(Node node) {
            BeanDefinitionBuilder wanRepConfigBuilder = this.createBeanBuilder(WanReplicationConfig.class);
            AbstractBeanDefinition beanDefinition = wanRepConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            wanRepConfigBuilder.addPropertyValue("name", (Object)name);
            Node attSnapshotEnabled = node.getAttributes().getNamedItem("snapshot-enabled");
            boolean snapshotEnabled = SpringXmlConfigBuilder.getBooleanValue((String)this.getTextContent(attSnapshotEnabled));
            wanRepConfigBuilder.addPropertyValue("snapshotEnabled", (Object)snapshotEnabled);
            ManagedList targetClusters = new ManagedList();
            for (Node n : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nName = SpringXmlConfigBuilder.cleanNodeName((Node)n);
                if (!"target-cluster".equals(nName)) continue;
                BeanDefinitionBuilder targetClusterConfigBuilder = this.createBeanBuilder(WanTargetClusterConfig.class);
                AbstractBeanDefinition childBeanDefinition = targetClusterConfigBuilder.getBeanDefinition();
                this.fillAttributeValues(n, targetClusterConfigBuilder, Collections.<String>emptyList());
                for (Node childNode : SpringXmlConfigBuilder.childElements((Node)n)) {
                    String childNodeName = SpringXmlConfigBuilder.cleanNodeName((Node)childNode);
                    if ("replication-impl".equals(childNodeName)) {
                        targetClusterConfigBuilder.addPropertyValue(this.xmlToJavaName(childNodeName), (Object)this.getTextContent(childNode));
                        continue;
                    }
                    if ("replication-impl-object".equals(childNodeName)) {
                        Node refName = childNode.getAttributes().getNamedItem("ref");
                        targetClusterConfigBuilder.addPropertyReference(this.xmlToJavaName(childNodeName), this.getTextContent(refName));
                        continue;
                    }
                    if ("end-points".equals(childNodeName)) {
                        ManagedList addresses = new ManagedList();
                        for (Node addressNode : SpringXmlConfigBuilder.childElements((Node)childNode)) {
                            if (!"address".equals(SpringXmlConfigBuilder.cleanNodeName((Node)addressNode))) continue;
                            addresses.add((Object)this.getTextContent(addressNode));
                        }
                        targetClusterConfigBuilder.addPropertyValue("endpoints", (Object)addresses);
                        continue;
                    }
                    if (!"acknowledge-type".equals(childNodeName)) continue;
                    targetClusterConfigBuilder.addPropertyValue(this.xmlToJavaName(childNodeName), (Object)this.getTextContent(childNode));
                }
                targetClusters.add((Object)childBeanDefinition);
            }
            wanRepConfigBuilder.addPropertyValue("targetClusterConfigs", (Object)targetClusters);
            this.wanReplicationManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private void handlePartitionGroup(Node node) {
            BeanDefinitionBuilder partitionConfigBuilder = this.createBeanBuilder(PartitionGroupConfig.class);
            this.fillAttributeValues(node, partitionConfigBuilder, new String[0]);
            ManagedList memberGroups = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"member-group".equals(name)) continue;
                BeanDefinitionBuilder memberGroupBuilder = this.createBeanBuilder(MemberGroupConfig.class);
                ManagedList interfaces = new ManagedList();
                for (Node n : SpringXmlConfigBuilder.childElements((Node)child)) {
                    if (!"interface".equals(SpringXmlConfigBuilder.cleanNodeName((Node)n))) continue;
                    interfaces.add((Object)this.getTextContent(n));
                }
                memberGroupBuilder.addPropertyValue("interfaces", (Object)interfaces);
                memberGroups.add((Object)memberGroupBuilder.getBeanDefinition());
            }
            partitionConfigBuilder.addPropertyValue("memberGroupConfigs", (Object)memberGroups);
            this.configBuilder.addPropertyValue("partitionGroupConfig", (Object)partitionConfigBuilder.getBeanDefinition());
        }

        private void handleManagementCenter(Node node) {
            this.createAndFillBeanBuilder(node, ManagementCenterConfig.class, "managementCenterConfig", this.configBuilder, new String[0]);
        }

        public void handleNearCacheConfig(Node node, BeanDefinitionBuilder configBuilder) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class);
            this.fillAttributeValues(node, nearCacheConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)childNode);
                if (!"eviction".equals(nodeName)) continue;
                this.handleEvictionConfig(childNode, nearCacheConfigBuilder);
            }
            configBuilder.addPropertyValue("nearCacheConfig", (Object)nearCacheConfigBuilder.getBeanDefinition());
        }

        private void handleEvictionConfig(Node node, BeanDefinitionBuilder configBuilder) {
            configBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node));
        }

        private CacheSimpleConfig.ExpiryPolicyFactoryConfig getExpiryPolicyFactoryConfig(Node node) {
            String className = this.getAttribute(node, "class-name");
            if (!StringUtil.isNullOrEmpty((String)className)) {
                return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(className);
            }
            CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = null;
            for (Node n : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)n);
                if (!"timed-expiry-policy-factory".equals(nodeName)) continue;
                String expiryPolicyTypeStr = this.getAttribute(n, "expiry-policy-type");
                String durationAmountStr = this.getAttribute(n, "duration-amount");
                String timeUnitStr = this.getAttribute(n, "time-unit");
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType = CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.valueOf((String)StringUtil.upperCaseInternal((String)expiryPolicyTypeStr));
                if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL && (StringUtil.isNullOrEmpty((String)durationAmountStr) || StringUtil.isNullOrEmpty((String)timeUnitStr))) {
                    throw new InvalidConfigurationException("Both of the \"duration-amount\" or \"time-unit\" attributes are required for expiry policy factory configuration (except \"ETERNAL\" expiry policy type)");
                }
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = null;
                if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL) {
                    long durationAmount = Long.parseLong(durationAmountStr);
                    TimeUnit timeUnit = TimeUnit.valueOf(StringUtil.upperCaseInternal((String)timeUnitStr));
                    durationConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig(durationAmount, timeUnit);
                }
                timedExpiryPolicyFactoryConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig(expiryPolicyType, durationConfig);
            }
            if (timedExpiryPolicyFactoryConfig == null) {
                throw new InvalidConfigurationException("One of the \"class-name\" or \"timed-expire-policy-factory\" configuration is needed for expiry policy factory configuration");
            }
            return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(timedExpiryPolicyFactoryConfig);
        }

        public void handleMapStoreConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder mapStoreConfigBuilder = this.createBeanBuilder(MapStoreConfig.class);
            AbstractBeanDefinition beanDefinition = mapStoreConfigBuilder.getBeanDefinition();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                if (!"properties".equals(SpringXmlConfigBuilder.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, mapStoreConfigBuilder);
                break;
            }
            String implAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            String initialModeAttrName = "initial-mode";
            this.fillAttributeValues(node, mapStoreConfigBuilder, "implementation", "factory-implementation", "initialMode");
            NamedNodeMap attrs = node.getAttributes();
            Node implRef = attrs.getNamedItem("implementation");
            Node factoryImplRef = attrs.getNamedItem("factory-implementation");
            Node initialMode = attrs.getNamedItem("initial-mode");
            if (factoryImplRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("implementation"), this.getTextContent(implRef));
            }
            if (initialMode != null) {
                MapStoreConfig.InitialLoadMode mode = MapStoreConfig.InitialLoadMode.valueOf((String)StringUtil.upperCaseInternal((String)this.getTextContent(initialMode)));
                mapStoreConfigBuilder.addPropertyValue("initialLoadMode", (Object)mode);
            }
            mapConfigBuilder.addPropertyValue("mapStoreConfig", (Object)beanDefinition);
        }

        public void handleMultiMap(Node node) {
            BeanDefinitionBuilder multiMapConfigBuilder = this.createBeanBuilder(MultiMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, multiMapConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                if (!"entry-listeners".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                multiMapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
            }
            this.multiMapManagedMap.put((Object)name, (Object)multiMapConfigBuilder.getBeanDefinition());
        }

        public void handleTopic(Node node) {
            BeanDefinitionBuilder topicConfigBuilder = this.createBeanBuilder(TopicConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, topicConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements((Node)node)) {
                if ("message-listeners".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) {
                    ManagedList listeners = this.parseListeners(childNode, ListenerConfig.class);
                    topicConfigBuilder.addPropertyValue("messageListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("statistics-enabled".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) {
                    String statisticsEnabled = this.getTextContent(childNode);
                    topicConfigBuilder.addPropertyValue("statisticsEnabled", (Object)statisticsEnabled);
                    continue;
                }
                if (!"global-ordering-enabled".equals(SpringXmlConfigBuilder.cleanNodeName((Node)childNode))) continue;
                String globalOrderingEnabled = this.getTextContent(childNode);
                topicConfigBuilder.addPropertyValue("globalOrderingEnabled", (Object)globalOrderingEnabled);
            }
            this.topicManagedMap.put((Object)name, (Object)topicConfigBuilder.getBeanDefinition());
        }

        public void handleJobTracker(Node node) {
            BeanDefinitionBuilder jobTrackerConfigBuilder = this.createBeanBuilder(JobTrackerConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, jobTrackerConfigBuilder, new String[0]);
            this.jobTrackerManagedMap.put((Object)name, (Object)jobTrackerConfigBuilder.getBeanDefinition());
        }

        private void handleSecurity(Node node) {
            BeanDefinitionBuilder securityConfigBuilder = this.createBeanBuilder(SecurityConfig.class);
            AbstractBeanDefinition beanDefinition = securityConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, securityConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if ("member-credentials-factory".equals(nodeName)) {
                    this.handleCredentialsFactory(child, securityConfigBuilder);
                    continue;
                }
                if ("member-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, true);
                    continue;
                }
                if ("client-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, false);
                    continue;
                }
                if ("client-permission-policy".equals(nodeName)) {
                    this.handlePermissionPolicy(child, securityConfigBuilder);
                    continue;
                }
                if ("client-permissions".equals(nodeName)) {
                    this.handleSecurityPermissions(child, securityConfigBuilder);
                    continue;
                }
                if (!"security-interceptors".equals(nodeName)) continue;
                this.handleSecurityInterceptors(child, securityConfigBuilder);
            }
            this.configBuilder.addPropertyValue("securityConfig", (Object)beanDefinition);
        }

        private void handleMemberAttributes(Node node) {
            BeanDefinitionBuilder memberAttributeConfigBuilder = this.createBeanBuilder(MemberAttributeConfig.class);
            AbstractBeanDefinition beanDefinition = memberAttributeConfigBuilder.getBeanDefinition();
            ManagedMap attributes = new ManagedMap();
            for (Node n : SpringXmlConfigBuilder.childElements((Node)node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName((Node)n);
                if (!"attribute".equals(name)) continue;
                String attributeName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String attributeType = this.getTextContent(n.getAttributes().getNamedItem("type")).trim();
                String value = this.getTextContent(n);
                Object oValue = "string".equals(attributeType) ? value : ("boolean".equals(attributeType) ? Boolean.valueOf(Boolean.parseBoolean(value)) : ("byte".equals(attributeType) ? Byte.valueOf(Byte.parseByte(value)) : ("double".equals(attributeType) ? Double.valueOf(Double.parseDouble(value)) : ("float".equals(attributeType) ? Float.valueOf(Float.parseFloat(value)) : ("int".equals(attributeType) ? Integer.valueOf(Integer.parseInt(value)) : ("long".equals(attributeType) ? Long.valueOf(Long.parseLong(value)) : ("short".equals(attributeType) ? Short.valueOf(Short.parseShort(value)) : value)))))));
                attributes.put((Object)attributeName, oValue);
            }
            memberAttributeConfigBuilder.addPropertyValue("attributes", (Object)attributes);
            this.configBuilder.addPropertyValue("memberAttributeConfig", (Object)beanDefinition);
        }

        private void handleNativeMemory(Node node) {
            BeanDefinitionBuilder nativeMemoryConfigBuilder = this.createBeanBuilder(NativeMemoryConfig.class);
            AbstractBeanDefinition beanDefinition = nativeMemoryConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, nativeMemoryConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"size".equals(nodeName)) continue;
                this.handleMemorySizeConfig(child, nativeMemoryConfigBuilder);
            }
            this.configBuilder.addPropertyValue("nativeMemoryConfig", (Object)beanDefinition);
        }

        private void handleMemorySizeConfig(Node node, BeanDefinitionBuilder nativeMemoryConfigBuilder) {
            BeanDefinitionBuilder memorySizeConfigBuilder = this.createBeanBuilder(MemorySize.class);
            NamedNodeMap attrs = node.getAttributes();
            Node value = attrs.getNamedItem("value");
            Node unit = attrs.getNamedItem("unit");
            memorySizeConfigBuilder.addConstructorArgValue((Object)this.getTextContent(value));
            memorySizeConfigBuilder.addConstructorArgValue((Object)MemoryUnit.valueOf((String)this.getTextContent(unit)));
            nativeMemoryConfigBuilder.addPropertyValue("size", (Object)memorySizeConfigBuilder.getBeanDefinition());
        }

        private void handleSecurityInterceptors(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedList lms = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"interceptor".equals(nodeName)) continue;
                BeanDefinitionBuilder siConfigBuilder = this.createBeanBuilder(SecurityInterceptorConfig.class);
                AbstractBeanDefinition beanDefinition = siConfigBuilder.getBeanDefinition();
                NamedNodeMap attrs = child.getAttributes();
                Node classNameNode = attrs.getNamedItem("class-name");
                String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
                Node implNode = attrs.getNamedItem("implementation");
                String implementation = implNode != null ? this.getTextContent(implNode) : null;
                Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create SecurityInterceptorConfig!");
                siConfigBuilder.addPropertyValue("className", (Object)className);
                if (implementation != null) {
                    siConfigBuilder.addPropertyReference("implementation", implementation);
                }
                lms.add(beanDefinition);
            }
            securityConfigBuilder.addPropertyValue("securityInterceptorConfigs", (Object)lms);
        }

        private void handleCredentialsFactory(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder credentialsConfigBuilder = this.createBeanBuilder(CredentialsFactoryConfig.class);
            AbstractBeanDefinition beanDefinition = credentialsConfigBuilder.getBeanDefinition();
            NamedNodeMap attrs = node.getAttributes();
            Node classNameNode = attrs.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attrs.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            credentialsConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                credentialsConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create CredentialsFactory!");
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, credentialsConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("memberCredentialsConfig", (Object)beanDefinition);
        }

        private void handleLoginModules(Node node, BeanDefinitionBuilder securityConfigBuilder, boolean member) {
            ManagedList lms = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"login-module".equals(nodeName)) continue;
                this.handleLoginModule(child, (List)lms);
            }
            if (member) {
                securityConfigBuilder.addPropertyValue("memberLoginModuleConfigs", (Object)lms);
            } else {
                securityConfigBuilder.addPropertyValue("clientLoginModuleConfigs", (Object)lms);
            }
        }

        private void handleLoginModule(Node node, List list) {
            BeanDefinitionBuilder lmConfigBuilder = this.createBeanBuilder(LoginModuleConfig.class);
            AbstractBeanDefinition beanDefinition = lmConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, lmConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, lmConfigBuilder);
                break;
            }
            list.add(beanDefinition);
        }

        private void handlePermissionPolicy(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder permPolicyConfigBuilder = this.createBeanBuilder(PermissionPolicyConfig.class);
            AbstractBeanDefinition beanDefinition = permPolicyConfigBuilder.getBeanDefinition();
            NamedNodeMap attrs = node.getAttributes();
            Node classNameNode = attrs.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attrs.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            permPolicyConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                permPolicyConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create PermissionPolicy!");
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, permPolicyConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("clientPolicyConfig", (Object)beanDefinition);
        }

        private void handleSecurityPermissions(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedSet permissions = new ManagedSet();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                PermissionConfig.PermissionType type = PermissionConfig.PermissionType.getType((String)nodeName);
                if (type == null) continue;
                this.handleSecurityPermission(child, (Set)permissions, type);
            }
            securityConfigBuilder.addPropertyValue("clientPermissionConfigs", (Object)permissions);
        }

        private void handleSecurityPermission(Node node, Set permissions, PermissionConfig.PermissionType type) {
            BeanDefinitionBuilder permissionConfigBuilder = this.createBeanBuilder(PermissionConfig.class);
            AbstractBeanDefinition beanDefinition = permissionConfigBuilder.getBeanDefinition();
            permissionConfigBuilder.addPropertyValue("type", (Object)type);
            NamedNodeMap attrs = node.getAttributes();
            Node nameNode = attrs.getNamedItem("name");
            String name = nameNode != null ? this.getTextContent(nameNode) : "*";
            permissionConfigBuilder.addPropertyValue("name", (Object)name);
            Node principalNode = attrs.getNamedItem("principal");
            String principal = principalNode != null ? this.getTextContent(principalNode) : "*";
            permissionConfigBuilder.addPropertyValue("principal", (Object)principal);
            ManagedList endpoints = new ManagedList();
            ManagedList actions = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if ("endpoints".equals(nodeName)) {
                    this.handleSecurityPermissionEndpoints(child, (List)endpoints);
                    continue;
                }
                if (!"actions".equals(nodeName)) continue;
                this.handleSecurityPermissionActions(child, (List)actions);
            }
            permissionConfigBuilder.addPropertyValue("endpoints", (Object)endpoints);
            permissionConfigBuilder.addPropertyValue("actions", (Object)actions);
            permissions.add(beanDefinition);
        }

        private void handleSecurityPermissionEndpoints(Node node, List endpoints) {
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"endpoint".equals(nodeName)) continue;
                endpoints.add(this.getTextContent(child));
            }
        }

        private void handleSecurityPermissionActions(Node node, List actions) {
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"action".equals(nodeName)) continue;
                actions.add(this.getTextContent(child));
            }
        }

        private void handleWanReplicationRef(BeanDefinitionBuilder beanDefinitionBuilder, Node childNode) {
            BeanDefinitionBuilder wanReplicationRefBuilder = this.createBeanBuilder(WanReplicationRef.class);
            AbstractBeanDefinition wanReplicationRefBeanDefinition = wanReplicationRefBuilder.getBeanDefinition();
            this.fillValues(childNode, wanReplicationRefBuilder, new String[0]);
            for (Node node : SpringXmlConfigBuilder.childElements((Node)childNode)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)node);
                if (!nodeName.equals("filters")) continue;
                ManagedList filters = new ManagedList();
                this.handleFilters(node, (List)filters);
                wanReplicationRefBuilder.addPropertyValue("filters", (Object)filters);
            }
            beanDefinitionBuilder.addPropertyValue("wanReplicationRef", (Object)wanReplicationRefBeanDefinition);
        }

        private void handleFilters(Node node, List filters) {
            for (Node child : SpringXmlConfigBuilder.childElements((Node)node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName((Node)child);
                if (!"filter-impl".equals(nodeName)) continue;
                filters.add(this.getTextContent(child));
            }
        }
    }
}

