/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.transaction;

import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionalList;
import com.hazelcast.transaction.TransactionalMap;
import com.hazelcast.transaction.TransactionalMultiMap;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.TransactionalQueue;
import com.hazelcast.transaction.TransactionalSet;
import java.util.UUID;

class TransactionContextHolder
implements TransactionContext {
    private final TransactionContext transactionContext;
    private boolean transactionActive;

    TransactionContextHolder(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public void beginTransaction() {
        this.transactionContext.beginTransaction();
        this.transactionActive = true;
    }

    public void commitTransaction() throws TransactionException {
        try {
            this.transactionContext.commitTransaction();
        }
        finally {
            this.transactionActive = false;
        }
    }

    public void rollbackTransaction() {
        try {
            this.transactionContext.rollbackTransaction();
        }
        finally {
            this.transactionActive = false;
        }
    }

    public boolean isTransactionActive() {
        return this.transactionActive;
    }

    public <K, V> TransactionalMap<K, V> getMap(String name) {
        return this.transactionContext.getMap(name);
    }

    public <E> TransactionalQueue<E> getQueue(String name) {
        return this.transactionContext.getQueue(name);
    }

    public <K, V> TransactionalMultiMap<K, V> getMultiMap(String name) {
        return this.transactionContext.getMultiMap(name);
    }

    public void suspendTransaction() {
        this.transactionContext.suspendTransaction();
    }

    public void resumeTransaction() {
        this.transactionContext.resumeTransaction();
    }

    public UUID getTxnId() {
        return this.transactionContext.getTxnId();
    }

    public <E> TransactionalList<E> getList(String name) {
        return this.transactionContext.getList(name);
    }

    public <E> TransactionalSet<E> getSet(String name) {
        return this.transactionContext.getSet(name);
    }

    public <T extends TransactionalObject> T getTransactionalObject(String serviceName, String name) {
        return (T)this.transactionContext.getTransactionalObject(serviceName, name);
    }
}

