/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.RestEndpointGroup;
import com.hazelcast.config.RestServerEndpointConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"advancedNetworkConfig-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestAdvancedNetworkApplicationContext {
    @Resource(name="instance")
    private HazelcastInstance instance;

    @BeforeClass
    @AfterClass
    public static void start() {
        HazelcastInstanceFactory.terminateAll();
    }

    @Test
    public void testAdvancedNetworkConfig() {
        Config config = this.instance.getConfig();
        AdvancedNetworkConfig advancedNetworkConfig = config.getAdvancedNetworkConfig();
        Assert.assertTrue((boolean)advancedNetworkConfig.isEnabled());
        TcpIpConfig tcpIpConfig = advancedNetworkConfig.getJoin().getTcpIpConfig();
        Assert.assertTrue((boolean)tcpIpConfig.isEnabled());
        Assert.assertEquals((Object)"127.0.0.1:5700", (Object)tcpIpConfig.getRequiredMember());
        Assert.assertFalse((boolean)advancedNetworkConfig.getJoin().getMulticastConfig().isEnabled());
        MemberAddressProviderConfig addressProviderConfig = advancedNetworkConfig.getMemberAddressProviderConfig();
        Assert.assertFalse((boolean)addressProviderConfig.isEnabled());
        ServerSocketEndpointConfig memberEndpointConfig = (ServerSocketEndpointConfig)advancedNetworkConfig.getEndpointConfigs().get(EndpointQualifier.MEMBER);
        Assert.assertEquals((long)5700L, (long)memberEndpointConfig.getPort());
        Assert.assertEquals((long)99L, (long)memberEndpointConfig.getPortCount());
        Assert.assertFalse((boolean)memberEndpointConfig.isPortAutoIncrement());
        Assert.assertTrue((boolean)memberEndpointConfig.getInterfaces().isEnabled());
        HazelcastTestSupport.assertContains((Collection)memberEndpointConfig.getInterfaces().getInterfaces(), (Object)"127.0.0.1");
        Assert.assertTrue((boolean)memberEndpointConfig.isReuseAddress());
        Assert.assertTrue((boolean)memberEndpointConfig.getSocketInterceptorConfig().isEnabled());
        Assert.assertEquals((Object)"com.hazelcast.SocketInterceptor", (Object)memberEndpointConfig.getSocketInterceptorConfig().getClassName());
        Assert.assertTrue((boolean)memberEndpointConfig.isSocketBufferDirect());
        Assert.assertTrue((boolean)memberEndpointConfig.isSocketKeepAlive());
        Assert.assertFalse((boolean)memberEndpointConfig.isSocketTcpNoDelay());
        EndpointConfig wanConfig = (EndpointConfig)advancedNetworkConfig.getEndpointConfigs().get(EndpointQualifier.resolve((ProtocolType)ProtocolType.WAN, (String)"wan-tokyo"));
        Assert.assertFalse((boolean)wanConfig.getInterfaces().isEnabled());
        Assert.assertTrue((boolean)wanConfig.getSymmetricEncryptionConfig().isEnabled());
        Assert.assertEquals((Object)"PBEWithMD5AndDES", (Object)wanConfig.getSymmetricEncryptionConfig().getAlgorithm());
        Assert.assertEquals((Object)"thesalt", (Object)wanConfig.getSymmetricEncryptionConfig().getSalt());
        Assert.assertEquals((Object)"thepass", (Object)wanConfig.getSymmetricEncryptionConfig().getPassword());
        Assert.assertEquals((long)19L, (long)wanConfig.getSymmetricEncryptionConfig().getIterationCount());
        ServerSocketEndpointConfig clientEndpointConfig = (ServerSocketEndpointConfig)advancedNetworkConfig.getEndpointConfigs().get(EndpointQualifier.CLIENT);
        Assert.assertEquals((long)9919L, (long)clientEndpointConfig.getPort());
        Assert.assertEquals((long)10L, (long)clientEndpointConfig.getPortCount());
        Assert.assertFalse((boolean)clientEndpointConfig.isPortAutoIncrement());
        Assert.assertTrue((boolean)clientEndpointConfig.isReuseAddress());
        RestServerEndpointConfig restServerEndpointConfig = advancedNetworkConfig.getRestEndpointConfig();
        Assert.assertEquals((long)9999L, (long)restServerEndpointConfig.getPort());
        Assert.assertTrue((boolean)restServerEndpointConfig.isPortAutoIncrement());
        HazelcastTestSupport.assertContainsAll((Collection)restServerEndpointConfig.getEnabledGroups(), Arrays.asList(RestEndpointGroup.HEALTH_CHECK, RestEndpointGroup.CLUSTER_READ));
        WanReplicationConfig testWan = config.getWanReplicationConfig("testWan");
        WanBatchPublisherConfig tokyoWanPublisherConfig = testWan.getBatchPublisherConfigs().stream().filter(pc -> pc.getPublisherId().equals("tokyoPublisherId")).findFirst().get();
        Assert.assertNotNull((Object)tokyoWanPublisherConfig);
        Assert.assertEquals((Object)"wan-tokyo", (Object)tokyoWanPublisherConfig.getEndpoint());
    }
}

