/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.DummyDiscoveryServiceProvider;
import com.hazelcast.spring.DummyDiscoveryStrategyFactory;
import com.hazelcast.spring.DummyNodeFilter;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"discoveryConfig-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestDiscoveryConfigApplicationContext {
    private Config config;
    @Resource(name="instance")
    private HazelcastInstance instance;

    @BeforeClass
    @AfterClass
    public static void start() {
        HazelcastInstanceFactory.terminateAll();
    }

    @Before
    public void before() {
        this.config = this.instance.getConfig();
    }

    @Test
    public void testNetworkDiscoveryConfig() {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        this.assertDiscoveryConfig(networkConfig.getJoin().getDiscoveryConfig());
    }

    @Test
    public void testWanDiscoveryConfig() {
        WanReplicationConfig wcfg = this.config.getWanReplicationConfig("testWan");
        WanBatchPublisherConfig publisherConfig = (WanBatchPublisherConfig)wcfg.getBatchPublisherConfigs().get(0);
        this.assertDiscoveryConfig(publisherConfig.getDiscoveryConfig());
    }

    private void assertDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        Assert.assertTrue((boolean)(discoveryConfig.getDiscoveryServiceProvider() instanceof DummyDiscoveryServiceProvider));
        Assert.assertTrue((boolean)(discoveryConfig.getNodeFilter() instanceof DummyNodeFilter));
        List discoveryStrategyConfigs = (List)discoveryConfig.getDiscoveryStrategyConfigs();
        Assert.assertEquals((long)1L, (long)discoveryStrategyConfigs.size());
        DiscoveryStrategyConfig discoveryStrategyConfig = (DiscoveryStrategyConfig)discoveryStrategyConfigs.get(0);
        Assert.assertTrue((boolean)(discoveryStrategyConfig.getDiscoveryStrategyFactory() instanceof DummyDiscoveryStrategyFactory));
        Assert.assertEquals((long)3L, (long)discoveryStrategyConfig.getProperties().size());
        Assert.assertEquals((Object)"foo", discoveryStrategyConfig.getProperties().get("key-string"));
        Assert.assertEquals((Object)"123", discoveryStrategyConfig.getProperties().get("key-int"));
        Assert.assertEquals((Object)"true", discoveryStrategyConfig.getProperties().get("key-boolean"));
    }
}

