/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.cache.AbstractHazelcastCacheReadTimeoutTest;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={TestConfig.class})
@Category(value={QuickTest.class})
public class HazelcastCacheReadTimeoutTestWithJavaConfig
extends AbstractHazelcastCacheReadTimeoutTest {
    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Configuration
    @EnableCaching
    @PropertySource(value={"classpath:timeout.properties"})
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        HazelcastCacheManager cacheManager(HazelcastInstance hazelcastInstance) {
            return new HazelcastCacheManager(hazelcastInstance);
        }

        @Bean
        HazelcastInstance hazelcastInstance(Config config) {
            return Hazelcast.newHazelcastInstance((Config)config);
        }

        @Bean
        Config config() {
            Config config = new Config();
            config.setProperty("hazelcast.wait.seconds.before.join", "0");
            config.setProperty("hazelcast.graceful.shutdown.max.wait", "120");
            config.setProperty("hazelcast.partition.backup.sync.interval", "1");
            config.getNetworkConfig().setPort(5701).setPortAutoIncrement(false);
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true).getMembers().add("127.0.0.1:5701");
            config.getNetworkConfig().getInterfaces().setEnabled(true).setInterfaces(Arrays.asList("127.0.0.1"));
            return config;
        }

        @Bean
        AbstractHazelcastCacheReadTimeoutTest.DummyTimeoutBean dummyTimeoutBean() {
            return new AbstractHazelcastCacheReadTimeoutTest.DummyTimeoutBean();
        }

        @Bean
        public static PropertySourcesPlaceholderConfigurer propertyConfigurer() {
            return new PropertySourcesPlaceholderConfigurer();
        }
    }
}

