/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.cache.IJCacheDummyBean;
import com.hazelcast.test.annotation.QuickTest;
import javax.annotation.Resource;
import javax.cache.CacheManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"jCacheCacheManager-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class JCacheCacheManagerTest {
    @Resource(name="instance")
    private HazelcastInstance instance;
    @Autowired
    private IJCacheDummyBean bean;
    @Resource(name="cacheManager")
    private JCacheCacheManager springCacheManager;
    @Resource(name="cacheManager2")
    private CacheManager cacheManager2;

    @BeforeClass
    @AfterClass
    public static void start() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Before
    public void reset() {
        Iterable cacheNames = this.springCacheManager.getCacheManager().getCacheNames();
        for (String cacheName : cacheNames) {
            this.springCacheManager.getCacheManager().getCache(cacheName).removeAll();
        }
        this.bean.reset();
    }

    @Test
    public void testBean() {
        int i;
        for (i = 0; i < 100; ++i) {
            this.bean.reset();
            this.bean.getName(i);
            this.bean.getCity(i);
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)("name:" + i), (Object)this.bean.getName(i));
            Assert.assertEquals((Object)("city:" + i), (Object)this.bean.getCity(i));
        }
    }

    @Test
    public void testURI() {
        Assert.assertEquals((Object)"hazelcast", (Object)this.springCacheManager.getCacheManager().getURI().toString());
        Assert.assertEquals((Object)"testURI", (Object)this.cacheManager2.getURI().toString());
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((Object)"testValue", (Object)this.cacheManager2.getProperties().getProperty("testProperty"));
        Assert.assertEquals((Object)"named-spring-hz-instance", (Object)this.cacheManager2.getProperties().getProperty("hazelcast.instance.name"));
    }

    @Test
    public void testCacheNames() {
        Assert.assertNotNull((Object)this.springCacheManager.getCacheManager().getCache("name"));
        Assert.assertNotNull((Object)this.springCacheManager.getCacheManager().getCache("city"));
    }

    public static class DummyBean
    implements IJCacheDummyBean {
        private boolean alreadyCalledName;
        private boolean alreadyCalledCity;

        @Override
        @Cacheable(value={"name"})
        public String getName(int index) {
            if (!this.alreadyCalledName) {
                this.alreadyCalledName = true;
                return "name:" + index;
            }
            Assert.fail((String)"value is not retrieved from cache on second call!");
            return null;
        }

        @Override
        @Cacheable(value={"city"})
        public String getCity(int k) {
            if (!this.alreadyCalledCity) {
                this.alreadyCalledCity = true;
                return "city:" + k;
            }
            Assert.fail((String)"value is not retrieved from cache on second call!");
            return null;
        }

        @Override
        public void reset() {
            this.alreadyCalledCity = false;
            this.alreadyCalledName = false;
        }
    }
}

