/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"beans-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestBeansApplicationContext
extends HazelcastTestSupport {
    @Autowired
    private ApplicationContext context;

    @BeforeClass
    @AfterClass
    public static void cleanup() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testApplicationContext() {
        Assert.assertTrue((boolean)HazelcastClient.getAllHazelcastClients().isEmpty());
        this.context.getBean("map2");
        Assert.assertEquals((long)1L, (long)Hazelcast.getAllHazelcastInstances().size());
        Assert.assertEquals((long)1L, (long)HazelcastClient.getAllHazelcastClients().size());
        HazelcastInstance hazelcast = (HazelcastInstance)Hazelcast.getAllHazelcastInstances().iterator().next();
        Assert.assertEquals((long)2L, (long)hazelcast.getDistributedObjects().size());
        this.context.getBean("client");
        this.context.getBean("client");
        Assert.assertEquals((long)3L, (long)HazelcastClient.getAllHazelcastClients().size());
        HazelcastClientProxy client = (HazelcastClientProxy)HazelcastClient.getAllHazelcastClients().iterator().next();
        Assert.assertNull((Object)client.getClientConfig().getManagedContext());
        HazelcastInstance instance = (HazelcastInstance)this.context.getBean("instance");
        Assert.assertEquals((long)1L, (long)Hazelcast.getAllHazelcastInstances().size());
        Assert.assertEquals((Object)instance, Hazelcast.getAllHazelcastInstances().iterator().next());
        Assert.assertNull((Object)instance.getConfig().getManagedContext());
    }

    @Test
    public void testPlaceHolder() {
        HazelcastInstance instance = (HazelcastInstance)this.context.getBean("instance");
        TestBeansApplicationContext.waitInstanceForSafeState((HazelcastInstance)instance);
        Config config = instance.getConfig();
        Assert.assertEquals((Object)"spring-cluster", (Object)config.getClusterName());
        Assert.assertTrue((boolean)config.getNetworkConfig().getJoin().getTcpIpConfig().isEnabled());
        Assert.assertEquals((long)6L, (long)config.getMapConfig("map1").getBackupCount());
        Assert.assertFalse((boolean)config.getMapConfig("map1").isStatisticsEnabled());
        Assert.assertEquals((long)64L, (long)config.getNativeMemoryConfig().getSize().getValue());
    }
}

