/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.CustomLoadBalancer;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"customLoadBalancer-applicationContext.xml"})
@Category(value={QuickTest.class})
public class TestCustomLoadBalancerContext {
    @Resource(name="client1")
    private HazelcastClientProxy client1;
    @Resource(name="client2")
    private HazelcastClientProxy client2;

    @BeforeClass
    @AfterClass
    public static void start() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testCustomLoadBalancer() {
        ClientConfig config1 = this.client1.getClientConfig();
        LoadBalancer loadBalancer1 = config1.getLoadBalancer();
        Assert.assertTrue((boolean)(loadBalancer1 instanceof CustomLoadBalancer));
        Assert.assertEquals((Object)"default-name", (Object)((CustomLoadBalancer)loadBalancer1).getName());
        ClientConfig config2 = this.client2.getClientConfig();
        LoadBalancer loadBalancer2 = config2.getLoadBalancer();
        Assert.assertTrue((boolean)(loadBalancer2 instanceof CustomLoadBalancer));
        Assert.assertEquals((Object)"custom-balancer-name", (Object)((CustomLoadBalancer)loadBalancer2).getName());
    }
}

