/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.collection.QueueStore;
import com.hazelcast.collection.QueueStoreFactory;
import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConsistencyCheckStrategy;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.HotRestartClusterDataRecoveryPolicy;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MemcacheProtocolConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MetadataPolicy;
import com.hazelcast.config.MetricsConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.OnJoinPermissionOperationName;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RestApiConfig;
import com.hazelcast.config.RestEndpointGroup;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.VaultSecureStoreConfig;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanQueueFullBehavior;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.cp.FencedLockConfig;
import com.hazelcast.config.cp.RaftAlgorithmConfig;
import com.hazelcast.config.cp.SemaphoreConfig;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.map.IMap;
import com.hazelcast.map.MapStore;
import com.hazelcast.map.MapStoreFactory;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.RingbufferStore;
import com.hazelcast.ringbuffer.RingbufferStoreFactory;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import com.hazelcast.splitbrainprotection.impl.ProbabilisticSplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.impl.RecentlyActiveSplitBrainProtectionFunction;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.DummyDiscoveryServiceProvider;
import com.hazelcast.spring.DummyDiscoveryStrategy;
import com.hazelcast.spring.DummyDiscoveryStrategyFactory;
import com.hazelcast.spring.DummyMapEvictionPolicyComparator;
import com.hazelcast.spring.DummyMembershipListener;
import com.hazelcast.spring.DummyNodeFilter;
import com.hazelcast.spring.DummyQueueStore;
import com.hazelcast.spring.DummyQueueStoreFactory;
import com.hazelcast.spring.DummyRingbufferStore;
import com.hazelcast.spring.DummyRingbufferStoreFactory;
import com.hazelcast.spring.DummyWanConsumer;
import com.hazelcast.spring.serialization.DummyDataSerializableFactory;
import com.hazelcast.spring.serialization.DummyPortableFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.wan.WanPublisher;
import com.hazelcast.wan.WanPublisherState;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"fullConfig-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestFullApplicationContext
extends HazelcastTestSupport {
    private Config config;
    @Resource(name="instance")
    private HazelcastInstance instance;
    @Resource(name="map1")
    private IMap<Object, Object> map1;
    @Resource(name="map2")
    private IMap<Object, Object> map2;
    @Resource(name="multiMap")
    private MultiMap multiMap;
    @Resource(name="replicatedMap")
    private ReplicatedMap replicatedMap;
    @Resource(name="queue")
    private IQueue queue;
    @Resource(name="topic")
    private ITopic topic;
    @Resource(name="set")
    private ISet set;
    @Resource(name="list")
    private IList list;
    @Resource(name="executorService")
    private ExecutorService executorService;
    @Resource(name="flakeIdGenerator")
    private FlakeIdGenerator flakeIdGenerator;
    @Resource(name="atomicLong")
    private IAtomicLong atomicLong;
    @Resource(name="atomicReference")
    private IAtomicReference atomicReference;
    @Resource(name="countDownLatch")
    private ICountDownLatch countDownLatch;
    @Resource(name="semaphore")
    private ISemaphore semaphore;
    @Resource(name="lock")
    private FencedLock lock;
    @Resource(name="dummyMapStore")
    private MapStore dummyMapStore;
    @Autowired
    private MapStoreFactory dummyMapStoreFactory;
    @Resource(name="dummyQueueStore")
    private QueueStore dummyQueueStore;
    @Autowired
    private QueueStoreFactory dummyQueueStoreFactory;
    @Resource(name="dummyRingbufferStore")
    private RingbufferStore dummyRingbufferStore;
    @Autowired
    private RingbufferStoreFactory dummyRingbufferStoreFactory;
    @Autowired
    private WanPublisher wanReplication;
    @Autowired
    private MembershipListener membershipListener;
    @Autowired
    private EntryListener entryListener;
    @Resource
    private SSLContextFactory sslContextFactory;
    @Resource
    private SocketInterceptor socketInterceptor;
    @Resource
    private StreamSerializer dummySerializer;
    @Resource(name="pnCounter")
    private PNCounter pnCounter;

    @BeforeClass
    public static void start() {
        System.clearProperty(ClusterProperty.METRICS_COLLECTION_FREQUENCY.getName());
        HazelcastInstanceFactory.terminateAll();
    }

    @AfterClass
    public static void stop() {
        HazelcastInstanceFactory.terminateAll();
        System.setProperty(ClusterProperty.METRICS_COLLECTION_FREQUENCY.getName(), "1");
    }

    @Before
    public void before() {
        this.config = this.instance.getConfig();
    }

    @Test
    public void testCacheConfig() {
        Assert.assertNotNull((Object)this.config);
        Assert.assertEquals((long)1L, (long)this.config.getCacheConfigs().size());
        CacheSimpleConfig cacheConfig = this.config.getCacheConfig("testCache");
        Assert.assertEquals((Object)"testCache", (Object)cacheConfig.getName());
        Assert.assertTrue((boolean)cacheConfig.isDisablePerEntryInvalidationEvents());
        Assert.assertTrue((boolean)cacheConfig.getHotRestartConfig().isEnabled());
        Assert.assertTrue((boolean)cacheConfig.getHotRestartConfig().isFsync());
        EventJournalConfig journalConfig = cacheConfig.getEventJournalConfig();
        Assert.assertTrue((boolean)journalConfig.isEnabled());
        Assert.assertEquals((long)123L, (long)journalConfig.getCapacity());
        Assert.assertEquals((long)321L, (long)journalConfig.getTimeToLiveSeconds());
        WanReplicationRef wanRef = cacheConfig.getWanReplicationRef();
        Assert.assertEquals((Object)"testWan", (Object)wanRef.getName());
        Assert.assertEquals((Object)"PUT_IF_ABSENT", (Object)wanRef.getMergePolicyClassName());
        Assert.assertEquals((long)1L, (long)wanRef.getFilters().size());
        Assert.assertEquals((Object)"com.example.SampleFilter", wanRef.getFilters().get(0));
    }

    @Test
    public void testMapConfig() {
        Assert.assertNotNull((Object)this.config);
        Assert.assertEquals((long)25L, (long)this.config.getMapConfigs().size());
        MapConfig testMapConfig = this.config.getMapConfig("testMap");
        Assert.assertNotNull((Object)testMapConfig);
        Assert.assertEquals((Object)"testMap", (Object)testMapConfig.getName());
        Assert.assertEquals((long)2L, (long)testMapConfig.getBackupCount());
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)testMapConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)testMapConfig.getEvictionConfig().getSize());
        Assert.assertEquals((long)0L, (long)testMapConfig.getTimeToLiveSeconds());
        Assert.assertTrue((boolean)testMapConfig.getMerkleTreeConfig().isEnabled());
        Assert.assertEquals((long)20L, (long)testMapConfig.getMerkleTreeConfig().getDepth());
        Assert.assertTrue((boolean)testMapConfig.getHotRestartConfig().isEnabled());
        Assert.assertTrue((boolean)testMapConfig.getHotRestartConfig().isFsync());
        EventJournalConfig journalConfig = testMapConfig.getEventJournalConfig();
        Assert.assertTrue((boolean)journalConfig.isEnabled());
        Assert.assertEquals((long)123L, (long)journalConfig.getCapacity());
        Assert.assertEquals((long)321L, (long)journalConfig.getTimeToLiveSeconds());
        Assert.assertEquals((Object)MetadataPolicy.OFF, (Object)testMapConfig.getMetadataPolicy());
        Assert.assertTrue((boolean)testMapConfig.isReadBackupData());
        Assert.assertEquals((long)2L, (long)testMapConfig.getIndexConfigs().size());
        for (IndexConfig index : testMapConfig.getIndexConfigs()) {
            if ("name".equals(index.getAttributes().get(0))) {
                Assert.assertEquals((Object)IndexType.HASH, (Object)index.getType());
                Assert.assertNull((Object)index.getName());
                continue;
            }
            if ("age".equals(index.getAttributes().get(0))) {
                Assert.assertEquals((Object)IndexType.SORTED, (Object)index.getType());
                Assert.assertEquals((Object)"sortedIndex", (Object)index.getName());
                Assert.assertEquals((Object)"name", index.getAttributes().get(1));
                continue;
            }
            Assert.fail((String)"unknown index!");
        }
        Assert.assertEquals((long)2L, (long)testMapConfig.getAttributeConfigs().size());
        for (AttributeConfig attribute : testMapConfig.getAttributeConfigs()) {
            if ("power".equals(attribute.getName())) {
                Assert.assertEquals((Object)"com.car.PowerExtractor", (Object)attribute.getExtractorClassName());
                continue;
            }
            if ("weight".equals(attribute.getName())) {
                Assert.assertEquals((Object)"com.car.WeightExtractor", (Object)attribute.getExtractorClassName());
                continue;
            }
            Assert.fail((String)"unknown attribute!");
        }
        Assert.assertEquals((Object)"my-split-brain-protection", (Object)testMapConfig.getSplitBrainProtectionName());
        MergePolicyConfig mergePolicyConfig = testMapConfig.getMergePolicyConfig();
        Assert.assertNotNull((Object)mergePolicyConfig);
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
        MapStoreConfig testMapStoreConfig = testMapConfig.getMapStoreConfig();
        Assert.assertNotNull((Object)testMapStoreConfig);
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyStore", (Object)testMapStoreConfig.getClassName());
        Assert.assertTrue((boolean)testMapStoreConfig.isEnabled());
        Assert.assertEquals((long)0L, (long)testMapStoreConfig.getWriteDelaySeconds());
        Assert.assertEquals((long)10L, (long)testMapStoreConfig.getWriteBatchSize());
        Assert.assertTrue((boolean)testMapStoreConfig.isWriteCoalescing());
        Assert.assertEquals((Object)MapStoreConfig.InitialLoadMode.EAGER, (Object)testMapStoreConfig.getInitialLoadMode());
        NearCacheConfig testNearCacheConfig = testMapConfig.getNearCacheConfig();
        Assert.assertNotNull((Object)testNearCacheConfig);
        Assert.assertEquals((long)0L, (long)testNearCacheConfig.getTimeToLiveSeconds());
        Assert.assertEquals((long)60L, (long)testNearCacheConfig.getMaxIdleSeconds());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)testNearCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((long)5000L, (long)testNearCacheConfig.getEvictionConfig().getSize());
        Assert.assertTrue((boolean)testNearCacheConfig.isInvalidateOnChange());
        Assert.assertFalse((boolean)testNearCacheConfig.isSerializeKeys());
        MapConfig testMapConfig2 = this.config.getMapConfig("testMap2");
        Assert.assertNotNull((Object)testMapConfig2.getMapStoreConfig().getImplementation());
        Assert.assertEquals((Object)this.dummyMapStore, (Object)testMapConfig2.getMapStoreConfig().getImplementation());
        Assert.assertEquals((Object)MapStoreConfig.InitialLoadMode.LAZY, (Object)testMapConfig2.getMapStoreConfig().getInitialLoadMode());
        WanReplicationRef wanReplicationRef = testMapConfig2.getWanReplicationRef();
        Assert.assertEquals((Object)"testWan", (Object)wanReplicationRef.getName());
        Assert.assertEquals((Object)"PUT_IF_ABSENT", (Object)wanReplicationRef.getMergePolicyClassName());
        Assert.assertTrue((boolean)wanReplicationRef.isRepublishingEnabled());
        Assert.assertEquals((long)1000L, (long)testMapConfig2.getEvictionConfig().getSize());
        Assert.assertEquals((Object)MaxSizePolicy.PER_NODE, (Object)testMapConfig2.getEvictionConfig().getMaxSizePolicy());
        Assert.assertEquals((long)2L, (long)testMapConfig2.getEntryListenerConfigs().size());
        for (EntryListenerConfig listener : testMapConfig2.getEntryListenerConfigs()) {
            if (listener.getClassName() != null) {
                Assert.assertNull((Object)listener.getImplementation());
                Assert.assertTrue((boolean)listener.isIncludeValue());
                Assert.assertFalse((boolean)listener.isLocal());
                continue;
            }
            Assert.assertNotNull((Object)listener.getImplementation());
            Assert.assertEquals((Object)this.entryListener, (Object)listener.getImplementation());
            Assert.assertTrue((boolean)listener.isLocal());
            Assert.assertTrue((boolean)listener.isIncludeValue());
        }
        MapConfig simpleMapConfig = this.config.getMapConfig("simpleMap");
        Assert.assertNotNull((Object)simpleMapConfig);
        Assert.assertEquals((Object)"simpleMap", (Object)simpleMapConfig.getName());
        Assert.assertEquals((long)3L, (long)simpleMapConfig.getBackupCount());
        Assert.assertEquals((long)1L, (long)simpleMapConfig.getAsyncBackupCount());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)simpleMapConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((long)10L, (long)simpleMapConfig.getEvictionConfig().getSize());
        Assert.assertEquals((long)1L, (long)simpleMapConfig.getTimeToLiveSeconds());
        Assert.assertNull((Object)simpleMapConfig.getNearCacheConfig());
        MapConfig testMapConfig3 = this.config.getMapConfig("testMap3");
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyStoreFactory", (Object)testMapConfig3.getMapStoreConfig().getFactoryClassName());
        Assert.assertFalse((boolean)testMapConfig3.getMapStoreConfig().getProperties().isEmpty());
        Assert.assertEquals((Object)testMapConfig3.getMapStoreConfig().getProperty("dummy.property"), (Object)"value");
        MapConfig testMapConfig4 = this.config.getMapConfig("testMap4");
        Assert.assertEquals((Object)this.dummyMapStoreFactory, (Object)testMapConfig4.getMapStoreConfig().getFactoryImplementation());
        MapConfig mapWithValueCachingSetToNever = this.config.getMapConfig("mapWithValueCachingSetToNever");
        Assert.assertEquals((Object)CacheDeserializedValues.NEVER, (Object)mapWithValueCachingSetToNever.getCacheDeserializedValues());
        MapConfig mapWithValueCachingSetToAlways = this.config.getMapConfig("mapWithValueCachingSetToAlways");
        Assert.assertEquals((Object)CacheDeserializedValues.ALWAYS, (Object)mapWithValueCachingSetToAlways.getCacheDeserializedValues());
        MapConfig mapWithDefaultValueCaching = this.config.getMapConfig("mapWithDefaultValueCaching");
        Assert.assertEquals((Object)CacheDeserializedValues.INDEX_ONLY, (Object)mapWithDefaultValueCaching.getCacheDeserializedValues());
        MapConfig testMapWithPartitionLostListenerConfig = this.config.getMapConfig("mapWithPartitionLostListener");
        List partitionLostListenerConfigs = testMapWithPartitionLostListenerConfig.getPartitionLostListenerConfigs();
        Assert.assertEquals((long)1L, (long)partitionLostListenerConfigs.size());
        Assert.assertEquals((Object)"DummyMapPartitionLostListenerImpl", (Object)((MapPartitionLostListenerConfig)partitionLostListenerConfigs.get(0)).getClassName());
        MapConfig testMapWithPartitionStrategyConfig = this.config.getMapConfig("mapWithPartitionStrategy");
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyPartitionStrategy", (Object)testMapWithPartitionStrategyConfig.getPartitioningStrategyConfig().getPartitioningStrategyClass());
    }

    @Test
    public void testMapNoWanMergePolicy() {
        MapConfig testMapConfig2 = this.config.getMapConfig("testMap2");
        WanReplicationRef wanReplicationRef = testMapConfig2.getWanReplicationRef();
        Assert.assertEquals((Object)"testWan", (Object)wanReplicationRef.getName());
        Assert.assertEquals((Object)"PUT_IF_ABSENT", (Object)wanReplicationRef.getMergePolicyClassName());
    }

    @Test
    public void testMemberFlakeIdGeneratorConfig() {
        FlakeIdGeneratorConfig c = this.instance.getConfig().findFlakeIdGeneratorConfig("flakeIdGenerator");
        Assert.assertEquals((long)3L, (long)c.getPrefetchCount());
        Assert.assertEquals((long)10L, (long)c.getPrefetchValidityMillis());
        Assert.assertEquals((long)30L, (long)c.getNodeIdOffset());
        Assert.assertEquals((long)22L, (long)c.getBitsSequence());
        Assert.assertEquals((long)33L, (long)c.getBitsNodeId());
        Assert.assertEquals((long)20000L, (long)c.getAllowedFutureMillis());
        Assert.assertFalse((boolean)c.isStatisticsEnabled());
        Assert.assertEquals((Object)"flakeIdGenerator*", (Object)c.getName());
        Assert.assertFalse((boolean)c.isStatisticsEnabled());
    }

    @Test
    public void testQueueConfig() {
        QueueConfig testQConfig = this.config.getQueueConfig("testQ");
        Assert.assertNotNull((Object)testQConfig);
        Assert.assertEquals((Object)"testQ", (Object)testQConfig.getName());
        Assert.assertEquals((long)1000L, (long)testQConfig.getMaxSize());
        Assert.assertEquals((long)1L, (long)testQConfig.getItemListenerConfigs().size());
        Assert.assertTrue((boolean)testQConfig.isStatisticsEnabled());
        ItemListenerConfig listenerConfig = (ItemListenerConfig)testQConfig.getItemListenerConfigs().get(0);
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyItemListener", (Object)listenerConfig.getClassName());
        Assert.assertTrue((boolean)listenerConfig.isIncludeValue());
        QueueConfig qConfig = this.config.getQueueConfig("queueWithSplitBrainConfig");
        Assert.assertNotNull((Object)qConfig);
        Assert.assertEquals((Object)"queueWithSplitBrainConfig", (Object)qConfig.getName());
        Assert.assertEquals((long)2500L, (long)qConfig.getMaxSize());
        Assert.assertFalse((boolean)qConfig.isStatisticsEnabled());
        Assert.assertEquals((long)100L, (long)qConfig.getEmptyQueueTtl());
        Assert.assertEquals((Object)"my-split-brain-protection", (Object)qConfig.getSplitBrainProtectionName());
        MergePolicyConfig mergePolicyConfig = qConfig.getMergePolicyConfig();
        Assert.assertEquals((Object)"DiscardMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
        QueueConfig queueWithStore1 = this.config.getQueueConfig("queueWithStore1");
        Assert.assertNotNull((Object)queueWithStore1);
        QueueStoreConfig storeConfig1 = queueWithStore1.getQueueStoreConfig();
        Assert.assertNotNull((Object)storeConfig1);
        Assert.assertEquals((Object)DummyQueueStore.class.getName(), (Object)storeConfig1.getClassName());
        QueueConfig queueWithStore2 = this.config.getQueueConfig("queueWithStore2");
        Assert.assertNotNull((Object)queueWithStore2);
        QueueStoreConfig storeConfig2 = queueWithStore2.getQueueStoreConfig();
        Assert.assertNotNull((Object)storeConfig2);
        Assert.assertEquals((Object)DummyQueueStoreFactory.class.getName(), (Object)storeConfig2.getFactoryClassName());
        QueueConfig queueWithStore3 = this.config.getQueueConfig("queueWithStore3");
        Assert.assertNotNull((Object)queueWithStore3);
        QueueStoreConfig storeConfig3 = queueWithStore3.getQueueStoreConfig();
        Assert.assertNotNull((Object)storeConfig3);
        Assert.assertEquals((Object)this.dummyQueueStore, (Object)storeConfig3.getStoreImplementation());
        QueueConfig queueWithStore4 = this.config.getQueueConfig("queueWithStore4");
        Assert.assertNotNull((Object)queueWithStore4);
        QueueStoreConfig storeConfig4 = queueWithStore4.getQueueStoreConfig();
        Assert.assertNotNull((Object)storeConfig4);
        Assert.assertEquals((Object)this.dummyQueueStoreFactory, (Object)storeConfig4.getFactoryImplementation());
    }

    @Test
    public void testRingbufferConfig() {
        RingbufferConfig testRingbuffer = this.config.getRingbufferConfig("testRingbuffer");
        Assert.assertNotNull((Object)testRingbuffer);
        Assert.assertEquals((Object)"testRingbuffer", (Object)testRingbuffer.getName());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)testRingbuffer.getInMemoryFormat());
        Assert.assertEquals((long)100L, (long)testRingbuffer.getCapacity());
        Assert.assertEquals((long)1L, (long)testRingbuffer.getBackupCount());
        Assert.assertEquals((long)1L, (long)testRingbuffer.getAsyncBackupCount());
        Assert.assertEquals((long)20L, (long)testRingbuffer.getTimeToLiveSeconds());
        RingbufferStoreConfig store1 = testRingbuffer.getRingbufferStoreConfig();
        Assert.assertNotNull((Object)store1);
        Assert.assertEquals((Object)DummyRingbufferStore.class.getName(), (Object)store1.getClassName());
        MergePolicyConfig mergePolicyConfig = testRingbuffer.getMergePolicyConfig();
        Assert.assertNotNull((Object)mergePolicyConfig);
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
        RingbufferConfig testRingbuffer2 = this.config.getRingbufferConfig("testRingbuffer2");
        Assert.assertNotNull((Object)testRingbuffer2);
        RingbufferStoreConfig store2 = testRingbuffer2.getRingbufferStoreConfig();
        Assert.assertNotNull((Object)store2);
        Assert.assertEquals((Object)DummyRingbufferStoreFactory.class.getName(), (Object)store2.getFactoryClassName());
        Assert.assertFalse((boolean)store2.getProperties().isEmpty());
        Assert.assertEquals((Object)"value", (Object)store2.getProperty("dummy.property"));
        Assert.assertEquals((Object)"value2", (Object)store2.getProperty("dummy.property.2"));
        RingbufferConfig testRingbuffer3 = this.config.getRingbufferConfig("testRingbuffer3");
        Assert.assertNotNull((Object)testRingbuffer3);
        RingbufferStoreConfig store3 = testRingbuffer3.getRingbufferStoreConfig();
        Assert.assertNotNull((Object)store3);
        Assert.assertEquals((Object)this.dummyRingbufferStore, (Object)store3.getStoreImplementation());
        RingbufferConfig testRingbuffer4 = this.config.getRingbufferConfig("testRingbuffer4");
        Assert.assertNotNull((Object)testRingbuffer4);
        RingbufferStoreConfig store4 = testRingbuffer4.getRingbufferStoreConfig();
        Assert.assertNotNull((Object)store4);
        Assert.assertEquals((Object)this.dummyRingbufferStoreFactory, (Object)store4.getFactoryImplementation());
    }

    @Test
    public void testPNCounterConfig() {
        PNCounterConfig testPNCounter = this.config.getPNCounterConfig("testPNCounter");
        Assert.assertNotNull((Object)testPNCounter);
        Assert.assertEquals((Object)"testPNCounter", (Object)testPNCounter.getName());
        Assert.assertEquals((long)100L, (long)testPNCounter.getReplicaCount());
        Assert.assertEquals((Object)"my-split-brain-protection", (Object)testPNCounter.getSplitBrainProtectionName());
        Assert.assertFalse((boolean)testPNCounter.isStatisticsEnabled());
    }

    @Test
    public void testSecurity() {
        SecurityConfig securityConfig = this.config.getSecurityConfig();
        Assert.assertEquals((Object)OnJoinPermissionOperationName.SEND, (Object)securityConfig.getOnJoinPermissionOperation());
        Set clientPermissionConfigs = securityConfig.getClientPermissionConfigs();
        Assert.assertFalse((boolean)securityConfig.getClientBlockUnmappedActions());
        Assert.assertTrue((boolean)CollectionUtil.isNotEmpty((Collection)clientPermissionConfigs));
        Assert.assertEquals((long)24L, (long)clientPermissionConfigs.size());
        PermissionConfig pnCounterPermission = new PermissionConfig(PermissionConfig.PermissionType.PN_COUNTER, "pnCounterPermission", "*").addAction("create").setEndpoints(Collections.emptySet());
        TestFullApplicationContext.assertContains((Collection)clientPermissionConfigs, (Object)pnCounterPermission);
        HashSet<PermissionConfig.PermissionType> permTypes = new HashSet<PermissionConfig.PermissionType>(Arrays.asList(PermissionConfig.PermissionType.values()));
        for (PermissionConfig pc : clientPermissionConfigs) {
            permTypes.remove(pc.getType());
        }
        Assert.assertTrue((String)("All permission types should be listed in fullConfig. Not found ones: " + permTypes), (boolean)permTypes.isEmpty());
    }

    @Test
    public void testReliableTopicConfig() {
        ReliableTopicConfig testReliableTopic = this.config.getReliableTopicConfig("testReliableTopic");
        Assert.assertNotNull((Object)testReliableTopic);
        Assert.assertEquals((Object)"testReliableTopic", (Object)testReliableTopic.getName());
        Assert.assertEquals((long)1L, (long)testReliableTopic.getMessageListenerConfigs().size());
        Assert.assertFalse((boolean)testReliableTopic.isStatisticsEnabled());
        ListenerConfig listenerConfig = (ListenerConfig)testReliableTopic.getMessageListenerConfigs().get(0);
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyMessageListener", (Object)listenerConfig.getClassName());
        Assert.assertEquals((long)10L, (long)testReliableTopic.getReadBatchSize());
        Assert.assertEquals((Object)TopicOverloadPolicy.BLOCK, (Object)testReliableTopic.getTopicOverloadPolicy());
    }

    @Test
    public void testMultimapConfig() {
        MultiMapConfig testMultiMapConfig = this.config.getMultiMapConfig("testMultimap");
        Assert.assertEquals((Object)MultiMapConfig.ValueCollectionType.LIST, (Object)testMultiMapConfig.getValueCollectionType());
        Assert.assertEquals((long)2L, (long)testMultiMapConfig.getEntryListenerConfigs().size());
        Assert.assertFalse((boolean)testMultiMapConfig.isBinary());
        Assert.assertFalse((boolean)testMultiMapConfig.isStatisticsEnabled());
        for (EntryListenerConfig listener : testMultiMapConfig.getEntryListenerConfigs()) {
            if (listener.getClassName() != null) {
                Assert.assertNull((Object)listener.getImplementation());
                Assert.assertTrue((boolean)listener.isIncludeValue());
                Assert.assertFalse((boolean)listener.isLocal());
                continue;
            }
            Assert.assertNotNull((Object)listener.getImplementation());
            Assert.assertEquals((Object)this.entryListener, (Object)listener.getImplementation());
            Assert.assertTrue((boolean)listener.isLocal());
            Assert.assertTrue((boolean)listener.isIncludeValue());
        }
        MergePolicyConfig mergePolicyConfig = testMultiMapConfig.getMergePolicyConfig();
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)1234L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testListConfig() {
        ListConfig testListConfig = this.config.getListConfig("testList");
        Assert.assertNotNull((Object)testListConfig);
        Assert.assertEquals((Object)"testList", (Object)testListConfig.getName());
        Assert.assertEquals((long)9999L, (long)testListConfig.getMaxSize());
        Assert.assertEquals((long)1L, (long)testListConfig.getBackupCount());
        Assert.assertEquals((long)1L, (long)testListConfig.getAsyncBackupCount());
        Assert.assertFalse((boolean)testListConfig.isStatisticsEnabled());
        MergePolicyConfig mergePolicyConfig = testListConfig.getMergePolicyConfig();
        Assert.assertEquals((Object)"DiscardMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testSetConfig() {
        SetConfig testSetConfig = this.config.getSetConfig("testSet");
        Assert.assertNotNull((Object)testSetConfig);
        Assert.assertEquals((Object)"testSet", (Object)testSetConfig.getName());
        Assert.assertEquals((long)7777L, (long)testSetConfig.getMaxSize());
        Assert.assertEquals((long)0L, (long)testSetConfig.getBackupCount());
        Assert.assertEquals((long)0L, (long)testSetConfig.getAsyncBackupCount());
        Assert.assertFalse((boolean)testSetConfig.isStatisticsEnabled());
        MergePolicyConfig mergePolicyConfig = testSetConfig.getMergePolicyConfig();
        Assert.assertEquals((Object)"DiscardMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testTopicConfig() {
        TopicConfig testTopicConfig = this.config.getTopicConfig("testTopic");
        Assert.assertNotNull((Object)testTopicConfig);
        Assert.assertEquals((Object)"testTopic", (Object)testTopicConfig.getName());
        Assert.assertEquals((long)1L, (long)testTopicConfig.getMessageListenerConfigs().size());
        Assert.assertTrue((boolean)testTopicConfig.isGlobalOrderingEnabled());
        Assert.assertFalse((boolean)testTopicConfig.isStatisticsEnabled());
        ListenerConfig listenerConfig = (ListenerConfig)testTopicConfig.getMessageListenerConfigs().get(0);
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyMessageListener", (Object)listenerConfig.getClassName());
    }

    @Test
    public void testClusterNameConfig() {
        Assert.assertEquals((Object)"spring-cluster", (Object)this.config.getClusterName());
    }

    @Test
    public void testExecutorConfig() {
        ExecutorConfig testExecConfig = this.config.getExecutorConfig("testExec");
        Assert.assertNotNull((Object)testExecConfig);
        Assert.assertEquals((Object)"testExec", (Object)testExecConfig.getName());
        Assert.assertEquals((long)2L, (long)testExecConfig.getPoolSize());
        Assert.assertEquals((long)100L, (long)testExecConfig.getQueueCapacity());
        Assert.assertTrue((boolean)testExecConfig.isStatisticsEnabled());
        ExecutorConfig testExec2Config = this.config.getExecutorConfig("testExec2");
        Assert.assertNotNull((Object)testExec2Config);
        Assert.assertEquals((Object)"testExec2", (Object)testExec2Config.getName());
        Assert.assertEquals((long)5L, (long)testExec2Config.getPoolSize());
        Assert.assertEquals((long)300L, (long)testExec2Config.getQueueCapacity());
        Assert.assertFalse((boolean)testExec2Config.isStatisticsEnabled());
    }

    @Test
    public void testDurableExecutorConfig() {
        DurableExecutorConfig testExecConfig = this.config.getDurableExecutorConfig("durableExec");
        Assert.assertNotNull((Object)testExecConfig);
        Assert.assertEquals((Object)"durableExec", (Object)testExecConfig.getName());
        Assert.assertEquals((long)10L, (long)testExecConfig.getPoolSize());
        Assert.assertEquals((long)5L, (long)testExecConfig.getDurability());
        Assert.assertEquals((long)200L, (long)testExecConfig.getCapacity());
    }

    @Test
    public void testScheduledExecutorConfig() {
        ScheduledExecutorConfig testExecConfig = this.config.getScheduledExecutorConfig("scheduledExec");
        Assert.assertNotNull((Object)testExecConfig);
        Assert.assertEquals((Object)"scheduledExec", (Object)testExecConfig.getName());
        Assert.assertEquals((long)10L, (long)testExecConfig.getPoolSize());
        Assert.assertEquals((long)5L, (long)testExecConfig.getDurability());
        Assert.assertEquals((long)100L, (long)testExecConfig.getCapacity());
        Assert.assertEquals((Object)ScheduledExecutorConfig.CapacityPolicy.PER_PARTITION, (Object)testExecConfig.getCapacityPolicy());
        MergePolicyConfig mergePolicyConfig = testExecConfig.getMergePolicyConfig();
        Assert.assertNotNull((Object)mergePolicyConfig);
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)101L, (long)mergePolicyConfig.getBatchSize());
    }

    @Test
    public void testCardinalityEstimatorConfig() {
        CardinalityEstimatorConfig estimatorConfig = this.config.getCardinalityEstimatorConfig("estimator");
        Assert.assertNotNull((Object)estimatorConfig);
        Assert.assertEquals((Object)"estimator", (Object)estimatorConfig.getName());
        Assert.assertEquals((long)4L, (long)estimatorConfig.getBackupCount());
        Assert.assertEquals((Object)"DiscardMergePolicy", (Object)estimatorConfig.getMergePolicyConfig().getPolicy());
        Assert.assertEquals((long)44L, (long)estimatorConfig.getMergePolicyConfig().getBatchSize());
    }

    @Test
    public void testNetworkConfig() {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Assert.assertNotNull((Object)networkConfig);
        Assert.assertEquals((long)5700L, (long)networkConfig.getPort());
        Assert.assertFalse((boolean)networkConfig.isPortAutoIncrement());
        Collection allowedPorts = networkConfig.getOutboundPortDefinitions();
        Assert.assertEquals((long)2L, (long)allowedPorts.size());
        Iterator portIter = allowedPorts.iterator();
        Assert.assertEquals((Object)"35000-35100", portIter.next());
        Assert.assertEquals((Object)"36000,36100", portIter.next());
        Assert.assertFalse((boolean)networkConfig.getJoin().getMulticastConfig().isEnabled());
        Assert.assertEquals((long)networkConfig.getJoin().getMulticastConfig().getMulticastTimeoutSeconds(), (long)8L);
        Assert.assertEquals((long)networkConfig.getJoin().getMulticastConfig().getMulticastTimeToLive(), (long)16L);
        Assert.assertFalse((boolean)networkConfig.getJoin().getMulticastConfig().isLoopbackModeEnabled());
        Set tis = networkConfig.getJoin().getMulticastConfig().getTrustedInterfaces();
        Assert.assertEquals((long)1L, (long)tis.size());
        Assert.assertEquals((Object)"10.10.10.*", tis.iterator().next());
        Assert.assertFalse((boolean)networkConfig.getInterfaces().isEnabled());
        Assert.assertEquals((long)1L, (long)networkConfig.getInterfaces().getInterfaces().size());
        Assert.assertEquals((Object)"10.10.1.*", networkConfig.getInterfaces().getInterfaces().iterator().next());
        TcpIpConfig tcp = networkConfig.getJoin().getTcpIpConfig();
        Assert.assertNotNull((Object)tcp);
        Assert.assertTrue((boolean)tcp.isEnabled());
        SymmetricEncryptionConfig symmetricEncryptionConfig = networkConfig.getSymmetricEncryptionConfig();
        Assert.assertFalse((boolean)symmetricEncryptionConfig.isEnabled());
        Assert.assertEquals((Object)"PBEWithMD5AndDES", (Object)symmetricEncryptionConfig.getAlgorithm());
        Assert.assertEquals((Object)"thesalt", (Object)symmetricEncryptionConfig.getSalt());
        Assert.assertEquals((Object)"thepass", (Object)symmetricEncryptionConfig.getPassword());
        Assert.assertEquals((long)19L, (long)symmetricEncryptionConfig.getIterationCount());
        List members = tcp.getMembers();
        Assert.assertEquals((String)members.toString(), (long)2L, (long)members.size());
        Assert.assertEquals((Object)"127.0.0.1:5700", members.get(0));
        Assert.assertEquals((Object)"127.0.0.1:5701", members.get(1));
        Assert.assertEquals((Object)"127.0.0.1:5700", (Object)tcp.getRequiredMember());
        this.assertAwsConfig(networkConfig.getJoin().getAwsConfig());
        this.assertGcpConfig(networkConfig.getJoin().getGcpConfig());
        this.assertAzureConfig(networkConfig.getJoin().getAzureConfig());
        this.assertKubernetesConfig(networkConfig.getJoin().getKubernetesConfig());
        this.assertEurekaConfig(networkConfig.getJoin().getEurekaConfig());
        Assert.assertTrue((String)"reuse-address", (boolean)networkConfig.isReuseAddress());
        MemberAddressProviderConfig memberAddressProviderConfig = networkConfig.getMemberAddressProviderConfig();
        Assert.assertFalse((boolean)memberAddressProviderConfig.isEnabled());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyMemberAddressProvider", (Object)memberAddressProviderConfig.getClassName());
        Assert.assertFalse((boolean)memberAddressProviderConfig.getProperties().isEmpty());
        Assert.assertEquals((Object)"value", (Object)memberAddressProviderConfig.getProperties().getProperty("dummy.property"));
        Assert.assertEquals((Object)"value2", (Object)memberAddressProviderConfig.getProperties().getProperty("dummy.property.2"));
        IcmpFailureDetectorConfig icmpFailureDetectorConfig = networkConfig.getIcmpFailureDetectorConfig();
        Assert.assertFalse((boolean)icmpFailureDetectorConfig.isEnabled());
        Assert.assertTrue((boolean)icmpFailureDetectorConfig.isParallelMode());
        Assert.assertTrue((boolean)icmpFailureDetectorConfig.isFailFastOnStartup());
        Assert.assertEquals((long)500L, (long)icmpFailureDetectorConfig.getTimeoutMilliseconds());
        Assert.assertEquals((long)1002L, (long)icmpFailureDetectorConfig.getIntervalMilliseconds());
        Assert.assertEquals((long)2L, (long)icmpFailureDetectorConfig.getMaxAttempts());
        Assert.assertEquals((long)1L, (long)icmpFailureDetectorConfig.getTtl());
    }

    private void assertAwsConfig(AwsConfig aws) {
        Assert.assertFalse((boolean)aws.isEnabled());
        Assert.assertEquals((Object)"sample-access-key", (Object)aws.getProperty("access-key"));
        Assert.assertEquals((Object)"sample-secret-key", (Object)aws.getProperty("secret-key"));
        Assert.assertEquals((Object)"sample-region", (Object)aws.getProperty("region"));
        Assert.assertEquals((Object)"sample-header", (Object)aws.getProperty("host-header"));
        Assert.assertEquals((Object)"sample-group", (Object)aws.getProperty("security-group-name"));
        Assert.assertEquals((Object)"sample-tag-key", (Object)aws.getProperty("tag-key"));
        Assert.assertEquals((Object)"sample-tag-value", (Object)aws.getProperty("tag-value"));
        Assert.assertEquals((Object)"sample-role", (Object)aws.getProperty("iam-role"));
    }

    private void assertGcpConfig(GcpConfig gcp) {
        Assert.assertFalse((boolean)gcp.isEnabled());
        Assert.assertEquals((Object)"us-east1-b,us-east1-c", (Object)gcp.getProperty("zones"));
    }

    private void assertAzureConfig(AzureConfig azure) {
        Assert.assertFalse((boolean)azure.isEnabled());
        Assert.assertEquals((Object)"CLIENT_ID", (Object)azure.getProperty("client-id"));
        Assert.assertEquals((Object)"CLIENT_SECRET", (Object)azure.getProperty("client-secret"));
        Assert.assertEquals((Object)"TENANT_ID", (Object)azure.getProperty("tenant-id"));
        Assert.assertEquals((Object)"SUB_ID", (Object)azure.getProperty("subscription-id"));
        Assert.assertEquals((Object)"HZLCAST001", (Object)azure.getProperty("cluster-id"));
        Assert.assertEquals((Object)"RESOURCE-GROUP-NAME", (Object)azure.getProperty("group-name"));
    }

    private void assertKubernetesConfig(KubernetesConfig kubernetes) {
        Assert.assertFalse((boolean)kubernetes.isEnabled());
        Assert.assertEquals((Object)"MY-KUBERNETES-NAMESPACE", (Object)kubernetes.getProperty("namespace"));
        Assert.assertEquals((Object)"MY-SERVICE-NAME", (Object)kubernetes.getProperty("service-name"));
        Assert.assertEquals((Object)"MY-SERVICE-LABEL-NAME", (Object)kubernetes.getProperty("service-label-name"));
        Assert.assertEquals((Object)"MY-SERVICE-LABEL-VALUE", (Object)kubernetes.getProperty("service-label-value"));
    }

    private void assertEurekaConfig(EurekaConfig eureka) {
        Assert.assertFalse((boolean)eureka.isEnabled());
        Assert.assertEquals((Object)"true", (Object)eureka.getProperty("self-registration"));
        Assert.assertEquals((Object)"hazelcast", (Object)eureka.getProperty("namespace"));
    }

    private void assertDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        Assert.assertTrue((boolean)(discoveryConfig.getDiscoveryServiceProvider() instanceof DummyDiscoveryServiceProvider));
        Assert.assertTrue((boolean)(discoveryConfig.getNodeFilter() instanceof DummyNodeFilter));
        List discoveryStrategyConfigs = (List)discoveryConfig.getDiscoveryStrategyConfigs();
        Assert.assertEquals((long)2L, (long)discoveryStrategyConfigs.size());
        DiscoveryStrategyConfig discoveryStrategyConfig = (DiscoveryStrategyConfig)discoveryStrategyConfigs.get(0);
        Assert.assertTrue((boolean)(discoveryStrategyConfig.getDiscoveryStrategyFactory() instanceof DummyDiscoveryStrategyFactory));
        Assert.assertEquals((long)3L, (long)discoveryStrategyConfig.getProperties().size());
        Assert.assertEquals((Object)"foo", discoveryStrategyConfig.getProperties().get("key-string"));
        Assert.assertEquals((Object)"123", discoveryStrategyConfig.getProperties().get("key-int"));
        Assert.assertEquals((Object)"true", discoveryStrategyConfig.getProperties().get("key-boolean"));
        DiscoveryStrategyConfig discoveryStrategyConfig2 = (DiscoveryStrategyConfig)discoveryStrategyConfigs.get(1);
        Assert.assertEquals((Object)DummyDiscoveryStrategy.class.getName(), (Object)discoveryStrategyConfig2.getClassName());
        Assert.assertEquals((long)1L, (long)discoveryStrategyConfig2.getProperties().size());
        Assert.assertEquals((Object)"foo2", discoveryStrategyConfig2.getProperties().get("key-string"));
    }

    @Test
    public void testProperties() {
        Properties properties = this.config.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((Object)"5", (Object)properties.get(ClusterProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName()));
        Assert.assertEquals((Object)"5", (Object)properties.get(ClusterProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName()));
        Assert.assertEquals((Object)"277", (Object)properties.get(ClusterProperty.PARTITION_COUNT.getName()));
        Config config2 = this.instance.getConfig();
        Properties properties2 = config2.getProperties();
        Assert.assertNotNull((Object)properties2);
        Assert.assertEquals((Object)"5", (Object)properties2.get(ClusterProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName()));
        Assert.assertEquals((Object)"5", (Object)properties2.get(ClusterProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName()));
        Assert.assertEquals((Object)"277", (Object)properties2.get(ClusterProperty.PARTITION_COUNT.getName()));
    }

    @Test
    public void testInstance() {
        Assert.assertNotNull((Object)this.instance);
        Set members = this.instance.getCluster().getMembers();
        Assert.assertEquals((long)1L, (long)members.size());
        Member member = (Member)members.iterator().next();
        InetSocketAddress inetSocketAddress = member.getSocketAddress();
        Assert.assertEquals((long)5700L, (long)inetSocketAddress.getPort());
        Assert.assertEquals((Object)"test-instance", (Object)this.config.getInstanceName());
        Assert.assertEquals((Object)"HAZELCAST_ENTERPRISE_LICENSE_KEY", (Object)this.config.getLicenseKey());
        Assert.assertEquals((long)277L, (long)this.instance.getPartitionService().getPartitions().size());
    }

    @Test
    public void testHazelcastInstances() {
        Assert.assertNotNull(this.map1);
        Assert.assertNotNull(this.map2);
        Assert.assertNotNull((Object)this.multiMap);
        Assert.assertNotNull((Object)this.replicatedMap);
        Assert.assertNotNull((Object)this.queue);
        Assert.assertNotNull((Object)this.topic);
        Assert.assertNotNull((Object)this.set);
        Assert.assertNotNull((Object)this.list);
        Assert.assertNotNull((Object)this.executorService);
        Assert.assertNotNull((Object)this.flakeIdGenerator);
        Assert.assertNotNull((Object)this.atomicLong);
        Assert.assertNotNull((Object)this.atomicReference);
        Assert.assertNotNull((Object)this.countDownLatch);
        Assert.assertNotNull((Object)this.semaphore);
        Assert.assertNotNull((Object)this.lock);
        Assert.assertNotNull((Object)this.pnCounter);
        Assert.assertEquals((Object)"map1", (Object)this.map1.getName());
        Assert.assertEquals((Object)"map2", (Object)this.map2.getName());
        Assert.assertEquals((Object)"testMultimap", (Object)this.multiMap.getName());
        Assert.assertEquals((Object)"replicatedMap", (Object)this.replicatedMap.getName());
        Assert.assertEquals((Object)"testQ", (Object)this.queue.getName());
        Assert.assertEquals((Object)"testTopic", (Object)this.topic.getName());
        Assert.assertEquals((Object)"set", (Object)this.set.getName());
        Assert.assertEquals((Object)"list", (Object)this.list.getName());
        Assert.assertEquals((Object)"flakeIdGenerator", (Object)this.flakeIdGenerator.getName());
        Assert.assertEquals((Object)"testAtomicLong", (Object)this.atomicLong.getName());
        Assert.assertEquals((Object)"testAtomicReference", (Object)this.atomicReference.getName());
        Assert.assertEquals((Object)"countDownLatch", (Object)this.countDownLatch.getName());
        Assert.assertEquals((Object)"semaphore", (Object)this.semaphore.getName());
    }

    @Test
    public void testWanReplicationConfig() {
        WanReplicationConfig wcfg = this.config.getWanReplicationConfig("testWan");
        Assert.assertNotNull((Object)wcfg);
        WanBatchPublisherConfig pc = (WanBatchPublisherConfig)wcfg.getBatchPublisherConfigs().get(0);
        Assert.assertEquals((Object)"tokyo", (Object)pc.getClusterName());
        Assert.assertEquals((Object)"tokyoPublisherId", (Object)pc.getPublisherId());
        Assert.assertEquals((Object)"com.hazelcast.enterprise.wan.impl.replication.WanBatchPublisher", (Object)pc.getClassName());
        Assert.assertEquals((Object)WanQueueFullBehavior.THROW_EXCEPTION, (Object)pc.getQueueFullBehavior());
        Assert.assertEquals((Object)WanPublisherState.STOPPED, (Object)pc.getInitialPublisherState());
        Assert.assertEquals((long)1000L, (long)pc.getQueueCapacity());
        Assert.assertEquals((long)50L, (long)pc.getBatchSize());
        Assert.assertEquals((long)3000L, (long)pc.getBatchMaxDelayMillis());
        Assert.assertTrue((boolean)pc.isSnapshotEnabled());
        Assert.assertEquals((long)5000L, (long)pc.getResponseTimeoutMillis());
        Assert.assertEquals((long)5L, (long)pc.getMaxTargetEndpoints());
        Assert.assertEquals((long)5L, (long)pc.getDiscoveryPeriodSeconds());
        Assert.assertTrue((boolean)pc.isUseEndpointPrivateAddress());
        Assert.assertEquals((long)5L, (long)pc.getIdleMinParkNs());
        Assert.assertEquals((long)5L, (long)pc.getIdleMaxParkNs());
        Assert.assertEquals((long)5L, (long)pc.getMaxConcurrentInvocations());
        Assert.assertEquals((Object)WanAcknowledgeType.ACK_ON_RECEIPT, (Object)pc.getAcknowledgeType());
        Assert.assertEquals((long)5L, (long)pc.getDiscoveryPeriodSeconds());
        Assert.assertEquals((long)5L, (long)pc.getMaxTargetEndpoints());
        this.assertAwsConfig(pc.getAwsConfig());
        this.assertGcpConfig(pc.getGcpConfig());
        this.assertAzureConfig(pc.getAzureConfig());
        this.assertKubernetesConfig(pc.getKubernetesConfig());
        this.assertEurekaConfig(pc.getEurekaConfig());
        WanCustomPublisherConfig customPublisher = (WanCustomPublisherConfig)wcfg.getCustomPublisherConfigs().get(0);
        Assert.assertEquals((Object)"istanbulPublisherId", (Object)customPublisher.getPublisherId());
        Assert.assertEquals((Object)"com.hazelcast.wan.custom.CustomPublisher", (Object)customPublisher.getClassName());
        Map customPublisherProps = customPublisher.getProperties();
        Assert.assertEquals((Object)"prop.publisher", customPublisherProps.get("custom.prop.publisher"));
        WanBatchPublisherConfig publisherPlaceHolderConfig = (WanBatchPublisherConfig)wcfg.getBatchPublisherConfigs().get(1);
        Assert.assertEquals((long)5000L, (long)publisherPlaceHolderConfig.getQueueCapacity());
        WanConsumerConfig consumerConfig = wcfg.getConsumerConfig();
        Assert.assertEquals((Object)"com.hazelcast.wan.custom.WanConsumer", (Object)consumerConfig.getClassName());
        Map consumerProps = consumerConfig.getProperties();
        Assert.assertEquals((Object)"prop.consumer", consumerProps.get("custom.prop.consumer"));
        Assert.assertTrue((boolean)consumerConfig.isPersistWanReplicatedData());
    }

    @Test
    public void testWanConsumerWithPersistDataFalse() {
        WanReplicationConfig config2 = this.config.getWanReplicationConfig("testWan2");
        WanConsumerConfig consumerConfig2 = config2.getConsumerConfig();
        TestFullApplicationContext.assertInstanceOf(DummyWanConsumer.class, (Object)consumerConfig2.getImplementation());
        Assert.assertFalse((boolean)consumerConfig2.isPersistWanReplicatedData());
    }

    @Test
    public void testNoWanConsumerClass() {
        WanReplicationConfig config2 = this.config.getWanReplicationConfig("testWan3");
        WanConsumerConfig consumerConfig2 = config2.getConsumerConfig();
        Assert.assertFalse((boolean)consumerConfig2.isPersistWanReplicatedData());
    }

    @Test
    public void testWanReplicationSyncConfig() {
        WanReplicationConfig wcfg = this.config.getWanReplicationConfig("testWan2");
        WanConsumerConfig consumerConfig = wcfg.getConsumerConfig();
        HashMap<String, String> consumerProps = new HashMap<String, String>();
        consumerProps.put("custom.prop.consumer", "prop.consumer");
        consumerConfig.setProperties(consumerProps);
        TestFullApplicationContext.assertInstanceOf(DummyWanConsumer.class, (Object)consumerConfig.getImplementation());
        Assert.assertEquals((Object)"prop.consumer", consumerConfig.getProperties().get("custom.prop.consumer"));
        Assert.assertFalse((boolean)consumerConfig.isPersistWanReplicatedData());
        List publisherConfigs = wcfg.getBatchPublisherConfigs();
        Assert.assertNotNull((Object)publisherConfigs);
        Assert.assertEquals((long)1L, (long)publisherConfigs.size());
        WanBatchPublisherConfig pc = (WanBatchPublisherConfig)publisherConfigs.get(0);
        Assert.assertEquals((Object)"tokyo", (Object)pc.getClusterName());
        WanSyncConfig wanSyncConfig = pc.getSyncConfig();
        Assert.assertNotNull((Object)wanSyncConfig);
        Assert.assertEquals((Object)ConsistencyCheckStrategy.MERKLE_TREES, (Object)wanSyncConfig.getConsistencyCheckStrategy());
    }

    @Test
    public void testConfigListeners() {
        Assert.assertNotNull((Object)this.membershipListener);
        List list = this.config.getListenerConfigs();
        Assert.assertEquals((long)2L, (long)list.size());
        for (ListenerConfig lc : list) {
            if (lc.getClassName() != null) {
                Assert.assertNull((Object)lc.getImplementation());
                Assert.assertEquals((Object)DummyMembershipListener.class.getName(), (Object)lc.getClassName());
                continue;
            }
            Assert.assertNotNull((Object)lc.getImplementation());
            Assert.assertEquals((Object)this.membershipListener, (Object)lc.getImplementation());
        }
    }

    @Test
    public void testPartitionGroupConfig() {
        PartitionGroupConfig pgc = this.config.getPartitionGroupConfig();
        Assert.assertTrue((boolean)pgc.isEnabled());
        Assert.assertEquals((Object)PartitionGroupConfig.MemberGroupType.CUSTOM, (Object)pgc.getGroupType());
        Assert.assertEquals((long)2L, (long)pgc.getMemberGroupConfigs().size());
        for (MemberGroupConfig mgc : pgc.getMemberGroupConfigs()) {
            Assert.assertEquals((long)2L, (long)mgc.getInterfaces().size());
        }
    }

    @Test
    public void testCRDTReplicationConfig() {
        CRDTReplicationConfig replicationConfig = this.config.getCRDTReplicationConfig();
        Assert.assertEquals((long)10L, (long)replicationConfig.getMaxConcurrentReplicationTargets());
        Assert.assertEquals((long)2000L, (long)replicationConfig.getReplicationPeriodMillis());
    }

    @Test
    public void testSSLConfig() {
        SSLConfig sslConfig = this.config.getNetworkConfig().getSSLConfig();
        Assert.assertNotNull((Object)sslConfig);
        Assert.assertFalse((boolean)sslConfig.isEnabled());
        Assert.assertEquals((Object)this.sslContextFactory, (Object)sslConfig.getFactoryImplementation());
    }

    @Test
    public void testSocketInterceptorConfig() {
        SocketInterceptorConfig socketInterceptorConfig = this.config.getNetworkConfig().getSocketInterceptorConfig();
        Assert.assertNotNull((Object)socketInterceptorConfig);
        Assert.assertFalse((boolean)socketInterceptorConfig.isEnabled());
        Assert.assertEquals((Object)this.socketInterceptor, (Object)socketInterceptorConfig.getImplementation());
    }

    @Test
    public void testManagementCenterConfig() {
        ManagementCenterConfig managementCenterConfig = this.config.getManagementCenterConfig();
        Assert.assertNotNull((Object)managementCenterConfig);
        Assert.assertTrue((boolean)managementCenterConfig.isScriptingEnabled());
    }

    @Test
    public void testMemberAttributesConfig() {
        MemberAttributeConfig memberAttributeConfig = this.config.getMemberAttributeConfig();
        Assert.assertNotNull((Object)memberAttributeConfig);
        Assert.assertEquals((Object)"spring-cluster", (Object)memberAttributeConfig.getAttribute("cluster.name"));
    }

    @Test
    public void testSerializationConfig() {
        SerializationConfig serializationConfig = this.config.getSerializationConfig();
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)serializationConfig.getByteOrder());
        Assert.assertFalse((boolean)serializationConfig.isCheckClassDefErrors());
        Assert.assertEquals((long)13L, (long)serializationConfig.getPortableVersion());
        Map dataSerializableFactoryClasses = serializationConfig.getDataSerializableFactoryClasses();
        Assert.assertFalse((boolean)dataSerializableFactoryClasses.isEmpty());
        Assert.assertEquals((Object)DummyDataSerializableFactory.class.getName(), dataSerializableFactoryClasses.get(1));
        Map dataSerializableFactories = serializationConfig.getDataSerializableFactories();
        Assert.assertFalse((boolean)dataSerializableFactories.isEmpty());
        Assert.assertEquals(DummyDataSerializableFactory.class, ((DataSerializableFactory)dataSerializableFactories.get(2)).getClass());
        Map portableFactoryClasses = serializationConfig.getPortableFactoryClasses();
        Assert.assertFalse((boolean)portableFactoryClasses.isEmpty());
        Assert.assertEquals((Object)DummyPortableFactory.class.getName(), portableFactoryClasses.get(1));
        Map portableFactories = serializationConfig.getPortableFactories();
        Assert.assertFalse((boolean)portableFactories.isEmpty());
        Assert.assertEquals(DummyPortableFactory.class, ((PortableFactory)portableFactories.get(2)).getClass());
        Collection serializerConfigs = serializationConfig.getSerializerConfigs();
        Assert.assertFalse((boolean)serializerConfigs.isEmpty());
        GlobalSerializerConfig globalSerializerConfig = serializationConfig.getGlobalSerializerConfig();
        Assert.assertNotNull((Object)globalSerializerConfig);
        Assert.assertEquals((Object)this.dummySerializer, (Object)globalSerializerConfig.getImplementation());
    }

    @Test
    public void testNativeMemoryConfig() {
        NativeMemoryConfig nativeMemoryConfig = this.config.getNativeMemoryConfig();
        Assert.assertFalse((boolean)nativeMemoryConfig.isEnabled());
        Assert.assertEquals((Object)MemoryUnit.MEGABYTES, (Object)nativeMemoryConfig.getSize().getUnit());
        Assert.assertEquals((long)256L, (long)nativeMemoryConfig.getSize().getValue());
        Assert.assertEquals((long)20L, (long)nativeMemoryConfig.getPageSize());
        Assert.assertEquals((Object)NativeMemoryConfig.MemoryAllocatorType.POOLED, (Object)nativeMemoryConfig.getAllocatorType());
        Assert.assertEquals((double)10.2, (double)nativeMemoryConfig.getMetadataSpacePercentage(), (double)0.1);
        Assert.assertEquals((long)10L, (long)nativeMemoryConfig.getMinBlockSize());
        Assert.assertEquals((Object)"/mnt/optane", (Object)nativeMemoryConfig.getPersistentMemoryDirectory());
    }

    @Test
    public void testReplicatedMapConfig() {
        Assert.assertNotNull((Object)this.config);
        Assert.assertEquals((long)1L, (long)this.config.getReplicatedMapConfigs().size());
        ReplicatedMapConfig replicatedMapConfig = this.config.getReplicatedMapConfig("replicatedMap");
        Assert.assertNotNull((Object)replicatedMapConfig);
        Assert.assertEquals((Object)"replicatedMap", (Object)replicatedMapConfig.getName());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)replicatedMapConfig.getInMemoryFormat());
        Assert.assertFalse((boolean)replicatedMapConfig.isAsyncFillup());
        Assert.assertFalse((boolean)replicatedMapConfig.isStatisticsEnabled());
        Assert.assertEquals((Object)"my-split-brain-protection", (Object)replicatedMapConfig.getSplitBrainProtectionName());
        MergePolicyConfig mergePolicyConfig = replicatedMapConfig.getMergePolicyConfig();
        Assert.assertNotNull((Object)mergePolicyConfig);
        Assert.assertEquals((Object)"PassThroughMergePolicy", (Object)mergePolicyConfig.getPolicy());
        Assert.assertEquals((long)2342L, (long)mergePolicyConfig.getBatchSize());
        replicatedMapConfig.getListenerConfigs();
        for (ListenerConfig listener : replicatedMapConfig.getListenerConfigs()) {
            if (listener.getClassName() != null) {
                Assert.assertNull((Object)listener.getImplementation());
                Assert.assertTrue((boolean)listener.isIncludeValue());
                Assert.assertFalse((boolean)listener.isLocal());
                continue;
            }
            Assert.assertNotNull((Object)listener.getImplementation());
            Assert.assertEquals((Object)this.entryListener, (Object)listener.getImplementation());
            Assert.assertTrue((boolean)listener.isLocal());
            Assert.assertTrue((boolean)listener.isIncludeValue());
        }
    }

    @Test
    public void testSplitBrainProtectionConfig() {
        Assert.assertNotNull((Object)this.config);
        Assert.assertEquals((long)3L, (long)this.config.getSplitBrainProtectionConfigs().size());
        SplitBrainProtectionConfig splitBrainProtectionConfig = this.config.getSplitBrainProtectionConfig("my-split-brain-protection");
        Assert.assertNotNull((Object)splitBrainProtectionConfig);
        Assert.assertEquals((Object)"my-split-brain-protection", (Object)splitBrainProtectionConfig.getName());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummySplitBrainProtectionFunction", (Object)splitBrainProtectionConfig.getFunctionClassName());
        Assert.assertTrue((boolean)splitBrainProtectionConfig.isEnabled());
        Assert.assertEquals((long)2L, (long)splitBrainProtectionConfig.getMinimumClusterSize());
        Assert.assertEquals((long)2L, (long)splitBrainProtectionConfig.getListenerConfigs().size());
        Assert.assertEquals((Object)SplitBrainProtectionOn.READ, (Object)splitBrainProtectionConfig.getProtectOn());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummySplitBrainProtectionListener", (Object)((SplitBrainProtectionListenerConfig)splitBrainProtectionConfig.getListenerConfigs().get(0)).getClassName());
        Assert.assertNotNull((Object)((SplitBrainProtectionListenerConfig)splitBrainProtectionConfig.getListenerConfigs().get(1)).getImplementation());
    }

    @Test
    public void testProbabilisticSplitBrainProtectionConfig() {
        SplitBrainProtectionConfig probabilisticSplitBrainProtectionConfig = this.config.getSplitBrainProtectionConfig("probabilistic-split-brain-protection");
        Assert.assertNotNull((Object)probabilisticSplitBrainProtectionConfig);
        Assert.assertEquals((Object)"probabilistic-split-brain-protection", (Object)probabilisticSplitBrainProtectionConfig.getName());
        Assert.assertNotNull((Object)probabilisticSplitBrainProtectionConfig.getFunctionImplementation());
        TestFullApplicationContext.assertInstanceOf(ProbabilisticSplitBrainProtectionFunction.class, (Object)probabilisticSplitBrainProtectionConfig.getFunctionImplementation());
        Assert.assertTrue((boolean)probabilisticSplitBrainProtectionConfig.isEnabled());
        Assert.assertEquals((long)3L, (long)probabilisticSplitBrainProtectionConfig.getMinimumClusterSize());
        Assert.assertEquals((long)2L, (long)probabilisticSplitBrainProtectionConfig.getListenerConfigs().size());
        Assert.assertEquals((Object)SplitBrainProtectionOn.READ_WRITE, (Object)probabilisticSplitBrainProtectionConfig.getProtectOn());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummySplitBrainProtectionListener", (Object)((SplitBrainProtectionListenerConfig)probabilisticSplitBrainProtectionConfig.getListenerConfigs().get(0)).getClassName());
        Assert.assertNotNull((Object)((SplitBrainProtectionListenerConfig)probabilisticSplitBrainProtectionConfig.getListenerConfigs().get(1)).getImplementation());
        ProbabilisticSplitBrainProtectionFunction splitBrainProtectionFunction = (ProbabilisticSplitBrainProtectionFunction)probabilisticSplitBrainProtectionConfig.getFunctionImplementation();
        Assert.assertEquals((double)11.0, (double)splitBrainProtectionFunction.getSuspicionThreshold(), (double)0.001);
        Assert.assertEquals((long)31415L, (long)splitBrainProtectionFunction.getAcceptableHeartbeatPauseMillis());
        Assert.assertEquals((long)42L, (long)splitBrainProtectionFunction.getMaxSampleSize());
        Assert.assertEquals((long)77123L, (long)splitBrainProtectionFunction.getHeartbeatIntervalMillis());
        Assert.assertEquals((long)1000L, (long)splitBrainProtectionFunction.getMinStdDeviationMillis());
    }

    @Test
    public void testRecentlyActiveSplitBrainProtectionConfig() {
        SplitBrainProtectionConfig recentlyActiveSplitBrainProtectionConfig = this.config.getSplitBrainProtectionConfig("recently-active-split-brain-protection");
        Assert.assertNotNull((Object)recentlyActiveSplitBrainProtectionConfig);
        Assert.assertEquals((Object)"recently-active-split-brain-protection", (Object)recentlyActiveSplitBrainProtectionConfig.getName());
        Assert.assertNotNull((Object)recentlyActiveSplitBrainProtectionConfig.getFunctionImplementation());
        TestFullApplicationContext.assertInstanceOf(RecentlyActiveSplitBrainProtectionFunction.class, (Object)recentlyActiveSplitBrainProtectionConfig.getFunctionImplementation());
        Assert.assertTrue((boolean)recentlyActiveSplitBrainProtectionConfig.isEnabled());
        Assert.assertEquals((long)5L, (long)recentlyActiveSplitBrainProtectionConfig.getMinimumClusterSize());
        Assert.assertEquals((Object)SplitBrainProtectionOn.READ_WRITE, (Object)recentlyActiveSplitBrainProtectionConfig.getProtectOn());
        RecentlyActiveSplitBrainProtectionFunction splitBrainProtectionFunction = (RecentlyActiveSplitBrainProtectionFunction)recentlyActiveSplitBrainProtectionConfig.getFunctionImplementation();
        Assert.assertEquals((long)5123L, (long)splitBrainProtectionFunction.getHeartbeatToleranceMillis());
    }

    @Test
    public void testFullQueryCacheConfig() {
        MapConfig mapConfig = this.config.getMapConfig("map-with-query-cache");
        QueryCacheConfig queryCacheConfig = (QueryCacheConfig)mapConfig.getQueryCacheConfigs().get(0);
        EntryListenerConfig entryListenerConfig = (EntryListenerConfig)queryCacheConfig.getEntryListenerConfigs().get(0);
        Assert.assertTrue((boolean)entryListenerConfig.isIncludeValue());
        Assert.assertFalse((boolean)entryListenerConfig.isLocal());
        Assert.assertEquals((Object)"com.hazelcast.spring.DummyEntryListener", (Object)entryListenerConfig.getClassName());
        Assert.assertFalse((boolean)queryCacheConfig.isIncludeValue());
        Assert.assertEquals((Object)"my-query-cache-1", (Object)queryCacheConfig.getName());
        Assert.assertEquals((long)12L, (long)queryCacheConfig.getBatchSize());
        Assert.assertEquals((long)33L, (long)queryCacheConfig.getBufferSize());
        Assert.assertEquals((long)12L, (long)queryCacheConfig.getDelaySeconds());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)queryCacheConfig.getInMemoryFormat());
        Assert.assertTrue((boolean)queryCacheConfig.isCoalesce());
        Assert.assertFalse((boolean)queryCacheConfig.isPopulate());
        this.assertIndexesEqual(queryCacheConfig);
        Assert.assertEquals((Object)"__key > 12", (Object)queryCacheConfig.getPredicateConfig().getSql());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)queryCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((Object)MaxSizePolicy.ENTRY_COUNT, (Object)queryCacheConfig.getEvictionConfig().getMaxSizePolicy());
        Assert.assertEquals((long)111L, (long)queryCacheConfig.getEvictionConfig().getSize());
    }

    private void assertIndexesEqual(QueryCacheConfig queryCacheConfig) {
        for (IndexConfig indexConfig : queryCacheConfig.getIndexConfigs()) {
            Assert.assertEquals((Object)"name", indexConfig.getAttributes().get(0));
            Assert.assertFalse((indexConfig.getType() == IndexType.SORTED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMapNativeMaxSizePolicy() {
        MapConfig mapConfig = this.config.getMapConfig("map-with-native-max-size-policy");
        EvictionConfig evictionConfig = mapConfig.getEvictionConfig();
        Assert.assertEquals((Object)MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE, (Object)evictionConfig.getMaxSizePolicy());
    }

    @Test
    public void testHotRestart() {
        File dir = new File("/mnt/hot-restart/");
        File hotBackupDir = new File("/mnt/hot-backup/");
        HotRestartPersistenceConfig hotRestartPersistenceConfig = this.config.getHotRestartPersistenceConfig();
        Assert.assertFalse((boolean)hotRestartPersistenceConfig.isEnabled());
        Assert.assertEquals((Object)dir.getAbsolutePath(), (Object)hotRestartPersistenceConfig.getBaseDir().getAbsolutePath());
        Assert.assertEquals((Object)hotBackupDir.getAbsolutePath(), (Object)hotRestartPersistenceConfig.getBackupDir().getAbsolutePath());
        Assert.assertEquals((long)1111L, (long)hotRestartPersistenceConfig.getValidationTimeoutSeconds());
        Assert.assertEquals((long)2222L, (long)hotRestartPersistenceConfig.getDataLoadTimeoutSeconds());
        Assert.assertEquals((Object)HotRestartClusterDataRecoveryPolicy.PARTIAL_RECOVERY_MOST_COMPLETE, (Object)hotRestartPersistenceConfig.getClusterDataRecoveryPolicy());
        Assert.assertFalse((boolean)hotRestartPersistenceConfig.isAutoRemoveStaleData());
        EncryptionAtRestConfig encryptionAtRestConfig = hotRestartPersistenceConfig.getEncryptionAtRestConfig();
        Assert.assertNotNull((Object)encryptionAtRestConfig);
        Assert.assertTrue((boolean)encryptionAtRestConfig.isEnabled());
        Assert.assertEquals((Object)"AES/CBC/PKCS5Padding", (Object)encryptionAtRestConfig.getAlgorithm());
        Assert.assertEquals((Object)"sugar", (Object)encryptionAtRestConfig.getSalt());
        Assert.assertEquals((long)16L, (long)encryptionAtRestConfig.getKeySize());
        Assert.assertTrue((boolean)(encryptionAtRestConfig.getSecureStoreConfig() instanceof VaultSecureStoreConfig));
        VaultSecureStoreConfig vaultConfig = (VaultSecureStoreConfig)encryptionAtRestConfig.getSecureStoreConfig();
        Assert.assertEquals((Object)"http://localhost:1234", (Object)vaultConfig.getAddress());
        Assert.assertEquals((Object)"secret/path", (Object)vaultConfig.getSecretPath());
        Assert.assertEquals((Object)"token", (Object)vaultConfig.getToken());
        SSLConfig sslConfig = vaultConfig.getSSLConfig();
        Assert.assertNotNull((Object)sslConfig);
        Assert.assertTrue((boolean)sslConfig.isEnabled());
        Assert.assertEquals((Object)this.sslContextFactory, (Object)sslConfig.getFactoryImplementation());
        Assert.assertEquals((long)60L, (long)vaultConfig.getPollingInterval());
    }

    @Test
    public void testMapEvictionPolicies() {
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)this.config.getMapConfig("lfuEvictionMap").getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)this.config.getMapConfig("lruEvictionMap").getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)this.config.getMapConfig("noneEvictionMap").getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((Object)EvictionPolicy.RANDOM, (Object)this.config.getMapConfig("randomEvictionMap").getEvictionConfig().getEvictionPolicy());
    }

    @Test
    public void testMemberNearCacheEvictionPolicies() {
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)this.getNearCacheEvictionPolicy("lfuNearCacheEvictionMap", this.config));
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)this.getNearCacheEvictionPolicy("lruNearCacheEvictionMap", this.config));
        Assert.assertEquals((Object)EvictionPolicy.RANDOM, (Object)this.getNearCacheEvictionPolicy("randomNearCacheEvictionMap", this.config));
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)this.getNearCacheEvictionPolicy("noneNearCacheEvictionMap", this.config));
    }

    private EvictionPolicy getNearCacheEvictionPolicy(String mapName, Config config) {
        return config.getMapConfig(mapName).getNearCacheConfig().getEvictionConfig().getEvictionPolicy();
    }

    @Test
    public void testMapEvictionPolicyClassName() {
        MapConfig mapConfig = this.config.getMapConfig("mapWithComparatorClassName");
        String expectedComparatorClassName = "com.hazelcast.internal.eviction.impl.comparator.LRUEvictionPolicyComparator";
        Assert.assertEquals((Object)expectedComparatorClassName, (Object)mapConfig.getEvictionConfig().getComparatorClassName());
    }

    @Test
    public void testMapEvictionPolicyImpl() {
        MapConfig mapConfig = this.config.getMapConfig("mapWithComparatorImpl");
        Assert.assertEquals(DummyMapEvictionPolicyComparator.class, mapConfig.getEvictionConfig().getComparator().getClass());
    }

    @Test
    public void testWhenBothMapEvictionPolicyClassNameAndEvictionPolicySet() {
        MapConfig mapConfig = this.config.getMapConfig("mapWithBothComparatorClassNameAndEvictionPolicy");
        String expectedComparatorClassName = "com.hazelcast.internal.eviction.impl.comparator.LFUEvictionPolicyComparator";
        EvictionConfig evictionConfig = mapConfig.getEvictionConfig();
        EvictionPolicy evictionPolicy = evictionConfig.getEvictionPolicy();
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)evictionPolicy);
        Assert.assertEquals((Object)expectedComparatorClassName, (Object)evictionConfig.getComparatorClassName());
    }

    @Test
    public void testExplicitPortCountConfiguration() {
        int portCount = this.instance.getConfig().getNetworkConfig().getPortCount();
        Assert.assertEquals((long)42L, (long)portCount);
    }

    @Test
    public void testJavaSerializationFilterConfig() {
        JavaSerializationFilterConfig filterConfig = this.config.getSerializationConfig().getJavaSerializationFilterConfig();
        Assert.assertNotNull((Object)filterConfig);
        Assert.assertTrue((boolean)filterConfig.isDefaultsDisabled());
        ClassFilter blacklist = filterConfig.getBlacklist();
        Assert.assertNotNull((Object)blacklist);
        Assert.assertEquals((long)1L, (long)blacklist.getClasses().size());
        Assert.assertTrue((boolean)blacklist.getClasses().contains("com.acme.app.BeanComparator"));
        Assert.assertEquals((long)0L, (long)blacklist.getPackages().size());
        Set prefixes = blacklist.getPrefixes();
        Assert.assertTrue((boolean)prefixes.contains("a.dangerous.package."));
        Assert.assertTrue((boolean)prefixes.contains("justaprefix"));
        Assert.assertEquals((long)2L, (long)prefixes.size());
        ClassFilter whitelist = filterConfig.getWhitelist();
        Assert.assertNotNull((Object)whitelist);
        Assert.assertEquals((long)2L, (long)whitelist.getClasses().size());
        Assert.assertTrue((boolean)whitelist.getClasses().contains("java.lang.String"));
        Assert.assertTrue((boolean)whitelist.getClasses().contains("example.Foo"));
        Assert.assertEquals((long)2L, (long)whitelist.getPackages().size());
        Assert.assertTrue((boolean)whitelist.getPackages().contains("com.acme.app"));
        Assert.assertTrue((boolean)whitelist.getPackages().contains("com.acme.app.subpkg"));
    }

    @Test
    public void testRestApiConfig() {
        RestApiConfig restApiConfig = this.config.getNetworkConfig().getRestApiConfig();
        Assert.assertNotNull((Object)restApiConfig);
        Assert.assertFalse((boolean)restApiConfig.isEnabled());
        for (RestEndpointGroup group : RestEndpointGroup.values()) {
            Assert.assertTrue((String)("Unexpected status of REST Endpoint group" + group), (boolean)restApiConfig.isGroupEnabled(group));
        }
    }

    @Test
    public void testMemcacheProtocolConfig() {
        MemcacheProtocolConfig memcacheProtocolConfig = this.config.getNetworkConfig().getMemcacheProtocolConfig();
        Assert.assertNotNull((Object)memcacheProtocolConfig);
        Assert.assertTrue((boolean)memcacheProtocolConfig.isEnabled());
    }

    @Test
    public void testCPSubsystemConfig() {
        CPSubsystemConfig cpSubsystemConfig = this.config.getCPSubsystemConfig();
        Assert.assertEquals((long)0L, (long)cpSubsystemConfig.getCPMemberCount());
        Assert.assertEquals((long)0L, (long)cpSubsystemConfig.getGroupSize());
        Assert.assertEquals((long)15L, (long)cpSubsystemConfig.getSessionTimeToLiveSeconds());
        Assert.assertEquals((long)3L, (long)cpSubsystemConfig.getSessionHeartbeatIntervalSeconds());
        Assert.assertEquals((long)120L, (long)cpSubsystemConfig.getMissingCPMemberAutoRemovalSeconds());
        Assert.assertEquals((long)30L, (long)cpSubsystemConfig.getDataLoadTimeoutSeconds());
        Assert.assertTrue((boolean)cpSubsystemConfig.isFailOnIndeterminateOperationState());
        Assert.assertFalse((boolean)cpSubsystemConfig.isPersistenceEnabled());
        Assert.assertEquals((Object)new File("/custom-dir").getAbsolutePath(), (Object)cpSubsystemConfig.getBaseDir().getAbsolutePath());
        RaftAlgorithmConfig raftAlgorithmConfig = cpSubsystemConfig.getRaftAlgorithmConfig();
        Assert.assertEquals((long)500L, (long)raftAlgorithmConfig.getLeaderElectionTimeoutInMillis());
        Assert.assertEquals((long)100L, (long)raftAlgorithmConfig.getLeaderHeartbeatPeriodInMillis());
        Assert.assertEquals((long)3L, (long)raftAlgorithmConfig.getMaxMissedLeaderHeartbeatCount());
        Assert.assertEquals((long)25L, (long)raftAlgorithmConfig.getAppendRequestMaxEntryCount());
        Assert.assertEquals((long)250L, (long)raftAlgorithmConfig.getCommitIndexAdvanceCountToSnapshot());
        Assert.assertEquals((long)75L, (long)raftAlgorithmConfig.getUncommittedEntryCountToRejectNewAppends());
        Assert.assertEquals((long)50L, (long)raftAlgorithmConfig.getAppendRequestBackoffTimeoutInMillis());
        SemaphoreConfig semaphoreConfig1 = cpSubsystemConfig.findSemaphoreConfig("sem1");
        SemaphoreConfig semaphoreConfig2 = cpSubsystemConfig.findSemaphoreConfig("sem2");
        Assert.assertNotNull((Object)semaphoreConfig1);
        Assert.assertNotNull((Object)semaphoreConfig2);
        Assert.assertTrue((boolean)semaphoreConfig1.isJDKCompatible());
        Assert.assertFalse((boolean)semaphoreConfig2.isJDKCompatible());
        Assert.assertEquals((long)1L, (long)semaphoreConfig1.getInitialPermits());
        Assert.assertEquals((long)2L, (long)semaphoreConfig2.getInitialPermits());
        FencedLockConfig lockConfig1 = cpSubsystemConfig.findLockConfig("lock1");
        FencedLockConfig lockConfig2 = cpSubsystemConfig.findLockConfig("lock2");
        Assert.assertNotNull((Object)lockConfig1);
        Assert.assertNotNull((Object)lockConfig2);
        Assert.assertEquals((long)1L, (long)lockConfig1.getLockAcquireLimit());
        Assert.assertEquals((long)2L, (long)lockConfig2.getLockAcquireLimit());
    }

    @Test
    public void testMetricsConfig() {
        MetricsConfig metricsConfig = this.config.getMetricsConfig();
        Assert.assertFalse((boolean)metricsConfig.isEnabled());
        Assert.assertFalse((boolean)metricsConfig.getManagementCenterConfig().isEnabled());
        Assert.assertEquals((long)42L, (long)metricsConfig.getManagementCenterConfig().getRetentionSeconds());
        Assert.assertFalse((boolean)metricsConfig.getJmxConfig().isEnabled());
        Assert.assertEquals((long)24L, (long)metricsConfig.getCollectionFrequencySeconds());
    }
}

