/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.map.IMap;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.cache.HazelcastCache;
import com.hazelcast.spring.cache.IDummyTimeoutBean;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"no-readtimeout-config.xml"})
@Category(value={QuickTest.class})
public class HazelcastCacheNoReadTimeoutTest
extends HazelcastTestSupport {
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IDummyTimeoutBean dummyTimeoutBean;
    private Cache delayNo;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Before
    public void setup() {
        this.delayNo = this.cacheManager.getCache("delayNo");
        ((IMap)this.delayNo.getNativeCache()).addInterceptor((MapInterceptor)new DelayIMapGetInterceptor(250));
    }

    @Test
    public void testCache_TimeoutConfig() {
        Assert.assertEquals((long)0L, (long)((HazelcastCache)this.delayNo).getReadTimeout());
    }

    @Test
    public void testBean_delayNo() {
        String key = this.createRandomKey();
        long start = System.nanoTime();
        this.dummyTimeoutBean.getDelayNo(key);
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        Assert.assertTrue((time >= 250L ? 1 : 0) != 0);
    }

    private String createRandomKey() {
        return UUID.randomUUID().toString();
    }

    public static class DummyTimeoutBean
    implements IDummyTimeoutBean {
        @Override
        public Object getDelay150(String key) {
            return null;
        }

        @Override
        public Object getDelay50(String key) {
            return null;
        }

        @Override
        public Object getDelayNo(String key) {
            return null;
        }

        @Override
        public String getDelay100(String key) {
            return null;
        }
    }

    private static class DelayIMapGetInterceptor
    implements MapInterceptor {
        private final int delay;

        DelayIMapGetInterceptor(int delay) {
            this.delay = delay;
        }

        public Object interceptGet(Object value) {
            HazelcastTestSupport.sleepMillis((int)this.delay);
            return null;
        }

        public void afterGet(Object value) {
        }

        public Object interceptPut(Object oldValue, Object newValue) {
            return null;
        }

        public void afterPut(Object value) {
        }

        public Object interceptRemove(Object removedValue) {
            return null;
        }

        public void afterRemove(Object value) {
        }
    }
}

