/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"simple-config.xml"})
@Category(value={QuickTest.class})
public class HazelcastCacheTest {
    @Autowired
    public CacheManager cacheManager;
    private Cache cache;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Before
    public void setup() {
        this.cache = this.cacheManager.getCache("test");
    }

    @Test
    public void testCacheGetCallable() {
        this.doTestCacheGetCallable("test");
    }

    @Test
    public void testCacheGetCallableWithNull() {
        this.doTestCacheGetCallable(null);
    }

    private void doTestCacheGetCallable(final Object returnValue) {
        String key = this.createRandomKey();
        Assert.assertNull((Object)this.cache.get((Object)key));
        Object value = this.cache.get((Object)key, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return returnValue;
            }
        });
        Assert.assertEquals((Object)returnValue, (Object)value);
        Assert.assertEquals((Object)value, (Object)this.cache.get((Object)key).get());
    }

    @Test
    public void testCacheGetCallableNotInvokedWithHit() {
        this.doTestCacheGetCallableNotInvokedWithHit("existing");
    }

    @Test
    public void testCacheGetCallableNotInvokedWithHitNull() {
        this.doTestCacheGetCallableNotInvokedWithHit(null);
    }

    private void doTestCacheGetCallableNotInvokedWithHit(Object initialValue) {
        String key = this.createRandomKey();
        this.cache.put((Object)key, initialValue);
        Object value = this.cache.get((Object)key, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                throw new IllegalStateException("Should not have been invoked");
            }
        });
        Assert.assertEquals((Object)initialValue, (Object)value);
    }

    @Test
    public void testCacheGetCallableFail() {
        String key = this.createRandomKey();
        Assert.assertNull((Object)this.cache.get((Object)key));
        try {
            this.cache.get((Object)key, (Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    throw new UnsupportedOperationException("Expected exception");
                }
            });
        }
        catch (Cache.ValueRetrievalException ex) {
            Assert.assertNotNull((Object)ex.getCause());
            Assert.assertEquals(UnsupportedOperationException.class, ex.getCause().getClass());
        }
    }

    @Test
    public void testCacheGetSynchronized() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        final CopyOnWriteArrayList results = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        final String key = this.createRandomKey();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    Integer value = (Integer)HazelcastCacheTest.this.cache.get((Object)key, (Callable)new Callable<Integer>(){

                        @Override
                        public Integer call() {
                            HazelcastTestSupport.sleepMillis((int)50);
                            return counter.incrementAndGet();
                        }
                    });
                    results.add(value);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        for (int i = 0; i < 10; ++i) {
            new Thread(run).start();
        }
        latch.await();
        Assert.assertEquals((long)10L, (long)results.size());
        for (Object result : results) {
            Assert.assertThat((Object)((Integer)result), (Matcher)Is.is((Object)1));
        }
    }

    private String createRandomKey() {
        return UUID.randomUUID().toString();
    }
}

