/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.context;

import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.context.MyEvictionPolicyComparator;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"test-jcache-application-context.xml"})
@Category(value={QuickTest.class})
public class TestJCache {
    @Autowired
    private ApplicationContext context;
    @Resource(name="instance1")
    private HazelcastInstance instance1;

    @BeforeClass
    @AfterClass
    public static void tearDown() {
        Hazelcast.shutdownAll();
    }

    @Test
    public void testContextInitializedSuccessfully() {
        Assert.assertNotNull((Object)this.context);
    }

    @Test
    public void testConfig() {
        Assert.assertNotNull((Object)this.instance1);
        CacheSimpleConfig simpleConfig = (CacheSimpleConfig)this.instance1.getConfig().getCacheConfigs().get("cache1");
        Assert.assertNotNull((Object)simpleConfig);
        Assert.assertEquals((long)1L, (long)simpleConfig.getAsyncBackupCount());
        Assert.assertEquals((long)2L, (long)simpleConfig.getBackupCount());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)simpleConfig.getKeyType());
        Assert.assertEquals((Object)"java.lang.String", (Object)simpleConfig.getValueType());
        Assert.assertTrue((boolean)simpleConfig.isStatisticsEnabled());
        Assert.assertTrue((boolean)simpleConfig.isManagementEnabled());
        Assert.assertTrue((boolean)simpleConfig.isReadThrough());
        Assert.assertTrue((boolean)simpleConfig.isWriteThrough());
        Assert.assertEquals((Object)"com.hazelcast.cache.MyCacheLoaderFactory", (Object)simpleConfig.getCacheLoaderFactory());
        Assert.assertEquals((Object)"com.hazelcast.cache.MyCacheWriterFactory", (Object)simpleConfig.getCacheWriterFactory());
        Assert.assertEquals((Object)"com.hazelcast.cache.MyExpiryPolicyFactory", (Object)simpleConfig.getExpiryPolicyFactoryConfig().getClassName());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)simpleConfig.getInMemoryFormat());
        Assert.assertNotNull((Object)simpleConfig.getEvictionConfig());
        Assert.assertEquals((long)50L, (long)simpleConfig.getEvictionConfig().getSize());
        Assert.assertEquals((Object)MaxSizePolicy.ENTRY_COUNT, (Object)simpleConfig.getEvictionConfig().getMaxSizePolicy());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)simpleConfig.getEvictionConfig().getEvictionPolicy());
    }

    @Test
    public void cacheConfigXmlTest_TimedCreatedExpiryPolicyFactory() {
        Config config = this.instance1.getConfig();
        CacheSimpleConfig cacheWithTimedCreatedExpiryPolicyFactoryConfig = config.getCacheConfig("cacheWithTimedCreatedExpiryPolicyFactory");
        CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig = cacheWithTimedCreatedExpiryPolicyFactoryConfig.getExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = expiryPolicyFactoryConfig.getTimedExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = timedExpiryPolicyFactoryConfig.getDurationConfig();
        Assert.assertNotNull((Object)expiryPolicyFactoryConfig);
        Assert.assertNotNull((Object)timedExpiryPolicyFactoryConfig);
        Assert.assertNotNull((Object)durationConfig);
        Assert.assertNull((Object)expiryPolicyFactoryConfig.getClassName());
        Assert.assertEquals((Object)CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.CREATED, (Object)timedExpiryPolicyFactoryConfig.getExpiryPolicyType());
        Assert.assertEquals((long)1L, (long)durationConfig.getDurationAmount());
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)durationConfig.getTimeUnit()));
    }

    @Test
    public void cacheConfigXmlTest_TimedAccessedExpiryPolicyFactory() {
        Config config = this.instance1.getConfig();
        CacheSimpleConfig cacheWithTimedAccessedExpiryPolicyFactoryConfig = config.getCacheConfig("cacheWithTimedAccessedExpiryPolicyFactory");
        CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig = cacheWithTimedAccessedExpiryPolicyFactoryConfig.getExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = expiryPolicyFactoryConfig.getTimedExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = timedExpiryPolicyFactoryConfig.getDurationConfig();
        Assert.assertNotNull((Object)expiryPolicyFactoryConfig);
        Assert.assertNotNull((Object)timedExpiryPolicyFactoryConfig);
        Assert.assertNotNull((Object)durationConfig);
        Assert.assertNull((Object)expiryPolicyFactoryConfig.getClassName());
        Assert.assertEquals((Object)CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ACCESSED, (Object)timedExpiryPolicyFactoryConfig.getExpiryPolicyType());
        Assert.assertEquals((long)2L, (long)durationConfig.getDurationAmount());
        Assert.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)durationConfig.getTimeUnit()));
    }

    @Test
    public void cacheConfigXmlTest_TimedModifiedExpiryPolicyFactory() {
        Config config = this.instance1.getConfig();
        CacheSimpleConfig cacheWithTimedModifiedExpiryPolicyFactoryConfig = config.getCacheConfig("cacheWithTimedModifiedExpiryPolicyFactory");
        CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig = cacheWithTimedModifiedExpiryPolicyFactoryConfig.getExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = expiryPolicyFactoryConfig.getTimedExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = timedExpiryPolicyFactoryConfig.getDurationConfig();
        Assert.assertNotNull((Object)expiryPolicyFactoryConfig);
        Assert.assertNotNull((Object)timedExpiryPolicyFactoryConfig);
        Assert.assertNotNull((Object)durationConfig);
        Assert.assertNull((Object)expiryPolicyFactoryConfig.getClassName());
        Assert.assertEquals((Object)CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.MODIFIED, (Object)timedExpiryPolicyFactoryConfig.getExpiryPolicyType());
        Assert.assertEquals((long)3L, (long)durationConfig.getDurationAmount());
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)durationConfig.getTimeUnit()));
    }

    @Test
    public void cacheConfigXmlTest_TimedModifiedTouchedPolicyFactory() {
        Config config = this.instance1.getConfig();
        CacheSimpleConfig cacheWithTimedTouchedExpiryPolicyFactoryConfig = config.getCacheConfig("cacheWithTimedTouchedExpiryPolicyFactory");
        CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig = cacheWithTimedTouchedExpiryPolicyFactoryConfig.getExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = expiryPolicyFactoryConfig.getTimedExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = timedExpiryPolicyFactoryConfig.getDurationConfig();
        Assert.assertNotNull((Object)expiryPolicyFactoryConfig);
        Assert.assertNotNull((Object)timedExpiryPolicyFactoryConfig);
        Assert.assertNotNull((Object)durationConfig);
        Assert.assertNull((Object)expiryPolicyFactoryConfig.getClassName());
        Assert.assertEquals((Object)CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.TOUCHED, (Object)timedExpiryPolicyFactoryConfig.getExpiryPolicyType());
        Assert.assertEquals((long)4L, (long)durationConfig.getDurationAmount());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)durationConfig.getTimeUnit()));
    }

    @Test
    public void cacheConfigXmlTest_TimedEternalTouchedPolicyFactory() {
        Config config = this.instance1.getConfig();
        CacheSimpleConfig cacheWithTimedEternalExpiryPolicyFactoryConfig = config.getCacheConfig("cacheWithTimedEternalExpiryPolicyFactory");
        CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig = cacheWithTimedEternalExpiryPolicyFactoryConfig.getExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = expiryPolicyFactoryConfig.getTimedExpiryPolicyFactoryConfig();
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = timedExpiryPolicyFactoryConfig.getDurationConfig();
        Assert.assertNotNull((Object)expiryPolicyFactoryConfig);
        Assert.assertNotNull((Object)timedExpiryPolicyFactoryConfig);
        Assert.assertNull((Object)durationConfig);
        Assert.assertNull((Object)expiryPolicyFactoryConfig.getClassName());
        Assert.assertEquals((Object)CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL, (Object)timedExpiryPolicyFactoryConfig.getExpiryPolicyType());
    }

    @Test
    public void cacheConfigXmlTest_PartitionLostListener() {
        Config config = this.instance1.getConfig();
        CacheSimpleConfig cacheWithPartitionLostListenerConfig = config.getCacheConfig("cacheWithPartitionLostListener");
        List partitionLostListenerConfigs = cacheWithPartitionLostListenerConfig.getPartitionLostListenerConfigs();
        Assert.assertNotNull((Object)partitionLostListenerConfigs);
        Assert.assertEquals((long)1L, (long)partitionLostListenerConfigs.size());
        Assert.assertEquals((Object)((CachePartitionLostListenerConfig)partitionLostListenerConfigs.get(0)).getClassName(), (Object)"DummyCachePartitionLostListenerImpl");
        Assert.assertNotNull((Object)partitionLostListenerConfigs);
        Assert.assertEquals((long)1L, (long)partitionLostListenerConfigs.size());
        Assert.assertEquals((Object)((CachePartitionLostListenerConfig)partitionLostListenerConfigs.get(0)).getClassName(), (Object)"DummyCachePartitionLostListenerImpl");
    }

    @Test
    public void cacheConfigXmlTest_ClusterSplitBrainProtection() {
        Assert.assertNotNull((Object)this.instance1);
        CacheSimpleConfig simpleConfig = this.instance1.getConfig().getCacheConfig("cacheWithSplitBrainProtectionRef");
        Assert.assertNotNull((Object)simpleConfig);
        Assert.assertEquals((Object)"cacheSplitBrainProtectionRefString", (Object)simpleConfig.getSplitBrainProtectionName());
    }

    @Test
    public void cacheConfigXmlTest_DefaultMergePolicy() {
        Assert.assertNotNull((Object)this.instance1);
        CacheSimpleConfig cacheWithDefaultMergePolicyConfig = this.instance1.getConfig().getCacheConfig("cacheWithDefaultMergePolicy");
        Assert.assertNotNull((Object)cacheWithDefaultMergePolicyConfig);
        Assert.assertEquals((Object)MergePolicyConfig.DEFAULT_MERGE_POLICY, (Object)cacheWithDefaultMergePolicyConfig.getMergePolicyConfig().getPolicy());
    }

    @Test
    public void cacheConfigXmlTest_CustomMergePolicy() {
        Assert.assertNotNull((Object)this.instance1);
        CacheSimpleConfig cacheWithCustomMergePolicyConfig = this.instance1.getConfig().getCacheConfig("cacheWithCustomMergePolicy");
        Assert.assertNotNull((Object)cacheWithCustomMergePolicyConfig);
        Assert.assertEquals((Object)"MyDummyMergePolicy", (Object)cacheWithCustomMergePolicyConfig.getMergePolicyConfig().getPolicy());
    }

    @Test
    public void cacheConfigXmlTest_ComparatorClassName() {
        Assert.assertNotNull((Object)this.instance1);
        CacheSimpleConfig cacheConfigWithComparatorClassName = this.instance1.getConfig().getCacheConfig("cacheWithComparatorClassName");
        Assert.assertNotNull((Object)cacheConfigWithComparatorClassName);
        EvictionConfig evictionConfig = cacheConfigWithComparatorClassName.getEvictionConfig();
        Assert.assertNotNull((Object)evictionConfig);
        Assert.assertEquals((Object)"com.mycompany.MyEvictionPolicyComparator", (Object)evictionConfig.getComparatorClassName());
    }

    @Test
    public void cacheConfigXmlTest_ComparatorBean() {
        Assert.assertNotNull((Object)this.instance1);
        CacheSimpleConfig cacheConfigWithComparatorClassName = this.instance1.getConfig().getCacheConfig("cacheWithComparatorBean");
        Assert.assertNotNull((Object)cacheConfigWithComparatorClassName);
        EvictionConfig evictionConfig = cacheConfigWithComparatorClassName.getEvictionConfig();
        Assert.assertNotNull((Object)evictionConfig);
        Assert.assertEquals(MyEvictionPolicyComparator.class, evictionConfig.getComparator().getClass());
    }

    @Test
    public void cacheConfigXmlTest_SimpleWriterLoader() {
        Assert.assertNotNull((Object)this.instance1);
        CacheSimpleConfig config = this.instance1.getConfig().getCacheConfig("cacheWithSimpleWriterAndLoader");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"com.hazelcast.config.CacheConfigTest$EmptyCacheWriter", (Object)config.getCacheWriter());
        Assert.assertEquals((Object)"com.hazelcast.config.CacheConfigTest$MyCacheLoader", (Object)config.getCacheLoader());
    }
}

