/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.transaction;

import com.hazelcast.spring.transaction.DummyObject;
import com.hazelcast.spring.transaction.OtherServiceBeanWithTransactionalContext;
import com.hazelcast.transaction.TransactionalTaskContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceBeanWithTransactionalContext {
    TransactionalTaskContext transactionalContext;
    OtherServiceBeanWithTransactionalContext otherService;

    public ServiceBeanWithTransactionalContext(TransactionalTaskContext transactionalContext, OtherServiceBeanWithTransactionalContext otherService) {
        this.transactionalContext = transactionalContext;
        this.otherService = otherService;
    }

    public void put(DummyObject object) {
        this.transactionalContext.getMap("dummyObjectMap").put((Object)object.getId(), (Object)object);
    }

    public void putWithException(DummyObject object) {
        this.put(object);
        throw new RuntimeException("oops, let's rollback!");
    }

    public void putUsingOtherBean_sameTransaction(DummyObject object) {
        this.otherService.put(object);
    }

    public void putUsingOtherBean_sameTransaction_withException(DummyObject object) {
        this.otherService.putWithException(object);
    }

    public void putUsingOtherBean_newTransaction(DummyObject object) {
        this.otherService.putInNewTransaction(object);
    }

    public void putUsingSameBean_thenOtherBeanThrowingException_sameTransaction(DummyObject object, DummyObject otherObject) {
        this.put(object);
        this.otherService.putWithException(otherObject);
    }

    public void putUsingOtherBean_thenSameBeanThrowingException_sameTransaction(DummyObject object, DummyObject otherObject) {
        this.otherService.put(otherObject);
        this.putWithException(object);
    }
}

