/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.spring.cache.IDummyBean;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"cacheManager-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestCacheManager
extends HazelcastTestSupport {
    @Resource(name="instance")
    private HazelcastInstance instance;
    @Autowired
    private IDummyBean bean;
    @Autowired
    private CacheManager cacheManager;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Test
    public void testBean_withValue() {
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)("name:" + i), (Object)this.bean.getName(i));
            Assert.assertEquals((Object)("city:" + i), (Object)this.bean.getCity(i));
        }
    }

    @Test
    public void testBean_withNull() {
        for (int i = 0; i < 100; ++i) {
            Assert.assertNull((Object)this.bean.getNull());
        }
    }

    @Test
    public void testBean_withTTL() {
        String name = this.bean.getNameWithTTL();
        Assert.assertEquals((Object)"ali", (Object)name);
        String nameFromCache = this.bean.getNameWithTTL();
        Assert.assertEquals((Object)"ali", (Object)nameFromCache);
        TestCacheManager.sleepSeconds((int)3);
        String nameFromCacheAfterTTL = this.bean.getNameWithTTL();
        Assert.assertNull((Object)nameFromCacheAfterTTL);
    }

    @Test
    public void testCacheNames() {
        String testMap = "test-map";
        final CountDownLatch distributionSignal = new CountDownLatch(1);
        this.instance.addDistributedObjectListener(new DistributedObjectListener(){

            public void distributedObjectCreated(DistributedObjectEvent event) {
                IMap map;
                DistributedObject distributedObject = event.getDistributedObject();
                if (distributedObject instanceof IMap && "test-map".equals((map = (IMap)distributedObject).getName())) {
                    distributionSignal.countDown();
                }
            }

            public void distributedObjectDestroyed(DistributedObjectEvent event) {
            }
        });
        Config config = new Config();
        config.getNetworkConfig().setPublicAddress("127.0.0.1").setPort(5101).setPortAutoIncrement(true);
        JoinConfig join = config.getNetworkConfig().getJoin();
        join.getMulticastConfig().setEnabled(false);
        join.getAwsConfig().setEnabled(false);
        join.getTcpIpConfig().setEnabled(true).setMembers(Arrays.asList("127.0.0.1"));
        HazelcastInstance testInstance = Hazelcast.newHazelcastInstance((Config)config);
        testInstance.getMap("test-map");
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)distributionSignal);
        Collection test = this.cacheManager.getCacheNames();
        TestCacheManager.assertContains((Collection)test, (Object)"test-map");
        testInstance.shutdown();
    }

    public static class DummyBean
    implements IDummyBean {
        final AtomicBoolean nullCall = new AtomicBoolean(false);
        final AtomicBoolean firstCall = new AtomicBoolean(false);

        @Override
        public String getName(int k) {
            Assert.fail((String)"should not call this method!");
            return null;
        }

        @Override
        public String getCity(int k) {
            Assert.fail((String)"should not call this method!");
            return null;
        }

        @Override
        public Object getNull() {
            if (this.nullCall.compareAndSet(false, true)) {
                return null;
            }
            Assert.fail((String)"should not call this method!");
            return null;
        }

        @Override
        public String getNameWithTTL() {
            if (this.firstCall.compareAndSet(false, true)) {
                return "ali";
            }
            return null;
        }
    }
}

