/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.hibernate;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastCacheRegionFactory;
import com.hazelcast.hibernate.HazelcastLocalCacheRegionFactory;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.net.InetSocketAddress;
import java.util.Set;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"hibernate-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestHibernateApplicationContext {
    @Resource(name="instance")
    private HazelcastInstance instance;
    @Resource(name="regionFactory")
    private HazelcastCacheRegionFactory regionFactory;
    @Resource(name="localRegionFactory")
    private HazelcastLocalCacheRegionFactory localRegionFactory;
    @Resource(name="localRegionFactory2")
    private HazelcastLocalCacheRegionFactory localRegionFactory2;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Test
    public void testInstance() {
        Assert.assertNotNull((Object)this.instance);
        Set members = this.instance.getCluster().getMembers();
        Assert.assertEquals((long)1L, (long)members.size());
        Member member = (Member)members.iterator().next();
        InetSocketAddress inetSocketAddress = member.getSocketAddress();
        Assert.assertEquals((long)5700L, (long)inetSocketAddress.getPort());
    }

    @Test
    public void testRegionFactory() {
        Assert.assertNotNull((Object)this.regionFactory);
        Assert.assertEquals((Object)this.regionFactory.getHazelcastInstance(), (Object)this.instance);
        Assert.assertNotNull((Object)this.localRegionFactory);
        Assert.assertEquals((Object)this.localRegionFactory.getHazelcastInstance(), (Object)this.instance);
        Assert.assertNotNull((Object)this.localRegionFactory2);
        Assert.assertEquals((Object)this.localRegionFactory2.getHazelcastInstance(), (Object)this.instance);
    }
}

