/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.hotrestart;

import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.config.HotRestartClusterDataRecoveryPolicy;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.JavaKeyStoreSecureStoreConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.spring.CustomSpringJUnit4ClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import javax.annotation.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=CustomSpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"hot-restart-encryption-keystore-applicationContext-hazelcast.xml"})
@Category(value={QuickTest.class})
public class TestHotRestartEncryptionKeyStoreApplicationContext {
    @Resource(name="instance")
    private HazelcastInstance instance;
    @Resource
    private SSLContextFactory sslContextFactory;

    @BeforeClass
    @AfterClass
    public static void start() {
        Hazelcast.shutdownAll();
    }

    @Test
    public void testHotRestart() {
        File dir = new File("/mnt/hot-restart/");
        File hotBackupDir = new File("/mnt/hot-backup/");
        HotRestartPersistenceConfig hotRestartPersistenceConfig = this.instance.getConfig().getHotRestartPersistenceConfig();
        Assert.assertFalse((boolean)hotRestartPersistenceConfig.isEnabled());
        Assert.assertEquals((Object)dir.getAbsolutePath(), (Object)hotRestartPersistenceConfig.getBaseDir().getAbsolutePath());
        Assert.assertEquals((Object)hotBackupDir.getAbsolutePath(), (Object)hotRestartPersistenceConfig.getBackupDir().getAbsolutePath());
        Assert.assertEquals((long)1111L, (long)hotRestartPersistenceConfig.getValidationTimeoutSeconds());
        Assert.assertEquals((long)2222L, (long)hotRestartPersistenceConfig.getDataLoadTimeoutSeconds());
        Assert.assertEquals((Object)HotRestartClusterDataRecoveryPolicy.PARTIAL_RECOVERY_MOST_COMPLETE, (Object)hotRestartPersistenceConfig.getClusterDataRecoveryPolicy());
        Assert.assertFalse((boolean)hotRestartPersistenceConfig.isAutoRemoveStaleData());
        EncryptionAtRestConfig encryptionAtRestConfig = hotRestartPersistenceConfig.getEncryptionAtRestConfig();
        Assert.assertNotNull((Object)encryptionAtRestConfig);
        Assert.assertTrue((boolean)encryptionAtRestConfig.isEnabled());
        Assert.assertEquals((Object)"AES/CBC/PKCS5Padding", (Object)encryptionAtRestConfig.getAlgorithm());
        Assert.assertEquals((Object)"sugar", (Object)encryptionAtRestConfig.getSalt());
        Assert.assertEquals((long)16L, (long)encryptionAtRestConfig.getKeySize());
        Assert.assertTrue((boolean)(encryptionAtRestConfig.getSecureStoreConfig() instanceof JavaKeyStoreSecureStoreConfig));
        JavaKeyStoreSecureStoreConfig keyStoreConfig = (JavaKeyStoreSecureStoreConfig)encryptionAtRestConfig.getSecureStoreConfig();
        Assert.assertEquals((Object)new File("/mnt/hot-restart/keystore.p12").getAbsolutePath(), (Object)keyStoreConfig.getPath().getAbsolutePath());
        Assert.assertEquals((Object)"PKCS12", (Object)keyStoreConfig.getType());
        Assert.assertEquals((Object)"password", (Object)keyStoreConfig.getPassword());
        Assert.assertEquals((long)60L, (long)keyStoreConfig.getPollingInterval());
    }
}

