/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.spring.CacheManagerBeanDefinitionParser;
import com.hazelcast.spring.HazelcastClientBeanDefinitionParser;
import com.hazelcast.spring.HazelcastConfigBeanDefinitionParser;
import com.hazelcast.spring.HazelcastFailoverClientBeanDefinitionParser;
import com.hazelcast.spring.HazelcastInstanceDefinitionParser;
import com.hazelcast.spring.HazelcastTypeBeanDefinitionParser;
import com.hazelcast.spring.hibernate.RegionFactoryBeanDefinitionParser;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class HazelcastNamespaceHandler
extends NamespaceHandlerSupport {
    static final Set<String> CP_TYPES = new HashSet<String>();
    private static final String MAP = "map";
    private static final String MULTI_MAP = "multiMap";
    private static final String REPLICATED_MAP = "replicatedMap";
    private static final String QUEUE = "queue";
    private static final String TOPIC = "topic";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String EXECUTOR_SERVICE = "executorService";
    private static final String DURABLE_EXECUTOR_SERVICE = "durableExecutorService";
    private static final String SCHEDULED_EXECUTOR_SERVICE = "scheduledExecutorService";
    private static final String RINGBUFFER = "ringbuffer";
    private static final String CARDINALITY_ESTIMATOR = "cardinalityEstimator";
    private static final String FLAKE_ID_GENERATOR = "flakeIdGenerator";
    private static final String ATOMIC_LONG = "atomicLong";
    private static final String ATOMIC_REFERENCE = "atomicReference";
    private static final String COUNT_DOWN_LATCH = "countDownLatch";
    private static final String SEMAPHORE = "semaphore";
    private static final String LOCK = "lock";
    private static final String RELIABLE_TOPIC = "reliableTopic";
    private static final String PNCOUNTER = "PNCounter";

    public void init() {
        String[] types;
        this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new HazelcastConfigBeanDefinitionParser());
        this.registerBeanDefinitionParser("hazelcast", (BeanDefinitionParser)new HazelcastInstanceDefinitionParser());
        this.registerBeanDefinitionParser("client", (BeanDefinitionParser)new HazelcastClientBeanDefinitionParser());
        this.registerBeanDefinitionParser("client-failover", (BeanDefinitionParser)new HazelcastFailoverClientBeanDefinitionParser());
        this.registerBeanDefinitionParser("hibernate-region-factory", (BeanDefinitionParser)new RegionFactoryBeanDefinitionParser());
        this.registerBeanDefinitionParser("cache-manager", (BeanDefinitionParser)new CacheManagerBeanDefinitionParser());
        for (String type : types = new String[]{MAP, MULTI_MAP, REPLICATED_MAP, QUEUE, TOPIC, SET, LIST, EXECUTOR_SERVICE, DURABLE_EXECUTOR_SERVICE, SCHEDULED_EXECUTOR_SERVICE, RINGBUFFER, CARDINALITY_ESTIMATOR, FLAKE_ID_GENERATOR, ATOMIC_LONG, ATOMIC_REFERENCE, COUNT_DOWN_LATCH, SEMAPHORE, LOCK, RELIABLE_TOPIC, PNCOUNTER}) {
            this.registerBeanDefinitionParser(type, (BeanDefinitionParser)new HazelcastTypeBeanDefinitionParser(type));
        }
    }

    static {
        CP_TYPES.add(LOCK);
        CP_TYPES.add(SEMAPHORE);
        CP_TYPES.add(COUNT_DOWN_LATCH);
        CP_TYPES.add(ATOMIC_LONG);
        CP_TYPES.add(ATOMIC_REFERENCE);
    }
}

