/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.CompactSerializationConfigAccessor;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class ConfigFactory {
    private static volatile Supplier<Config> configSupplier = Config::new;
    private static volatile Supplier<ClientConfig> clientConfigSupplier = ClientConfig::new;
    private static volatile Supplier<ClientFailoverConfig> clientFailoverConfigSupplier = ClientFailoverConfig::new;

    private ConfigFactory() {
    }

    static void setConfigSupplier(Supplier<Config> configSupplier) {
        ConfigFactory.configSupplier = configSupplier;
    }

    static void setClientConfigSupplier(Supplier<ClientConfig> clientConfigSupplier) {
        ConfigFactory.clientConfigSupplier = clientConfigSupplier;
    }

    static void setClientFailoverConfigSupplier(Supplier<ClientFailoverConfig> clientFailoverConfigSupplier) {
        ConfigFactory.clientFailoverConfigSupplier = clientFailoverConfigSupplier;
    }

    public static Config newConfig() {
        return configSupplier.get();
    }

    public static ClientConfig newClientConfig() {
        return clientConfigSupplier.get();
    }

    public static ClientFailoverConfig newClientFailoverConfig() {
        return clientFailoverConfigSupplier.get();
    }

    public static EvictionConfig newEvictionConfig(Integer maxSize, MaxSizePolicy maxSizePolicy, EvictionPolicy evictionPolicy, boolean isNearCache, boolean isIMap, String comparatorClassName, EvictionPolicyComparator<?, ?, ?> comparator) {
        int finalSize = ConfigFactory.maxSize(maxSize, isIMap);
        MaxSizePolicy finalMaxSizePolicy = ConfigFactory.maxSizePolicy(maxSizePolicy, isIMap);
        EvictionPolicy finalEvictionPolicy = ConfigFactory.evictionPolicy(evictionPolicy, isIMap);
        try {
            ConfigFactory.doEvictionConfigChecks(finalMaxSizePolicy, finalEvictionPolicy, comparatorClassName, comparator, isIMap, isNearCache);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
        EvictionConfig evictionConfig = new EvictionConfig().setSize(finalSize).setMaxSizePolicy(finalMaxSizePolicy).setEvictionPolicy(finalEvictionPolicy);
        if (comparatorClassName != null) {
            evictionConfig.setComparatorClassName(comparatorClassName);
        }
        if (comparator != null) {
            evictionConfig.setComparator(comparator);
        }
        return evictionConfig;
    }

    public static AliasedDiscoveryConfig newAliasedDiscoveryConfig(String tag, Map<String, String> properties) {
        AliasedDiscoveryConfig config = AliasedDiscoveryConfigUtils.newConfigFor((String)tag);
        properties.forEach((arg_0, arg_1) -> ((AliasedDiscoveryConfig)config).setProperty(arg_0, arg_1));
        return config;
    }

    public static CompactSerializationConfig newCompactSerializationConfig(List<String> serializerClassNames, List<String> compactSerializableClassNames) {
        CompactSerializationConfig config = new CompactSerializationConfig();
        for (String compactSerializableClassName : compactSerializableClassNames) {
            CompactSerializationConfigAccessor.registerClass((CompactSerializationConfig)config, (String)compactSerializableClassName);
        }
        for (String serializerClassName : serializerClassNames) {
            CompactSerializationConfigAccessor.registerSerializer((CompactSerializationConfig)config, (String)serializerClassName);
        }
        return config;
    }

    private static int maxSize(Integer size, boolean isIMap) {
        if (size == null) {
            return isIMap ? Integer.MAX_VALUE : 10000;
        }
        if (isIMap && size == 0) {
            return Integer.MAX_VALUE;
        }
        return size;
    }

    private static EvictionPolicy evictionPolicy(EvictionPolicy evictionPolicy, boolean isIMap) {
        if (evictionPolicy == null) {
            return isIMap ? MapConfig.DEFAULT_EVICTION_POLICY : EvictionConfig.DEFAULT_EVICTION_POLICY;
        }
        return evictionPolicy;
    }

    private static MaxSizePolicy maxSizePolicy(MaxSizePolicy maxSizePolicy, boolean isIMap) {
        if (maxSizePolicy == null) {
            return isIMap ? MapConfig.DEFAULT_MAX_SIZE_POLICY : EvictionConfig.DEFAULT_MAX_SIZE_POLICY;
        }
        return maxSizePolicy;
    }

    private static void doEvictionConfigChecks(MaxSizePolicy maxSizePolicyValue, EvictionPolicy evictionPolicyValue, String comparatorClassNameValue, Object comparatorBeanValue, boolean isIMap, boolean isNearCache) {
        if (isIMap) {
            ConfigValidator.checkMapEvictionConfig((MaxSizePolicy)maxSizePolicyValue, (EvictionPolicy)evictionPolicyValue, (String)comparatorClassNameValue, (Object)comparatorBeanValue);
            return;
        }
        if (isNearCache) {
            ConfigValidator.checkNearCacheEvictionConfig((EvictionPolicy)evictionPolicyValue, (String)comparatorClassNameValue, (Object)comparatorBeanValue);
            return;
        }
        ConfigValidator.checkEvictionConfig((EvictionPolicy)evictionPolicyValue, (String)comparatorClassNameValue, (Object)comparatorBeanValue, (EnumSet)ConfigValidator.COMMONLY_SUPPORTED_EVICTION_POLICIES);
    }
}

