/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.AuditlogConfig;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.config.DataPersistenceConfig;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.DynamicConfigurationConfig;
import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.IntegrityCheckerConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JavaKeyStoreSecureStoreConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MemcacheProtocolConfig;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.MetricsConfig;
import com.hazelcast.config.MetricsJmxConfig;
import com.hazelcast.config.MetricsManagementCenterConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.OnJoinPermissionOperationName;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.PersistenceConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.ProbabilisticSplitBrainProtectionConfigBuilder;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.RecentlyActiveSplitBrainProtectionConfigBuilder;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RestApiConfig;
import com.hazelcast.config.RestEndpointGroup;
import com.hazelcast.config.RestServerEndpointConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionConfigBuilder;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.config.SqlConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.config.UserCodeNamespacesConfig;
import com.hazelcast.config.VaultSecureStoreConfig;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.config.cp.CPMapConfig;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.cp.FencedLockConfig;
import com.hazelcast.config.cp.RaftAlgorithmConfig;
import com.hazelcast.config.cp.SemaphoreConfig;
import com.hazelcast.config.security.AccessControlServiceConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.KerberosAuthenticationConfig;
import com.hazelcast.config.security.KerberosIdentityConfig;
import com.hazelcast.config.security.LdapAuthenticationConfig;
import com.hazelcast.config.security.LdapRoleMappingMode;
import com.hazelcast.config.security.LdapSearchScope;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.SimpleAuthenticationConfig;
import com.hazelcast.config.security.TlsAuthenticationConfig;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.config.tpc.TpcConfig;
import com.hazelcast.config.tpc.TpcSocketConfig;
import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.config.vector.VectorIndexConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.namespace.impl.ResourceDefinitionImpl;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.Capacity;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.spring.config.ConfigFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastConfigBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    private static final ILogger LOGGER = Logger.getLogger(HazelcastConfigBeanDefinitionParser.class);
    private static final Map<String, String> ICMP_FAILURE_DETECTOR_CONFIG_PROPERTIES;

    public AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlConfigBuilder springXmlConfigBuilder = new SpringXmlConfigBuilder(parserContext);
        springXmlConfigBuilder.handleConfig(element);
        return springXmlConfigBuilder.getBeanDefinition();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ttl", "ttl");
        map.put("timeout-milliseconds", "timeoutMilliseconds");
        map.put("parallel-mode", "parallelMode");
        map.put("fail-fast-on-startup", "failFastOnStartup");
        map.put("max-attempts", "maxAttempts");
        map.put("interval-milliseconds", "intervalMilliseconds");
        ICMP_FAILURE_DETECTOR_CONFIG_PROPERTIES = Collections.unmodifiableMap(map);
    }

    private class SpringXmlConfigBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private ManagedMap<String, AbstractBeanDefinition> mapConfigManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> cacheConfigManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> queueManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> ringbufferManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> reliableTopicManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> listManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> setManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> topicManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> multiMapManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> executorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> durableExecutorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> scheduledExecutorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> cardinalityEstimatorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> wanReplicationManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> replicatedMapManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> splitBrainProtectionManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> flakeIdGeneratorConfigMap;
        private ManagedMap<String, AbstractBeanDefinition> pnCounterManagedMap;
        private ManagedMap<EndpointQualifier, AbstractBeanDefinition> endpointConfigsMap;
        private ManagedMap<String, AbstractBeanDefinition> deviceConfigManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> dataConnectionConfigMap;
        private ManagedMap<String, AbstractBeanDefinition> vectorCollectionConfigManagedMap;
        private boolean hasNetwork;
        private boolean hasAdvancedNetworkEnabled;

        SpringXmlConfigBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConfigFactory.class, (String)"newConfig");
            this.mapConfigManagedMap = this.createManagedMap("mapConfigs");
            this.cacheConfigManagedMap = this.createManagedMap("cacheConfigs");
            this.queueManagedMap = this.createManagedMap("queueConfigs");
            this.ringbufferManagedMap = this.createManagedMap("ringbufferConfigs");
            this.reliableTopicManagedMap = this.createManagedMap("reliableTopicConfigs");
            this.listManagedMap = this.createManagedMap("listConfigs");
            this.setManagedMap = this.createManagedMap("setConfigs");
            this.topicManagedMap = this.createManagedMap("topicConfigs");
            this.multiMapManagedMap = this.createManagedMap("multiMapConfigs");
            this.executorManagedMap = this.createManagedMap("executorConfigs");
            this.durableExecutorManagedMap = this.createManagedMap("durableExecutorConfigs");
            this.scheduledExecutorManagedMap = this.createManagedMap("scheduledExecutorConfigs");
            this.cardinalityEstimatorManagedMap = this.createManagedMap("cardinalityEstimatorConfigs");
            this.wanReplicationManagedMap = this.createManagedMap("wanReplicationConfigs");
            this.replicatedMapManagedMap = this.createManagedMap("replicatedMapConfigs");
            this.splitBrainProtectionManagedMap = this.createManagedMap("splitBrainProtectionConfigs");
            this.flakeIdGeneratorConfigMap = this.createManagedMap("flakeIdGeneratorConfigs");
            this.pnCounterManagedMap = this.createManagedMap("PNCounterConfigs");
            this.endpointConfigsMap = new ManagedMap();
            this.deviceConfigManagedMap = this.createManagedMap("deviceConfigs");
            this.dataConnectionConfigMap = this.createManagedMap("dataConnectionConfigs");
            this.vectorCollectionConfigManagedMap = this.createManagedMap("vectorCollectionConfigs");
        }

        private ManagedMap<String, AbstractBeanDefinition> createManagedMap(String configName) {
            ManagedMap managedMap = new ManagedMap();
            this.configBuilder.addPropertyValue(configName, (Object)managedMap);
            return managedMap;
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.configBuilder.getBeanDefinition();
        }

        public void handleConfig(Element element) {
            if (element != null) {
                this.handleCommonBeanAttributes(element, this.configBuilder, this.parserContext);
                for (Node node : DomConfigHelper.childElements((Node)element)) {
                    String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                    if ("network".equals(nodeName)) {
                        this.handleNetwork(node);
                        continue;
                    }
                    if ("advanced-network".equals(nodeName)) {
                        this.handleAdvancedNetwork(node);
                        continue;
                    }
                    if ("properties".equals(nodeName)) {
                        this.handleProperties(node);
                        continue;
                    }
                    if ("executor-service".equals(nodeName)) {
                        this.handleExecutor(node);
                        continue;
                    }
                    if ("durable-executor-service".equals(nodeName)) {
                        this.handleDurableExecutor(node);
                        continue;
                    }
                    if ("scheduled-executor-service".equals(nodeName)) {
                        this.handleScheduledExecutor(node);
                        continue;
                    }
                    if ("cardinality-estimator".equals(nodeName)) {
                        this.handleCardinalityEstimator(node);
                        continue;
                    }
                    if ("queue".equals(nodeName)) {
                        this.handleQueue(node);
                        continue;
                    }
                    if ("ringbuffer".equals(nodeName)) {
                        this.handleRingbuffer(node);
                        continue;
                    }
                    if ("reliable-topic".equals(nodeName)) {
                        this.handleReliableTopic(node);
                        continue;
                    }
                    if ("map".equals(nodeName)) {
                        this.handleMap(node);
                        continue;
                    }
                    if ("cache".equals(nodeName)) {
                        this.handleCache(node);
                        continue;
                    }
                    if ("multimap".equals(nodeName)) {
                        this.handleMultiMap(node);
                        continue;
                    }
                    if ("list".equals(nodeName)) {
                        this.handleList(node);
                        continue;
                    }
                    if ("set".equals(nodeName)) {
                        this.handleSet(node);
                        continue;
                    }
                    if ("topic".equals(nodeName)) {
                        this.handleTopic(node);
                        continue;
                    }
                    if ("replicatedmap".equals(nodeName)) {
                        this.handleReplicatedMap(node);
                        continue;
                    }
                    if ("wan-replication".equals(nodeName)) {
                        this.handleWanReplication(node);
                        continue;
                    }
                    if ("partition-group".equals(nodeName)) {
                        this.handlePartitionGroup(node);
                        continue;
                    }
                    if ("serialization".equals(nodeName)) {
                        this.handleSerialization(node);
                        continue;
                    }
                    if ("native-memory".equals(nodeName)) {
                        this.handleNativeMemory(node);
                        continue;
                    }
                    if ("security".equals(nodeName)) {
                        this.handleSecurity(node);
                        continue;
                    }
                    if ("member-attributes".equals(nodeName)) {
                        this.handleMemberAttributes(node);
                        continue;
                    }
                    if ("instance-name".equals(nodeName) || "cluster-name".equals(nodeName) || "license-key".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("listeners".equals(nodeName)) {
                        ManagedList<BeanDefinition> listeners = this.parseListeners(node, ListenerConfig.class);
                        this.configBuilder.addPropertyValue("listenerConfigs", listeners);
                        continue;
                    }
                    if ("lite-member".equals(nodeName)) {
                        this.handleLiteMember(node);
                        continue;
                    }
                    if ("management-center".equals(nodeName)) {
                        this.handleManagementCenter(node);
                        continue;
                    }
                    if ("spring-aware".equals(nodeName)) {
                        this.handleSpringAware();
                        continue;
                    }
                    if ("split-brain-protection".equals(nodeName)) {
                        this.handleSplitBrainProtection(node);
                        continue;
                    }
                    if ("hot-restart-persistence".equals(nodeName)) {
                        this.handleHotRestartPersistence(node);
                        continue;
                    }
                    if ("persistence".equals(nodeName)) {
                        this.handlePersistence(node);
                        continue;
                    }
                    if ("flake-id-generator".equals(nodeName)) {
                        this.handleFlakeIdGenerator(node);
                        continue;
                    }
                    if ("crdt-replication".equals(nodeName)) {
                        this.handleCRDTReplication(node);
                        continue;
                    }
                    if ("pn-counter".equals(nodeName)) {
                        this.handlePNCounter(node);
                        continue;
                    }
                    if ("cp-subsystem".equals(nodeName)) {
                        this.handleCPSubSystem(node);
                        continue;
                    }
                    if ("metrics".equals(nodeName)) {
                        this.handleMetrics(node);
                        continue;
                    }
                    if ("instance-tracking".equals(nodeName)) {
                        this.handleInstanceTracking(node);
                        continue;
                    }
                    if ("sql".equals(nodeName)) {
                        this.handleSql(node);
                        continue;
                    }
                    if ("auditlog".equals(nodeName)) {
                        this.handleAuditlog(node);
                        continue;
                    }
                    if ("jet".equals(nodeName)) {
                        this.handleJet(node);
                        continue;
                    }
                    if ("local-device".equals(nodeName)) {
                        this.handleLocalDevice(node);
                        continue;
                    }
                    if ("dynamic-configuration".equals(nodeName)) {
                        this.handleDynamicConfiguration(node);
                        continue;
                    }
                    if ("integrity-checker".equals(nodeName)) {
                        this.handleIntegrityChecker(node);
                        continue;
                    }
                    if ("data-connection".equals(nodeName)) {
                        this.handleDataConnection(node);
                        continue;
                    }
                    if ("tpc".equals(nodeName)) {
                        this.handleTpc(node);
                        continue;
                    }
                    if ("vector-collection".equals(nodeName)) {
                        this.handleVectorCollection(node);
                        continue;
                    }
                    if (!"user-code-namespaces".equals(nodeName)) continue;
                    this.handleNamespaces(node);
                }
            }
            if (this.hasNetwork && this.hasAdvancedNetworkEnabled) {
                throw new InvalidConfigurationException("Ambiguous configuration: cannot include both <network> and an enabled <advanced-network> element. Configure network using one of <network> or <advanced-network enabled=\"true\">.");
            }
        }

        @Deprecated
        private void handleHotRestartPersistence(Node node) {
            BeanDefinitionBuilder hotRestartConfigBuilder = this.createBeanBuilder(HotRestartPersistenceConfig.class);
            this.fillAttributeValues(node, hotRestartConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("base-dir".equals(name)) {
                    String value = this.getTextContent(child);
                    hotRestartConfigBuilder.addPropertyValue("baseDir", (Object)value);
                    continue;
                }
                if ("backup-dir".equals(name)) {
                    hotRestartConfigBuilder.addPropertyValue("backupDir", (Object)this.getTextContent(child));
                    continue;
                }
                if (!"encryption-at-rest".equals(name)) continue;
                this.handleEncryptionAtRest(hotRestartConfigBuilder, child);
            }
            this.configBuilder.addPropertyValue("hotRestartPersistenceConfig", (Object)hotRestartConfigBuilder.getBeanDefinition());
        }

        private void handlePersistence(Node node) {
            BeanDefinitionBuilder persistenceConfigBuilder = this.createBeanBuilder(PersistenceConfig.class);
            this.fillAttributeValues(node, persistenceConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("base-dir".equals(name)) {
                    String value = this.getTextContent(child);
                    persistenceConfigBuilder.addPropertyValue("baseDir", (Object)value);
                    continue;
                }
                if ("backup-dir".equals(name)) {
                    persistenceConfigBuilder.addPropertyValue("backupDir", (Object)this.getTextContent(child));
                    continue;
                }
                if (!"encryption-at-rest".equals(name)) continue;
                this.handleEncryptionAtRest(persistenceConfigBuilder, child);
            }
            this.configBuilder.addPropertyValue("persistenceConfig", (Object)persistenceConfigBuilder.getBeanDefinition());
        }

        private void handleDynamicConfiguration(Node node) {
            BeanDefinitionBuilder dynamicConfigBuilder = this.createBeanBuilder(DynamicConfigurationConfig.class);
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if ("persistence-enabled".equals(name)) {
                    boolean persistenceEnabled = DomConfigHelper.getBooleanValue((String)this.getTextContent(n));
                    dynamicConfigBuilder.addPropertyValue("persistenceEnabled", (Object)persistenceEnabled);
                    if (!persistenceEnabled) continue;
                    throw new InvalidConfigurationException("Dynamic Configuration Persistence isn't available for Spring.");
                }
                if ("backup-dir".equals(name)) {
                    dynamicConfigBuilder.addPropertyValue("backupDir", (Object)this.getTextContent(n));
                    continue;
                }
                if (!"backup-count".equals(name)) continue;
                dynamicConfigBuilder.addPropertyValue("backupCount", (Object)DomConfigHelper.getIntegerValue((String)"backup-count", (String)this.getTextContent(n)));
            }
            this.configBuilder.addPropertyValue("dynamicConfigurationConfig", (Object)dynamicConfigBuilder.getBeanDefinition());
        }

        private void handleLocalDevice(Node deviceNode) {
            BeanDefinitionBuilder deviceConfigBuilder = this.createBeanBuilder(LocalDeviceConfig.class);
            AbstractBeanDefinition beanDefinition = deviceConfigBuilder.getBeanDefinition();
            Node attName = deviceNode.getAttributes().getNamedItem("name");
            String deviceName = this.getTextContent(attName);
            deviceConfigBuilder.addPropertyValue("name", (Object)deviceName);
            this.fillAttributeValues(deviceNode, deviceConfigBuilder, new String[0]);
            for (Node n : DomConfigHelper.childElements((Node)deviceNode)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if ("base-dir".equals(name)) {
                    deviceConfigBuilder.addPropertyValue("baseDir", (Object)this.getTextContent(n));
                    continue;
                }
                if ("capacity".equals(name)) {
                    this.handleCapacity(n, deviceConfigBuilder);
                    continue;
                }
                if ("block-size".equals(name)) {
                    deviceConfigBuilder.addPropertyValue("blockSize", (Object)DomConfigHelper.getIntegerValue((String)"block-size", (String)this.getTextContent(n)));
                    continue;
                }
                if ("read-io-thread-count".equals(name)) {
                    deviceConfigBuilder.addPropertyValue("readIOThreadCount", (Object)DomConfigHelper.getIntegerValue((String)"read-io-thread-count", (String)this.getTextContent(n)));
                    continue;
                }
                if (!"write-io-thread-count".equals(name)) continue;
                deviceConfigBuilder.addPropertyValue("writeIOThreadCount", (Object)DomConfigHelper.getIntegerValue((String)"write-io-thread-count", (String)this.getTextContent(n)));
            }
            this.deviceConfigManagedMap.put((Object)deviceName, (Object)beanDefinition);
        }

        private void handleEncryptionAtRest(BeanDefinitionBuilder hotRestartConfigBuilder, Node node) {
            BeanDefinitionBuilder encryptionAtRestConfigBuilder = this.createBeanBuilder(EncryptionAtRestConfig.class);
            this.fillAttributeValues(node, encryptionAtRestConfigBuilder, new String[0]);
            this.fillValues(node, encryptionAtRestConfigBuilder, "secureStore");
            Node secureStoreNode = DomConfigHelper.childElementWithName((Node)node, (String)"secure-store", (boolean)true);
            for (Node child : DomConfigHelper.childElements((Node)secureStoreNode)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                AbstractBeanDefinition secureStoreBeanDefinition = null;
                if ("keystore".equals(nodeName)) {
                    secureStoreBeanDefinition = this.handleKeyStoreSecureStoreConfig(child);
                } else if ("vault".equals(nodeName)) {
                    secureStoreBeanDefinition = this.handleVaultSecureStoreConfig(child);
                }
                if (secureStoreBeanDefinition == null) continue;
                encryptionAtRestConfigBuilder.addPropertyValue("secureStoreConfig", (Object)secureStoreBeanDefinition);
            }
            hotRestartConfigBuilder.addPropertyValue("encryptionAtRestConfig", (Object)encryptionAtRestConfigBuilder.getBeanDefinition());
        }

        private AbstractBeanDefinition handleKeyStoreSecureStoreConfig(Node node) {
            BeanDefinitionBuilder keyStoreConfigBuilder = this.createBeanBuilder(JavaKeyStoreSecureStoreConfig.class);
            Node pathNode = DomConfigHelper.childElementWithName((Node)node, (String)"path", (boolean)true);
            keyStoreConfigBuilder.addConstructorArgValue((Object)new File(this.getTextContent(pathNode).trim()).getAbsoluteFile());
            this.fillValues(node, keyStoreConfigBuilder, new String[0]);
            return keyStoreConfigBuilder.getBeanDefinition();
        }

        private AbstractBeanDefinition handleVaultSecureStoreConfig(Node node) {
            BeanDefinitionBuilder vaultConfigBuilder = this.createBeanBuilder(VaultSecureStoreConfig.class);
            Node addressNode = DomConfigHelper.childElementWithName((Node)node, (String)"address", (boolean)true);
            Node secretPathNode = DomConfigHelper.childElementWithName((Node)node, (String)"secrets-path", (boolean)true);
            Node tokenNode = DomConfigHelper.childElementWithName((Node)node, (String)"token", (boolean)true);
            vaultConfigBuilder.addConstructorArgValue((Object)this.getTextContent(addressNode).trim());
            vaultConfigBuilder.addConstructorArgValue((Object)this.getTextContent(secretPathNode).trim());
            vaultConfigBuilder.addConstructorArgValue((Object)this.getTextContent(tokenNode).trim());
            this.fillValues(node, vaultConfigBuilder, "ssl");
            Node ssl = DomConfigHelper.childElementWithName((Node)node, (String)"ssl", (boolean)true);
            if (ssl != null) {
                this.handleSSLConfig(ssl, vaultConfigBuilder);
            }
            return vaultConfigBuilder.getBeanDefinition();
        }

        private void handleFlakeIdGenerator(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(FlakeIdGeneratorConfig.class);
            this.fillAttributeValues(node, configBuilder, new String[0]);
            String name = this.getAttribute(node, "name");
            this.flakeIdGeneratorConfigMap.put((Object)name, (Object)configBuilder.getBeanDefinition());
        }

        private void handleCRDTReplication(Node node) {
            BeanDefinitionBuilder crdtReplicationConfigBuilder = this.createBeanBuilder(CRDTReplicationConfig.class);
            this.fillAttributeValues(node, crdtReplicationConfigBuilder, new String[0]);
            this.configBuilder.addPropertyValue("CRDTReplicationConfig", (Object)crdtReplicationConfigBuilder.getBeanDefinition());
        }

        private void handleCPSubSystem(Node node) {
            BeanDefinitionBuilder cpSubsystemConfigBuilder = this.createBeanBuilder(CPSubsystemConfig.class);
            this.fillValues(node, cpSubsystemConfigBuilder, "raftAlgorithm", "semaphores", "locks", "cpMemberCount", "missingCpMemberAutoRemovalSeconds", "cpMemberPriority", "maps");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("raft-algorithm".equals(nodeName)) {
                    BeanDefinitionBuilder raftAlgorithmConfigBuilder = this.createBeanBuilder(RaftAlgorithmConfig.class);
                    this.fillValues(child, raftAlgorithmConfigBuilder, new String[0]);
                    cpSubsystemConfigBuilder.addPropertyValue("raftAlgorithmConfig", (Object)raftAlgorithmConfigBuilder.getBeanDefinition());
                    continue;
                }
                if ("semaphores".equals(nodeName)) {
                    ManagedMap semaphores = new ManagedMap();
                    this.handleSemaphores((ManagedMap<String, AbstractBeanDefinition>)semaphores, child);
                    cpSubsystemConfigBuilder.addPropertyValue("SemaphoreConfigs", (Object)semaphores);
                    continue;
                }
                if ("locks".equals(nodeName)) {
                    ManagedMap locks = new ManagedMap();
                    this.handleFencedLocks((ManagedMap<String, AbstractBeanDefinition>)locks, child);
                    cpSubsystemConfigBuilder.addPropertyValue("LockConfigs", (Object)locks);
                    continue;
                }
                if ("maps".equals(nodeName)) {
                    ManagedMap maps = new ManagedMap();
                    this.handleCpMaps((ManagedMap<String, AbstractBeanDefinition>)maps, child);
                    cpSubsystemConfigBuilder.addPropertyValue("CpMapConfigs", (Object)maps);
                    continue;
                }
                String value = this.getTextContent(child).trim();
                if ("cp-member-count".equals(nodeName)) {
                    cpSubsystemConfigBuilder.addPropertyValue("CPMemberCount", (Object)value);
                    continue;
                }
                if ("missing-cp-member-auto-removal-seconds".equals(nodeName)) {
                    cpSubsystemConfigBuilder.addPropertyValue("missingCPMemberAutoRemovalSeconds", (Object)DomConfigHelper.getIntegerValue((String)"missing-cp-member-auto-removal-seconds", (String)value));
                    continue;
                }
                if (!"cp-member-priority".equals(nodeName)) continue;
                cpSubsystemConfigBuilder.addPropertyValue("CPMemberPriority", (Object)DomConfigHelper.getIntegerValue((String)"cp-member-priority", (String)value));
            }
            this.configBuilder.addPropertyValue("CPSubsystemConfig", (Object)cpSubsystemConfigBuilder.getBeanDefinition());
        }

        private void handleSemaphores(ManagedMap<String, AbstractBeanDefinition> semaphores, Node node) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder semaphoreConfigBuilder = this.createBeanBuilder(SemaphoreConfig.class);
                for (Node subChild : DomConfigHelper.childElements((Node)child)) {
                    String nodeName = DomConfigHelper.cleanNodeName((Node)subChild);
                    String value = this.getTextContent(subChild).trim();
                    if ("name".equals(nodeName)) {
                        semaphoreConfigBuilder.addPropertyValue("name", (Object)value);
                        continue;
                    }
                    if ("jdk-compatible".equals(nodeName)) {
                        semaphoreConfigBuilder.addPropertyValue("JDKCompatible", (Object)DomConfigHelper.getBooleanValue((String)value));
                        continue;
                    }
                    if (!"initial-permits".equals(nodeName)) continue;
                    semaphoreConfigBuilder.addPropertyValue("initialPermits", (Object)DomConfigHelper.getIntegerValue((String)"initial-permits", (String)value));
                }
                AbstractBeanDefinition beanDefinition = semaphoreConfigBuilder.getBeanDefinition();
                String name = (String)beanDefinition.getPropertyValues().get("name");
                semaphores.put((Object)name, (Object)beanDefinition);
            }
        }

        private void handleFencedLocks(ManagedMap<String, AbstractBeanDefinition> locks, Node node) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder lockConfigBuilder = this.createBeanBuilder(FencedLockConfig.class);
                this.fillValues(child, lockConfigBuilder, new String[0]);
                AbstractBeanDefinition beanDefinition = lockConfigBuilder.getBeanDefinition();
                String name = (String)beanDefinition.getPropertyValues().get("name");
                locks.put((Object)name, (Object)beanDefinition);
            }
        }

        private void handleCpMaps(ManagedMap<String, AbstractBeanDefinition> maps, Node node) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder cpMapConfigBuilder = this.createBeanBuilder(CPMapConfig.class);
                this.fillValues(child, cpMapConfigBuilder, new String[0]);
                AbstractBeanDefinition beanDefinition = cpMapConfigBuilder.getBeanDefinition();
                String name = (String)beanDefinition.getPropertyValues().get("name");
                maps.put((Object)name, (Object)beanDefinition);
            }
        }

        private void handleSplitBrainProtection(Node node) {
            BeanDefinitionBuilder splitBrainProtectionBuilder = this.createBeanBuilder(SplitBrainProtectionConfig.class);
            AbstractBeanDefinition beanDefinition = splitBrainProtectionBuilder.getBeanDefinition();
            String name = this.getAttribute(node, "name");
            splitBrainProtectionBuilder.addPropertyValue("name", (Object)name);
            Node attrEnabled = node.getAttributes().getNamedItem("enabled");
            boolean enabled = attrEnabled != null && DomConfigHelper.getBooleanValue((String)this.getTextContent(attrEnabled));
            splitBrainProtectionBuilder.addPropertyValue("enabled", (Object)enabled);
            SplitBrainProtectionConfigBuilder configBuilder = null;
            int splitBrainProtectionSize = 3;
            String splitBrainProtectionClassName = null;
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String value = this.getTextContent(n).trim();
                String nodeName = DomConfigHelper.cleanNodeName((Node)n);
                if ("minimum-cluster-size".equals(nodeName)) {
                    splitBrainProtectionBuilder.addPropertyValue("minimumClusterSize", (Object)DomConfigHelper.getIntegerValue((String)"minimum-cluster-size", (String)value));
                    continue;
                }
                if ("listeners".equals(nodeName)) {
                    ManagedList<BeanDefinition> listeners = this.parseListeners(n, SplitBrainProtectionListenerConfig.class);
                    splitBrainProtectionBuilder.addPropertyValue("listenerConfigs", listeners);
                    continue;
                }
                if ("protect-on".equals(nodeName)) {
                    splitBrainProtectionBuilder.addPropertyValue("protectOn", (Object)SplitBrainProtectionOn.valueOf((String)value));
                    continue;
                }
                if ("function-class-name".equals(nodeName)) {
                    splitBrainProtectionClassName = value;
                    splitBrainProtectionBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)value);
                    continue;
                }
                if ("recently-active-split-brain-protection".equals(nodeName)) {
                    configBuilder = this.handleRecentlyActiveSplitBrainProtection(name, n, splitBrainProtectionSize);
                    continue;
                }
                if (!"probabilistic-split-brain-protection".equals(nodeName)) continue;
                configBuilder = this.handleProbabilisticSplitBrainProtection(name, n, splitBrainProtectionSize);
            }
            if (configBuilder != null) {
                boolean splitBrainProtectionFunctionDefinedByClassName;
                boolean bl = splitBrainProtectionFunctionDefinedByClassName = !StringUtil.isNullOrEmpty(splitBrainProtectionClassName);
                if (splitBrainProtectionFunctionDefinedByClassName) {
                    throw new InvalidConfigurationException("A split brain protection cannot simultaneously define probabilistic-split-brain-protection or recently-active-split-brain-protection and a split brain protection function class name.");
                }
                SplitBrainProtectionConfig constructedConfig = configBuilder.build();
                splitBrainProtectionBuilder.addPropertyValue("functionImplementation", (Object)constructedConfig.getFunctionImplementation());
            }
            this.splitBrainProtectionManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private SplitBrainProtectionConfigBuilder handleRecentlyActiveSplitBrainProtection(String name, Node node, int splitBrainProtectionSize) {
            int heartbeatToleranceMillis = DomConfigHelper.getIntegerValue((String)"heartbeat-tolerance-millis", (String)this.getAttribute(node, "heartbeat-tolerance-millis"), (int)RecentlyActiveSplitBrainProtectionConfigBuilder.DEFAULT_HEARTBEAT_TOLERANCE_MILLIS);
            RecentlyActiveSplitBrainProtectionConfigBuilder splitBrainProtectionConfigBuilder = SplitBrainProtectionConfig.newRecentlyActiveSplitBrainProtectionConfigBuilder((String)name, (int)splitBrainProtectionSize, (int)heartbeatToleranceMillis);
            return splitBrainProtectionConfigBuilder;
        }

        private SplitBrainProtectionConfigBuilder handleProbabilisticSplitBrainProtection(String name, Node node, int splitBrainProtectionSize) {
            long acceptableHeartPause = DomConfigHelper.getLongValue((String)"acceptable-heartbeat-pause-millis", (String)this.getAttribute(node, "acceptable-heartbeat-pause-millis"), (long)ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_HEARTBEAT_PAUSE_MILLIS);
            double threshold = DomConfigHelper.getDoubleValue((String)"suspicion-threshold", (String)this.getAttribute(node, "suspicion-threshold"), (double)ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_PHI_THRESHOLD);
            int maxSampleSize = DomConfigHelper.getIntegerValue((String)"max-sample-size", (String)this.getAttribute(node, "max-sample-size"), (int)ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_SAMPLE_SIZE);
            long minStdDeviation = DomConfigHelper.getLongValue((String)"min-std-deviation-millis", (String)this.getAttribute(node, "min-std-deviation-millis"), (long)ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_MIN_STD_DEVIATION);
            long heartbeatIntervalMillis = DomConfigHelper.getLongValue((String)"heartbeat-interval-millis", (String)this.getAttribute(node, "heartbeat-interval-millis"), (long)ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_HEARTBEAT_INTERVAL_MILLIS);
            ProbabilisticSplitBrainProtectionConfigBuilder splitBrainProtectionConfigBuilder = SplitBrainProtectionConfig.newProbabilisticSplitBrainProtectionConfigBuilder((String)name, (int)splitBrainProtectionSize).withAcceptableHeartbeatPauseMillis(acceptableHeartPause).withSuspicionThreshold(threshold).withHeartbeatIntervalMillis(heartbeatIntervalMillis).withMinStdDeviationMillis(minStdDeviation).withMaxSampleSize(maxSampleSize);
            return splitBrainProtectionConfigBuilder;
        }

        private void handleMergePolicyConfig(Node node, BeanDefinitionBuilder builder) {
            BeanDefinitionBuilder mergePolicyConfigBuilder = this.createBeanBuilder(MergePolicyConfig.class);
            AbstractBeanDefinition beanDefinition = mergePolicyConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, mergePolicyConfigBuilder, new String[0]);
            mergePolicyConfigBuilder.addPropertyValue("policy", (Object)this.getTextContent(node));
            builder.addPropertyValue("mergePolicyConfig", (Object)beanDefinition);
        }

        private void handleLiteMember(Node node) {
            Node attrEnabled = node.getAttributes().getNamedItem("enabled");
            this.configBuilder.addPropertyValue(this.xmlToJavaName(DomConfigHelper.cleanNodeName((Node)node)), (Object)this.getTextContent(attrEnabled));
        }

        public void handleReplicatedMap(Node node) {
            BeanDefinitionBuilder replicatedMapConfigBuilder = this.createBeanBuilder(ReplicatedMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, replicatedMapConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList<BeanDefinition> listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    replicatedMapConfigBuilder.addPropertyValue("listenerConfigs", listeners);
                    continue;
                }
                if ("split-brain-protection-ref".equals(nodeName)) {
                    replicatedMapConfigBuilder.addPropertyValue("splitBrainProtectionName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, replicatedMapConfigBuilder);
                    continue;
                }
                if (!"user-code-namespace".equals(nodeName)) continue;
                replicatedMapConfigBuilder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.replicatedMapManagedMap.put((Object)name, (Object)replicatedMapConfigBuilder.getBeanDefinition());
        }

        public void handleNetwork(Node node) {
            this.hasNetwork = true;
            BeanDefinitionBuilder networkConfigBuilder = this.createBeanBuilder(NetworkConfig.class);
            AbstractBeanDefinition beanDefinition = networkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, networkConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, networkConfigBuilder);
                    continue;
                }
                if ("interfaces".equals(nodeName)) {
                    this.handleInterfaces(child, networkConfigBuilder);
                    continue;
                }
                if ("symmetric-encryption".equals(nodeName)) {
                    this.handleSymmetricEncryption(child, networkConfigBuilder);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("outbound-ports".equals(nodeName)) {
                    this.handleOutboundPorts(child, networkConfigBuilder);
                    continue;
                }
                if ("reuse-address".equals(nodeName)) {
                    this.handleReuseAddress(child, networkConfigBuilder);
                    continue;
                }
                if ("member-address-provider".equals(nodeName)) {
                    this.handleMemberAddressProvider(child, networkConfigBuilder);
                    continue;
                }
                if ("failure-detector".equals(nodeName)) {
                    this.handleFailureDetector(child, networkConfigBuilder);
                    continue;
                }
                if ("rest-api".equals(nodeName)) {
                    this.handleRestApi(child, networkConfigBuilder);
                    continue;
                }
                if ("memcache-protocol".equals(nodeName)) {
                    this.handleMemcacheProtocol(child, networkConfigBuilder);
                    continue;
                }
                if (!"tpc-socket".equals(nodeName)) continue;
                this.handleTpcSocketConfig(child, networkConfigBuilder);
            }
            this.configBuilder.addPropertyValue("networkConfig", (Object)beanDefinition);
        }

        private void handleTpcSocketConfig(Node node, BeanDefinitionBuilder beanDefinitionBuilder) {
            BeanDefinitionBuilder tpcSocketConfigBuilder = this.createBeanBuilder(TpcSocketConfig.class);
            AbstractBeanDefinition beanDefinition = tpcSocketConfigBuilder.getBeanDefinition();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("port-range".equals(nodeName)) {
                    tpcSocketConfigBuilder.addPropertyValue("portRange", (Object)this.getTextContent(child));
                    continue;
                }
                if ("receive-buffer-size-kb".equals(nodeName)) {
                    tpcSocketConfigBuilder.addPropertyValue("receiveBufferSizeKB", (Object)DomConfigHelper.getIntegerValue((String)"receive-buffer-size-kb", (String)this.getTextContent(child)));
                    continue;
                }
                if (!"send-buffer-size-kb".equals(nodeName)) continue;
                tpcSocketConfigBuilder.addPropertyValue("sendBufferSizeKB", (Object)DomConfigHelper.getIntegerValue((String)"send-buffer-size-kb", (String)this.getTextContent(child)));
            }
            beanDefinitionBuilder.addPropertyValue("tpcSocketConfig", (Object)beanDefinition);
        }

        void handleAdvancedNetwork(Node node) {
            BeanDefinitionBuilder advNetworkConfigBuilder = this.createBeanBuilder(AdvancedNetworkConfig.class);
            AbstractBeanDefinition beanDefinition = advNetworkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, advNetworkConfigBuilder, new String[0]);
            String enabled = this.getAttribute(node, "enabled");
            if (DomConfigHelper.getBooleanValue((String)enabled)) {
                this.hasAdvancedNetworkEnabled = true;
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, advNetworkConfigBuilder);
                    continue;
                }
                if ("member-address-provider".equals(nodeName)) {
                    this.handleMemberAddressProvider(child, advNetworkConfigBuilder);
                    continue;
                }
                if ("failure-detector".equals(nodeName)) {
                    this.handleFailureDetector(child, advNetworkConfigBuilder);
                    continue;
                }
                if ("wan-endpoint-config".equals(nodeName)) {
                    this.handleWanEndpointConfig(child);
                    continue;
                }
                if ("member-server-socket-endpoint-config".equals(nodeName)) {
                    this.handleMemberServerSocketEndpointConfig(child);
                    continue;
                }
                if ("client-server-socket-endpoint-config".equals(nodeName)) {
                    this.handleClientServerSocketEndpointConfig(child);
                    continue;
                }
                if ("wan-server-socket-endpoint-config".equals(nodeName)) {
                    this.handleWanServerSocketEndpointConfig(child);
                    continue;
                }
                if ("rest-server-socket-endpoint-config".equals(nodeName)) {
                    this.handleRestServerSocketEndpointConfig(child);
                    continue;
                }
                if (!"memcache-server-socket-endpoint-config".equals(nodeName)) continue;
                this.handleMemcacheServerSocketEndpointConfig(child);
            }
            advNetworkConfigBuilder.addPropertyValue("endpointConfigs", this.endpointConfigsMap);
            this.configBuilder.addPropertyValue("advancedNetworkConfig", (Object)beanDefinition);
        }

        void handleWanEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(EndpointConfig.class);
            this.handleEndpointConfig(node, ProtocolType.WAN, endpointConfigBuilder);
        }

        void handleEndpointConfig(Node node, ProtocolType type, BeanDefinitionBuilder endpointConfigBuilder) {
            AbstractBeanDefinition beanDefinition = endpointConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, endpointConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                this.handleEndpointConfigCommons(child, endpointConfigBuilder);
            }
            this.endpointConfigsMap.put((Object)this.createEndpointQualifier(type, node), (Object)beanDefinition);
        }

        private void handleEndpointConfigCommons(Node node, BeanDefinitionBuilder endpointConfigBuilder) {
            String nodeName = DomConfigHelper.cleanNodeName((Node)node);
            if ("outbound-ports".equals(nodeName)) {
                this.handleOutboundPorts(node, endpointConfigBuilder);
            } else if ("interfaces".equals(nodeName)) {
                this.handleInterfaces(node, endpointConfigBuilder);
            } else if ("symmetric-encryption".equals(nodeName)) {
                this.handleSymmetricEncryption(node, endpointConfigBuilder);
            } else if ("ssl".equals(nodeName)) {
                this.handleSSLConfig(node, endpointConfigBuilder);
            } else if ("socket-interceptor".equals(nodeName)) {
                this.handleSocketInterceptorConfig(node, endpointConfigBuilder);
            } else if ("socket-options".equals(nodeName)) {
                this.handleEndpointSocketOptions(node, endpointConfigBuilder);
            } else if ("tpc-socket".equals(nodeName)) {
                this.handleTpcSocketConfig(node, endpointConfigBuilder);
            }
        }

        void handleMemberServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(ServerSocketEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.MEMBER, endpointConfigBuilder);
        }

        void handleClientServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(ServerSocketEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.CLIENT, endpointConfigBuilder);
        }

        void handleWanServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(ServerSocketEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.WAN, endpointConfigBuilder);
        }

        void handleRestServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(RestServerEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.REST, endpointConfigBuilder);
            ManagedSet groupSet = new ManagedSet();
            for (RestEndpointGroup group : RestEndpointGroup.values()) {
                if (!group.isEnabledByDefault()) continue;
                groupSet.add((Object)group);
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"endpoint-groups".equals(nodeName)) continue;
                this.handleRestEndpointGroup(node, endpointConfigBuilder, (ManagedSet<RestEndpointGroup>)groupSet);
            }
        }

        void handleMemcacheServerSocketEndpointConfig(Node node) {
            BeanDefinitionBuilder endpointConfigBuilder = this.createBeanBuilder(ServerSocketEndpointConfig.class);
            this.handleServerSocketEndpointConfig(node, ProtocolType.MEMCACHE, endpointConfigBuilder);
        }

        void handleServerSocketEndpointConfig(Node node, ProtocolType type, BeanDefinitionBuilder endpointBuilder) {
            AbstractBeanDefinition beanDefinition = endpointBuilder.getBeanDefinition();
            this.fillAttributeValues(node, endpointBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("reuse-address".equals(nodeName)) {
                    String value = this.getTextContent(child).trim();
                    endpointBuilder.addPropertyValue("reuseAddress", (Object)value);
                    continue;
                }
                this.handleEndpointConfigCommons(child, endpointBuilder);
            }
            this.endpointConfigsMap.put((Object)this.createEndpointQualifier(type, node), (Object)beanDefinition);
        }

        void handleEndpointSocketOptions(Node node, BeanDefinitionBuilder endpointConfigBuilder) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                String textContent = this.getTextContent(child);
                if ("buffer-direct".equals(nodeName)) {
                    endpointConfigBuilder.addPropertyValue("socketBufferDirect", (Object)DomConfigHelper.getBooleanValue((String)textContent));
                    continue;
                }
                if ("tcp-no-delay".equals(nodeName)) {
                    endpointConfigBuilder.addPropertyValue("socketTcpNoDelay", (Object)DomConfigHelper.getBooleanValue((String)textContent));
                    continue;
                }
                if ("keep-alive".equals(nodeName)) {
                    endpointConfigBuilder.addPropertyValue("socketKeepAlive", (Object)DomConfigHelper.getBooleanValue((String)textContent));
                    continue;
                }
                if ("connect-timeout-seconds".equals(nodeName)) {
                    this.addIntegerPropertyValue(endpointConfigBuilder, "socketConnectTimeoutSeconds", textContent);
                    continue;
                }
                if ("send-buffer-size-kb".equals(nodeName)) {
                    this.addIntegerPropertyValue(endpointConfigBuilder, "socketSendBufferSizeKb", textContent);
                    continue;
                }
                if ("receive-buffer-size-kb".equals(nodeName)) {
                    this.addIntegerPropertyValue(endpointConfigBuilder, "socketRcvBufferSizeKb", textContent);
                    continue;
                }
                if ("linger-seconds".equals(nodeName)) {
                    this.addIntegerPropertyValue(endpointConfigBuilder, "socketLingerSeconds", textContent);
                    continue;
                }
                if ("keep-idle-seconds".equals(nodeName)) {
                    this.addIntegerPropertyValue(endpointConfigBuilder, "socketKeepIdleSeconds", textContent);
                    continue;
                }
                if ("keep-interval-seconds".equals(nodeName)) {
                    this.addIntegerPropertyValue(endpointConfigBuilder, "socketKeepIntervalSeconds", textContent);
                    continue;
                }
                if (!"keep-count".equals(nodeName)) continue;
                this.addIntegerPropertyValue(endpointConfigBuilder, "socketKeepCount", textContent);
            }
        }

        private void addIntegerPropertyValue(BeanDefinitionBuilder bdb, String parameterName, String textContent) {
            bdb.addPropertyValue(parameterName, (Object)DomConfigHelper.getIntegerValue((String)parameterName, (String)textContent));
        }

        public void handleProperties(Node node) {
            this.handleProperties(node, this.configBuilder);
        }

        public void handleInterfaces(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(InterfacesConfig.class);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int a = 0; a < attributes.getLength(); ++a) {
                    Node att = attributes.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
            ManagedList interfacesSet = new ManagedList();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = this.xmlToJavaName(DomConfigHelper.cleanNodeName((Node)n));
                String value = this.getTextContent(n);
                if (!"interface".equals(name)) continue;
                interfacesSet.add((Object)value);
            }
            builder.addPropertyValue("interfaces", (Object)interfacesSet);
            networkConfigBuilder.addPropertyValue("interfaces", (Object)beanDefinition);
        }

        public void handleJoin(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder joinConfigBuilder = this.createBeanBuilder(JoinConfig.class);
            AbstractBeanDefinition beanDefinition = joinConfigBuilder.getBeanDefinition();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("multicast".equals(name)) {
                    this.handleMulticast(child, joinConfigBuilder);
                    continue;
                }
                if ("tcp-ip".equals(name)) {
                    this.handleTcpIp(child, joinConfigBuilder);
                    continue;
                }
                if (AliasedDiscoveryConfigUtils.supports((String)name)) {
                    this.handleAliasedDiscoveryStrategy(child, joinConfigBuilder, name);
                    continue;
                }
                if ("discovery-strategies".equals(name)) {
                    this.handleDiscoveryStrategies(child, joinConfigBuilder);
                    continue;
                }
                if (!"auto-detection".equals(name)) continue;
                this.handleAutoDetection(child, joinConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("join", (Object)beanDefinition);
        }

        private void handleOutboundPorts(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            ManagedList outboundPorts = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"ports".equals(name)) continue;
                String value = this.getTextContent(child);
                outboundPorts.add((Object)value);
            }
            networkConfigBuilder.addPropertyValue("outboundPortDefinitions", (Object)outboundPorts);
        }

        private void handleReuseAddress(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String value = node.getTextContent();
            networkConfigBuilder.addPropertyValue("reuseAddress", (Object)value);
        }

        private void handleMemberAddressProvider(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder memberAddressProviderConfigBuilder = this.createBeanBuilder(MemberAddressProviderConfig.class);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!"properties".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, memberAddressProviderConfigBuilder);
                break;
            }
            String implementationAttr = "implementation";
            String classNameAttr = "class-name";
            String implementationValue = this.getAttribute(node, implementationAttr);
            String classNameValue = this.getAttribute(node, classNameAttr);
            memberAddressProviderConfigBuilder.addPropertyValue("enabled", (Object)DomConfigHelper.getBooleanValue((String)this.getAttribute(node, "enabled")));
            if (!StringUtil.isNullOrEmpty((String)implementationValue)) {
                memberAddressProviderConfigBuilder.addPropertyReference(implementationAttr, implementationValue);
            } else {
                if (StringUtil.isNullOrEmpty((String)classNameValue)) {
                    throw new InvalidConfigurationException("One of the \"class-name\" or \"implementation\" configuration is needed for member address provider configuration");
                }
                memberAddressProviderConfigBuilder.addPropertyValue("className", (Object)classNameValue);
            }
            networkConfigBuilder.addPropertyValue("memberAddressProviderConfig", (Object)memberAddressProviderConfigBuilder.getBeanDefinition());
        }

        private void handleFailureDetector(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            if (!node.hasChildNodes()) {
                return;
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!DomConfigHelper.cleanNodeName((Node)child).equals("icmp")) {
                    throw new IllegalStateException("Unsupported child under Failure-Detector");
                }
                Node enabledNode = child.getAttributes().getNamedItem("enabled");
                BeanDefinitionBuilder icmpFailureDetectorConfigBuilder = this.createBeanBuilder(IcmpFailureDetectorConfig.class);
                icmpFailureDetectorConfigBuilder.addPropertyValue("enabled", (Object)this.getTextContent(enabledNode));
                for (Node n : DomConfigHelper.childElements((Node)child)) {
                    String nodeName = DomConfigHelper.cleanNodeName((Node)n);
                    String propertyName = ICMP_FAILURE_DETECTOR_CONFIG_PROPERTIES.get(nodeName);
                    if (propertyName == null) continue;
                    icmpFailureDetectorConfigBuilder.addPropertyValue(propertyName, (Object)this.getTextContent(n));
                }
                networkConfigBuilder.addPropertyValue("icmpFailureDetectorConfig", (Object)icmpFailureDetectorConfigBuilder.getBeanDefinition());
            }
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, implAttribute);
            Node implNode = node.getAttributes().getNamedItem(implAttribute);
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttribute), implementation);
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        public void handleSymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, SymmetricEncryptionConfig.class, "symmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleExecutor(Node node) {
            BeanDefinitionBuilder builder = this.createAndFillListedBean(node, ExecutorConfig.class, "name", this.executorManagedMap, new String[0]);
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                if (!"user-code-namespace".equals(DomConfigHelper.cleanNodeName((Node)n))) continue;
                builder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(n));
            }
        }

        public void handleDurableExecutor(Node node) {
            BeanDefinitionBuilder builder = this.createAndFillListedBean(node, DurableExecutorConfig.class, "name", this.durableExecutorManagedMap, new String[0]);
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                if (!"user-code-namespace".equals(DomConfigHelper.cleanNodeName((Node)n))) continue;
                builder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(n));
            }
        }

        public void handleScheduledExecutor(Node node) {
            BeanDefinitionBuilder builder = this.createAndFillListedBean(node, ScheduledExecutorConfig.class, "name", this.scheduledExecutorManagedMap, "mergePolicy");
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if ("merge-policy".equals(name)) {
                    this.handleMergePolicyConfig(n, builder);
                    continue;
                }
                if (!"user-code-namespace".equals(name)) continue;
                builder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(n));
            }
        }

        public void handleCardinalityEstimator(Node node) {
            BeanDefinitionBuilder builder = this.createAndFillListedBean(node, CardinalityEstimatorConfig.class, "name", this.cardinalityEstimatorManagedMap, "mergePolicy");
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"merge-policy".equals(name)) continue;
                this.handleMergePolicyConfig(n, builder);
            }
        }

        public void handlePNCounter(Node node) {
            this.createAndFillListedBean(node, PNCounterConfig.class, "name", this.pnCounterManagedMap, new String[0]);
        }

        public void handleMulticast(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.handleTrustedInterfacesBean(node, joinConfigBuilder, MulticastConfig.class, "multicastConfig");
        }

        private void handleTrustedInterfacesBean(Node node, BeanDefinitionBuilder configBuilder, Class<?> configClass, String propertyName) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, configClass, propertyName, configBuilder, "trusted-interfaces", "interface");
            ManagedList interfaces = new ManagedList();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"trusted-interfaces".equals(name)) continue;
                for (Node i : DomConfigHelper.childElements((Node)n)) {
                    name = DomConfigHelper.cleanNodeName((Node)i);
                    if (!"interface".equals(name)) continue;
                    String value = this.getTextContent(i);
                    interfaces.add((Object)value);
                }
            }
            builder.addPropertyValue("trustedInterfaces", (Object)interfaces);
        }

        public void handleTcpIp(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, TcpIpConfig.class, "tcpIpConfig", joinConfigBuilder, "interface", "member", "members");
            ManagedList members = new ManagedList();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"member".equals(name) && !"members".equals(name) && !"interface".equals(name)) continue;
                String value = this.getTextContent(n);
                members.add((Object)value);
            }
            builder.addPropertyValue("members", (Object)members);
        }

        public void handleReliableTopic(Node node) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(ReliableTopicConfig.class);
            this.fillAttributeValues(node, builder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                if ("message-listeners".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    ManagedList<BeanDefinition> listeners = this.parseListeners(childNode, ListenerConfig.class);
                    builder.addPropertyValue("messageListenerConfigs", listeners);
                    continue;
                }
                if (!"user-code-namespace".equals(DomConfigHelper.cleanNodeName((Node)childNode))) continue;
                builder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.reliableTopicManagedMap.put((Object)this.getAttribute(node, "name"), (Object)builder.getBeanDefinition());
        }

        public void handleRingbuffer(Node node) {
            BeanDefinitionBuilder ringbufferConfigBuilder = this.createBeanBuilder(RingbufferConfig.class);
            this.fillAttributeValues(node, ringbufferConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("ringbuffer-store".equals(nodeName)) {
                    this.handleRingbufferStoreConfig(childNode, ringbufferConfigBuilder);
                    continue;
                }
                if ("split-brain-protection-ref".equals(nodeName)) {
                    ringbufferConfigBuilder.addPropertyValue("splitBrainProtectionName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, ringbufferConfigBuilder);
                    continue;
                }
                if (!"user-code-namespace".equals(nodeName)) continue;
                ringbufferConfigBuilder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.ringbufferManagedMap.put((Object)this.getAttribute(node, "name"), (Object)ringbufferConfigBuilder.getBeanDefinition());
        }

        public void handleRingbufferStoreConfig(Node node, BeanDefinitionBuilder ringbufferConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(RingbufferStoreConfig.class);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!"properties".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, builder);
                break;
            }
            this.extractBasicStoreConfig(node, builder);
            ringbufferConfigBuilder.addPropertyValue("ringbufferStoreConfig", (Object)builder.getBeanDefinition());
        }

        public void handleQueue(Node node) {
            BeanDefinitionBuilder queueConfigBuilder = this.createBeanBuilder(QueueConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, queueConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList<BeanDefinition> listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    queueConfigBuilder.addPropertyValue("itemListenerConfigs", listeners);
                    continue;
                }
                if ("queue-store".equals(nodeName)) {
                    this.handleQueueStoreConfig(childNode, queueConfigBuilder);
                    continue;
                }
                if ("split-brain-protection-ref".equals(nodeName)) {
                    queueConfigBuilder.addPropertyValue("splitBrainProtectionName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, queueConfigBuilder);
                    continue;
                }
                if (!"user-code-namespace".equals(nodeName)) continue;
                queueConfigBuilder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.queueManagedMap.put((Object)name, (Object)queueConfigBuilder.getBeanDefinition());
        }

        public void handleQueueStoreConfig(Node node, BeanDefinitionBuilder queueConfigBuilder) {
            BeanDefinitionBuilder queueStoreConfigBuilder = this.createBeanBuilder(QueueStoreConfig.class);
            AbstractBeanDefinition beanDefinition = queueStoreConfigBuilder.getBeanDefinition();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!"properties".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, queueStoreConfigBuilder);
                break;
            }
            String storeImplAttrName = "store-implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillAttributeValues(node, queueStoreConfigBuilder, storeImplAttrName, factoryImplAttrName);
            NamedNodeMap attributes = node.getAttributes();
            Node implRef = attributes.getNamedItem(storeImplAttrName);
            Node factoryImplRef = attributes.getNamedItem(factoryImplAttrName);
            if (factoryImplRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(factoryImplAttrName), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(storeImplAttrName), this.getTextContent(implRef));
            }
            queueConfigBuilder.addPropertyValue("queueStoreConfig", (Object)beanDefinition);
        }

        private void extractBasicStoreConfig(Node node, BeanDefinitionBuilder builder) {
            String storeImplAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillAttributeValues(node, builder, storeImplAttrName, factoryImplAttrName);
            String implRef = this.getAttribute(node, storeImplAttrName);
            String factoryImplRef = this.getAttribute(node, factoryImplAttrName);
            if (factoryImplRef != null) {
                builder.addPropertyReference(this.xmlToJavaName(factoryImplAttrName), factoryImplRef);
            }
            if (implRef != null) {
                builder.addPropertyReference(this.xmlToJavaName("store-implementation"), implRef);
            }
        }

        public void handleList(Node node) {
            BeanDefinitionBuilder listConfigBuilder = this.createBeanBuilder(ListConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, listConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList<BeanDefinition> listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    listConfigBuilder.addPropertyValue("itemListenerConfigs", listeners);
                    continue;
                }
                if ("split-brain-protection-ref".equals(nodeName)) {
                    listConfigBuilder.addPropertyValue("splitBrainProtectionName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, listConfigBuilder);
                    continue;
                }
                if (!"user-code-namespace".equals(nodeName)) continue;
                listConfigBuilder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.listManagedMap.put((Object)name, (Object)listConfigBuilder.getBeanDefinition());
        }

        public void handleSet(Node node) {
            BeanDefinitionBuilder setConfigBuilder = this.createBeanBuilder(SetConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, setConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList<BeanDefinition> listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    setConfigBuilder.addPropertyValue("itemListenerConfigs", listeners);
                    continue;
                }
                if ("split-brain-protection-ref".equals(nodeName)) {
                    setConfigBuilder.addPropertyValue("splitBrainProtectionName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, setConfigBuilder);
                    continue;
                }
                if (!"user-code-namespace".equals(nodeName)) continue;
                setConfigBuilder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.setManagedMap.put((Object)name, (Object)setConfigBuilder.getBeanDefinition());
        }

        public void handleMap(Node node) {
            BeanDefinitionBuilder mapConfigBuilder = this.createBeanBuilder(MapConfig.class);
            AbstractBeanDefinition beanDefinition = mapConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            mapConfigBuilder.addPropertyValue("name", (Object)name);
            this.fillAttributeValues(node, mapConfigBuilder, new String[0]);
            Node cacheDeserializedValueNode = node.getAttributes().getNamedItem("cache-deserialized-values");
            if (cacheDeserializedValueNode != null) {
                mapConfigBuilder.addPropertyValue("cacheDeserializedValues", (Object)this.getTextContent(cacheDeserializedValueNode));
            }
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                ManagedList<BeanDefinition> listeners;
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("map-store".equals(nodeName)) {
                    this.handleMapStoreConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("near-cache".equals(nodeName)) {
                    this.handleNearCacheConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("wan-replication-ref".equals(nodeName)) {
                    this.handleWanReplicationRef(mapConfigBuilder, childNode);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : DomConfigHelper.childElements((Node)childNode)) {
                        this.handleIndex((ManagedList<BeanDefinition>)indexes, indexNode);
                    }
                    mapConfigBuilder.addPropertyValue("indexConfigs", (Object)indexes);
                    continue;
                }
                if ("attributes".equals(nodeName)) {
                    ManagedList attributes = new ManagedList();
                    for (Node attributeNode : DomConfigHelper.childElements((Node)childNode)) {
                        BeanDefinitionBuilder attributeConfBuilder = this.createBeanBuilder(AttributeConfig.class);
                        this.fillAttributeValues(attributeNode, attributeConfBuilder, new String[0]);
                        attributes.add((Object)attributeConfBuilder.getBeanDefinition());
                    }
                    mapConfigBuilder.addPropertyValue("attributeConfigs", (Object)attributes);
                    continue;
                }
                if ("entry-listeners".equals(nodeName)) {
                    listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    mapConfigBuilder.addPropertyValue("entryListenerConfigs", listeners);
                    continue;
                }
                if ("split-brain-protection-ref".equals(nodeName)) {
                    mapConfigBuilder.addPropertyValue("splitBrainProtectionName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("query-caches".equals(nodeName)) {
                    ManagedList<BeanDefinition> queryCaches = this.getQueryCaches(childNode);
                    mapConfigBuilder.addPropertyValue("queryCacheConfigs", queryCaches);
                    continue;
                }
                if ("partition-lost-listeners".endsWith(nodeName)) {
                    listeners = this.parseListeners(childNode, MapPartitionLostListenerConfig.class);
                    mapConfigBuilder.addPropertyValue("partitionLostListenerConfigs", listeners);
                    continue;
                }
                if ("merkle-tree".equals(nodeName)) {
                    this.handleMerkleTreeConfig(mapConfigBuilder, childNode);
                    continue;
                }
                if ("hot-restart".equals(nodeName)) {
                    this.handleHotRestartConfig(mapConfigBuilder, childNode);
                    continue;
                }
                if ("data-persistence".equals(nodeName)) {
                    this.handleDataPersistenceConfig(mapConfigBuilder, childNode);
                    continue;
                }
                if ("event-journal".equals(nodeName)) {
                    this.handleEventJournalConfig(mapConfigBuilder, childNode);
                    continue;
                }
                if ("eviction".equals(nodeName)) {
                    this.handleEvictionConfig(childNode, mapConfigBuilder, false, true);
                    continue;
                }
                if ("partition-strategy".equals(nodeName)) {
                    PartitioningStrategyConfig psConfig = new PartitioningStrategyConfig(this.getTextContent(childNode));
                    mapConfigBuilder.addPropertyValue("partitioningStrategyConfig", (Object)psConfig);
                    continue;
                }
                if ("tiered-store".equals(nodeName)) {
                    this.handleTieredStoreConfig(mapConfigBuilder, childNode);
                    continue;
                }
                if ("partition-attributes".equals(nodeName)) {
                    this.handlePartitionAttributes(mapConfigBuilder, childNode);
                    continue;
                }
                if (!"user-code-namespace".equals(nodeName)) continue;
                mapConfigBuilder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.mapConfigManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private void handleMerkleTreeConfig(BeanDefinitionBuilder configBuilder, Node node) {
            BeanDefinitionBuilder merkleTreeBuilder = this.createBeanBuilder(MerkleTreeConfig.class);
            this.fillAttributeValues(node, merkleTreeBuilder, new String[0]);
            configBuilder.addPropertyValue("merkleTreeConfig", (Object)merkleTreeBuilder.getBeanDefinition());
        }

        @Deprecated
        private void handleHotRestartConfig(BeanDefinitionBuilder configBuilder, Node node) {
            BeanDefinitionBuilder hotRestartConfigBuilder = this.createBeanBuilder(HotRestartConfig.class);
            this.fillAttributeValues(node, hotRestartConfigBuilder, new String[0]);
            configBuilder.addPropertyValue("hotRestartConfig", (Object)hotRestartConfigBuilder.getBeanDefinition());
        }

        private void handleDataPersistenceConfig(BeanDefinitionBuilder configBuilder, Node node) {
            BeanDefinitionBuilder dataPersistenceConfigBuilder = this.createBeanBuilder(DataPersistenceConfig.class);
            this.fillAttributeValues(node, dataPersistenceConfigBuilder, new String[0]);
            configBuilder.addPropertyValue("dataPersistenceConfig", (Object)dataPersistenceConfigBuilder.getBeanDefinition());
        }

        private void handleTieredStoreConfig(BeanDefinitionBuilder configBuilder, Node node) {
            BeanDefinitionBuilder tieredStoreConfigBuilder = this.createBeanBuilder(TieredStoreConfig.class);
            this.fillAttributeValues(node, tieredStoreConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("memory-tier".equals(name)) {
                    this.handleMemoryTierConfig(tieredStoreConfigBuilder, child);
                    continue;
                }
                if (!"disk-tier".equals(name)) continue;
                this.handleDiskTierConfig(tieredStoreConfigBuilder, child);
            }
            configBuilder.addPropertyValue("tieredStoreConfig", (Object)tieredStoreConfigBuilder.getBeanDefinition());
        }

        private void handleMemoryTierConfig(BeanDefinitionBuilder configBuilder, Node node) {
            BeanDefinitionBuilder memoryTierConfigBuilder = this.createBeanBuilder(MemoryTierConfig.class);
            this.fillAttributeValues(node, memoryTierConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"capacity".equals(name)) continue;
                this.handleCapacity(child, memoryTierConfigBuilder);
            }
            configBuilder.addPropertyValue("memoryTierConfig", (Object)memoryTierConfigBuilder.getBeanDefinition());
        }

        private void handleCapacity(Node node, BeanDefinitionBuilder nativeMemoryConfigBuilder) {
            BeanDefinitionBuilder capacityConfigBuilder = this.createBeanBuilder(Capacity.class);
            NamedNodeMap attributes = node.getAttributes();
            Node value = attributes.getNamedItem("value");
            Node unit = attributes.getNamedItem("unit");
            capacityConfigBuilder.addConstructorArgValue((Object)this.getTextContent(value));
            capacityConfigBuilder.addConstructorArgValue((Object)this.getTextContent(unit));
            nativeMemoryConfigBuilder.addPropertyValue("capacity", (Object)capacityConfigBuilder.getBeanDefinition());
        }

        private void handleDiskTierConfig(BeanDefinitionBuilder configBuilder, Node node) {
            BeanDefinitionBuilder diskTierConfig = this.createBeanBuilder(DiskTierConfig.class);
            this.fillAttributeValues(node, diskTierConfig, new String[0]);
            configBuilder.addPropertyValue("diskTierConfig", (Object)diskTierConfig.getBeanDefinition());
        }

        private void handleEventJournalConfig(BeanDefinitionBuilder configBuilder, Node node) {
            BeanDefinitionBuilder eventJournalBuilder = this.createBeanBuilder(EventJournalConfig.class);
            this.fillAttributeValues(node, eventJournalBuilder, new String[0]);
            configBuilder.addPropertyValue("eventJournalConfig", (Object)eventJournalBuilder.getBeanDefinition());
        }

        private ManagedList<BeanDefinition> getQueryCaches(Node childNode) {
            ManagedList queryCaches = new ManagedList();
            for (Node queryCacheNode : DomConfigHelper.childElements((Node)childNode)) {
                BeanDefinitionBuilder beanDefinitionBuilder = this.parseQueryCaches(queryCacheNode);
                queryCaches.add((Object)beanDefinitionBuilder.getBeanDefinition());
            }
            return queryCaches;
        }

        private BeanDefinitionBuilder parseQueryCaches(Node queryCacheNode) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(QueryCacheConfig.class);
            for (Node node : DomConfigHelper.childElements((Node)queryCacheNode)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                String textContent = this.getTextContent(node);
                NamedNodeMap attributes = queryCacheNode.getAttributes();
                String cacheName = this.getTextContent(attributes.getNamedItem("name"));
                builder.addPropertyValue("name", (Object)cacheName);
                if ("predicate".equals(nodeName)) {
                    BeanDefinitionBuilder predicateBuilder = this.createBeanBuilder(PredicateConfig.class);
                    String predicateType = this.getTextContent(node.getAttributes().getNamedItem("type"));
                    if ("sql".equals(predicateType)) {
                        predicateBuilder.addPropertyValue("sql", (Object)textContent);
                    } else if ("class-name".equals(predicateType)) {
                        predicateBuilder.addPropertyValue("className", (Object)textContent);
                    }
                    builder.addPropertyValue("predicateConfig", (Object)predicateBuilder.getBeanDefinition());
                    continue;
                }
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList listeners = new ManagedList();
                    String implementationAttr = "implementation";
                    for (Node listenerNode : DomConfigHelper.childElements((Node)node)) {
                        BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(EntryListenerConfig.class);
                        this.fillAttributeValues(listenerNode, listenerConfBuilder, implementationAttr);
                        Node implementationNode = listenerNode.getAttributes().getNamedItem(implementationAttr);
                        if (implementationNode != null) {
                            listenerConfBuilder.addPropertyReference(implementationAttr, this.getTextContent(implementationNode));
                        }
                        listeners.add((Object)listenerConfBuilder.getBeanDefinition());
                    }
                    builder.addPropertyValue("entryListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("include-value".equals(nodeName)) {
                    builder.addPropertyValue("includeValue", (Object)textContent);
                    continue;
                }
                if ("batch-size".equals(nodeName)) {
                    builder.addPropertyValue("batchSize", (Object)textContent);
                    continue;
                }
                if ("buffer-size".equals(nodeName)) {
                    builder.addPropertyValue("bufferSize", (Object)textContent);
                    continue;
                }
                if ("delay-seconds".equals(nodeName)) {
                    builder.addPropertyValue("delaySeconds", (Object)textContent);
                    continue;
                }
                if ("in-memory-format".equals(nodeName)) {
                    String value = textContent.trim();
                    builder.addPropertyValue("inMemoryFormat", (Object)InMemoryFormat.valueOf((String)StringUtil.upperCaseInternal((String)value)));
                    continue;
                }
                if ("coalesce".equals(nodeName)) {
                    builder.addPropertyValue("coalesce", (Object)textContent);
                    continue;
                }
                if ("populate".equals(nodeName)) {
                    builder.addPropertyValue("populate", (Object)textContent);
                    continue;
                }
                if ("serialize-keys".equals(nodeName)) {
                    builder.addPropertyValue("serializeKeys", (Object)textContent);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : DomConfigHelper.childElements((Node)node)) {
                        this.handleIndex((ManagedList<BeanDefinition>)indexes, indexNode);
                    }
                    builder.addPropertyValue("indexConfigs", (Object)indexes);
                    continue;
                }
                if (!"eviction".equals(nodeName)) continue;
                builder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node, false, false));
            }
            return builder;
        }

        public void handleCache(Node node) {
            BeanDefinitionBuilder cacheConfigBuilder = this.createBeanBuilder(CacheSimpleConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, cacheConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                ManagedList<BeanDefinition> listeners;
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("eviction".equals(nodeName)) {
                    cacheConfigBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(childNode, false, false));
                    continue;
                }
                if ("expiry-policy-factory".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    cacheConfigBuilder.addPropertyValue("expiryPolicyFactoryConfig", (Object)this.getExpiryPolicyFactoryConfig(childNode));
                    continue;
                }
                if ("cache-entry-listeners".equals(nodeName)) {
                    listeners = new ManagedList<BeanDefinition>();
                    for (Node listenerNode : DomConfigHelper.childElements((Node)childNode)) {
                        BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(CacheSimpleEntryListenerConfig.class);
                        this.fillAttributeValues(listenerNode, listenerConfBuilder, new String[0]);
                        listeners.add((Object)listenerConfBuilder.getBeanDefinition());
                    }
                    cacheConfigBuilder.addPropertyValue("cacheEntryListeners", listeners);
                    continue;
                }
                if ("wan-replication-ref".equals(nodeName)) {
                    this.handleWanReplicationRef(cacheConfigBuilder, childNode);
                    continue;
                }
                if ("partition-lost-listeners".equals(nodeName)) {
                    listeners = this.parseListeners(childNode, CachePartitionLostListenerConfig.class);
                    cacheConfigBuilder.addPropertyValue("partitionLostListenerConfigs", listeners);
                    continue;
                }
                if ("split-brain-protection-ref".equals(nodeName)) {
                    cacheConfigBuilder.addPropertyValue("splitBrainProtectionName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, cacheConfigBuilder);
                    continue;
                }
                if ("hot-restart".equals(nodeName)) {
                    this.handleHotRestartConfig(cacheConfigBuilder, childNode);
                    continue;
                }
                if ("data-persistence".equals(nodeName)) {
                    this.handleDataPersistenceConfig(cacheConfigBuilder, childNode);
                    continue;
                }
                if ("event-journal".equals(nodeName)) {
                    this.handleEventJournalConfig(cacheConfigBuilder, childNode);
                    continue;
                }
                if ("merkle-tree".equals(nodeName)) {
                    this.handleMerkleTreeConfig(cacheConfigBuilder, childNode);
                    continue;
                }
                if (!"user-code-namespace".equals(nodeName)) continue;
                cacheConfigBuilder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.cacheConfigManagedMap.put((Object)name, (Object)cacheConfigBuilder.getBeanDefinition());
        }

        public void handleWanReplication(Node node) {
            BeanDefinitionBuilder replicationConfigBuilder = this.createBeanBuilder(WanReplicationConfig.class);
            String name = this.getAttribute(node, "name");
            replicationConfigBuilder.addPropertyValue("name", (Object)name);
            ManagedList batchPublishers = new ManagedList();
            ManagedList customPublishers = new ManagedList();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String nName = DomConfigHelper.cleanNodeName((Node)n);
                if ("batch-publisher".equals(nName)) {
                    batchPublishers.add((Object)this.handleBatchPublisher(n));
                }
                if ("custom-publisher".equals(nName)) {
                    customPublishers.add((Object)this.handleCustomPublisher(n));
                    continue;
                }
                if (!"consumer".equals(nName)) continue;
                replicationConfigBuilder.addPropertyValue("consumerConfig", (Object)this.handleWanConsumer(n));
            }
            replicationConfigBuilder.addPropertyValue("batchPublisherConfigs", (Object)batchPublishers);
            replicationConfigBuilder.addPropertyValue("customPublisherConfigs", (Object)customPublishers);
            this.wanReplicationManagedMap.put((Object)name, (Object)replicationConfigBuilder.getBeanDefinition());
        }

        private AbstractBeanDefinition handleBatchPublisher(Node n) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(WanBatchPublisherConfig.class);
            AbstractBeanDefinition definition = builder.getBeanDefinition();
            ArrayList<String> excluded = new ArrayList<String>(AliasedDiscoveryConfigUtils.getTags());
            excluded.add("properties");
            excluded.add("discoveryStrategies");
            excluded.add("sync");
            this.fillValues(n, builder, excluded.toArray(new String[0]));
            for (Node child : DomConfigHelper.childElements((Node)n)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("properties".equals(nodeName)) {
                    this.handleProperties(child, builder);
                    continue;
                }
                if (AliasedDiscoveryConfigUtils.supports((String)nodeName)) {
                    this.handleAliasedDiscoveryStrategy(child, builder, nodeName);
                    continue;
                }
                if ("discovery-strategies".equals(nodeName)) {
                    this.handleDiscoveryStrategies(child, builder);
                    continue;
                }
                if (!"sync".equals(nodeName)) continue;
                this.createAndFillBeanBuilder(child, WanSyncConfig.class, "syncConfig", builder, new String[0]);
            }
            return definition;
        }

        private AbstractBeanDefinition handleCustomPublisher(Node n) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(WanCustomPublisherConfig.class);
            AbstractBeanDefinition definition = builder.getBeanDefinition();
            this.fillValues(n, builder, "properties");
            String className = this.getAttribute(n, "class-name");
            String implementation = this.getAttribute(n, "implementation");
            builder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                builder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create CustomWanPublisherConfig!");
            for (Node child : DomConfigHelper.childElements((Node)n)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, builder);
            }
            return definition;
        }

        private AbstractBeanDefinition handleWanConsumer(Node n) {
            BeanDefinitionBuilder consumerConfigBuilder = this.createBeanBuilder(WanConsumerConfig.class);
            String className = this.getAttribute(n, "class-name");
            String implementation = this.getAttribute(n, "implementation");
            boolean persistWanReplicatedData = DomConfigHelper.getBooleanValue((String)this.getAttribute(n, "persist-wan-replicated-data"));
            if (!StringUtil.isNullOrEmptyAfterTrim((String)className)) {
                consumerConfigBuilder.addPropertyValue("className", (Object)className);
            }
            if (implementation != null) {
                consumerConfigBuilder.addPropertyReference("implementation", implementation);
            }
            consumerConfigBuilder.addPropertyValue("persistWanReplicatedData", (Object)persistWanReplicatedData);
            for (Node child : DomConfigHelper.childElements((Node)n)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, consumerConfigBuilder);
            }
            return consumerConfigBuilder.getBeanDefinition();
        }

        private void handlePartitionGroup(Node node) {
            BeanDefinitionBuilder partitionConfigBuilder = this.createBeanBuilder(PartitionGroupConfig.class);
            this.fillAttributeValues(node, partitionConfigBuilder, new String[0]);
            ManagedList memberGroups = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"member-group".equals(name)) continue;
                BeanDefinitionBuilder memberGroupBuilder = this.createBeanBuilder(MemberGroupConfig.class);
                ManagedList interfaces = new ManagedList();
                for (Node n : DomConfigHelper.childElements((Node)child)) {
                    if (!"interface".equals(DomConfigHelper.cleanNodeName((Node)n))) continue;
                    interfaces.add((Object)this.getTextContent(n));
                }
                memberGroupBuilder.addPropertyValue("interfaces", (Object)interfaces);
                memberGroups.add((Object)memberGroupBuilder.getBeanDefinition());
            }
            partitionConfigBuilder.addPropertyValue("memberGroupConfigs", (Object)memberGroups);
            this.configBuilder.addPropertyValue("partitionGroupConfig", (Object)partitionConfigBuilder.getBeanDefinition());
        }

        private void handleManagementCenter(Node node) {
            this.handleTrustedInterfacesBean(node, this.configBuilder, ManagementCenterConfig.class, "managementCenterConfig");
        }

        public void handleNearCacheConfig(Node node, BeanDefinitionBuilder configBuilder) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class);
            this.fillAttributeValues(node, nearCacheConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if (!"eviction".equals(nodeName)) continue;
                this.handleEvictionConfig(childNode, nearCacheConfigBuilder, true, false);
            }
            configBuilder.addPropertyValue("nearCacheConfig", (Object)nearCacheConfigBuilder.getBeanDefinition());
        }

        private void handleEvictionConfig(Node node, BeanDefinitionBuilder configBuilder, boolean isNearCache, boolean isIMap) {
            configBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node, isNearCache, isIMap));
        }

        private CacheSimpleConfig.ExpiryPolicyFactoryConfig getExpiryPolicyFactoryConfig(Node node) {
            String className = this.getAttribute(node, "class-name");
            if (!StringUtil.isNullOrEmpty((String)className)) {
                return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(className);
            }
            CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = null;
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)n);
                if (!"timed-expiry-policy-factory".equals(nodeName)) continue;
                String expiryPolicyTypeStr = this.getAttribute(n, "expiry-policy-type");
                String durationAmountStr = this.getAttribute(n, "duration-amount");
                String timeUnitStr = this.getAttribute(n, "time-unit");
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType = CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.valueOf((String)StringUtil.upperCaseInternal((String)expiryPolicyTypeStr));
                if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL && (StringUtil.isNullOrEmpty((String)durationAmountStr) || StringUtil.isNullOrEmpty((String)timeUnitStr))) {
                    throw new InvalidConfigurationException("Both of the \"duration-amount\" or \"time-unit\" attributes are required for expiry policy factory configuration (except \"ETERNAL\" expiry policy type)");
                }
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = null;
                if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL) {
                    long durationAmount = Long.parseLong(durationAmountStr);
                    TimeUnit timeUnit = TimeUnit.valueOf(StringUtil.upperCaseInternal((String)timeUnitStr));
                    durationConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig(durationAmount, timeUnit);
                }
                timedExpiryPolicyFactoryConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig(expiryPolicyType, durationConfig);
            }
            if (timedExpiryPolicyFactoryConfig == null) {
                throw new InvalidConfigurationException("One of the \"class-name\" or \"timed-expire-policy-factory\" configuration is needed for expiry policy factory configuration");
            }
            return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(timedExpiryPolicyFactoryConfig);
        }

        public void handleMapStoreConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder mapStoreConfigBuilder = this.createBeanBuilder(MapStoreConfig.class);
            AbstractBeanDefinition beanDefinition = mapStoreConfigBuilder.getBeanDefinition();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if (!"properties".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                this.handleProperties(child, mapStoreConfigBuilder);
                break;
            }
            String implAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            String initialModeAttrName = "initial-mode";
            this.fillAttributeValues(node, mapStoreConfigBuilder, implAttrName, factoryImplAttrName, "initialMode");
            NamedNodeMap attributes = node.getAttributes();
            Node implRef = attributes.getNamedItem(implAttrName);
            Node factoryImplRef = attributes.getNamedItem(factoryImplAttrName);
            Node initialMode = attributes.getNamedItem(initialModeAttrName);
            if (factoryImplRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(factoryImplAttrName), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttrName), this.getTextContent(implRef));
            }
            if (initialMode != null) {
                MapStoreConfig.InitialLoadMode mode = MapStoreConfig.InitialLoadMode.valueOf((String)StringUtil.upperCaseInternal((String)this.getTextContent(initialMode)));
                mapStoreConfigBuilder.addPropertyValue("initialLoadMode", (Object)mode);
            }
            mapConfigBuilder.addPropertyValue("mapStoreConfig", (Object)beanDefinition);
        }

        public void handleMultiMap(Node node) {
            BeanDefinitionBuilder multiMapConfigBuilder = this.createBeanBuilder(MultiMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, multiMapConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList<BeanDefinition> listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    multiMapConfigBuilder.addPropertyValue("entryListenerConfigs", listeners);
                    continue;
                }
                if ("split-brain-protection-ref".equals(nodeName)) {
                    multiMapConfigBuilder.addPropertyValue("splitBrainProtectionName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, multiMapConfigBuilder);
                    continue;
                }
                if (!"user-code-namespace".equals(nodeName)) continue;
                multiMapConfigBuilder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.multiMapManagedMap.put((Object)name, (Object)multiMapConfigBuilder.getBeanDefinition());
        }

        public void handleTopic(Node node) {
            BeanDefinitionBuilder topicConfigBuilder = this.createBeanBuilder(TopicConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, topicConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                if ("message-listeners".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    ManagedList<BeanDefinition> listeners = this.parseListeners(childNode, ListenerConfig.class);
                    topicConfigBuilder.addPropertyValue("messageListenerConfigs", listeners);
                    continue;
                }
                if ("statistics-enabled".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    String statisticsEnabled = this.getTextContent(childNode);
                    topicConfigBuilder.addPropertyValue("statisticsEnabled", (Object)statisticsEnabled);
                    continue;
                }
                if ("global-ordering-enabled".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    String globalOrderingEnabled = this.getTextContent(childNode);
                    topicConfigBuilder.addPropertyValue("globalOrderingEnabled", (Object)globalOrderingEnabled);
                    continue;
                }
                if ("multi-threading-enabled".equals(DomConfigHelper.cleanNodeName((Node)childNode))) {
                    String multiThreadingEnabled = this.getTextContent(childNode);
                    topicConfigBuilder.addPropertyValue("multiThreadingEnabled", (Object)multiThreadingEnabled);
                    continue;
                }
                if (!"user-code-namespace".equals(DomConfigHelper.cleanNodeName((Node)childNode))) continue;
                topicConfigBuilder.addPropertyValue("userCodeNamespace", (Object)this.getTextContent(childNode));
            }
            this.topicManagedMap.put((Object)name, (Object)topicConfigBuilder.getBeanDefinition());
        }

        private void handleSecurity(Node node) {
            BeanDefinitionBuilder securityConfigBuilder = this.createBeanBuilder(SecurityConfig.class);
            AbstractBeanDefinition beanDefinition = securityConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, securityConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("realms".equals(nodeName)) {
                    this.handleRealms(child, securityConfigBuilder);
                    continue;
                }
                if ("member-authentication".equals(nodeName)) {
                    securityConfigBuilder.addPropertyValue("memberRealm", (Object)this.getAttribute(child, "realm"));
                    continue;
                }
                if ("client-authentication".equals(nodeName)) {
                    securityConfigBuilder.addPropertyValue("clientRealm", (Object)this.getAttribute(child, "realm"));
                    continue;
                }
                if ("client-permission-policy".equals(nodeName)) {
                    this.handlePermissionPolicy(child, securityConfigBuilder);
                    continue;
                }
                if ("client-permissions".equals(nodeName)) {
                    this.handleSecurityPermissions(child, securityConfigBuilder);
                    continue;
                }
                if ("security-interceptors".equals(nodeName)) {
                    this.handleSecurityInterceptors(child, securityConfigBuilder);
                    continue;
                }
                if (!"client-block-unmapped-actions".equals(nodeName)) continue;
                securityConfigBuilder.addPropertyValue("clientBlockUnmappedActions", (Object)DomConfigHelper.getBooleanValue((String)this.getTextContent(child)));
            }
            this.configBuilder.addPropertyValue("securityConfig", (Object)beanDefinition);
        }

        private void handleRealms(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedMap realms = new ManagedMap();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"realm".equals(nodeName)) continue;
                realms.put((Object)this.getAttribute(child, "name"), (Object)this.handleRealm(child));
            }
            securityConfigBuilder.addPropertyValue("realmConfigs", (Object)realms);
        }

        private AbstractBeanDefinition handleRealm(Node node) {
            BeanDefinitionBuilder realmConfigBuilder = this.createBeanBuilder(RealmConfig.class);
            AbstractBeanDefinition beanDefinition = realmConfigBuilder.getBeanDefinition();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("identity".equals(nodeName)) {
                    this.handleIdentity(child, realmConfigBuilder);
                    continue;
                }
                if ("authentication".equals(nodeName)) {
                    this.handleAuthentication(child, realmConfigBuilder);
                    continue;
                }
                if (!"access-control-service".equals(nodeName)) continue;
                this.handleAccessControlService(child, realmConfigBuilder);
            }
            return beanDefinition;
        }

        private void handleAccessControlService(Node node, BeanDefinitionBuilder realmConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(AccessControlServiceConfig.class);
            this.fillValues(node, builder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, builder);
            }
            realmConfigBuilder.addPropertyValue("accessControlServiceConfig", (Object)builder.getBeanDefinition());
        }

        private void handleAuthentication(Node node, BeanDefinitionBuilder realmConfigBuilder) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("jaas".equals(nodeName)) {
                    this.handleLoginModules(child, realmConfigBuilder);
                    continue;
                }
                if ("tls".equals(nodeName)) {
                    this.createAndFillBeanBuilder(child, TlsAuthenticationConfig.class, "TlsAuthenticationConfig", realmConfigBuilder, new String[0]);
                    continue;
                }
                if ("ldap".equals(nodeName)) {
                    this.handleLdapAuthenticationConfig(realmConfigBuilder, child);
                    continue;
                }
                if ("kerberos".equals(nodeName)) {
                    this.handleKerberosAuthenticationConfig(realmConfigBuilder, child);
                    continue;
                }
                if (!"simple".equals(nodeName)) continue;
                this.handleSimpleAuthenticationConfig(realmConfigBuilder, child);
            }
        }

        private BeanDefinitionBuilder handleLdapAuthenticationConfig(BeanDefinitionBuilder parentBuilder, Node node) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, LdapAuthenticationConfig.class, "LdapAuthenticationConfig", parentBuilder, "roleMappingMode", "userSearchScope", "roleSearchScope");
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = this.xmlToJavaName(DomConfigHelper.cleanNodeName((Node)n));
                if ("roleMappingMode".equals(name)) {
                    builder.addPropertyValue(name, (Object)LdapRoleMappingMode.getRoleMappingMode((String)this.getTextContent(n)));
                    continue;
                }
                if (!"userSearchScope".equals(name) && !"roleSearchScope".equals(name)) continue;
                builder.addPropertyValue(name, (Object)LdapSearchScope.getSearchScope((String)this.getTextContent(n)));
            }
            return builder;
        }

        private BeanDefinitionBuilder handleKerberosAuthenticationConfig(BeanDefinitionBuilder realmConfigBuilder, Node node) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, KerberosAuthenticationConfig.class, "KerberosAuthenticationConfig", realmConfigBuilder, "ldap");
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = this.xmlToJavaName(DomConfigHelper.cleanNodeName((Node)n));
                if (!"ldap".equals(name)) continue;
                this.handleLdapAuthenticationConfig(builder, n);
            }
            return builder;
        }

        private BeanDefinitionBuilder handleSimpleAuthenticationConfig(BeanDefinitionBuilder realmConfigBuilder, Node node) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, SimpleAuthenticationConfig.class, "SimpleAuthenticationConfig", realmConfigBuilder, "user");
            ManagedMap users = new ManagedMap();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"user".equals(nodeName)) continue;
                users.put((Object)this.getAttribute(child, "username"), (Object)this.handleSimpleUser(child));
            }
            builder.addPropertyValue("userMap", (Object)users);
            return builder;
        }

        private BeanDefinition handleSimpleUser(Node node) {
            BeanDefinitionBuilder simpleUserBuilder = this.createBeanBuilder(SimpleAuthenticationConfig.UserDto.class);
            simpleUserBuilder.addConstructorArgValue((Object)this.getAttribute(node, "password"));
            ArrayList<String> roles = new ArrayList<String>();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"role".equals(nodeName)) continue;
                roles.add(this.getTextContent(child));
            }
            simpleUserBuilder.addConstructorArgValue((Object)roles.toArray(new String[roles.size()]));
            return simpleUserBuilder.getBeanDefinition();
        }

        private void handleIdentity(Node node, BeanDefinitionBuilder realmConfigBuilder) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder configBuilder;
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("credentials-factory".equals(nodeName)) {
                    this.handleCredentialsFactory(child, realmConfigBuilder);
                    continue;
                }
                if ("username-password".equals(nodeName)) {
                    configBuilder = this.createBeanBuilder(UsernamePasswordIdentityConfig.class).addConstructorArgValue((Object)this.getAttribute(child, "username")).addConstructorArgValue((Object)this.getAttribute(child, "password"));
                    realmConfigBuilder.addPropertyValue("UsernamePasswordIdentityConfig", (Object)configBuilder.getBeanDefinition());
                    continue;
                }
                if ("token".equals(nodeName)) {
                    configBuilder = this.createBeanBuilder(TokenIdentityConfig.class).addConstructorArgValue((Object)TokenEncoding.getTokenEncoding((String)this.getAttribute(child, "encoding"))).addConstructorArgValue((Object)this.getTextContent(child));
                    realmConfigBuilder.addPropertyValue("TokenIdentityConfig", (Object)configBuilder.getBeanDefinition());
                    continue;
                }
                if ("kerberos".equals(nodeName)) {
                    this.createAndFillBeanBuilder(child, KerberosIdentityConfig.class, "KerberosIdentityConfig", realmConfigBuilder, new String[0]);
                    continue;
                }
                if (!"credentials-ref".equals(nodeName)) continue;
                realmConfigBuilder.addPropertyReference("credentials", this.getTextContent(child));
            }
        }

        private void handleMemberAttributes(Node node) {
            BeanDefinitionBuilder memberAttributeConfigBuilder = this.createBeanBuilder(MemberAttributeConfig.class);
            AbstractBeanDefinition beanDefinition = memberAttributeConfigBuilder.getBeanDefinition();
            ManagedMap attributes = new ManagedMap();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"attribute".equals(name)) continue;
                String attributeName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String value = this.getTextContent(n);
                attributes.put((Object)attributeName, (Object)value);
            }
            memberAttributeConfigBuilder.addPropertyValue("attributes", (Object)attributes);
            this.configBuilder.addPropertyValue("memberAttributeConfig", (Object)beanDefinition);
        }

        private void handleSecurityInterceptors(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedList lms = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"interceptor".equals(nodeName)) continue;
                BeanDefinitionBuilder siConfigBuilder = this.createBeanBuilder(SecurityInterceptorConfig.class);
                AbstractBeanDefinition beanDefinition = siConfigBuilder.getBeanDefinition();
                NamedNodeMap attributes = child.getAttributes();
                Node classNameNode = attributes.getNamedItem("class-name");
                String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
                Node implNode = attributes.getNamedItem("implementation");
                String implementation = implNode != null ? this.getTextContent(implNode) : null;
                Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create SecurityInterceptorConfig!");
                siConfigBuilder.addPropertyValue("className", (Object)className);
                if (implementation != null) {
                    siConfigBuilder.addPropertyReference("implementation", implementation);
                }
                lms.add(beanDefinition);
            }
            securityConfigBuilder.addPropertyValue("securityInterceptorConfigs", (Object)lms);
        }

        private void handleCredentialsFactory(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder credentialsConfigBuilder = this.createBeanBuilder(CredentialsFactoryConfig.class);
            AbstractBeanDefinition beanDefinition = credentialsConfigBuilder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            credentialsConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                credentialsConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create CredentialsFactory!");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, credentialsConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("credentialsFactoryConfig", (Object)beanDefinition);
        }

        private void handleLoginModules(Node node, BeanDefinitionBuilder realmConfigBuilder) {
            BeanDefinitionBuilder jaasConfigBuilder = this.createBeanBuilder(JaasAuthenticationConfig.class);
            AbstractBeanDefinition beanDefinition = jaasConfigBuilder.getBeanDefinition();
            ManagedList lms = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"login-module".equals(nodeName)) continue;
                this.handleLoginModule(child, (List<BeanDefinition>)lms);
            }
            jaasConfigBuilder.addPropertyValue("loginModuleConfigs", (Object)lms);
            realmConfigBuilder.addPropertyValue("jaasAuthenticationConfig", (Object)beanDefinition);
        }

        private void handleLoginModule(Node node, List<BeanDefinition> list) {
            BeanDefinitionBuilder lmConfigBuilder = this.createBeanBuilder(LoginModuleConfig.class);
            AbstractBeanDefinition beanDefinition = lmConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, lmConfigBuilder, "class-name", "implementation");
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            lmConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                lmConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create LoginModule!");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, lmConfigBuilder);
                break;
            }
            list.add((BeanDefinition)beanDefinition);
        }

        private void handlePermissionPolicy(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder permPolicyConfigBuilder = this.createBeanBuilder(PermissionPolicyConfig.class);
            AbstractBeanDefinition beanDefinition = permPolicyConfigBuilder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            permPolicyConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                permPolicyConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create PermissionPolicy!");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, permPolicyConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("clientPolicyConfig", (Object)beanDefinition);
        }

        private void handleSecurityPermissions(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedSet permissions = new ManagedSet();
            NamedNodeMap attributes = node.getAttributes();
            Node onJoinOpAttribute = attributes.getNamedItem("on-join-operation");
            securityConfigBuilder.addPropertyValue("permissionPriorityGrant", (Object)DomConfigHelper.getBooleanValue((String)this.getAttribute(node, "priority-grant")));
            if (onJoinOpAttribute != null) {
                String onJoinOp = this.getTextContent(onJoinOpAttribute);
                OnJoinPermissionOperationName onJoinPermissionOperation = OnJoinPermissionOperationName.valueOf((String)StringUtil.upperCaseInternal((String)onJoinOp));
                securityConfigBuilder.addPropertyValue("onJoinPermissionOperation", (Object)onJoinPermissionOperation);
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                PermissionConfig.PermissionType type = PermissionConfig.PermissionType.getType((String)nodeName);
                if (type == null) continue;
                this.handleSecurityPermission(child, (Set<BeanDefinition>)permissions, type);
            }
            securityConfigBuilder.addPropertyValue("clientPermissionConfigs", (Object)permissions);
        }

        private void handleSecurityPermission(Node node, Set<BeanDefinition> permissions, PermissionConfig.PermissionType type) {
            BeanDefinitionBuilder permissionConfigBuilder = this.createBeanBuilder(PermissionConfig.class);
            AbstractBeanDefinition beanDefinition = permissionConfigBuilder.getBeanDefinition();
            permissionConfigBuilder.addPropertyValue("type", (Object)type);
            NamedNodeMap attributes = node.getAttributes();
            Node nameNode = attributes.getNamedItem("name");
            String name = nameNode != null ? this.getTextContent(nameNode) : null;
            permissionConfigBuilder.addPropertyValue("name", (Object)name);
            permissionConfigBuilder.addPropertyValue("deny", (Object)DomConfigHelper.getBooleanValue((String)this.getAttribute(node, "deny")));
            Node principalNode = attributes.getNamedItem("principal");
            String principal = principalNode != null ? this.getTextContent(principalNode) : null;
            permissionConfigBuilder.addPropertyValue("principal", (Object)principal);
            ManagedList endpoints = new ManagedList();
            ManagedList actions = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("endpoints".equals(nodeName)) {
                    this.handleSecurityPermissionEndpoints(child, (List<String>)endpoints);
                    continue;
                }
                if (!"actions".equals(nodeName)) continue;
                this.handleSecurityPermissionActions(child, (List<String>)actions);
            }
            permissionConfigBuilder.addPropertyValue("endpoints", (Object)endpoints);
            permissionConfigBuilder.addPropertyValue("actions", (Object)actions);
            permissions.add((BeanDefinition)beanDefinition);
        }

        private void handleSecurityPermissionEndpoints(Node node, List<String> endpoints) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"endpoint".equals(nodeName)) continue;
                endpoints.add(this.getTextContent(child));
            }
        }

        private void handleSecurityPermissionActions(Node node, List<String> actions) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"action".equals(nodeName)) continue;
                actions.add(this.getTextContent(child));
            }
        }

        private void handleWanReplicationRef(BeanDefinitionBuilder beanDefinitionBuilder, Node childNode) {
            BeanDefinitionBuilder wanReplicationRefBuilder = this.createBeanBuilder(WanReplicationRef.class);
            AbstractBeanDefinition wanReplicationRefBeanDefinition = wanReplicationRefBuilder.getBeanDefinition();
            this.fillValues(childNode, wanReplicationRefBuilder, new String[0]);
            for (Node node : DomConfigHelper.childElements((Node)childNode)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                if (!nodeName.equals("filters")) continue;
                ManagedList filters = new ManagedList();
                this.handleFilters(node, (List<String>)filters);
                wanReplicationRefBuilder.addPropertyValue("filters", (Object)filters);
            }
            beanDefinitionBuilder.addPropertyValue("wanReplicationRef", (Object)wanReplicationRefBeanDefinition);
        }

        private void handleFilters(Node node, List<String> filters) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"filter-impl".equals(nodeName)) continue;
                filters.add(this.getTextContent(child));
            }
        }

        private void handleRestApi(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder restApiConfigBuilder = this.createBeanBuilder(RestApiConfig.class);
            AbstractBeanDefinition beanDefinition = restApiConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, restApiConfigBuilder, new String[0]);
            ManagedSet groupSet = new ManagedSet();
            for (RestEndpointGroup group : RestEndpointGroup.values()) {
                if (!group.isEnabledByDefault()) continue;
                groupSet.add((Object)group);
            }
            this.handleRestEndpointGroup(node, restApiConfigBuilder, (ManagedSet<RestEndpointGroup>)groupSet);
            networkConfigBuilder.addPropertyValue("restApiConfig", (Object)beanDefinition);
        }

        private void handleRestEndpointGroup(Node node, BeanDefinitionBuilder builder, ManagedSet<RestEndpointGroup> groupSet) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                RestEndpointGroup group;
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"endpoint-group".equals(nodeName)) continue;
                NamedNodeMap attributes = child.getAttributes();
                Node attrEnabled = attributes.getNamedItem("enabled");
                boolean enabled = attrEnabled != null && DomConfigHelper.getBooleanValue((String)this.getTextContent(attrEnabled));
                String name = this.getTextContent(attributes.getNamedItem("name"));
                try {
                    group = RestEndpointGroup.valueOf((String)name);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidConfigurationException("Wrong name attribute value was provided in endpoint-group element: " + name + "\nAllowed values: " + Arrays.toString(RestEndpointGroup.values()));
                }
                if (enabled) {
                    groupSet.add((Object)group);
                    continue;
                }
                groupSet.remove((Object)group);
            }
            builder.addPropertyValue("enabledGroups", groupSet);
        }

        private void handleMemcacheProtocol(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder memcacheProtocolConfigBuilder = this.createBeanBuilder(MemcacheProtocolConfig.class);
            AbstractBeanDefinition beanDefinition = memcacheProtocolConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, memcacheProtocolConfigBuilder, new String[0]);
            networkConfigBuilder.addPropertyValue("memcacheProtocolConfig", (Object)beanDefinition);
        }

        private EndpointQualifier createEndpointQualifier(ProtocolType type, Node node) {
            return EndpointQualifier.resolveForConfig((ProtocolType)type, (String)this.getAttribute(node, "name"));
        }

        private void handleInstanceTracking(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(InstanceTrackingConfig.class);
            this.fillAttributeValues(node, configBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("file-name".equals(name)) {
                    configBuilder.addPropertyValue("fileName", (Object)this.getTextContent(child));
                    continue;
                }
                if (!"format-pattern".equals(name)) continue;
                configBuilder.addPropertyValue("formatPattern", (Object)this.getTextContent(child));
            }
            this.configBuilder.addPropertyValue("instanceTrackingConfig", (Object)configBuilder.getBeanDefinition());
        }

        private void handleMetrics(Node node) {
            BeanDefinitionBuilder metricsConfigBuilder = this.createBeanBuilder(MetricsConfig.class);
            this.fillValues(node, metricsConfigBuilder, "managementCenter", "jmx");
            NamedNodeMap attributes = node.getAttributes();
            Node attrEnabled = attributes.getNamedItem("enabled");
            boolean enabled = attrEnabled != null && DomConfigHelper.getBooleanValue((String)this.getTextContent(attrEnabled));
            metricsConfigBuilder.addPropertyValue("enabled", (Object)enabled);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("management-center".equals(nodeName)) {
                    BeanDefinitionBuilder metricsMcConfigBuilder = this.createBeanBuilder(MetricsManagementCenterConfig.class);
                    this.fillValues(child, metricsMcConfigBuilder, new String[0]);
                    metricsConfigBuilder.addPropertyValue("managementCenterConfig", (Object)metricsMcConfigBuilder.getBeanDefinition());
                    continue;
                }
                if (!"jmx".equals(nodeName)) continue;
                BeanDefinitionBuilder metricsJmxConfigBuilder = this.createBeanBuilder(MetricsJmxConfig.class);
                this.fillValues(child, metricsJmxConfigBuilder, new String[0]);
                metricsConfigBuilder.addPropertyValue("jmxConfig", (Object)metricsJmxConfigBuilder.getBeanDefinition());
            }
            this.configBuilder.addPropertyValue("metricsConfig", (Object)metricsConfigBuilder.getBeanDefinition());
        }

        private void handleSql(Node node) {
            BeanDefinitionBuilder sqlConfigBuilder = this.createBeanBuilder(SqlConfig.class);
            this.fillValues(node, sqlConfigBuilder, "executorPoolSize", "timeoutMillis");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                String value = this.getTextContent(child).trim();
                if (!"statement-timeout-millis".equals(nodeName)) continue;
                sqlConfigBuilder.addPropertyValue("statementTimeoutMillis", (Object)DomConfigHelper.getLongValue((String)"statement-timeout-millis", (String)value));
            }
            this.configBuilder.addPropertyValue("sqlConfig", (Object)sqlConfigBuilder.getBeanDefinition());
        }

        private void handleAuditlog(Node node) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(AuditlogConfig.class);
            this.fillValues(node, builder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, builder);
            }
            this.configBuilder.addPropertyValue("auditlogConfig", (Object)builder.getBeanDefinition());
        }

        private void handleJet(Node node) {
            BeanDefinitionBuilder jetConfigBuilder = this.createBeanBuilder(JetConfig.class);
            this.fillValues(node, jetConfigBuilder, "instance", "edgeDefaults");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("instance".equals(nodeName)) {
                    if (this.jetConfigContainsInstanceConfigFields(node)) {
                        LOGGER.warning("<instance> tag will be ignored since <jet> tag already contains the instance fields.");
                        continue;
                    }
                    BeanDefinitionBuilder instanceConfigBuilder = this.createBeanBuilder(InstanceConfig.class);
                    this.fillValues(child, instanceConfigBuilder, new String[0]);
                    jetConfigBuilder.addPropertyValue("instanceConfig", (Object)instanceConfigBuilder.getBeanDefinition());
                    continue;
                }
                if (!"edge-defaults".equals(nodeName)) continue;
                BeanDefinitionBuilder edgeConfigBuilder = this.createBeanBuilder(EdgeConfig.class);
                this.fillValues(child, edgeConfigBuilder, new String[0]);
                jetConfigBuilder.addPropertyValue("defaultEdgeConfig", (Object)edgeConfigBuilder.getBeanDefinition());
            }
            this.configBuilder.addPropertyValue("jetConfig", (Object)jetConfigBuilder.getBeanDefinition());
        }

        public void handleVectorCollection(Node node) {
            BeanDefinitionBuilder vectorCollectionConfigBuilder = this.createBeanBuilder(VectorCollectionConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, vectorCollectionConfigBuilder, new String[0]);
            ManagedList vectorIndexConfigs = new ManagedList();
            Node indexesNode = DomConfigHelper.firstChildElement((Node)node);
            if ("indexes".equals(DomConfigHelper.cleanNodeName((Node)indexesNode))) {
                for (Node childNode : DomConfigHelper.childElements((Node)indexesNode)) {
                    String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                    if (!"index".equals(nodeName)) continue;
                    vectorIndexConfigs.add((Object)this.parseVectorIndex(childNode));
                }
            }
            vectorCollectionConfigBuilder.addPropertyValue("vectorIndexConfigs", (Object)vectorIndexConfigs);
            this.vectorCollectionConfigManagedMap.put((Object)name, (Object)vectorCollectionConfigBuilder.getBeanDefinition());
        }

        private AbstractBeanDefinition parseVectorIndex(Node node) {
            BeanDefinitionBuilder vectorIndexConfBuilder = this.createBeanBuilder(VectorIndexConfig.class);
            this.fillAttributeValues(node, vectorIndexConfBuilder, new String[0]);
            return vectorIndexConfBuilder.getBeanDefinition();
        }

        private boolean jetConfigContainsInstanceConfigFields(Node node) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"cooperative-thread-count".equals(nodeName) && !"flow-control-period".equals(nodeName) && !"backup-count".equals(nodeName) && !"scale-up-delay-millis".equals(nodeName) && !"lossless-restart-enabled".equals(nodeName) && !"max-processor-accumulated-records".equals(nodeName)) continue;
                return true;
            }
            return false;
        }

        private void handleIntegrityChecker(Node node) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(IntegrityCheckerConfig.class);
            this.fillValues(node, builder, new String[0]);
            this.configBuilder.addPropertyValue("integrityCheckerConfig", (Object)builder.getBeanDefinition());
        }

        private void handleDataConnection(Node node) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(DataConnectionConfig.class);
            builder.addPropertyValue("name", (Object)this.getAttribute(node, "name"));
            this.fillValues(node, builder, "properties");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, builder);
                break;
            }
            this.dataConnectionConfigMap.put((Object)this.getAttribute(node, "name"), (Object)builder.getBeanDefinition());
        }

        private void handleTpc(Node node) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(TpcConfig.class);
            builder.addPropertyValue("enabled", (Object)this.getAttribute(node, "enabled"));
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"eventloop-count".equals(nodeName)) continue;
                builder.addPropertyValue("eventloopCount", (Object)DomConfigHelper.getIntegerValue((String)"eventloop-count", (String)this.getTextContent(child)));
            }
            this.configBuilder.addPropertyValue("tpcConfig", (Object)builder.getBeanDefinition());
        }

        private void handleNamespaces(Node node) {
            BeanDefinitionBuilder namespacesBuilder = this.createBeanBuilder(UserCodeNamespacesConfig.class);
            if (!Boolean.parseBoolean(this.getAttribute(node, "enabled"))) {
                namespacesBuilder.addPropertyValue("enabled", (Object)false);
                this.configBuilder.addPropertyValue("namespacesConfig", (Object)namespacesBuilder.getBeanDefinition());
                return;
            }
            ManagedMap namespaces = new ManagedMap();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                if ("class-filter".equals(DomConfigHelper.cleanNodeName((Node)child))) {
                    this.handleJavaSerializationFilter(child, namespacesBuilder, "classFilterConfig");
                    continue;
                }
                if (!"namespace".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
                this.handleNamespace(child, (ManagedMap<String, BeanDefinition>)namespaces);
            }
            namespacesBuilder.addConstructorArgValue((Object)true);
            namespacesBuilder.addConstructorArgValue((Object)namespaces);
            this.configBuilder.addPropertyValue("namespacesConfig", (Object)namespacesBuilder.getBeanDefinition());
        }

        private void handleNamespace(Node node, ManagedMap<String, BeanDefinition> namespaces) {
            String name = this.getAttribute(node, "name");
            BeanDefinitionBuilder namespaceConfigBuilder = this.createBeanBuilder(UserCodeNamespaceConfig.class);
            ManagedMap resources = new ManagedMap();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("jar".equals(nodeName)) {
                    this.handleNamespaceResource(child, ResourceType.JAR, (ManagedMap<String, BeanDefinition>)resources);
                    continue;
                }
                if ("jars-in-zip".equals(nodeName)) {
                    this.handleNamespaceResource(child, ResourceType.JARS_IN_ZIP, (ManagedMap<String, BeanDefinition>)resources);
                    continue;
                }
                if (!"class".equals(nodeName)) continue;
                this.handleNamespaceResource(child, ResourceType.CLASS, (ManagedMap<String, BeanDefinition>)resources);
            }
            namespaceConfigBuilder.addConstructorArgValue((Object)name);
            namespaceConfigBuilder.addConstructorArgValue((Object)resources);
            namespaces.put((Object)name, (Object)namespaceConfigBuilder.getBeanDefinition());
        }

        private void handleNamespaceResource(Node node, ResourceType type, ManagedMap<String, BeanDefinition> resources) {
            BeanDefinitionBuilder resourceConfigBuilder = this.createBeanBuilder(ResourceConfig.class);
            BeanDefinitionBuilder resourceDefBuilder = this.createBeanBuilder(ResourceDefinitionImpl.class);
            String resourceId = this.getAttribute(node, "id");
            URL url = this.getNamespaceResourceUrl(node);
            resourceConfigBuilder.addConstructorArgValue((Object)url);
            resourceConfigBuilder.addConstructorArgValue((Object)resourceId);
            resourceConfigBuilder.addConstructorArgValue((Object)type);
            AbstractBeanDefinition resourceConfigBeanDef = resourceConfigBuilder.getBeanDefinition();
            resourceDefBuilder.addConstructorArgValue((Object)resourceConfigBeanDef);
            String resolvedId = ConfigUtils.resolveResourceId((String)resourceId, (URL)url);
            resources.put((Object)resolvedId, (Object)resourceDefBuilder.getBeanDefinition());
        }

        private URL getNamespaceResourceUrl(Node node) {
            URL url = null;
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                if (!ConfigUtils.matches((String)DomConfigHelper.cleanNodeName((Node)n), (String)"url")) continue;
                try {
                    url = new URI(this.getTextContent(n)).toURL();
                    break;
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new InvalidConfigurationException("Malformed resource URL", (Throwable)e);
                }
            }
            return url;
        }

        private void handlePartitionAttributes(BeanDefinitionBuilder mapConfigBuilder, Node node) {
            ManagedList partitioningAttributeConfigs = new ManagedList();
            for (Node attributeNode : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder attributeConfBuilder = this.createBeanBuilder(PartitioningAttributeConfig.class);
                attributeConfBuilder.addPropertyValue("attributeName", (Object)this.getTextContent(attributeNode));
                partitioningAttributeConfigs.add((Object)attributeConfBuilder.getBeanDefinition());
            }
            mapConfigBuilder.addPropertyValue("partitioningAttributeConfigs", (Object)partitioningAttributeConfigs);
        }
    }
}

