/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite;

import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastRexBuilder
extends RexBuilder {
    public HazelcastRexBuilder(RelDataTypeFactory typeFactory) {
        super(typeFactory);
        assert (typeFactory instanceof HazelcastTypeFactory);
    }

    public RexNode makeLiteral(Object value, RelDataType type, boolean allowCast) {
        if (type.getSqlTypeName() == SqlTypeName.ANY && value instanceof Number) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                Number number = (Number)value;
                int bitWidth = HazelcastIntegerType.bitWidthOf(number.longValue());
                type = HazelcastIntegerType.of(bitWidth, false);
            } else if (value instanceof Float) {
                type = HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.REAL);
            } else if (value instanceof Double) {
                type = HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.DOUBLE);
            } else if (value instanceof BigDecimal) {
                type = HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.DECIMAL);
            }
        }
        return super.makeLiteral(value, type, allowCast);
    }
}

