/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry;

import com.hazelcast.com.esri.core.geometry.AttributeStreamOfDbl;
import com.hazelcast.com.esri.core.geometry.AttributeStreamOfInt32;
import com.hazelcast.com.esri.core.geometry.BucketSort;
import com.hazelcast.com.esri.core.geometry.ClassicSort;
import com.hazelcast.com.esri.core.geometry.Clusterer;
import com.hazelcast.com.esri.core.geometry.CrackAndCluster;
import com.hazelcast.com.esri.core.geometry.Cracker;
import com.hazelcast.com.esri.core.geometry.EditShape;
import com.hazelcast.com.esri.core.geometry.Envelope;
import com.hazelcast.com.esri.core.geometry.Envelope2D;
import com.hazelcast.com.esri.core.geometry.Geometry;
import com.hazelcast.com.esri.core.geometry.GeometryException;
import com.hazelcast.com.esri.core.geometry.IndexMultiDCList;
import com.hazelcast.com.esri.core.geometry.InternalUtils;
import com.hazelcast.com.esri.core.geometry.MultiPathImpl;
import com.hazelcast.com.esri.core.geometry.MultiPoint;
import com.hazelcast.com.esri.core.geometry.MultiVertexGeometry;
import com.hazelcast.com.esri.core.geometry.MultiVertexGeometryImpl;
import com.hazelcast.com.esri.core.geometry.NonSimpleResult;
import com.hazelcast.com.esri.core.geometry.NumberUtils;
import com.hazelcast.com.esri.core.geometry.Point;
import com.hazelcast.com.esri.core.geometry.Point2D;
import com.hazelcast.com.esri.core.geometry.Polygon;
import com.hazelcast.com.esri.core.geometry.Polyline;
import com.hazelcast.com.esri.core.geometry.ProgressTracker;
import com.hazelcast.com.esri.core.geometry.Segment;
import com.hazelcast.com.esri.core.geometry.SegmentIteratorImpl;
import com.hazelcast.com.esri.core.geometry.Simplificator;
import com.hazelcast.com.esri.core.geometry.SpatialReference;
import com.hazelcast.com.esri.core.geometry.SpatialReferenceImpl;
import com.hazelcast.com.esri.core.geometry.TopologicalOperations;
import com.hazelcast.com.esri.core.geometry.Treap;
import com.hazelcast.com.esri.core.geometry.VertexDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

class OperatorSimplifyLocalHelper {
    private final VertexDescription m_description;
    private Geometry m_geometry;
    private SpatialReferenceImpl m_sr;
    private int m_dbgCounter;
    private double m_toleranceIsSimple;
    private double m_toleranceSimplify;
    private int m_knownSimpleResult;
    private int m_attributeCount;
    private ArrayList<Edge> m_edges;
    private AttributeStreamOfInt32 m_FreeEdges;
    private ArrayList<Edge> m_lineEdgesRecycle;
    private AttributeStreamOfInt32 m_newEdges;
    private SegmentIteratorImpl m_recycledSegIter;
    private IndexMultiDCList m_crossOverHelperList;
    private AttributeStreamOfInt32 m_paths_for_OGC_tests;
    private ProgressTracker m_progressTracker;
    private Treap m_AET;
    private AttributeStreamOfInt32 m_xyToNode1;
    private AttributeStreamOfInt32 m_xyToNode2;
    private AttributeStreamOfInt32 m_pathOrientations;
    private AttributeStreamOfInt32 m_pathParentage;
    private int m_unknownOrientationPathCount;
    private double m_yScanline;
    private AttributeStreamOfDbl m_xy;
    private AttributeStreamOfInt32 m_pairs;
    private AttributeStreamOfInt32 m_pairIndices;
    private EditShape m_editShape;
    private boolean m_bOGCRestrictions;
    private boolean m_bPlanarSimplify;
    NonSimpleResult m_nonSimpleResult;

    private int isSimplePlanarImpl_() {
        this.m_bPlanarSimplify = true;
        if (Geometry.isMultiPath(this.m_geometry.getType().value())) {
            if (!this.checkStructure_()) {
                return 0;
            }
            if (!this.checkDegenerateSegments_(false)) {
                return 0;
            }
        }
        if (!this.checkClustering_()) {
            return 0;
        }
        if (!Geometry.isMultiPath(this.m_geometry.getType().value())) {
            return 2;
        }
        if (!this.checkCracking_()) {
            return 0;
        }
        if (this.m_geometry.getType() == Geometry.Type.Polyline) {
            if (!this.checkSelfIntersectionsPolylinePlanar_()) {
                return 0;
            }
            return 2;
        }
        if (!this.checkSelfIntersections_()) {
            return 0;
        }
        return this.checkValidRingOrientation_();
    }

    private boolean testToleranceDistance_(int xyindex1, int xyindex2) {
        double y2;
        double x2;
        double y1;
        boolean b;
        double x1 = this.m_xy.read(2 * xyindex1);
        boolean bl = b = !Clusterer.isClusterCandidate_(x1, y1 = this.m_xy.read(2 * xyindex1 + 1), x2 = this.m_xy.read(2 * xyindex2), y2 = this.m_xy.read(2 * xyindex2 + 1), this.m_toleranceIsSimple * this.m_toleranceIsSimple);
        if (!b) {
            if (this.m_geometry.getDimension() == 0) {
                return false;
            }
            return x1 == x2 && y1 == y2;
        }
        return b;
    }

    private boolean checkStructure_() {
        MultiPathImpl multiPathImpl = (MultiPathImpl)this.m_geometry._getImpl();
        int minsize = multiPathImpl.m_bPolygon ? 3 : 2;
        int npath = multiPathImpl.getPathCount();
        for (int ipath = 0; ipath < npath; ++ipath) {
            if (multiPathImpl.getPathSize(ipath) >= minsize) continue;
            this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.Structure, ipath, 0);
            return false;
        }
        return true;
    }

    private boolean checkDegenerateSegments_(boolean bTestZs) {
        double ztolerance;
        MultiPathImpl multiPathImpl = (MultiPathImpl)this.m_geometry._getImpl();
        SegmentIteratorImpl segIter = multiPathImpl.querySegmentIterator();
        boolean bHasZ = multiPathImpl.hasAttribute(1);
        double d = ztolerance = !bHasZ ? 0.0 : InternalUtils.calculateZToleranceFromGeometry(this.m_sr, multiPathImpl, false);
        while (segIter.nextPath()) {
            while (segIter.hasNextSegment()) {
                Segment seg = segIter.nextSegment();
                double length = seg.calculateLength2D();
                if (length > this.m_toleranceIsSimple) continue;
                if (bTestZs && bHasZ) {
                    double z0 = seg.getStartAttributeAsDbl(1, 0);
                    double z1 = seg.getStartAttributeAsDbl(1, 0);
                    if (Math.abs(z1 - z0) > ztolerance) continue;
                }
                this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.DegenerateSegments, segIter.getStartPointIndex(), -1);
                return false;
            }
        }
        return true;
    }

    private boolean checkClustering_() {
        MultiVertexGeometryImpl multiVertexImpl = (MultiVertexGeometryImpl)this.m_geometry._getImpl();
        MultiPathImpl multiPathImpl = null;
        if (Geometry.isMultiPath(this.m_geometry.getType().value())) {
            multiPathImpl = (MultiPathImpl)this.m_geometry._getImpl();
        }
        boolean get_paths = (this.m_bPlanarSimplify || this.m_bOGCRestrictions) && multiPathImpl != null;
        int pointCount = multiVertexImpl.getPointCount();
        this.m_xy = (AttributeStreamOfDbl)multiVertexImpl.getAttributeStreamRef(0);
        this.m_pairs = new AttributeStreamOfInt32(0);
        this.m_pairs.reserve(pointCount * 2);
        this.m_pairIndices = new AttributeStreamOfInt32(0);
        this.m_pairIndices.reserve(pointCount * 2);
        if (get_paths) {
            if (this.m_paths_for_OGC_tests == null) {
                this.m_paths_for_OGC_tests = new AttributeStreamOfInt32(0);
            }
            this.m_paths_for_OGC_tests.reserve(pointCount);
        }
        int ipath = 0;
        for (int i = 0; i < pointCount; ++i) {
            this.m_pairs.add(2 * i);
            this.m_pairs.add(2 * i + 1);
            this.m_pairIndices.add(2 * i);
            this.m_pairIndices.add(2 * i + 1);
            if (!get_paths) continue;
            while (i >= multiPathImpl.getPathEnd(ipath)) {
                ++ipath;
            }
            this.m_paths_for_OGC_tests.add(ipath);
        }
        BucketSort sorter = new BucketSort();
        sorter.sort(this.m_pairIndices, 0, 2 * pointCount, new IndexSorter(this, get_paths));
        this.m_AET.clear();
        this.m_AET.setComparator(new ClusterTestComparator(this));
        this.m_AET.setCapacity(pointCount);
        int n = pointCount * 2;
        for (int index = 0; index < n; ++index) {
            int rightneighbour;
            int leftneighbour;
            int aetNode;
            int pairIndex = this.m_pairIndices.get(index);
            int pair = this.m_pairs.get(pairIndex);
            int xyindex = pair >> 1;
            if ((pair & 1) == 0) {
                aetNode = this.m_AET.addElement(xyindex, -1);
                leftneighbour = this.m_AET.getPrev(aetNode);
                if (leftneighbour != Treap.nullNode() && !this.testToleranceDistance_(this.m_AET.getElement(leftneighbour), xyindex)) {
                    this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.Clustering, xyindex, this.m_AET.getElement(leftneighbour));
                    return false;
                }
                rightneighbour = this.m_AET.getNext(aetNode);
                if (rightneighbour == Treap.nullNode() || this.testToleranceDistance_(this.m_AET.getElement(rightneighbour), xyindex)) continue;
                this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.Clustering, xyindex, this.m_AET.getElement(rightneighbour));
                return false;
            }
            aetNode = this.m_AET.search(xyindex, -1);
            leftneighbour = this.m_AET.getPrev(aetNode);
            rightneighbour = this.m_AET.getNext(aetNode);
            this.m_AET.deleteNode(aetNode, -1);
            if (leftneighbour == Treap.nullNode() || rightneighbour == Treap.nullNode() || this.testToleranceDistance_(this.m_AET.getElement(leftneighbour), this.m_AET.getElement(rightneighbour))) continue;
            this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.Clustering, this.m_AET.getElement(leftneighbour), this.m_AET.getElement(rightneighbour));
            return false;
        }
        return true;
    }

    private boolean checkCracking_() {
        MultiVertexGeometryImpl multiVertexImpl = (MultiVertexGeometryImpl)this.m_geometry._getImpl();
        int pointCount = multiVertexImpl.getPointCount();
        if (pointCount < 10) {
            return this.checkCrackingBrute_();
        }
        return this.checkCrackingPlanesweep_();
    }

    private boolean checkCrackingPlanesweep_() {
        EditShape editShape = new EditShape();
        editShape.addGeometry(this.m_geometry);
        NonSimpleResult result = new NonSimpleResult();
        boolean bNonSimple = Cracker.needsCracking(false, editShape, this.m_toleranceIsSimple, result, this.m_progressTracker);
        if (bNonSimple) {
            result.m_vertexIndex1 = editShape.getVertexIndex(result.m_vertexIndex1);
            result.m_vertexIndex2 = editShape.getVertexIndex(result.m_vertexIndex2);
            this.m_nonSimpleResult.Assign(result);
            return false;
        }
        return true;
    }

    private boolean checkCrackingBrute_() {
        MultiPathImpl multiPathImpl = (MultiPathImpl)this.m_geometry._getImpl();
        SegmentIteratorImpl segIter1 = multiPathImpl.querySegmentIterator();
        SegmentIteratorImpl segIter2 = multiPathImpl.querySegmentIterator();
        while (segIter1.nextPath()) {
            while (segIter1.hasNextSegment()) {
                Segment seg1 = segIter1.nextSegment();
                if (segIter1.isLastSegmentInPath() && segIter1.isLastPath()) continue;
                segIter2.resetTo(segIter1);
                while (true) {
                    if (segIter2.hasNextSegment()) {
                        Segment seg2 = segIter2.nextSegment();
                        int res = seg1._isIntersecting(seg2, this.m_toleranceIsSimple, true);
                        if (res == 0) continue;
                        NonSimpleResult.Reason reason = res == 2 ? NonSimpleResult.Reason.CrossOver : NonSimpleResult.Reason.Cracking;
                        this.m_nonSimpleResult = new NonSimpleResult(reason, segIter1.getStartPointIndex(), segIter2.getStartPointIndex());
                        return false;
                    }
                    if (!segIter2.nextPath()) break;
                }
            }
        }
        return true;
    }

    private boolean checkSelfIntersections_() {
        MultiPathImpl multiPathImpl = (MultiPathImpl)this.m_geometry._getImpl();
        this.m_edges.clear();
        this.m_edges.ensureCapacity(20);
        this.m_lineEdgesRecycle.clear();
        this.m_lineEdgesRecycle.ensureCapacity(20);
        this.m_recycledSegIter = multiPathImpl.querySegmentIterator();
        this.m_recycledSegIter.setCirculator(true);
        AttributeStreamOfInt32 bunch = new AttributeStreamOfInt32(0);
        bunch.reserve(10);
        int pointCount = multiPathImpl.getPointCount();
        double xprev = Double.NaN;
        double yprev = 0.0;
        int n = pointCount * 2;
        for (int index = 0; index < n; ++index) {
            int pairIndex = this.m_pairIndices.get(index);
            int pair = this.m_pairs.get(pairIndex);
            if ((pair & 1) != 0) continue;
            int xyindex = pair >> 1;
            double x = this.m_xy.read(2 * xyindex);
            double y = this.m_xy.read(2 * xyindex + 1);
            if (bunch.size() != 0 && (x != xprev || y != yprev)) {
                if (!this.processBunchForSelfIntersectionTest_(bunch)) {
                    return false;
                }
                if (bunch != null) {
                    bunch.clear(false);
                }
            }
            bunch.add(xyindex);
            xprev = x;
            yprev = y;
        }
        assert (bunch.size() > 0);
        return this.processBunchForSelfIntersectionTest_(bunch);
    }

    boolean checkSelfIntersectionsPolylinePlanar_() {
        MultiPathImpl multiPathImpl = (MultiPathImpl)this.m_geometry._getImpl();
        boolean[] closedPaths = new boolean[multiPathImpl.getPathCount()];
        int npaths = multiPathImpl.getPathCount();
        for (int ipath = 0; ipath < npaths; ++ipath) {
            closedPaths[ipath] = multiPathImpl.isClosedPathInXYPlane(ipath);
        }
        Vertex_info_pl vi_prev = new Vertex_info_pl();
        Point2D pt = new Point2D();
        int pairIndex = this.m_pairIndices.get(0);
        int pair = this.m_pairs.get(pairIndex);
        int xyindex = pair >> 1;
        this.m_xy.read(2 * xyindex, pt);
        int ipath = this.m_paths_for_OGC_tests.get(xyindex);
        boolean is_closed_path = closedPaths[ipath];
        int path_start = multiPathImpl.getPathStart(ipath);
        int path_last = multiPathImpl.getPathEnd(ipath) - 1;
        boolean bl = vi_prev.end_point = xyindex == path_start || xyindex == path_last;
        vi_prev.boundary = this.m_bOGCRestrictions ? !is_closed_path && vi_prev.end_point : vi_prev.end_point;
        vi_prev.ipath = ipath;
        vi_prev.x = pt.x;
        vi_prev.y = pt.y;
        vi_prev.ivertex = xyindex;
        Vertex_info_pl vi = new Vertex_info_pl();
        int n = this.m_pairIndices.size();
        for (int index = 1; index < n; ++index) {
            boolean end_point;
            int pairIndex2 = this.m_pairIndices.get(index);
            int pair2 = this.m_pairs.get(pairIndex2);
            if ((pair2 & 1) != 0) continue;
            int xyindex2 = pair2 >> 1;
            this.m_xy.read(2 * xyindex2, pt);
            int ipath2 = this.m_paths_for_OGC_tests.get(xyindex2);
            if (ipath2 != vi_prev.ipath) {
                is_closed_path = closedPaths[ipath2];
                path_start = multiPathImpl.getPathStart(ipath2);
                path_last = multiPathImpl.getPathEnd(ipath2) - 1;
            }
            boolean bl2 = end_point = xyindex2 == path_start || xyindex2 == path_last;
            boolean boundary = this.m_bOGCRestrictions ? !is_closed_path && vi_prev.end_point : vi_prev.end_point;
            vi.x = pt.x;
            vi.y = pt.y;
            vi.ipath = ipath2;
            vi.ivertex = xyindex2;
            vi.boundary = boundary;
            vi.end_point = end_point;
            if (vi.x == vi_prev.x && vi.y == vi_prev.y) {
                if (this.m_bOGCRestrictions) {
                    if (!(vi.boundary && vi_prev.boundary || vi.ipath == vi_prev.ipath && (vi.end_point || vi_prev.end_point))) {
                        this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.OGCPolylineSelfTangency, vi.ivertex, vi_prev.ivertex);
                        return false;
                    }
                } else if (!vi.end_point || !vi_prev.end_point) {
                    this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.CrossOver, vi.ivertex, vi_prev.ivertex);
                    return false;
                }
            }
            Vertex_info_pl tmp = vi_prev;
            vi_prev = vi;
            vi = tmp;
        }
        return true;
    }

    boolean check_self_intersections_polygons_OGC_() {
        MultiPathImpl multiPathImpl = (MultiPathImpl)this.m_geometry._getImpl();
        int[] ring_to_polygon = new int[multiPathImpl.getPathCount()];
        int exteriors = -1;
        boolean has_holes = false;
        int n = multiPathImpl.getPathCount();
        for (int ipath = 0; ipath < n; ++ipath) {
            if (multiPathImpl.isExteriorRing(ipath)) {
                has_holes = false;
                ++exteriors;
                if (ipath < n - 1 && !multiPathImpl.isExteriorRing(ipath + 1)) {
                    has_holes = true;
                }
            }
            ring_to_polygon[ipath] = has_holes ? exteriors : -1;
        }
        Vertex_info_pg vi_prev = null;
        Point2D pt = new Point2D();
        int pairIndex = this.m_pairIndices.get(0);
        int pair = this.m_pairs.get(pairIndex);
        int xyindex = pair >> 1;
        this.m_xy.read(2 * xyindex, pt);
        int ipath = this.m_paths_for_OGC_tests.get(xyindex);
        vi_prev = new Vertex_info_pg(pt.x, pt.y, ipath, xyindex, ring_to_polygon[ipath]);
        ArrayList<Vertex_info_pg> intersections = new ArrayList<Vertex_info_pg>(multiPathImpl.getPathCount() * 2);
        int n2 = this.m_pairIndices.size();
        for (int index = 1; index < n2; ++index) {
            int pairIndex2 = this.m_pairIndices.get(index);
            int pair2 = this.m_pairs.get(pairIndex2);
            if ((pair2 & 1) != 0) continue;
            int xyindex2 = pair2 >> 1;
            this.m_xy.read(2 * xyindex2, pt);
            int ipath2 = this.m_paths_for_OGC_tests.get(xyindex2);
            Vertex_info_pg vi = new Vertex_info_pg(pt.x, pt.y, ipath2, xyindex2, ring_to_polygon[ipath2]);
            if (vi.x == vi_prev.x && vi.y == vi_prev.y) {
                if (vi.ipath == vi_prev.ipath) {
                    this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.OGCPolygonSelfTangency, vi.ivertex, vi_prev.ivertex);
                    return false;
                }
                if (ring_to_polygon[vi.ipath] >= 0 && ring_to_polygon[vi.ipath] == ring_to_polygon[vi_prev.ipath]) {
                    if (intersections.size() == 0 || intersections.get(intersections.size() - 1) != vi_prev) {
                        intersections.add(vi_prev);
                    }
                    intersections.add(vi);
                }
            }
            vi_prev = vi;
        }
        if (intersections.size() == 0) {
            return true;
        }
        IndexMultiDCList graph = new IndexMultiDCList(true);
        Arrays.fill(ring_to_polygon, -1);
        int vnode_index = -1;
        Point2D prev = new Point2D();
        prev.setNaN();
        int n3 = intersections.size();
        for (int i = 0; i < n3; ++i) {
            int rnode_index;
            Vertex_info_pg cur = (Vertex_info_pg)intersections.get(i);
            if (cur.x != prev.x || cur.y != prev.y) {
                vnode_index = graph.createList(0);
                prev.x = cur.x;
                prev.y = cur.y;
            }
            if ((rnode_index = ring_to_polygon[cur.ipath]) == -1) {
                ring_to_polygon[cur.ipath] = rnode_index = graph.createList(2);
            }
            graph.addElement(rnode_index, vnode_index);
            graph.addElement(vnode_index, rnode_index);
        }
        AttributeStreamOfInt32 depth_first_stack = new AttributeStreamOfInt32(0);
        depth_first_stack.reserve(10);
        int node = graph.getFirstList();
        while (node != -1) {
            int ncolor = graph.getListData(node);
            if ((ncolor & 1) == 0 && (ncolor & 2) != 0) {
                int bad_rnode = -1;
                depth_first_stack.add(node);
                depth_first_stack.add(-1);
                while (depth_first_stack.size() > 0) {
                    int cur_node_parent = depth_first_stack.getLast();
                    depth_first_stack.removeLast();
                    int cur_node = depth_first_stack.getLast();
                    depth_first_stack.removeLast();
                    int color = graph.getListData(cur_node);
                    if ((color & 1) != 0) {
                        if ((color & 2) == 0) {
                            bad_rnode = cur_node_parent;
                            break;
                        }
                        bad_rnode = cur_node;
                        break;
                    }
                    graph.setListData(cur_node, color | 1);
                    int adjacent_node = graph.getFirst(cur_node);
                    while (adjacent_node != -1) {
                        int adjacent_node_data = graph.getData(adjacent_node);
                        if (adjacent_node_data != cur_node_parent) {
                            depth_first_stack.add(adjacent_node_data);
                            depth_first_stack.add(cur_node);
                        }
                        adjacent_node = graph.getNext(adjacent_node);
                    }
                }
                if (bad_rnode != -1) {
                    int bad_ring_index = -1;
                    int n4 = ring_to_polygon.length;
                    for (int i = 0; i < n4; ++i) {
                        if (ring_to_polygon[i] != bad_rnode) continue;
                        bad_ring_index = i;
                        break;
                    }
                    this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.OGCDisconnectedInterior, bad_ring_index, -1);
                    return false;
                }
            }
            node = graph.getNextList(node);
        }
        return true;
    }

    private int checkValidRingOrientation_() {
        MultiPathImpl multiPathImpl = (MultiPathImpl)this.m_geometry._getImpl();
        double totalArea = multiPathImpl.calculateArea2D();
        if (totalArea <= 0.0) {
            this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.RingOrientation, multiPathImpl.getPathCount() == 1 ? 1 : -1, -1);
            return 0;
        }
        if (multiPathImpl.getPathCount() == 1) {
            if (this.m_bOGCRestrictions && !this.check_self_intersections_polygons_OGC_()) {
                return 0;
            }
            return 2;
        }
        this.m_pathOrientations = new AttributeStreamOfInt32(multiPathImpl.getPathCount(), 0);
        this.m_pathParentage = new AttributeStreamOfInt32(multiPathImpl.getPathCount(), -1);
        int parent_ring = -1;
        double exteriorArea = 0.0;
        int n = multiPathImpl.getPathCount();
        for (int ipath = 0; ipath < n; ++ipath) {
            double area = multiPathImpl.calculateRingArea2D(ipath);
            this.m_pathOrientations.write(ipath, area < 0.0 ? 0 : 256);
            if (area > 0.0) {
                parent_ring = ipath;
                exteriorArea = area;
                continue;
            }
            if (area == 0.0) {
                this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.RingOrientation, ipath, -1);
                return 0;
            }
            if (parent_ring < 0 || exteriorArea < Math.abs(area)) {
                this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.RingOrder, ipath, -1);
                if (this.m_bOGCRestrictions) {
                    return 0;
                }
            }
            this.m_pathParentage.write(ipath, parent_ring);
        }
        this.m_unknownOrientationPathCount = multiPathImpl.getPathCount();
        this.m_newEdges = new AttributeStreamOfInt32(0);
        this.m_newEdges.reserve(10);
        int pointCount = multiPathImpl.getPointCount();
        this.m_yScanline = Double.NaN;
        AttributeStreamOfInt32 bunch = new AttributeStreamOfInt32(0);
        bunch.reserve(10);
        this.m_xyToNode1 = new AttributeStreamOfInt32(pointCount, Treap.nullNode());
        this.m_xyToNode2 = new AttributeStreamOfInt32(pointCount, Treap.nullNode());
        if (this.m_FreeEdges != null) {
            this.m_FreeEdges.clear(false);
        } else {
            this.m_FreeEdges = new AttributeStreamOfInt32(0);
        }
        this.m_FreeEdges.reserve(10);
        this.m_AET.clear();
        this.m_AET.setComparator(new RingOrientationTestComparator(this));
        int n2 = pointCount * 2;
        for (int index = 0; this.m_unknownOrientationPathCount > 0 && index < n2; ++index) {
            int pairIndex = this.m_pairIndices.get(index);
            int pair = this.m_pairs.get(pairIndex);
            if ((pair & 1) != 0) continue;
            int xyindex = pair >> 1;
            double y = this.m_xy.read(2 * xyindex + 1);
            if (y != this.m_yScanline && bunch.size() != 0) {
                if (!this.processBunchForRingOrientationTest_(bunch)) {
                    return 0;
                }
                if (bunch != null) {
                    bunch.clear(false);
                }
            }
            bunch.add(xyindex);
            this.m_yScanline = y;
        }
        if (this.m_unknownOrientationPathCount > 0 && !this.processBunchForRingOrientationTest_(bunch)) {
            return 0;
        }
        if (this.m_bOGCRestrictions) {
            if (this.m_nonSimpleResult.m_reason != NonSimpleResult.Reason.NotDetermined) {
                return 0;
            }
            if (!this.check_self_intersections_polygons_OGC_()) {
                return 0;
            }
            return 2;
        }
        if (this.m_nonSimpleResult.m_reason == NonSimpleResult.Reason.NotDetermined) {
            return 2;
        }
        return 1;
    }

    private boolean processBunchForSelfIntersectionTest_(AttributeStreamOfInt32 bunch) {
        assert (bunch.size() > 0);
        if (bunch.size() == 1) {
            return true;
        }
        assert (this.m_edges.size() == 0);
        int n = bunch.size();
        for (int i = 0; i < n; ++i) {
            int xyindex = bunch.get(i);
            this.m_recycledSegIter.resetToVertex(xyindex);
            Segment seg1 = this.m_recycledSegIter.previousSegment();
            this.m_edges.add(this.createEdge_(seg1, xyindex, this.m_recycledSegIter.getPathIndex(), true));
            this.m_recycledSegIter.nextSegment();
            Segment seg2 = this.m_recycledSegIter.nextSegment();
            this.m_edges.add(this.createEdge_(seg2, xyindex, this.m_recycledSegIter.getPathIndex(), false));
        }
        assert ((this.m_edges.size() & 1) == 0);
        Collections.sort(this.m_edges, new EdgeComparerForSelfIntersection(this));
        int list = this.m_crossOverHelperList.getFirstList();
        if (list == -1) {
            list = this.m_crossOverHelperList.createList(0);
        }
        this.m_crossOverHelperList.reserveNodes(this.m_edges.size());
        int n2 = this.m_edges.size();
        for (int i = 0; i < n2; ++i) {
            this.m_crossOverHelperList.addElement(list, i);
        }
        boolean bContinue = true;
        int i1 = -1;
        int i2 = -1;
        block2: while (bContinue) {
            bContinue = false;
            int listnode = this.m_crossOverHelperList.getFirst(list);
            if (listnode == -1) break;
            int nextnode = this.m_crossOverHelperList.getNext(listnode);
            while (nextnode != -1) {
                int edgeindex1 = this.m_crossOverHelperList.getData(listnode);
                int edgeindex2 = this.m_crossOverHelperList.getData(nextnode);
                i1 = this.m_edges.get((int)edgeindex1).m_vertexIndex;
                i2 = this.m_edges.get((int)edgeindex2).m_vertexIndex;
                if (i1 == i2) {
                    bContinue = true;
                    this.m_crossOverHelperList.deleteElement(list, listnode);
                    listnode = this.m_crossOverHelperList.getPrev(nextnode);
                    if ((nextnode = this.m_crossOverHelperList.deleteElement(list, nextnode)) != -1 && listnode != -1) continue;
                    continue block2;
                }
                listnode = nextnode;
                nextnode = this.m_crossOverHelperList.getNext(listnode);
            }
        }
        int listSize = this.m_crossOverHelperList.getListSize(list);
        this.m_crossOverHelperList.clear(list);
        if (listSize > 0) {
            this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.CrossOver, i1, i2);
            return false;
        }
        int n3 = bunch.size();
        for (int i = 0; i < n3; ++i) {
            this.recycleEdge_(this.m_edges.get(i));
        }
        this.m_edges.clear();
        return true;
    }

    private boolean processBunchForRingOrientationTest_(AttributeStreamOfInt32 bunch) {
        int xyindex;
        int i;
        ++this.m_dbgCounter;
        assert (bunch.size() > 0);
        int n = bunch.size();
        for (i = 0; i < n; ++i) {
            int edgeIndex;
            xyindex = bunch.get(i);
            int aetNode = this.m_xyToNode1.read(xyindex);
            if (aetNode != Treap.nullNode()) {
                edgeIndex = this.m_AET.getElement(aetNode);
                this.m_FreeEdges.add(edgeIndex);
                this.m_AET.deleteNode(aetNode, -1);
                this.recycleEdge_(this.m_edges.get(edgeIndex));
                this.m_edges.set(edgeIndex, null);
                this.m_xyToNode1.write(xyindex, Treap.nullNode());
            }
            if ((aetNode = this.m_xyToNode2.read(xyindex)) == Treap.nullNode()) continue;
            edgeIndex = this.m_AET.getElement(aetNode);
            this.m_FreeEdges.add(edgeIndex);
            this.m_AET.deleteNode(aetNode, -1);
            this.recycleEdge_(this.m_edges.get(edgeIndex));
            this.m_edges.set(edgeIndex, null);
            this.m_xyToNode2.write(xyindex, Treap.nullNode());
        }
        n = bunch.size();
        for (i = 0; i < n; ++i) {
            int edgeIndex;
            xyindex = bunch.get(i);
            this.m_recycledSegIter.resetToVertex(xyindex);
            Segment seg1 = this.m_recycledSegIter.previousSegment();
            if (seg1.getStartY() > seg1.getEndY()) {
                int edgeIndex2;
                int edgeTopIndex = this.m_recycledSegIter.getStartPointIndex();
                Edge edge = this.createEdge_(seg1, xyindex, this.m_recycledSegIter.getPathIndex(), true);
                if (this.m_FreeEdges.size() > 0) {
                    edgeIndex2 = this.m_FreeEdges.getLast();
                    this.m_FreeEdges.removeLast();
                    this.m_edges.set(edgeIndex2, edge);
                } else {
                    edgeIndex2 = this.m_edges.size();
                    this.m_edges.add(edge);
                }
                int aetNode = this.m_AET.addElement(edgeIndex2, -1);
                if (this.m_xyToNode1.read(edgeTopIndex) == Treap.nullNode()) {
                    this.m_xyToNode1.write(edgeTopIndex, aetNode);
                } else {
                    assert (this.m_xyToNode2.read(edgeTopIndex) == Treap.nullNode());
                    this.m_xyToNode2.write(edgeTopIndex, aetNode);
                }
                if ((this.m_pathOrientations.read(this.m_recycledSegIter.getPathIndex()) & 3) == 0) {
                    this.m_newEdges.add(aetNode);
                }
            }
            this.m_recycledSegIter.nextSegment();
            Segment seg2 = this.m_recycledSegIter.nextSegment();
            if (!(seg2.getStartY() < seg2.getEndY())) continue;
            int edgeTopIndex = this.m_recycledSegIter.getEndPointIndex();
            Edge edge = this.createEdge_(seg2, xyindex, this.m_recycledSegIter.getPathIndex(), false);
            if (this.m_FreeEdges.size() > 0) {
                edgeIndex = this.m_FreeEdges.getLast();
                this.m_FreeEdges.removeLast();
                this.m_edges.set(edgeIndex, edge);
            } else {
                edgeIndex = this.m_edges.size();
                this.m_edges.add(edge);
            }
            int aetNode = this.m_AET.addElement(edgeIndex, -1);
            if (this.m_xyToNode1.read(edgeTopIndex) == Treap.nullNode()) {
                this.m_xyToNode1.write(edgeTopIndex, aetNode);
            } else {
                assert (this.m_xyToNode2.read(edgeTopIndex) == Treap.nullNode());
                this.m_xyToNode2.write(edgeTopIndex, aetNode);
            }
            if ((this.m_pathOrientations.read(this.m_recycledSegIter.getPathIndex()) & 3) != 0) continue;
            this.m_newEdges.add(aetNode);
        }
        n = this.m_newEdges.size();
        for (i = 0; i < n && this.m_unknownOrientationPathCount > 0; ++i) {
            int aetNode = this.m_newEdges.get(i);
            int edgeIndexInitial = this.m_AET.getElement(aetNode);
            Edge edgeInitial = this.m_edges.get(edgeIndexInitial);
            int pathIndexInitial = edgeInitial.m_pathIndex;
            int directionInitial = this.m_pathOrientations.read(pathIndexInitial);
            if ((directionInitial & 3) != 0) continue;
            int prevExteriorPath = -1;
            int node = this.m_AET.getPrev(aetNode);
            int prevNode = aetNode;
            int oddEven = 0;
            int edgeIndex = -1;
            Edge edge = null;
            int pathIndex = -1;
            int dir = 0;
            while (node != Treap.nullNode()) {
                edgeIndex = this.m_AET.getElement(node);
                edge = this.m_edges.get(edgeIndex);
                pathIndex = edge.m_pathIndex;
                dir = this.m_pathOrientations.read(pathIndex);
                if ((dir & 3) != 0) break;
                prevNode = node;
                node = this.m_AET.getPrev(node);
            }
            if (node == Treap.nullNode()) {
                oddEven = 1;
                node = prevNode;
            } else {
                prevExteriorPath = (dir & 3) == 1 ? pathIndex : this.m_pathParentage.read(pathIndex);
                oddEven = edge.getRightSide() != 0 ? 0 : 1;
                node = this.m_AET.getNext(node);
            }
            do {
                edgeIndex = this.m_AET.getElement(node);
                edge = this.m_edges.get(edgeIndex);
                pathIndex = edge.m_pathIndex;
                int direction = this.m_pathOrientations.read(pathIndex);
                if ((direction & 3) == 0) {
                    int parent;
                    if (oddEven != edge.getRightSide()) {
                        this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.RingOrientation, pathIndex, -1);
                        return false;
                    }
                    int dir2 = oddEven != 0 && !edge.getReversed() ? 1 : 2;
                    direction = direction & 0xFC | dir2;
                    this.m_pathOrientations.write(pathIndex, dir2);
                    if (dir2 == 2 && this.m_nonSimpleResult.m_reason == NonSimpleResult.Reason.NotDetermined && (parent = this.m_pathParentage.read(pathIndex)) != prevExteriorPath) {
                        this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.RingOrder, pathIndex, -1);
                        if (this.m_bOGCRestrictions) {
                            return false;
                        }
                    }
                    --this.m_unknownOrientationPathCount;
                    if (this.m_unknownOrientationPathCount == 0) {
                        return true;
                    }
                }
                if ((direction & 3) == 1) {
                    prevExteriorPath = pathIndex;
                }
                prevNode = node;
                node = this.m_AET.getNext(node);
                int n2 = oddEven = oddEven != 0 ? 0 : 1;
            } while (prevNode != aetNode);
        }
        if (this.m_newEdges != null) {
            this.m_newEdges.clear(false);
        } else {
            this.m_newEdges = new AttributeStreamOfInt32(0);
        }
        return true;
    }

    private Edge createEdge_(Segment seg, int xyindex, int pathIndex, boolean bReversed) {
        Geometry.Type gt = seg.getType();
        if (gt != Geometry.Type.Line) {
            throw GeometryException.GeometryInternalError();
        }
        Edge edge = this.createEdgeLine_(seg);
        edge.m_vertexIndex = xyindex;
        edge.m_pathIndex = pathIndex;
        edge.m_flags = 0;
        edge.setReversed(bReversed);
        return edge;
    }

    private Edge createEdgeLine_(Segment seg) {
        Edge edge = null;
        if (this.m_lineEdgesRecycle.size() > 0) {
            int indexLast = this.m_lineEdgesRecycle.size() - 1;
            edge = this.m_lineEdgesRecycle.get(indexLast);
            this.m_lineEdgesRecycle.remove(indexLast);
            seg.copyTo(edge.m_segment);
        } else {
            edge = new Edge();
            edge.m_segment = (Segment)Segment._clone(seg);
        }
        return edge;
    }

    private void recycleEdge_(Edge edge) {
        Geometry.Type gt = edge.m_segment.getType();
        if (gt == Geometry.Type.Line) {
            this.m_lineEdgesRecycle.add(edge);
        }
    }

    int multiPointIsSimpleAsFeature_() {
        int i;
        MultiVertexGeometryImpl multiVertexImpl = (MultiVertexGeometryImpl)this.m_geometry._getImpl();
        int pointCount = multiVertexImpl.getPointCount();
        AttributeStreamOfInt32 indices = new AttributeStreamOfInt32(0);
        for (i = 0; i < pointCount; ++i) {
            indices.add(i);
        }
        indices.Sort(0, pointCount, new MultiPointVertexComparer(this));
        for (i = 1; i < pointCount; ++i) {
            if (this.compareVerticesMultiPoint_(indices.get(i - 1), indices.get(i)) != 0) continue;
            this.m_nonSimpleResult = new NonSimpleResult(NonSimpleResult.Reason.Clustering, indices.get(i - 1), indices.get(i));
            return 0;
        }
        return 2;
    }

    int polylineIsSimpleAsFeature_() {
        if (!this.checkStructure_()) {
            return 0;
        }
        return this.checkDegenerateSegments_(true) ? 2 : 0;
    }

    int polygonIsSimpleAsFeature_() {
        return this.isSimplePlanarImpl_();
    }

    MultiPoint multiPointSimplifyAsFeature_() {
        MultiVertexGeometryImpl multiVertexImpl = (MultiVertexGeometryImpl)this.m_geometry._getImpl();
        int pointCount = multiVertexImpl.getPointCount();
        assert (pointCount > 0);
        AttributeStreamOfInt32 indices = new AttributeStreamOfInt32(0);
        for (int i = 0; i < pointCount; ++i) {
            indices.add(i);
        }
        indices.Sort(0, pointCount, new MultiPointVertexComparer2(this));
        boolean[] indicesOut = new boolean[pointCount];
        indicesOut[indices.get((int)0)] = true;
        for (int i = 1; i < pointCount; ++i) {
            int ind2;
            int ind1 = indices.get(i - 1);
            indicesOut[ind2] = this.compareVerticesMultiPoint_(ind1, ind2 = indices.get(i)) != 0;
        }
        MultiPoint dst = (MultiPoint)this.m_geometry.createInstance();
        MultiPoint src = (MultiPoint)this.m_geometry;
        int istart = 0;
        int iend = 1;
        for (int i = 0; i < pointCount; ++i) {
            if (indicesOut[i]) {
                iend = i + 1;
                continue;
            }
            if (istart < iend) {
                dst.add(src, istart, iend);
            }
            istart = i + 1;
        }
        if (istart < iend) {
            dst.add(src, istart, iend);
        }
        ((MultiVertexGeometryImpl)dst._getImpl()).setIsSimple(2, this.m_toleranceSimplify, false);
        return dst;
    }

    Polyline polylineSimplifyAsFeature_() {
        MultiPathImpl multiPathImpl = (MultiPathImpl)this.m_geometry._getImpl();
        SegmentIteratorImpl segIterFwd = multiPathImpl.querySegmentIterator();
        SegmentIteratorImpl segIterBwd = multiPathImpl.querySegmentIterator();
        Polyline dst = (Polyline)this.m_geometry.createInstance();
        Polyline src = (Polyline)this.m_geometry;
        boolean bHasZ = multiPathImpl.hasAttribute(1);
        double ztolerance = !bHasZ ? 0.0 : InternalUtils.calculateZToleranceFromGeometry(this.m_sr, multiPathImpl, true);
        AttributeStreamOfInt32 fwdStack = new AttributeStreamOfInt32(0);
        AttributeStreamOfInt32 bwdStack = new AttributeStreamOfInt32(0);
        fwdStack.reserve(multiPathImpl.getPointCount() / 2 + 1);
        bwdStack.reserve(multiPathImpl.getPointCount() / 2 + 1);
        while (segIterFwd.nextPath()) {
            segIterBwd.nextPath();
            if (multiPathImpl.getPathSize(segIterFwd.getPathIndex()) < 2) continue;
            segIterBwd.resetToLastSegment();
            double lengthFwd = 0.0;
            double lengthBwd = 0.0;
            boolean bFirst = true;
            while (segIterFwd.hasNextSegment()) {
                Point2D pt;
                int idx2;
                assert (segIterBwd.hasPreviousSegment());
                Segment segFwd = segIterFwd.nextSegment();
                Segment segBwd = segIterBwd.previousSegment();
                int idx1 = segIterFwd.getStartPointIndex();
                if (idx1 > (idx2 = segIterBwd.getStartPointIndex())) break;
                if (bFirst) {
                    fwdStack.add(segIterFwd.getStartPointIndex());
                    bwdStack.add(segIterBwd.getEndPointIndex());
                    bFirst = false;
                }
                int index0 = fwdStack.getLast();
                int index1 = segIterFwd.getEndPointIndex();
                if (index1 - index0 > 1) {
                    pt = new Point2D();
                    pt.sub(multiPathImpl.getXY(index0), multiPathImpl.getXY(index1));
                    lengthFwd = pt.length();
                } else {
                    lengthFwd = segFwd.calculateLength2D();
                }
                index0 = bwdStack.getLast();
                index1 = segIterBwd.getStartPointIndex();
                if (index1 - index0 > 1) {
                    pt = new Point2D();
                    pt.sub(multiPathImpl.getXY(index0), multiPathImpl.getXY(index1));
                    lengthBwd = pt.length();
                } else {
                    lengthBwd = segBwd.calculateLength2D();
                }
                if (lengthFwd > this.m_toleranceSimplify) {
                    fwdStack.add(segIterFwd.getEndPointIndex());
                    lengthFwd = 0.0;
                } else if (bHasZ) {
                    double z0 = multiPathImpl.getAttributeAsDbl(1, fwdStack.getLast(), 0);
                    double z1 = segFwd.getEndAttributeAsDbl(1, 0);
                    if (Math.abs(z1 - z0) > ztolerance) {
                        fwdStack.add(segIterFwd.getEndPointIndex());
                        lengthFwd = 0.0;
                    }
                }
                if (lengthBwd > this.m_toleranceSimplify) {
                    bwdStack.add(segIterBwd.getStartPointIndex());
                    lengthBwd = 0.0;
                    continue;
                }
                if (!bHasZ) continue;
                double z0 = multiPathImpl.getAttributeAsDbl(1, bwdStack.getLast(), 0);
                double z1 = segBwd.getEndAttributeAsDbl(1, 0);
                if (!(Math.abs(z1 - z0) > ztolerance)) continue;
                bwdStack.add(segIterBwd.getStartPointIndex());
                lengthBwd = 0.0;
            }
            if (fwdStack.getLast() < bwdStack.getLast()) {
                if (fwdStack.size() > bwdStack.size()) {
                    fwdStack.removeLast();
                } else {
                    bwdStack.removeLast();
                }
            } else if (fwdStack.getLast() == bwdStack.getLast()) {
                bwdStack.removeLast();
            } else {
                assert (fwdStack.getLast() - bwdStack.getLast() == 1);
                bwdStack.removeLast();
                bwdStack.removeLast();
            }
            if (bwdStack.size() + fwdStack.size() >= 2) {
                int i;
                Point point = new Point();
                int n = fwdStack.size();
                for (i = 0; i < n; ++i) {
                    src.getPointByVal(fwdStack.get(i), point);
                    if (i == 0) {
                        dst.startPath(point);
                        continue;
                    }
                    dst.lineTo(point);
                }
                for (i = bwdStack.size() - 1; i > 0; --i) {
                    src.getPointByVal(bwdStack.get(i), point);
                    dst.lineTo(point);
                }
                if (src.isClosedPath(segIterFwd.getPathIndex())) {
                    dst.closePathWithLine();
                } else if (bwdStack.size() > 0) {
                    src.getPointByVal(bwdStack.get(0), point);
                    dst.lineTo(point);
                }
            }
            if (fwdStack != null) {
                fwdStack.clear(false);
            }
            if (bwdStack == null) continue;
            bwdStack.clear(false);
        }
        ((MultiVertexGeometryImpl)dst._getImpl()).setIsSimple(2, this.m_toleranceSimplify, false);
        return dst;
    }

    Polygon polygonSimplifyAsFeature_() {
        return (Polygon)this.simplifyPlanar_();
    }

    MultiVertexGeometry simplifyPlanar_() {
        if (this.m_geometry.getType() == Geometry.Type.Polygon && ((Polygon)this.m_geometry).getFillRule() == 1) {
            return TopologicalOperations.planarSimplify((MultiVertexGeometry)this.m_geometry, this.m_toleranceSimplify, true, false, this.m_progressTracker);
        }
        this.m_editShape = new EditShape();
        this.m_editShape.addGeometry(this.m_geometry);
        if (this.m_editShape.getTotalPointCount() != 0) {
            assert (this.m_knownSimpleResult != 2);
            if (this.m_knownSimpleResult != 1) {
                CrackAndCluster.execute(this.m_editShape, this.m_toleranceSimplify, this.m_progressTracker, true);
            }
            if (this.m_geometry.getType().equals((Object)Geometry.Type.Polygon)) {
                Simplificator.execute(this.m_editShape, this.m_editShape.getFirstGeometry(), this.m_knownSimpleResult, false, this.m_progressTracker);
            }
        }
        this.m_geometry = this.m_editShape.getGeometry(this.m_editShape.getFirstGeometry());
        if (this.m_geometry.getType().equals((Object)Geometry.Type.Polygon)) {
            ((MultiPathImpl)this.m_geometry._getImpl())._updateOGCFlags();
            ((Polygon)this.m_geometry).setFillRule(0);
        }
        ((MultiVertexGeometryImpl)this.m_geometry._getImpl()).setIsSimple(2, this.m_toleranceSimplify, false);
        return (MultiVertexGeometry)this.m_geometry;
    }

    OperatorSimplifyLocalHelper(Geometry geometry, SpatialReference spatialReference, int knownSimpleResult, ProgressTracker progressTracker, boolean bOGCRestrictions) {
        this.m_description = geometry.getDescription();
        this.m_geometry = geometry;
        this.m_sr = (SpatialReferenceImpl)spatialReference;
        this.m_dbgCounter = 0;
        this.m_toleranceIsSimple = InternalUtils.calculateToleranceFromGeometry((SpatialReference)this.m_sr, geometry, false);
        this.m_toleranceSimplify = InternalUtils.calculateToleranceFromGeometry((SpatialReference)this.m_sr, geometry, true);
        this.m_knownSimpleResult = knownSimpleResult;
        this.m_attributeCount = this.m_description.getAttributeCount();
        this.m_edges = new ArrayList();
        this.m_lineEdgesRecycle = new ArrayList();
        this.m_crossOverHelperList = new IndexMultiDCList();
        this.m_AET = new Treap();
        this.m_nonSimpleResult = new NonSimpleResult();
        this.m_bPlanarSimplify = this.m_bOGCRestrictions = bOGCRestrictions;
    }

    protected static int isSimplePlanar(Geometry geometry, SpatialReference spatialReference, boolean bForce, ProgressTracker progressTracker) {
        int knownSimpleResult;
        assert (false);
        if (geometry.isEmpty()) {
            return 1;
        }
        Geometry.Type gt = geometry.getType();
        if (gt == Geometry.Type.Point) {
            return 1;
        }
        if (gt == Geometry.Type.Envelope) {
            Envelope2D env2D = new Envelope2D();
            geometry.queryEnvelope2D(env2D);
            boolean bReturnValue = !env2D.isDegenerate(InternalUtils.calculateToleranceFromGeometry(spatialReference, geometry, false));
            return bReturnValue ? 1 : 0;
        }
        if (Geometry.isSegment(gt.value())) {
            throw GeometryException.GeometryInternalError();
        }
        if (!Geometry.isMultiVertex(gt.value())) {
            throw GeometryException.GeometryInternalError();
        }
        double tolerance = InternalUtils.calculateToleranceFromGeometry(spatialReference, geometry, false);
        double geomTolerance = 0.0;
        int isSimple = ((MultiVertexGeometryImpl)geometry._getImpl()).getIsSimple(tolerance);
        int n = knownSimpleResult = bForce ? -1 : isSimple;
        if (knownSimpleResult != -1) {
            return knownSimpleResult;
        }
        if (knownSimpleResult == 1) {
            assert (tolerance <= geomTolerance);
            tolerance = geomTolerance;
        }
        OperatorSimplifyLocalHelper helper = new OperatorSimplifyLocalHelper(geometry, spatialReference, knownSimpleResult, progressTracker, false);
        knownSimpleResult = helper.isSimplePlanarImpl_();
        ((MultiVertexGeometryImpl)geometry._getImpl()).setIsSimple(knownSimpleResult, tolerance, false);
        return knownSimpleResult;
    }

    protected static int isSimpleAsFeature(Geometry geometry, SpatialReference spatialReference, boolean bForce, NonSimpleResult result, ProgressTracker progressTracker) {
        int knownSimpleResult;
        if (result != null) {
            result.m_reason = NonSimpleResult.Reason.NotDetermined;
            result.m_vertexIndex1 = -1;
            result.m_vertexIndex2 = -1;
        }
        if (geometry.isEmpty()) {
            return 1;
        }
        Geometry.Type gt = geometry.getType();
        if (gt == Geometry.Type.Point) {
            return 1;
        }
        double tolerance = InternalUtils.calculateToleranceFromGeometry(spatialReference, geometry, false);
        if (gt == Geometry.Type.Envelope) {
            Envelope env = (Envelope)geometry;
            Envelope2D env2D = new Envelope2D();
            env.queryEnvelope2D(env2D);
            if (env2D.isDegenerate(tolerance)) {
                if (result != null) {
                    result.m_reason = NonSimpleResult.Reason.DegenerateSegments;
                    result.m_vertexIndex1 = -1;
                    result.m_vertexIndex2 = -1;
                }
                return 0;
            }
            return 1;
        }
        if (Geometry.isSegment(gt.value())) {
            Segment seg = (Segment)geometry;
            Polyline polyline = new Polyline(seg.getDescription());
            polyline.addSegment(seg, true);
            return OperatorSimplifyLocalHelper.isSimpleAsFeature(polyline, spatialReference, bForce, result, progressTracker);
        }
        int isSimple = ((MultiVertexGeometryImpl)geometry._getImpl()).getIsSimple(tolerance);
        int n = knownSimpleResult = bForce ? -1 : isSimple;
        if (knownSimpleResult != -1) {
            return knownSimpleResult;
        }
        OperatorSimplifyLocalHelper helper = new OperatorSimplifyLocalHelper(geometry, spatialReference, knownSimpleResult, progressTracker, false);
        if (gt == Geometry.Type.MultiPoint) {
            knownSimpleResult = helper.multiPointIsSimpleAsFeature_();
        } else if (gt == Geometry.Type.Polyline) {
            knownSimpleResult = helper.polylineIsSimpleAsFeature_();
        } else if (gt == Geometry.Type.Polygon) {
            knownSimpleResult = helper.polygonIsSimpleAsFeature_();
        } else {
            throw GeometryException.GeometryInternalError();
        }
        ((MultiVertexGeometryImpl)geometry._getImpl()).setIsSimple(knownSimpleResult, tolerance, false);
        if (result != null && knownSimpleResult == 0) {
            result.Assign(helper.m_nonSimpleResult);
        }
        return knownSimpleResult;
    }

    static int isSimpleOGC(Geometry geometry, SpatialReference spatialReference, boolean bForce, NonSimpleResult result, ProgressTracker progressTracker) {
        if (result != null) {
            result.m_reason = NonSimpleResult.Reason.NotDetermined;
            result.m_vertexIndex1 = -1;
            result.m_vertexIndex2 = -1;
        }
        if (geometry.isEmpty()) {
            return 1;
        }
        Geometry.Type gt = geometry.getType();
        if (gt == Geometry.Type.Point) {
            return 1;
        }
        double tolerance = InternalUtils.calculateToleranceFromGeometry(spatialReference, geometry, false);
        if (gt == Geometry.Type.Envelope) {
            Envelope env = (Envelope)geometry;
            Envelope2D env2D = new Envelope2D();
            env.queryEnvelope2D(env2D);
            if (env2D.isDegenerate(tolerance)) {
                if (result != null) {
                    result.m_reason = NonSimpleResult.Reason.DegenerateSegments;
                    result.m_vertexIndex1 = -1;
                    result.m_vertexIndex2 = -1;
                }
                return 0;
            }
            return 1;
        }
        if (Geometry.isSegment(gt.value())) {
            Segment seg = (Segment)geometry;
            Polyline polyline = new Polyline(seg.getDescription());
            polyline.addSegment(seg, true);
            return OperatorSimplifyLocalHelper.isSimpleAsFeature(polyline, spatialReference, bForce, result, progressTracker);
        }
        int knownSimpleResult = -1;
        OperatorSimplifyLocalHelper helper = new OperatorSimplifyLocalHelper(geometry, spatialReference, knownSimpleResult, progressTracker, true);
        if (gt != Geometry.Type.MultiPoint && gt != Geometry.Type.Polyline && gt != Geometry.Type.Polygon) {
            throw GeometryException.GeometryInternalError();
        }
        knownSimpleResult = helper.isSimplePlanarImpl_();
        if (result != null) {
            result.Assign(helper.m_nonSimpleResult);
        }
        return knownSimpleResult;
    }

    protected static Geometry simplifyAsFeature(Geometry geometry, SpatialReference spatialReference, boolean bForce, ProgressTracker progressTracker) {
        MultiVertexGeometry result;
        int knownSimpleResult;
        if (geometry.isEmpty()) {
            return geometry;
        }
        Geometry.Type gt = geometry.getType();
        if (gt == Geometry.Type.Point) {
            return geometry;
        }
        double tolerance = InternalUtils.calculateToleranceFromGeometry(spatialReference, geometry, false);
        if (gt == Geometry.Type.Envelope) {
            Envelope env = (Envelope)geometry;
            Envelope2D env2D = new Envelope2D();
            env.queryEnvelope2D(env2D);
            if (env2D.isDegenerate(tolerance)) {
                return env.createInstance();
            }
            return geometry;
        }
        if (Geometry.isSegment(gt.value())) {
            Segment seg = (Segment)geometry;
            Polyline polyline = new Polyline(seg.getDescription());
            polyline.addSegment(seg, true);
            return OperatorSimplifyLocalHelper.simplifyAsFeature(polyline, spatialReference, bForce, progressTracker);
        }
        double geomTolerance = 0.0;
        int isSimple = ((MultiVertexGeometryImpl)geometry._getImpl()).getIsSimple(tolerance);
        int n = knownSimpleResult = bForce ? -1 : isSimple;
        if (knownSimpleResult == 2) {
            if (gt == Geometry.Type.Polygon && ((Polygon)geometry).getFillRule() != 0) {
                Geometry res = geometry.copy();
                ((Polygon)res).setFillRule(0);
                return res;
            }
            return geometry;
        }
        OperatorSimplifyLocalHelper helper = new OperatorSimplifyLocalHelper(geometry, spatialReference, knownSimpleResult, progressTracker, false);
        if (gt == Geometry.Type.MultiPoint) {
            result = helper.multiPointSimplifyAsFeature_();
        } else if (gt == Geometry.Type.Polyline) {
            result = helper.polylineSimplifyAsFeature_();
        } else if (gt == Geometry.Type.Polygon) {
            result = helper.polygonSimplifyAsFeature_();
        } else {
            throw GeometryException.GeometryInternalError();
        }
        return result;
    }

    static Geometry simplifyOGC(Geometry geometry, SpatialReference spatialReference, boolean bForce, ProgressTracker progressTracker) {
        if (geometry.isEmpty()) {
            return geometry;
        }
        Geometry.Type gt = geometry.getType();
        if (gt == Geometry.Type.Point) {
            return geometry;
        }
        double tolerance = InternalUtils.calculateToleranceFromGeometry(spatialReference, geometry, false);
        if (gt == Geometry.Type.Envelope) {
            Envelope env = (Envelope)geometry;
            Envelope2D env2D = new Envelope2D();
            env.queryEnvelope2D(env2D);
            if (env2D.isDegenerate(tolerance)) {
                return env.createInstance();
            }
            return geometry;
        }
        if (Geometry.isSegment(gt.value())) {
            Segment seg = (Segment)geometry;
            Polyline polyline = new Polyline(seg.getDescription());
            polyline.addSegment(seg, true);
            return OperatorSimplifyLocalHelper.simplifyOGC(polyline, spatialReference, bForce, progressTracker);
        }
        if (!Geometry.isMultiVertex(gt.value())) {
            throw new GeometryException("OGC simplify is not implemented for this geometry type" + (Object)((Object)gt));
        }
        MultiVertexGeometry result = TopologicalOperations.simplifyOGC((MultiVertexGeometry)geometry, tolerance, false, progressTracker);
        return result;
    }

    private int compareVertices_(int i1, int i2, boolean get_paths) {
        if (i1 == i2) {
            return 0;
        }
        int pair1 = this.m_pairs.get(i1);
        int pair2 = this.m_pairs.get(i2);
        int xy1 = pair1 >> 1;
        int xy2 = pair2 >> 1;
        Point2D pt1 = new Point2D();
        Point2D pt2 = new Point2D();
        this.m_xy.read(2 * xy1, pt1);
        pt1.y = pt1.y + ((pair1 & 1) != 0 ? this.m_toleranceIsSimple : -this.m_toleranceIsSimple);
        this.m_xy.read(2 * xy2, pt2);
        pt2.y = pt2.y + ((pair2 & 1) != 0 ? this.m_toleranceIsSimple : -this.m_toleranceIsSimple);
        int res = pt1.compare(pt2);
        if (res == 0 && get_paths) {
            int di = this.m_paths_for_OGC_tests.get(xy1) - this.m_paths_for_OGC_tests.get(xy2);
            return di < 0 ? -1 : (di > 0 ? 1 : 0);
        }
        return res;
    }

    private int compareVerticesMultiPoint_(int i1, int i2) {
        if (i1 == i2) {
            return 0;
        }
        MultiVertexGeometryImpl multiVertexImpl = (MultiVertexGeometryImpl)this.m_geometry._getImpl();
        Point2D pt1 = multiVertexImpl.getXY(i1);
        Point2D pt2 = multiVertexImpl.getXY(i2);
        if (pt1.x < pt2.x) {
            return -1;
        }
        if (pt1.x > pt2.x) {
            return 1;
        }
        if (pt1.y < pt2.y) {
            return -1;
        }
        if (pt1.y > pt2.y) {
            return 1;
        }
        for (int attrib = 1; attrib < this.m_attributeCount; ++attrib) {
            int semantics = this.m_description.getSemantics(attrib);
            int nords = VertexDescription.getComponentCount(semantics);
            for (int ord = 0; ord < nords; ++ord) {
                double v2;
                double v1 = multiVertexImpl.getAttributeAsDbl(semantics, i1, ord);
                if (v1 < (v2 = multiVertexImpl.getAttributeAsDbl(semantics, i2, ord))) {
                    return -1;
                }
                if (!(v1 > v2)) continue;
                return 1;
            }
        }
        return 0;
    }

    private int compareVerticesMultiPoint2_(int i1, int i2) {
        int res = this.compareVerticesMultiPoint_(i1, i2);
        if (res == 0) {
            return i1 < i2 ? -1 : 1;
        }
        return res;
    }

    private int edgeAngleCompare_(Edge edge1, Edge edge2) {
        if (edge1.equals(edge2)) {
            return 0;
        }
        Point2D v1 = edge1.m_segment._getTangent(edge1.getReversed() ? 1.0 : 0.0);
        if (edge1.getReversed()) {
            v1.negate();
        }
        Point2D v2 = edge2.m_segment._getTangent(edge2.getReversed() ? 1.0 : 0.0);
        if (edge2.getReversed()) {
            v2.negate();
        }
        int q1 = v1._getQuarter();
        int q2 = v2._getQuarter();
        if (q2 == q1) {
            double cross = v1.crossProduct(v2);
            double crossError = 4.0 * NumberUtils.doubleEps() * (Math.abs(v2.x * v1.y) + Math.abs(v2.y * v1.x));
            if (Math.abs(cross) <= crossError) {
                cross -= 1.0;
                cross += 1.0;
            }
            assert (Math.abs(cross) > crossError);
            return cross < 0.0 ? 1 : (cross > 0.0 ? -1 : 0);
        }
        return q1 < q2 ? -1 : 1;
    }

    private static final class MultiPointVertexComparer2
    extends AttributeStreamOfInt32.IntComparator {
        OperatorSimplifyLocalHelper parent;

        MultiPointVertexComparer2(OperatorSimplifyLocalHelper parent_) {
            this.parent = parent_;
        }

        @Override
        public int compare(int i1, int i2) {
            return this.parent.compareVerticesMultiPoint2_(i1, i2);
        }
    }

    private static final class MultiPointVertexComparer
    extends AttributeStreamOfInt32.IntComparator {
        OperatorSimplifyLocalHelper parent;

        MultiPointVertexComparer(OperatorSimplifyLocalHelper parent_) {
            this.parent = parent_;
        }

        @Override
        public int compare(int i1, int i2) {
            return this.parent.compareVerticesMultiPoint_(i1, i2);
        }
    }

    private static final class EdgeComparerForSelfIntersection
    implements Comparator<Edge> {
        OperatorSimplifyLocalHelper parent;

        EdgeComparerForSelfIntersection(OperatorSimplifyLocalHelper parent_) {
            this.parent = parent_;
        }

        @Override
        public int compare(Edge e1, Edge e2) {
            return this.parent.edgeAngleCompare_(e1, e2);
        }
    }

    private static final class IndexSorter
    extends ClassicSort {
        OperatorSimplifyLocalHelper parent;
        private boolean get_paths;
        private Point2D pt1_dummy = new Point2D();

        IndexSorter(OperatorSimplifyLocalHelper parent_, boolean get_paths_) {
            this.parent = parent_;
            this.get_paths = get_paths_;
        }

        @Override
        public void userSort(int begin, int end, AttributeStreamOfInt32 indices) {
            indices.Sort(begin, end, new VertexComparer(this.parent, this.get_paths));
        }

        @Override
        public double getValue(int index) {
            int pair = this.parent.m_pairs.get(index);
            int xy1 = pair >> 1;
            this.parent.m_xy.read(2 * xy1, this.pt1_dummy);
            double y = this.pt1_dummy.y + ((pair & 1) != 0 ? this.parent.m_toleranceIsSimple : -this.parent.m_toleranceIsSimple);
            return y;
        }
    }

    private static final class VertexComparer
    extends AttributeStreamOfInt32.IntComparator {
        OperatorSimplifyLocalHelper parent;
        boolean get_paths;

        VertexComparer(OperatorSimplifyLocalHelper parent_, boolean get_paths_) {
            this.parent = parent_;
            this.get_paths = get_paths_;
        }

        @Override
        public int compare(int i1, int i2) {
            return this.parent.compareVertices_(i1, i2, this.get_paths);
        }
    }

    private static final class RingOrientationTestComparator
    extends Treap.Comparator {
        private OperatorSimplifyLocalHelper m_helper;

        RingOrientationTestComparator(OperatorSimplifyLocalHelper helper) {
            this.m_helper = helper;
        }

        @Override
        int compare(Treap treap, int left, int node) {
            double x2;
            int right = treap.getElement(node);
            Edge edge1 = (Edge)this.m_helper.m_edges.get(left);
            Edge edge2 = (Edge)this.m_helper.m_edges.get(right);
            boolean bEdge1Reversed = edge1.getReversed();
            boolean bEdge2Reversed = edge2.getReversed();
            double x1 = edge1.m_segment.intersectionOfYMonotonicWithAxisX(this.m_helper.m_yScanline, 0.0);
            if (x1 == (x2 = edge2.m_segment.intersectionOfYMonotonicWithAxisX(this.m_helper.m_yScanline, 0.0))) {
                double y2;
                double y1 = bEdge1Reversed ? edge1.m_segment.getStartY() : edge1.m_segment.getEndY();
                double miny = Math.min(y1, y2 = bEdge2Reversed ? edge2.m_segment.getStartY() : edge2.m_segment.getEndY());
                double y = (miny - this.m_helper.m_yScanline) * 0.5 + this.m_helper.m_yScanline;
                if (y == this.m_helper.m_yScanline) {
                    y = miny;
                }
                x1 = edge1.m_segment.intersectionOfYMonotonicWithAxisX(y, 0.0);
                x2 = edge2.m_segment.intersectionOfYMonotonicWithAxisX(y, 0.0);
                assert (x1 != x2);
            }
            return x1 < x2 ? -1 : (x1 > x2 ? 1 : 0);
        }
    }

    private static final class ClusterTestComparator
    extends Treap.Comparator {
        OperatorSimplifyLocalHelper m_helper;

        ClusterTestComparator(OperatorSimplifyLocalHelper helper) {
            this.m_helper = helper;
        }

        @Override
        int compare(Treap treap, int xy1, int node) {
            double x2;
            int xy2 = treap.getElement(node);
            double x1 = this.m_helper.m_xy.read(2 * xy1);
            double dx = x1 - (x2 = this.m_helper.m_xy.read(2 * xy2));
            return dx < 0.0 ? -1 : (dx > 0.0 ? 1 : 0);
        }
    }

    static final class Vertex_info_pg {
        double x;
        double y;
        int ipath;
        int ivertex;
        int ipolygon;

        Vertex_info_pg(double x_, double y_, int ipath_, int xyindex_, int polygon_) {
            this.x = x_;
            this.y = y_;
            this.ipath = ipath_;
            this.ivertex = xyindex_;
            this.ipolygon = polygon_;
        }

        boolean is_equal(Vertex_info_pg other) {
            return this.x == other.x && this.y == other.y && this.ipath == other.ipath && this.ivertex == other.ivertex && this.ipolygon == other.ipolygon;
        }
    }

    static final class Vertex_info_pl {
        double x;
        double y;
        int ipath;
        int ivertex;
        boolean boundary;
        boolean end_point;

        Vertex_info_pl() {
        }
    }

    static final class Vertex_info {
        double x;
        double y;
        int ipath;
        int ivertex;
        boolean boundary;

        Vertex_info() {
        }
    }

    private static final class Edge {
        Segment m_segment;
        int m_vertexIndex;
        int m_pathIndex;
        int m_flags = 0;

        Edge() {
        }

        void setReversed(boolean bYesNo) {
            this.m_flags &= 0xFFFFFFFE;
            this.m_flags |= bYesNo ? 1 : 0;
        }

        boolean getReversed() {
            return (this.m_flags & 1) != 0;
        }

        int getRightSide() {
            return this.getReversed() ? 0 : 1;
        }
    }
}

