/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.sql.impl.opt.FieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static PredicateEx<JetSqlRow> filterFn(@Nonnull Expression<Boolean> predicate, @Nonnull ExpressionEvalContext context) {
        return (PredicateEx & Serializable)row0 -> {
            Row row = row0.getRow();
            return Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context));
        };
    }

    public static ComparatorEx<JetSqlRow> comparisonFn(@Nonnull List<FieldCollation> fieldCollationList) {
        return (ComparatorEx & Serializable)(row1, row2) -> {
            for (FieldCollation fieldCollation : fieldCollationList) {
                int index = fieldCollation.getIndex();
                Comparable o1 = (Comparable)row1.get(index);
                Object o2 = row2.get(index);
                RelFieldCollation.Direction direction = fieldCollation.getDirection();
                int result = o1 == o2 ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : o1.compareTo(o2)));
                if (direction.isDescending()) {
                    if (result < 0) {
                        result = 1;
                    } else if (result > 0) {
                        result = -1;
                    }
                }
                if (result == 0) continue;
                return result;
            }
            return 0;
        };
    }

    public static FunctionEx<JetSqlRow, JetSqlRow> projectionFn(@Nonnull List<Expression<?>> projections, @Nonnull ExpressionEvalContext context) {
        return (FunctionEx & Serializable)row0 -> {
            Row row = row0.getRow();
            Object[] result = new Object[projections.size()];
            for (int i = 0; i < projections.size(); ++i) {
                result[i] = ExpressionUtil.evaluate((Expression)projections.get(i), row, context);
            }
            return new JetSqlRow((SerializationService)context.getSerializationService(), result);
        };
    }

    @Nullable
    public static JetSqlRow join(@Nonnull JetSqlRow leftRow, @Nonnull JetSqlRow rightRow, @Nonnull Expression<Boolean> predicate, @Nonnull ExpressionEvalContext context) {
        Object[] joined = Arrays.copyOf(leftRow.getValues(), leftRow.getFieldCount() + rightRow.getFieldCount());
        System.arraycopy(rightRow.getValues(), 0, joined, leftRow.getFieldCount(), rightRow.getFieldCount());
        JetSqlRow result = new JetSqlRow((SerializationService)context.getSerializationService(), joined);
        Row row = result.getRow();
        return Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context)) ? result : null;
    }

    @Nonnull
    public static List<JetSqlRow> evaluate(@Nullable Expression<Boolean> predicate, @Nullable List<Expression<?>> projection, @Nonnull Stream<JetSqlRow> rows, @Nonnull ExpressionEvalContext context) {
        return rows.map(row -> ExpressionUtil.evaluate(predicate, projection, row, context)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static JetSqlRow evaluate(@Nullable Expression<Boolean> predicate, @Nullable List<Expression<?>> projection, @Nonnull JetSqlRow values, @Nonnull ExpressionEvalContext context) {
        Row row = values.getRow();
        if (predicate != null && !Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context))) {
            return null;
        }
        if (projection == null) {
            return values;
        }
        Object[] result = new Object[projection.size()];
        for (int i = 0; i < projection.size(); ++i) {
            result[i] = ExpressionUtil.evaluate(projection.get(i), row, context);
        }
        return new JetSqlRow((SerializationService)context.getSerializationService(), result);
    }

    @Nullable
    public static JetSqlRow evaluate(@Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projection, @Nonnull Row row, @Nonnull ExpressionEvalContext context) {
        if (predicate != null && !Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context))) {
            return null;
        }
        Object[] result = new Object[projection.size()];
        for (int i = 0; i < projection.size(); ++i) {
            result[i] = ExpressionUtil.evaluate(projection.get(i), row, context);
        }
        return new JetSqlRow((SerializationService)context.getSerializationService(), result);
    }

    public static Object evaluate(@Nonnull Expression<?> expression, @Nonnull Row row, @Nonnull ExpressionEvalContext context) {
        return expression.evalTop(row, context);
    }
}

