/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.config.IndexType;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.OptimizerContext;
import com.hazelcast.jet.sql.impl.PlanExecutor;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.UpdatingEntryProcessor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.parse.SqlAlterJob;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.SqlPermission;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.PlanCheckContext;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.security.Permission;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

abstract class SqlPlanImpl
extends SqlPlan {
    protected SqlPlanImpl(PlanKey planKey) {
        super(planKey);
    }

    public boolean isPlanValid(PlanCheckContext context) {
        throw new UnsupportedOperationException(this.isCacheable() ? "override this method" : "method should not be called for non-cacheable plans");
    }

    protected void checkPermissions(SqlSecurityContext context, DAG dag) {
        if (!context.isSecurityEnabled()) {
            return;
        }
        for (Vertex vertex : dag) {
            Permission permission = vertex.getMetaSupplier().getRequiredPermission();
            if (permission == null) continue;
            context.checkPermission(permission);
        }
    }

    public void checkPermissions(SqlSecurityContext context) {
    }

    private static void ensureNoArguments(String name, List<Object> arguments) {
        if (!arguments.isEmpty()) {
            throw QueryException.error((String)(name + " does not support dynamic parameters"));
        }
    }

    private static void ensureNoTimeout(String name, long timeout) {
        if (timeout > 0L) {
            throw QueryException.error((String)(name + " does not support timeout"));
        }
    }

    static class IMapDeletePlan
    extends SqlPlanImpl {
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final String mapName;
        private final Expression<?> keyCondition;
        private final PlanExecutor planExecutor;
        private final List<Permission> permissions;

        IMapDeletePlan(PlanKey planKey, PlanObjectKey objectKey, QueryParameterMetadata parameterMetadata, String mapName, Expression<?> keyCondition, PlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.objectKeys = Collections.singleton(objectKey);
            this.parameterMetadata = parameterMetadata;
            this.mapName = mapName;
            this.keyCondition = keyCondition;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        QueryParameterMetadata parameterMetadata() {
            return this.parameterMetadata;
        }

        String mapName() {
            return this.mapName;
        }

        Expression<?> keyCondition() {
            return this.keyCondition;
        }

        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new MapPermission(this.mapName, new String[]{"create", "read", "put", "remove"}));
            this.permissions.forEach(arg_0 -> ((SqlSecurityContext)context).checkPermission(arg_0));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, arguments, timeout);
        }
    }

    static class IMapUpdatePlan
    extends SqlPlanImpl {
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final String mapName;
        private final Expression<?> keyCondition;
        private final UpdatingEntryProcessor.Supplier updaterSupplier;
        private final PlanExecutor planExecutor;
        private final List<Permission> permissions;

        IMapUpdatePlan(PlanKey planKey, PlanObjectKey objectKey, QueryParameterMetadata parameterMetadata, String mapName, Expression<?> keyCondition, UpdatingEntryProcessor.Supplier updaterSupplier, PlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.objectKeys = Collections.singleton(objectKey);
            this.parameterMetadata = parameterMetadata;
            this.mapName = mapName;
            this.keyCondition = keyCondition;
            this.updaterSupplier = updaterSupplier;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        QueryParameterMetadata parameterMetadata() {
            return this.parameterMetadata;
        }

        String mapName() {
            return this.mapName;
        }

        Expression<?> keyCondition() {
            return this.keyCondition;
        }

        UpdatingEntryProcessor.Supplier updaterSupplier() {
            return this.updaterSupplier;
        }

        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new MapPermission(this.mapName, new String[]{"create", "read", "put", "remove"}));
            this.permissions.forEach(arg_0 -> ((SqlSecurityContext)context).checkPermission(arg_0));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, arguments, timeout);
        }
    }

    static class IMapSinkPlan
    extends SqlPlanImpl {
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final String mapName;
        private final Function<ExpressionEvalContext, Map<Object, Object>> entriesFn;
        private final PlanExecutor planExecutor;
        private final List<Permission> permissions;

        IMapSinkPlan(PlanKey planKey, PlanObjectKey objectKey, QueryParameterMetadata parameterMetadata, String mapName, Function<ExpressionEvalContext, Map<Object, Object>> entriesFn, PlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.objectKeys = Collections.singleton(objectKey);
            this.parameterMetadata = parameterMetadata;
            this.mapName = mapName;
            this.entriesFn = entriesFn;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        QueryParameterMetadata parameterMetadata() {
            return this.parameterMetadata;
        }

        String mapName() {
            return this.mapName;
        }

        Function<ExpressionEvalContext, Map<Object, Object>> entriesFn() {
            return this.entriesFn;
        }

        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new MapPermission(this.mapName, new String[]{"create", "put", "remove"}));
            this.permissions.forEach(arg_0 -> ((SqlSecurityContext)context).checkPermission(arg_0));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, arguments, timeout);
        }
    }

    static class IMapInsertPlan
    extends SqlPlanImpl {
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final String mapName;
        private final Function<ExpressionEvalContext, List<Map.Entry<Object, Object>>> entriesFn;
        private final PlanExecutor planExecutor;
        private final List<Permission> permissions;

        IMapInsertPlan(PlanKey planKey, PlanObjectKey objectKey, QueryParameterMetadata parameterMetadata, String mapName, Function<ExpressionEvalContext, List<Map.Entry<Object, Object>>> entriesFn, PlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.objectKeys = Collections.singleton(objectKey);
            this.parameterMetadata = parameterMetadata;
            this.mapName = mapName;
            this.entriesFn = entriesFn;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        QueryParameterMetadata parameterMetadata() {
            return this.parameterMetadata;
        }

        String mapName() {
            return this.mapName;
        }

        Function<ExpressionEvalContext, List<Map.Entry<Object, Object>>> entriesFn() {
            return this.entriesFn;
        }

        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new MapPermission(this.mapName, new String[]{"create", "put"}));
            this.permissions.forEach(arg_0 -> ((SqlSecurityContext)context).checkPermission(arg_0));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, arguments, timeout);
        }
    }

    static class IMapSelectPlan
    extends SqlPlanImpl {
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final String mapName;
        private final Expression<?> keyCondition;
        private final KvRowProjector.Supplier rowProjectorSupplier;
        private final SqlRowMetadata rowMetadata;
        private final PlanExecutor planExecutor;
        private final List<Permission> permissions;

        IMapSelectPlan(PlanKey planKey, PlanObjectKey objectKey, QueryParameterMetadata parameterMetadata, String mapName, Expression<?> keyCondition, KvRowProjector.Supplier rowProjectorSupplier, SqlRowMetadata rowMetadata, PlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.objectKeys = Collections.singleton(objectKey);
            this.parameterMetadata = parameterMetadata;
            this.mapName = mapName;
            this.keyCondition = keyCondition;
            this.rowProjectorSupplier = rowProjectorSupplier;
            this.rowMetadata = rowMetadata;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        QueryParameterMetadata parameterMetadata() {
            return this.parameterMetadata;
        }

        String mapName() {
            return this.mapName;
        }

        Expression<?> keyCondition() {
            return this.keyCondition;
        }

        KvRowProjector.Supplier rowProjectorSupplier() {
            return this.rowProjectorSupplier;
        }

        SqlRowMetadata rowMetadata() {
            return this.rowMetadata;
        }

        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new MapPermission(this.mapName, new String[]{"create", "read"}));
            this.permissions.forEach(arg_0 -> ((SqlSecurityContext)context).checkPermission(arg_0));
        }

        public boolean producesRows() {
            return true;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, queryId, arguments, timeout);
        }
    }

    static class DmlPlan
    extends SqlPlanImpl {
        private final TableModify.Operation operation;
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final DAG dag;
        private final String query;
        private final boolean infiniteRows;
        private final PlanExecutor planExecutor;
        private final List<Permission> permissions;

        DmlPlan(TableModify.Operation operation, PlanKey planKey, QueryParameterMetadata parameterMetadata, Set<PlanObjectKey> objectKeys, DAG dag, String query, boolean infiniteRows, PlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.operation = operation;
            this.objectKeys = objectKeys;
            this.parameterMetadata = parameterMetadata;
            this.dag = dag;
            this.query = query;
            this.infiniteRows = infiniteRows;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        TableModify.Operation getOperation() {
            return this.operation;
        }

        QueryParameterMetadata getParameterMetadata() {
            return this.parameterMetadata;
        }

        DAG getDag() {
            return this.dag;
        }

        public String getQuery() {
            return this.query;
        }

        public boolean isInfiniteRows() {
            return this.infiniteRows;
        }

        public boolean isCacheable() {
            return !this.objectKeys.contains(PlanObjectKey.NON_CACHEABLE_OBJECT_KEY);
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            this.checkPermissions(context, this.dag);
            this.permissions.forEach(arg_0 -> ((SqlSecurityContext)context).checkPermission(arg_0));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, queryId, arguments, timeout);
        }
    }

    static class SelectPlan
    extends SqlPlanImpl {
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final DAG dag;
        private final String query;
        private final boolean isStreaming;
        private final SqlRowMetadata rowMetadata;
        private final PlanExecutor planExecutor;
        private final List<Permission> permissions;

        SelectPlan(PlanKey planKey, QueryParameterMetadata parameterMetadata, Set<PlanObjectKey> objectKeys, DAG dag, String query, boolean isStreaming, SqlRowMetadata rowMetadata, PlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.objectKeys = objectKeys;
            this.parameterMetadata = parameterMetadata;
            this.dag = dag;
            this.query = query;
            this.isStreaming = isStreaming;
            this.rowMetadata = rowMetadata;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        QueryParameterMetadata getParameterMetadata() {
            return this.parameterMetadata;
        }

        DAG getDag() {
            return this.dag;
        }

        boolean isStreaming() {
            return this.isStreaming;
        }

        SqlRowMetadata getRowMetadata() {
            return this.rowMetadata;
        }

        public String getQuery() {
            return this.query;
        }

        public boolean isCacheable() {
            return !this.objectKeys.contains(PlanObjectKey.NON_CACHEABLE_OBJECT_KEY);
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            this.checkPermissions(context, this.dag);
            this.permissions.forEach(arg_0 -> ((SqlSecurityContext)context).checkPermission(arg_0));
        }

        public boolean producesRows() {
            return true;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, queryId, arguments, timeout);
        }
    }

    static class ExplainStatementPlan
    extends SqlPlanImpl {
        private final PhysicalRel rel;
        private final PlanExecutor planExecutor;

        ExplainStatementPlan(PlanKey planKey, PhysicalRel rel, PlanExecutor planExecutor) {
            super(planKey);
            this.rel = rel;
            this.planExecutor = planExecutor;
        }

        public PhysicalRel getRel() {
            return this.rel;
        }

        public boolean isCacheable() {
            return false;
        }

        public boolean producesRows() {
            return true;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoTimeout("EXPLAIN", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class ShowStatementPlan
    extends SqlPlanImpl {
        private final SqlShowStatement.ShowStatementTarget showTarget;
        private final PlanExecutor planExecutor;

        ShowStatementPlan(PlanKey planKey, SqlShowStatement.ShowStatementTarget showTarget, PlanExecutor planExecutor) {
            super(planKey);
            this.showTarget = showTarget;
            this.planExecutor = planExecutor;
        }

        SqlShowStatement.ShowStatementTarget getShowTarget() {
            return this.showTarget;
        }

        public boolean isCacheable() {
            return false;
        }

        public boolean producesRows() {
            return true;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("SHOW " + (Object)((Object)this.showTarget), arguments);
            SqlPlanImpl.ensureNoTimeout("SHOW " + (Object)((Object)this.showTarget), timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class DropViewPlan
    extends SqlPlanImpl {
        private final String viewName;
        private final boolean ifExists;
        private final PlanExecutor planExecutor;

        DropViewPlan(PlanKey planKey, String viewName, boolean ifExists, PlanExecutor planExecutor) {
            super(planKey);
            this.viewName = viewName;
            this.ifExists = ifExists;
            this.planExecutor = planExecutor;
        }

        String viewName() {
            return this.viewName;
        }

        boolean isIfExists() {
            return this.ifExists;
        }

        public boolean isCacheable() {
            return false;
        }

        public boolean producesRows() {
            return false;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new SqlPermission(this.viewName, new String[]{"drop-view"}));
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("DROP VIEW", arguments);
            SqlPlanImpl.ensureNoTimeout("DROP VIEW", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class CreateViewPlan
    extends SqlPlanImpl {
        private final OptimizerContext context;
        private final String viewName;
        private final String viewQuery;
        private final boolean viewIsStream;
        private final boolean replace;
        private final boolean ifNotExists;
        private final PlanExecutor planExecutor;

        CreateViewPlan(PlanKey planKey, OptimizerContext context, String viewName, String viewQuery, boolean viewIsStream, boolean replace, boolean ifNotExists, PlanExecutor planExecutor) {
            super(planKey);
            this.context = context;
            this.viewName = viewName;
            this.viewQuery = viewQuery;
            this.viewIsStream = viewIsStream;
            this.replace = replace;
            this.ifNotExists = ifNotExists;
            this.planExecutor = planExecutor;
        }

        public OptimizerContext context() {
            return this.context;
        }

        public String viewName() {
            return this.viewName;
        }

        public String viewQuery() {
            return this.viewQuery;
        }

        public boolean isStream() {
            return this.viewIsStream;
        }

        boolean isReplace() {
            return this.replace;
        }

        public boolean ifNotExists() {
            return this.ifNotExists;
        }

        public boolean isCacheable() {
            return false;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new SqlPermission(this.viewName, new String[]{"create-view"}));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("CREATE VIEW", arguments);
            SqlPlanImpl.ensureNoTimeout("CREATE VIEW", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class DropSnapshotPlan
    extends SqlPlanImpl {
        private final String snapshotName;
        private final boolean ifExists;
        private final PlanExecutor planExecutor;

        DropSnapshotPlan(PlanKey planKey, String snapshotName, boolean ifExists, PlanExecutor planExecutor) {
            super(planKey);
            this.snapshotName = snapshotName;
            this.ifExists = ifExists;
            this.planExecutor = planExecutor;
        }

        String getSnapshotName() {
            return this.snapshotName;
        }

        boolean isIfExists() {
            return this.ifExists;
        }

        public boolean isCacheable() {
            return false;
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("DROP SNAPSHOT", arguments);
            SqlPlanImpl.ensureNoTimeout("DROP SNAPSHOT", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class CreateSnapshotPlan
    extends SqlPlanImpl {
        private final String snapshotName;
        private final String jobName;
        private final PlanExecutor planExecutor;

        CreateSnapshotPlan(PlanKey planKey, String snapshotName, String jobName, PlanExecutor planExecutor) {
            super(planKey);
            this.snapshotName = snapshotName;
            this.jobName = jobName;
            this.planExecutor = planExecutor;
        }

        String getSnapshotName() {
            return this.snapshotName;
        }

        String getJobName() {
            return this.jobName;
        }

        public boolean isCacheable() {
            return false;
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("CREATE SNAPSHOT", arguments);
            SqlPlanImpl.ensureNoTimeout("CREATE SNAPSHOT", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class DropJobPlan
    extends SqlPlanImpl {
        private final String jobName;
        private final boolean ifExists;
        private final String withSnapshotName;
        private final PlanExecutor planExecutor;

        DropJobPlan(PlanKey planKey, String jobName, boolean ifExists, String withSnapshotName, PlanExecutor planExecutor) {
            super(planKey);
            this.jobName = jobName;
            this.ifExists = ifExists;
            this.withSnapshotName = withSnapshotName;
            this.planExecutor = planExecutor;
        }

        String getJobName() {
            return this.jobName;
        }

        boolean isIfExists() {
            return this.ifExists;
        }

        String getWithSnapshotName() {
            return this.withSnapshotName;
        }

        public boolean isCacheable() {
            return false;
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("DROP JOB", arguments);
            SqlPlanImpl.ensureNoTimeout("DROP JOB", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class AlterJobPlan
    extends SqlPlanImpl {
        private final String jobName;
        private final SqlAlterJob.AlterJobOperation operation;
        private final PlanExecutor planExecutor;

        AlterJobPlan(PlanKey planKey, String jobName, SqlAlterJob.AlterJobOperation operation, PlanExecutor planExecutor) {
            super(planKey);
            this.jobName = jobName;
            this.operation = operation;
            this.planExecutor = planExecutor;
        }

        String getJobName() {
            return this.jobName;
        }

        SqlAlterJob.AlterJobOperation getOperation() {
            return this.operation;
        }

        public boolean isCacheable() {
            return false;
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("ALTER JOB", arguments);
            SqlPlanImpl.ensureNoTimeout("ALTER JOB", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class CreateJobPlan
    extends SqlPlanImpl {
        private final JobConfig jobConfig;
        private final boolean ifNotExists;
        private final DmlPlan dmlPlan;
        private final String query;
        private final boolean infiniteRows;
        private final PlanExecutor planExecutor;

        CreateJobPlan(PlanKey planKey, JobConfig jobConfig, boolean ifNotExists, DmlPlan dmlPlan, String query, boolean infiniteRows, PlanExecutor planExecutor) {
            super(planKey);
            assert (dmlPlan.operation == TableModify.Operation.INSERT) : DmlPlan.access$200(dmlPlan);
            this.jobConfig = jobConfig;
            this.ifNotExists = ifNotExists;
            this.dmlPlan = dmlPlan;
            this.query = query;
            this.infiniteRows = infiniteRows;
            this.planExecutor = planExecutor;
        }

        public boolean isInfiniteRows() {
            return this.infiniteRows;
        }

        public String getQuery() {
            return this.query;
        }

        JobConfig getJobConfig() {
            return this.jobConfig;
        }

        boolean isIfNotExists() {
            return this.ifNotExists;
        }

        DmlPlan getExecutionPlan() {
            return this.dmlPlan;
        }

        QueryParameterMetadata getParameterMetadata() {
            return this.dmlPlan.getParameterMetadata();
        }

        public boolean isCacheable() {
            return this.dmlPlan.isCacheable();
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return this.dmlPlan.isPlanValid(context);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            this.dmlPlan.checkPermissions(context);
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoTimeout("CREATE JOB", timeout);
            return this.planExecutor.execute(this, arguments);
        }
    }

    static class DropIndexPlan
    extends SqlPlanImpl {
        private final String name;
        private final boolean ifExists;
        private final PlanExecutor planExecutor;

        DropIndexPlan(PlanKey planKey, String name, boolean ifExists, PlanExecutor planExecutor) {
            super(planKey);
            this.name = name;
            this.ifExists = ifExists;
            this.planExecutor = planExecutor;
        }

        String name() {
            return this.name;
        }

        boolean ifExists() {
            return this.ifExists;
        }

        public boolean isCacheable() {
            return false;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new SqlPermission(this.name, new String[]{"destroy"}));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            throw QueryException.error((String)"DROP INDEX is not supported.");
        }
    }

    static class CreateIndexPlan
    extends SqlPlanImpl {
        private final String name;
        private final String mapName;
        private final String[] attributes;
        private final Map<String, String> options;
        private final IndexType indexType;
        private final boolean ifNotExists;
        private final PlanExecutor planExecutor;

        CreateIndexPlan(PlanKey planKey, String name, String mapName, IndexType indexType, List<String> attributes, Map<String, String> options, boolean ifNotExists, PlanExecutor planExecutor) {
            super(planKey);
            this.name = name;
            this.mapName = mapName;
            this.indexType = indexType;
            this.attributes = attributes.toArray(new String[0]);
            this.options = options;
            this.ifNotExists = ifNotExists;
            this.planExecutor = planExecutor;
        }

        public String indexName() {
            return this.name;
        }

        public String mapName() {
            return this.mapName;
        }

        public String[] attributes() {
            return this.attributes;
        }

        public IndexType indexType() {
            return this.indexType;
        }

        public Map<String, String> options() {
            return this.options;
        }

        boolean ifNotExists() {
            return this.ifNotExists;
        }

        public boolean isCacheable() {
            return false;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new SqlPermission(this.name, new String[]{"index"}));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("CREATE INDEX", arguments);
            SqlPlanImpl.ensureNoTimeout("CREATE INDEX", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class DropMappingPlan
    extends SqlPlanImpl {
        private final String name;
        private final boolean ifExists;
        private final PlanExecutor planExecutor;

        DropMappingPlan(PlanKey planKey, String name, boolean ifExists, PlanExecutor planExecutor) {
            super(planKey);
            this.name = name;
            this.ifExists = ifExists;
            this.planExecutor = planExecutor;
        }

        String name() {
            return this.name;
        }

        boolean ifExists() {
            return this.ifExists;
        }

        public boolean isCacheable() {
            return false;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new SqlPermission(this.name, new String[]{"destroy"}));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("DROP MAPPING", arguments);
            SqlPlanImpl.ensureNoTimeout("DROP MAPPING", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class CreateMappingPlan
    extends SqlPlanImpl {
        private final Mapping mapping;
        private final boolean replace;
        private final boolean ifNotExists;
        private final PlanExecutor planExecutor;

        CreateMappingPlan(PlanKey planKey, Mapping mapping, boolean replace, boolean ifNotExists, PlanExecutor planExecutor) {
            super(planKey);
            this.mapping = mapping;
            this.replace = replace;
            this.ifNotExists = ifNotExists;
            this.planExecutor = planExecutor;
        }

        Mapping mapping() {
            return this.mapping;
        }

        boolean replace() {
            return this.replace;
        }

        boolean ifNotExists() {
            return this.ifNotExists;
        }

        public boolean isCacheable() {
            return false;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission((Permission)new SqlPermission(this.mapping.name(), new String[]{"create"}));
        }

        public boolean producesRows() {
            return false;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            SqlPlanImpl.ensureNoArguments("CREATE MAPPING", arguments);
            SqlPlanImpl.ensureNoTimeout("CREATE MAPPING", timeout);
            return this.planExecutor.execute(this);
        }
    }
}

