/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate.function;

import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.jet.sql.impl.schema.HazelcastSqlOperandMetadata;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableFunctionParameter;
import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.HazelcastResources;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.List;

final class WindowOperandMetadata
extends HazelcastSqlOperandMetadata {
    private final int[] operandIndexes;

    WindowOperandMetadata(List<HazelcastTableFunctionParameter> parameters, int[] operandIndexes) {
        super(parameters);
        this.operandIndexes = operandIndexes;
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        boolean result = true;
        for (int columnIndex : this.operandIndexes) {
            result &= this.checkOperandTypes(binding, throwOnFailure, columnIndex);
        }
        assert (result || !throwOnFailure);
        return result;
    }

    private boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure, int columnIndex) {
        SqlNode lag = binding.operand(columnIndex);
        HazelcastSqlValidator validator = binding.getValidator();
        SqlTypeName orderingColumnType = WindowUtils.getOrderingColumnType(binding, 1).getSqlTypeName();
        SqlTypeName lagType = validator.getValidatedNodeType(lag).getSqlTypeName();
        boolean result = SqlTypeName.INT_TYPES.contains((Object)orderingColumnType) ? SqlTypeName.INT_TYPES.contains((Object)lagType) : (SqlTypeName.DATETIME_TYPES.contains((Object)orderingColumnType) ? lagType.getFamily() == SqlTypeFamily.INTERVAL_DAY_TIME : false);
        if (!result && throwOnFailure) {
            QueryDataTypeFamily hzOrderingColumnType = HazelcastTypeUtils.toHazelcastTypeFromSqlTypeName(orderingColumnType).getTypeFamily();
            QueryDataTypeFamily hzLagType = HazelcastTypeUtils.toHazelcastTypeFromSqlTypeName(lagType).getTypeFamily();
            throw validator.newValidationError(binding.getCall(), HazelcastResources.RESOURCES.windowFunctionTypeMismatch(hzOrderingColumnType.toString(), hzLagType.toString()));
        }
        return result;
    }
}

