/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.iteration.IndexIterationPointer;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.AbstractIndexReader;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.map.impl.operation.MapFetchIndexOperation;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.sql.impl.exec.scan.MapIndexScanMetadata;
import com.hazelcast.sql.impl.exec.scan.MapScanRow;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

final class MapIndexScanP
extends AbstractProcessor {
    private final MapIndexScanMetadata metadata;
    private HazelcastInstance hazelcastInstance;
    private ExpressionEvalContext evalContext;
    private AbstractIndexReader<MapFetchIndexOperation.MapFetchIndexOperationResult, QueryableEntry<?, ?>> reader;
    private final ArrayList<Split> splits = new ArrayList();
    private MapScanRow row;
    private JetSqlRow pendingItem;
    private boolean isIndexSorted;

    private MapIndexScanP(@Nonnull MapIndexScanMetadata indexScanMetadata) {
        this.metadata = indexScanMetadata;
    }

    protected void init(@Nonnull Processor.Context context) {
        this.hazelcastInstance = context.hazelcastInstance();
        this.evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)context);
        this.reader = new LocalMapIndexReader(this.hazelcastInstance, this.evalContext.getSerializationService(), this.metadata);
        int[] memberPartitions = context.processorPartitions();
        this.splits.add(new Split(new PartitionIdSet(this.hazelcastInstance.getPartitionService().getPartitions().size(), memberPartitions), this.hazelcastInstance.getCluster().getLocalMember().getAddress(), MapIndexScanP.filtersToPointers(this.metadata.getFilter(), this.metadata.isDescending(), this.evalContext)));
        this.row = MapScanRow.create((QueryTargetDescriptor)this.metadata.getKeyDescriptor(), (QueryTargetDescriptor)this.metadata.getValueDescriptor(), this.metadata.getFieldPaths(), this.metadata.getFieldTypes(), (Extractors)Extractors.newBuilder((InternalSerializationService)this.evalContext.getSerializationService()).build(), (InternalSerializationService)this.evalContext.getSerializationService());
        this.isIndexSorted = this.metadata.getComparator() != null;
    }

    private static IndexIterationPointer[] filtersToPointers(@Nonnull IndexFilter filter, boolean descending, ExpressionEvalContext evalContext) {
        return IndexIterationPointer.createFromIndexFilter((IndexFilter)filter, (boolean)descending, (ExpressionEvalContext)evalContext);
    }

    public boolean complete() {
        return this.isIndexSorted ? this.runSortedIndex() : this.runHashIndex();
    }

    public boolean closeIsCooperative() {
        return true;
    }

    private boolean runSortedIndex() {
        while (this.pendingItem == null || this.tryEmit(this.pendingItem)) {
            this.pendingItem = null;
            JetSqlRow extreme = null;
            int extremeIndex = -1;
            for (int i = 0; i < this.splits.size(); ++i) {
                Split split = this.splits.get(i);
                try {
                    split.peek();
                }
                catch (MapFetchIndexOperation.MissingPartitionException e) {
                    this.splits.addAll(this.splitOnMigration(split));
                    this.splits.remove(i--);
                    continue;
                }
                if (split.currentRow == null) {
                    if (split.done()) {
                        this.splits.remove(i--);
                        continue;
                    }
                    return false;
                }
                if (extremeIndex >= 0 && this.metadata.getComparator().compare((Object)split.currentRow, (Object)this.splits.get(extremeIndex).currentRow) >= 0) continue;
                extremeIndex = i;
                extreme = split.currentRow;
            }
            if (extremeIndex < 0) {
                assert (this.splits.isEmpty());
                return true;
            }
            this.pendingItem = extreme;
            this.splits.get(extremeIndex).remove();
        }
        return false;
    }

    private boolean runHashIndex() {
        block2: while (true) {
            int i = 0;
            while (true) {
                block10: {
                    if (i >= this.splits.size()) continue block2;
                    Split split = this.splits.get(i);
                    try {
                        split.peek();
                    }
                    catch (MapFetchIndexOperation.MissingPartitionException e) {
                        this.splits.addAll(this.splitOnMigration(split));
                        this.splits.remove(i--);
                        break block10;
                    }
                    if (split.currentRow == null) {
                        if (split.done()) {
                            this.splits.remove(i--);
                            if (this.splits.isEmpty()) {
                                return true;
                            }
                        }
                    } else if (this.tryEmit(split.currentRow)) {
                        split.remove();
                    } else {
                        return false;
                    }
                }
                ++i;
            }
            break;
        }
    }

    private List<Split> splitOnMigration(Split split) {
        IndexIterationPointer[] lastPointers = split.pointers;
        InternalPartitionService partitionService = Util.getNodeEngine((HazelcastInstance)this.hazelcastInstance).getPartitionService();
        HashMap<Address, Split> newSplits = new HashMap<Address, Split>();
        PrimitiveIterator.OfInt partitionIterator = split.partitions.intIterator();
        while (partitionIterator.hasNext()) {
            int partitionId = partitionIterator.nextInt();
            Address potentialOwner = partitionService.getPartition(partitionId).getOwnerOrNull();
            Address owner = potentialOwner == null ? split.owner : partitionService.getPartition(partitionId).getOwnerOrNull();
            newSplits.computeIfAbsent(owner, x -> new Split(new PartitionIdSet(partitionService.getPartitionCount()), owner, lastPointers)).partitions.add(partitionId);
        }
        return new ArrayList<Split>(newSplits.values());
    }

    static ProcessorSupplier readMapIndexSupplier(MapIndexScanMetadata indexScanMetadata) {
        return new MapIndexScanProcessorSupplier(indexScanMetadata);
    }

    private static final class MapIndexScanProcessorSupplier
    implements ProcessorSupplier,
    DataSerializable {
        private MapIndexScanMetadata metadata;

        private MapIndexScanProcessorSupplier() {
        }

        private MapIndexScanProcessorSupplier(@Nonnull MapIndexScanMetadata metadata) {
            this.metadata = metadata;
        }

        @Nonnull
        public List<Processor> get(int count) {
            return IntStream.range(0, count).mapToObj(i -> new MapIndexScanP(this.metadata)).collect(Collectors.toList());
        }

        public List<Permission> permissions() {
            return Collections.singletonList(new MapPermission(this.metadata.getMapName(), new String[]{"create", "read"}));
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.metadata);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.metadata = (MapIndexScanMetadata)in.readObject();
        }
    }

    private static final class LocalMapIndexReader
    extends AbstractIndexReader<MapFetchIndexOperation.MapFetchIndexOperationResult, QueryableEntry<?, ?>> {
        static final int FETCH_SIZE_HINT = 128;
        private final HazelcastInstance hazelcastInstance;
        private final String indexName;

        private LocalMapIndexReader(@Nonnull HazelcastInstance hzInstance, @Nonnull InternalSerializationService serializationService, @Nonnull MapIndexScanMetadata indexScanMetadata) {
            super(indexScanMetadata.getMapName(), MapFetchIndexOperation.MapFetchIndexOperationResult::getEntries);
            this.hazelcastInstance = hzInstance;
            this.indexName = indexScanMetadata.getIndexName();
            this.serializationService = serializationService;
        }

        @Nonnull
        public InternalCompletableFuture<MapFetchIndexOperation.MapFetchIndexOperationResult> readBatch(Address address, PartitionIdSet partitions, IndexIterationPointer[] pointers) {
            MapProxyImpl mapProxyImpl = (MapProxyImpl)this.hazelcastInstance.getMap(this.objectName);
            MapOperationProvider operationProvider = mapProxyImpl.getOperationProvider();
            MapOperation op = operationProvider.createFetchIndexOperation(mapProxyImpl.getName(), this.indexName, pointers, partitions, 128);
            return mapProxyImpl.getOperationService().invokeOnTarget(mapProxyImpl.getServiceName(), (Operation)op, address);
        }
    }

    private final class Split {
        private final PartitionIdSet partitions;
        private final Address owner;
        private IndexIterationPointer[] pointers;
        private List<QueryableEntry<?, ?>> currentBatch = Collections.emptyList();
        private JetSqlRow currentRow;
        private int currentBatchPosition;
        private CompletableFuture<MapFetchIndexOperation.MapFetchIndexOperationResult> future;

        private Split(PartitionIdSet partitions, Address owner, IndexIterationPointer[] pointers) {
            this.partitions = partitions;
            this.owner = owner;
            this.pointers = pointers;
            this.currentBatchPosition = 0;
            this.future = null;
        }

        private void peek() {
            if (this.future == null && this.pointers.length > 0) {
                this.future = MapIndexScanP.this.reader.readBatch(this.owner, this.partitions, this.pointers);
            }
            if (this.currentBatch.size() == this.currentBatchPosition && this.future != null && this.future.isDone()) {
                MapFetchIndexOperation.MapFetchIndexOperationResult result;
                try {
                    result = (MapFetchIndexOperation.MapFetchIndexOperationResult)MapIndexScanP.this.reader.toBatchResult(this.future);
                }
                catch (ExecutionException e) {
                    Throwable t2 = this.findTopologyExceptionInCauses(e);
                    if (t2 != null) {
                        throw new MapFetchIndexOperation.MissingPartitionException(t2.toString(), (Throwable)e);
                    }
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.currentBatch = MapIndexScanP.this.reader.toRecordSet((Object)result);
                this.currentBatchPosition = 0;
                this.pointers = result.getPointers();
                this.future = null;
            }
            while (this.currentRow == null && this.currentBatchPosition < this.currentBatch.size()) {
                this.currentRow = this.projectAndFilter(this.currentBatch.get(this.currentBatchPosition));
                if (this.currentRow != null) continue;
                ++this.currentBatchPosition;
            }
        }

        private Throwable findTopologyExceptionInCauses(Throwable t2) {
            while (t2 != null) {
                if (t2 instanceof MapFetchIndexOperation.MissingPartitionException || t2 instanceof HazelcastInstanceNotActiveException || t2 instanceof MemberLeftException || t2 instanceof TargetDisconnectedException || t2 instanceof TargetNotMemberException || t2 instanceof WrongTargetException) {
                    return t2;
                }
                t2 = t2.getCause();
            }
            return null;
        }

        private JetSqlRow projectAndFilter(@Nonnull QueryableEntry<?, ?> entry) {
            MapIndexScanP.this.row.setKeyValue(entry.getKeyIfPresent(), entry.getKeyDataIfPresent(), entry.getValueIfPresent(), entry.getValueDataIfPresent());
            return ExpressionUtil.evaluate(MapIndexScanP.this.metadata.getRemainingFilter(), MapIndexScanP.this.metadata.getProjection(), (Row)MapIndexScanP.this.row, MapIndexScanP.this.evalContext);
        }

        private void remove() {
            ++this.currentBatchPosition;
            this.currentRow = null;
        }

        private boolean done() {
            return this.currentBatchPosition == this.currentBatch.size() && this.pointers.length == 0;
        }
    }
}

