/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.jet.sql.impl.expression.json.JsonCreationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.VariExpression;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;

public class JsonObjectFunction
extends VariExpression<HazelcastJsonValue>
implements IdentifiedDataSerializable {
    private SqlJsonConstructorNullClause nullClause;

    public JsonObjectFunction() {
    }

    private JsonObjectFunction(Expression<?>[] fields, SqlJsonConstructorNullClause nullClause) {
        super(fields);
        this.nullClause = nullClause;
    }

    public static JsonObjectFunction create(Expression<?>[] fields, SqlJsonConstructorNullClause nullClause) {
        return new JsonObjectFunction(fields, nullClause);
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 3;
    }

    public HazelcastJsonValue eval(Row row, ExpressionEvalContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirst = true;
        for (int i = 0; i < this.operands.length; i += 2) {
            Object key = this.operands[i].eval(row, context);
            Object value = this.operands[i + 1].eval(row, context);
            if (value == null && !this.keepNulls()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            assert (key instanceof String);
            sb.append(JsonCreationUtil.serializeString((String)key));
            sb.append(':');
            sb.append(JsonCreationUtil.serializeValue(value));
        }
        sb.append('}');
        return new HazelcastJsonValue(sb.toString());
    }

    private boolean keepNulls() {
        return this.nullClause.equals((Object)SqlJsonConstructorNullClause.NULL_ON_NULL);
    }

    public QueryDataType getType() {
        return QueryDataType.JSON;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeString(this.nullClause.name());
    }

    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.nullClause = SqlJsonConstructorNullClause.valueOf(in.readString());
    }
}

