/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.com.google.common.cache.Cache;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.jet.sql.impl.expression.json.JsonPathUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import com.hazelcast.org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import com.hazelcast.org.jsfr.json.exception.JsonPathCompilerException;
import com.hazelcast.org.jsfr.json.path.JsonPath;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.VariExpression;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class JsonQueryFunction
extends VariExpression<HazelcastJsonValue>
implements IdentifiedDataSerializable {
    private static final ILogger LOGGER = Logger.getLogger(JsonQueryFunction.class);
    private final Cache<String, JsonPath> pathCache = JsonPathUtil.makePathCache();
    private SqlJsonQueryWrapperBehavior wrapperBehavior;
    private SqlJsonQueryEmptyOrErrorBehavior onEmpty;
    private SqlJsonQueryEmptyOrErrorBehavior onError;

    public JsonQueryFunction() {
    }

    private JsonQueryFunction(Expression<?>[] operands, SqlJsonQueryWrapperBehavior wrapperBehavior, SqlJsonQueryEmptyOrErrorBehavior onEmpty, SqlJsonQueryEmptyOrErrorBehavior onError) {
        super(operands);
        this.wrapperBehavior = wrapperBehavior;
        this.onEmpty = onEmpty;
        this.onError = onError;
    }

    public static JsonQueryFunction create(Expression<?> json, Expression<?> path, SqlJsonQueryWrapperBehavior wrapperBehavior, SqlJsonQueryEmptyOrErrorBehavior onEmpty, SqlJsonQueryEmptyOrErrorBehavior onError) {
        Expression[] operands = new Expression[]{json, path};
        return new JsonQueryFunction(operands, wrapperBehavior, onEmpty, onError);
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 0;
    }

    public HazelcastJsonValue eval(Row row, ExpressionEvalContext context) {
        JsonPath jsonPath;
        String json;
        String path = (String)this.operands[1].eval(row, context);
        if (path == null) {
            throw QueryException.error((String)"SQL/JSON path expression cannot be null");
        }
        Object operand0 = this.operands[0].eval(row, context);
        String string = json = operand0 instanceof HazelcastJsonValue ? operand0.toString() : (String)operand0;
        if (json == null) {
            json = "";
        }
        try {
            jsonPath = this.pathCache.asMap().computeIfAbsent(path, JsonPathUtil::compile);
        }
        catch (JsonPathCompilerException e) {
            LOGGER.fine("JSON_QUERY JsonPath compilation failed", (Throwable)e);
            throw QueryException.error((String)("Invalid SQL/JSON path expression: " + e.getMessage()));
        }
        return this.wrap(this.execute(json, jsonPath));
    }

    private String onErrorResponse(Exception exception) {
        switch (this.onError) {
            case ERROR: {
                LOGGER.fine("JSON_QUERY failed", (Throwable)exception);
                throw QueryException.error((String)("JSON_QUERY failed: " + exception));
            }
            case EMPTY_ARRAY: {
                return "[]";
            }
            case EMPTY_OBJECT: {
                return "{}";
            }
        }
        return null;
    }

    private String onEmptyResponse() {
        switch (this.onEmpty) {
            case ERROR: {
                throw QueryException.error((String)"JSON_QUERY evaluated to no value");
            }
            case EMPTY_ARRAY: {
                return "[]";
            }
            case EMPTY_OBJECT: {
                return "{}";
            }
        }
        return null;
    }

    private HazelcastJsonValue wrap(String json) {
        if (json == null) {
            return null;
        }
        return new HazelcastJsonValue(json);
    }

    private String execute(String json, JsonPath path) {
        Collection<Object> resultColl;
        try {
            resultColl = JsonPathUtil.read(json, path);
        }
        catch (Exception exception) {
            return this.onErrorResponse(exception);
        }
        if (resultColl.isEmpty()) {
            return this.onEmptyResponse();
        }
        switch (this.wrapperBehavior) {
            case WITH_CONDITIONAL_ARRAY: {
                return JsonPathUtil.wrapToArray(resultColl, false);
            }
            case WITH_UNCONDITIONAL_ARRAY: {
                return JsonPathUtil.wrapToArray(resultColl, true);
            }
        }
        if (resultColl.size() > 1) {
            throw QueryException.error((String)"JSON_QUERY evaluated to multiple values");
        }
        Object result = resultColl.iterator().next();
        return JsonPathUtil.serialize(result);
    }

    public QueryDataType getType() {
        return QueryDataType.JSON;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.wrapperBehavior.ordinal());
        out.writeInt(this.onEmpty.ordinal());
        out.writeInt(this.onError.ordinal());
    }

    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.wrapperBehavior = SqlJsonQueryWrapperBehavior.values()[in.readInt()];
        this.onEmpty = SqlJsonQueryEmptyOrErrorBehavior.values()[in.readInt()];
        this.onError = SqlJsonQueryEmptyOrErrorBehavior.values()[in.readInt()];
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.onEmpty, this.onError});
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JsonQueryFunction that = (JsonQueryFunction)((Object)o);
        return this.onEmpty.equals((Object)that.onEmpty) && this.onError.equals((Object)that.onError);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{operand=" + Arrays.toString(this.operands) + ", onEmpty=" + this.onEmpty.name() + ", onError=" + this.onError.name() + '}';
    }
}

