/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.com.google.common.cache.Cache;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.jet.sql.impl.expression.json.JsonPathUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import com.hazelcast.org.jsfr.json.exception.JsonPathCompilerException;
import com.hazelcast.org.jsfr.json.path.JsonPath;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.VariExpressionWithType;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class JsonValueFunction<T>
extends VariExpressionWithType<T>
implements IdentifiedDataSerializable {
    private static final ILogger LOGGER = Logger.getLogger(JsonValueFunction.class);
    private final Cache<String, JsonPath> pathCache = JsonPathUtil.makePathCache();
    private SqlJsonValueEmptyOrErrorBehavior onEmpty;
    private SqlJsonValueEmptyOrErrorBehavior onError;

    public JsonValueFunction() {
    }

    private JsonValueFunction(Expression<?>[] operands, QueryDataType resultType, SqlJsonValueEmptyOrErrorBehavior onEmpty, SqlJsonValueEmptyOrErrorBehavior onError) {
        super(operands, resultType);
        this.onEmpty = onEmpty;
        this.onError = onError;
    }

    public static JsonValueFunction<?> create(Expression<?> json, Expression<?> path, Expression<?> defaultValueOnEmpty, Expression<?> defaultValueOnError, QueryDataType resultType, SqlJsonValueEmptyOrErrorBehavior onEmpty, SqlJsonValueEmptyOrErrorBehavior onError) {
        Expression[] operands = new Expression[]{json, path, defaultValueOnEmpty, defaultValueOnError};
        return new JsonValueFunction(operands, resultType, onEmpty, onError);
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 2;
    }

    public T eval(Row row, ExpressionEvalContext context) {
        Collection<Object> resultColl;
        JsonPath jsonPath;
        String json;
        String path = (String)this.operands[1].eval(row, context);
        if (path == null) {
            throw QueryException.error((String)"SQL/JSON path expression cannot be null");
        }
        Object defaultOnEmpty = this.operands[2].eval(row, context);
        Object defaultOnError = this.operands[3].eval(row, context);
        Object operand0 = this.operands[0].eval(row, context);
        String string = json = operand0 instanceof HazelcastJsonValue ? operand0.toString() : (String)operand0;
        if (json == null) {
            json = "";
        }
        try {
            jsonPath = this.pathCache.asMap().computeIfAbsent(path, JsonPathUtil::compile);
        }
        catch (JsonPathCompilerException e) {
            LOGGER.fine("JSON_QUERY JsonPath compilation failed", (Throwable)e);
            throw QueryException.error((String)("Invalid SQL/JSON path expression: " + e.getMessage()));
        }
        try {
            resultColl = JsonPathUtil.read(json, jsonPath);
        }
        catch (Exception e) {
            return this.onErrorResponse(e, defaultOnError);
        }
        if (resultColl.isEmpty()) {
            return this.onEmptyResponse(defaultOnEmpty);
        }
        if (resultColl.size() > 1) {
            throw QueryException.error((String)"JSON_VALUE evaluated to multiple values");
        }
        Object onlyResult = resultColl.iterator().next();
        if (JsonPathUtil.isArrayOrObject(onlyResult)) {
            return this.onErrorResponse((Exception)((Object)QueryException.error((String)"Result of JSON_VALUE cannot be array or object")), defaultOnError);
        }
        Object result = this.convertResultType(onlyResult);
        return (T)result;
    }

    private T onEmptyResponse(Object defaultValue) {
        switch (this.onEmpty) {
            case ERROR: {
                throw QueryException.error((String)"JSON_VALUE evaluated to no value");
            }
            case DEFAULT: {
                return (T)defaultValue;
            }
        }
        return null;
    }

    private T onErrorResponse(Exception exception, Object defaultValue) {
        switch (this.onError) {
            case ERROR: {
                LOGGER.fine("JSON_VALUE failed", (Throwable)exception);
                throw QueryException.error((String)("JSON_VALUE failed: " + exception));
            }
            case DEFAULT: {
                return (T)defaultValue;
            }
        }
        return null;
    }

    private Object convertResultType(Object result) {
        if (result == null) {
            return null;
        }
        if (this.resultType.getTypeFamily().equals((Object)QueryDataTypeFamily.VARCHAR)) {
            return result.toString();
        }
        Converter converter = Converters.getConverter(result.getClass());
        switch (this.resultType.getTypeFamily().getPublicType()) {
            case TINYINT: {
                return converter.asTinyint(result);
            }
            case SMALLINT: {
                return converter.asSmallint(result);
            }
            case INTEGER: {
                return converter.asInt(result);
            }
            case BIGINT: {
                return converter.asBigint(result);
            }
            case REAL: {
                return Float.valueOf(converter.asReal(result));
            }
            case DOUBLE: {
                return converter.asDouble(result);
            }
            case DECIMAL: {
                return converter.asDecimal(result);
            }
            case TIMESTAMP: {
                return converter.asTimestamp(result);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return converter.asTimestampWithTimezone(result);
            }
            case DATE: {
                return converter.asDate(result);
            }
            case TIME: {
                return converter.asTime(result);
            }
        }
        return result;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeString(this.onEmpty.name());
        out.writeString(this.onError.name());
    }

    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.onEmpty = SqlJsonValueEmptyOrErrorBehavior.valueOf(in.readString());
        this.onError = SqlJsonValueEmptyOrErrorBehavior.valueOf(in.readString());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.onEmpty, this.onError);
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JsonValueFunction that = (JsonValueFunction)((Object)o);
        return this.onEmpty.equals(that.onEmpty) && this.onError.equals(that.onError);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{operand=" + Arrays.toString(this.operands) + ", resultType=" + this.resultType + ", onEmpty=" + this.onEmpty.name() + ", onError=" + this.onError.name() + '}';
    }
}

