/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.distribution.DistributionTrait;
import com.hazelcast.jet.sql.impl.opt.metadata.Boundedness;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMetadataQuery;
import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.jet.sql.impl.schema.HazelcastRelOptTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastJsonType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.plan.volcano.HazelcastRelSubsetUtil;
import com.hazelcast.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.org.apache.calcite.prepare.RelOptTableImpl;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexDynamicParam;
import com.hazelcast.org.apache.calcite.rex.RexFieldAccess;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexLocalRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class OptUtils {
    private OptUtils() {
    }

    public static RelTraitSet toLogicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, Conventions.LOGICAL);
    }

    public static RelNode toLogicalInput(RelNode rel) {
        return RelOptRule.convert(rel, OptUtils.toLogicalConvention(rel.getTraitSet()));
    }

    public static RelTraitSet toPhysicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, Conventions.PHYSICAL);
    }

    public static RelNode toPhysicalInput(RelNode rel) {
        return RelOptRule.convert(rel, OptUtils.toPhysicalConvention(rel.getTraitSet()));
    }

    public static RelTraitSet traitPlus(RelTraitSet traitSet, RelTrait trait) {
        return traitSet.plus(trait).simplify();
    }

    public static LogicalTableScan createLogicalScan(RelOptCluster cluster, HazelcastTable hazelcastTable) {
        JetTable table = (JetTable)((Object)hazelcastTable.getTarget());
        HazelcastRelOptTable relTable = OptUtils.createRelTable(table.getQualifiedName(), hazelcastTable, cluster.getTypeFactory());
        return LogicalTableScan.create(cluster, relTable, ImmutableList.of());
    }

    public static LogicalTableScan createLogicalScan(TableScan originalScan, HazelcastTable newHazelcastTable) {
        HazelcastRelOptTable originalRelTable = (HazelcastRelOptTable)originalScan.getTable();
        HazelcastRelOptTable newTable = OptUtils.createRelTable(originalRelTable, newHazelcastTable, originalScan.getCluster().getTypeFactory());
        return LogicalTableScan.create(originalScan.getCluster(), newTable, originalScan.getHints());
    }

    public static HazelcastRelOptTable createRelTable(List<String> names, HazelcastTable hazelcastTable, RelDataTypeFactory typeFactory) {
        RelDataType rowType = hazelcastTable.getRowType(typeFactory);
        RelOptTableImpl relTable = RelOptTableImpl.create(null, rowType, names, hazelcastTable, null);
        return new HazelcastRelOptTable(relTable);
    }

    public static HazelcastRelOptTable createRelTable(HazelcastRelOptTable originalRelTable, HazelcastTable newHazelcastTable, RelDataTypeFactory typeFactory) {
        RelOptTableImpl newTable = RelOptTableImpl.create(originalRelTable.getRelOptSchema(), newHazelcastTable.getRowType(typeFactory), originalRelTable.getDelegate().getQualifiedName(), newHazelcastTable, null);
        return new HazelcastRelOptTable(newTable);
    }

    public static Collection<RelNode> extractPhysicalRelsFromSubset(RelNode input) {
        return OptUtils.extractRelsFromSubset(input, OptUtils::isPhysical);
    }

    private static boolean isPhysical(RelNode rel) {
        return rel.getTraitSet().getTrait(ConventionTraitDef.INSTANCE).equals(Conventions.PHYSICAL);
    }

    public static Collection<RelNode> extractLogicalRelsFromSubset(RelNode input) {
        return OptUtils.extractRelsFromSubset(input, OptUtils::isLogical);
    }

    private static boolean isLogical(RelNode rel) {
        return rel.getTraitSet().getTrait(ConventionTraitDef.INSTANCE).equals(Conventions.LOGICAL);
    }

    private static Collection<RelNode> extractRelsFromSubset(RelNode input, Predicate<RelNode> predicate) {
        HashSet<RelTraitSet> traitSets = new HashSet<RelTraitSet>();
        Set<RelNode> res = Collections.newSetFromMap(new IdentityHashMap());
        for (RelNode relNode : HazelcastRelSubsetUtil.getSubsets(input)) {
            if (!predicate.test(relNode) || !traitSets.add(relNode.getTraitSet())) continue;
            res.add(relNode);
        }
        return res;
    }

    public static boolean isBounded(RelNode rel) {
        return OptUtils.metadataQuery(rel).extractBoundedness(rel) == Boundedness.BOUNDED;
    }

    public static boolean isUnbounded(RelNode rel) {
        return OptUtils.metadataQuery(rel).extractBoundedness(rel) == Boundedness.UNBOUNDED;
    }

    public static HazelcastRelMetadataQuery metadataQuery(RelNode rel) {
        return HazelcastRelMetadataQuery.reuseOrCreate(rel.getCluster().getMetadataQuery());
    }

    public static HazelcastRelOptCluster getCluster(RelNode rel) {
        assert (rel.getCluster() instanceof HazelcastRelOptCluster);
        return (HazelcastRelOptCluster)rel.getCluster();
    }

    public static DistributionTrait getDistribution(RelNode rel) {
        return rel.getTraitSet().getTrait(OptUtils.getCluster(rel).getDistributionTraitDef());
    }

    @Nullable
    public static <T> T findMatchingRel(RelNode node, RelOptRuleOperand operandPredicate) {
        if (node instanceof RelSubset) {
            RelNode res = null;
            for (RelNode rel : ((RelSubset)node).getRels()) {
                if (!operandPredicate.matches(rel)) continue;
                if (res != null) {
                    throw new RuntimeException("multiple matches found");
                }
                res = rel;
            }
            return (T)res;
        }
        if (operandPredicate.matches(node)) {
            return (T)node;
        }
        return null;
    }

    public static PlanNodeSchema schema(RelDataType rowType) {
        return new PlanNodeSchema(OptUtils.extractFieldTypes(rowType));
    }

    public static PlanNodeSchema schema(RelOptTable relTable) {
        Object table = relTable.unwrap(HazelcastTable.class).getTarget();
        return OptUtils.schema(table);
    }

    public static PlanNodeSchema schema(Table table) {
        ArrayList<QueryDataType> fieldTypes = new ArrayList<QueryDataType>();
        for (TableField field : table.getFields()) {
            fieldTypes.add(field.getType());
        }
        return new PlanNodeSchema(fieldTypes);
    }

    public static RexVisitor<Expression<?>> createRexToExpressionVisitor(PlanNodeFieldTypeProvider schema, QueryParameterMetadata parameterMetadata) {
        return new RexToExpressionVisitor(schema, parameterMetadata);
    }

    public static RelDataType convert(TableField field, RelDataTypeFactory typeFactory) {
        QueryDataType fieldType = field.getType();
        SqlTypeName sqlTypeName = HazelcastTypeUtils.toCalciteType(fieldType);
        if (sqlTypeName == null) {
            throw new IllegalStateException("Unsupported type family: " + fieldType + ", getSqlTypeName should never return null.");
        }
        if (sqlTypeName == SqlTypeName.OTHER) {
            return OptUtils.convertCustomType(fieldType);
        }
        RelDataType relType = typeFactory.createSqlType(sqlTypeName);
        return typeFactory.createTypeWithNullability(relType, true);
    }

    private static RelDataType convertCustomType(QueryDataType fieldType) {
        switch (fieldType.getTypeFamily()) {
            case JSON: {
                return HazelcastJsonType.create(true);
            }
        }
        throw new IllegalStateException("Unexpected type family: " + fieldType);
    }

    private static List<QueryDataType> extractFieldTypes(RelDataType rowType) {
        return Util.toList(rowType.getFieldList(), f -> HazelcastTypeUtils.toHazelcastType(f.getType()));
    }

    public static boolean requiresJob(RelNode rel) {
        return ((HazelcastRelOptCluster)rel.getCluster()).requiresJob();
    }

    public static boolean hasTableType(RelNode rel, Class<? extends Table> tableClass) {
        if (rel.getTable() == null) {
            return false;
        }
        HazelcastTable table = rel.getTable().unwrap(HazelcastTable.class);
        return table != null && tableClass.isAssignableFrom(table.getTarget().getClass());
    }

    public static HazelcastTable extractHazelcastTable(RelNode rel) {
        HazelcastTable table = rel.getTable().unwrap(HazelcastTable.class);
        assert (table != null);
        return table;
    }

    public static RexNode extractKeyConstantExpression(RelOptTable relTable, RexBuilder rexBuilder) {
        HazelcastTable table = relTable.unwrap(HazelcastTable.class);
        RexNode filter = table.getFilter();
        if (filter == null) {
            return null;
        }
        int keyIndex = OptUtils.findKeyIndex(table.getTarget());
        switch (filter.getKind()) {
            case INPUT_REF: {
                return ((RexInputRef)filter).getIndex() == keyIndex ? rexBuilder.makeLiteral(true) : null;
            }
            case NOT: {
                RexNode operand = ((RexCall)filter).getOperands().get(0);
                return operand.getKind() == SqlKind.INPUT_REF && ((RexInputRef)operand).getIndex() == keyIndex ? rexBuilder.makeLiteral(false) : null;
            }
            case EQUALS: {
                Tuple2<Integer, RexNode> constantExpressionByIndex = OptUtils.extractConstantExpression((RexCall)filter);
                return constantExpressionByIndex != null && (Integer)constantExpressionByIndex.getKey() == keyIndex ? (RexNode)constantExpressionByIndex.getValue() : null;
            }
        }
        return null;
    }

    private static int findKeyIndex(Table table) {
        List<String> primaryKey = SqlConnectorUtil.getJetSqlConnector(table).getPrimaryKey(table);
        assert (primaryKey.size() == 1);
        int keyIndex = table.getFieldIndex(primaryKey.get(0));
        assert (keyIndex > -1);
        return keyIndex;
    }

    private static Tuple2<Integer, RexNode> extractConstantExpression(RexCall condition) {
        Tuple2<Integer, RexNode> constantExpression = OptUtils.extractConstantExpression(condition, 0);
        return constantExpression != null ? constantExpression : OptUtils.extractConstantExpression(condition, 1);
    }

    private static Tuple2<Integer, RexNode> extractConstantExpression(RexCall condition, int i) {
        RexNode firstOperand = condition.getOperands().get(i);
        if (firstOperand.getKind() == SqlKind.INPUT_REF) {
            int index = ((RexInputRef)firstOperand).getIndex();
            RexNode secondOperand = condition.getOperands().get(1 - i);
            if (RexUtil.isConstant(secondOperand)) {
                return Tuple2.tuple2((Object)index, (Object)secondOperand);
            }
        }
        return null;
    }

    public static boolean hasInputRef(RexNode expression, final int ... indexes) {
        final boolean[] res = new boolean[]{false};
        expression.accept(new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                if (Util.arrayIndexOf((int)inputRef.getIndex(), (int[])indexes) >= 0) {
                    res[0] = true;
                }
                return null;
            }
        });
        return res[0];
    }

    public static RexNode inlineExpression(final List<RexNode> inlinedExpressions, RexNode expr) {
        return expr.accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                return (RexNode)inlinedExpressions.get(inputRef.getIndex());
            }

            @Override
            public RexNode visitLocalRef(RexLocalRef localRef) {
                return localRef;
            }

            @Override
            public RexNode visitCall(RexCall call) {
                ArrayList<RexNode> newOperands = new ArrayList<RexNode>(call.getOperands().size());
                for (RexNode operand : call.operands) {
                    newOperands.add(operand.accept(this));
                }
                return call.clone(call.type, newOperands);
            }

            @Override
            public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
                return dynamicParam;
            }

            @Override
            public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
                RexNode expr = fieldAccess.getReferenceExpr();
                RexNode newOperand = expr.accept(this);
                if (newOperand != fieldAccess.getReferenceExpr()) {
                    throw new RuntimeException("replacing partition key not supported");
                }
                return fieldAccess;
            }

            @Override
            public RexNode visitLiteral(RexLiteral literal) {
                return literal;
            }
        });
    }

    public static List<RexNode> inlineExpressions(List<RexNode> inlinedExpressions, List<RexNode> exprs) {
        ArrayList<RexNode> res = new ArrayList<RexNode>(exprs.size());
        for (RexNode expr : exprs) {
            res.add(OptUtils.inlineExpression(inlinedExpressions, expr));
        }
        return res;
    }
}

