/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.DeleteByKeyMapLogicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;

public final class DeleteByKeyMapLogicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new DeleteByKeyMapLogicalRule();

    private DeleteByKeyMapLogicalRule() {
        super(DeleteByKeyMapLogicalRule.operandJ(TableModify.class, null, modify -> !OptUtils.requiresJob(modify) && modify.isDelete(), DeleteByKeyMapLogicalRule.operandJ(TableScan.class, null, scan -> OptUtils.hasTableType(scan, PartitionedMapTable.class), DeleteByKeyMapLogicalRule.none()), new RelOptRuleOperand[0]), DeleteByKeyMapLogicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        TableModify delete = (TableModify)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        RelOptTable table = scan.getTable();
        RexNode keyCondition = OptUtils.extractKeyConstantExpression(table, delete.getCluster().getRexBuilder());
        if (keyCondition != null) {
            DeleteByKeyMapLogicalRel rel = new DeleteByKeyMapLogicalRel(delete.getCluster(), OptUtils.toLogicalConvention(delete.getTraitSet()), table, keyCondition);
            call.transformTo(rel);
        }
    }
}

