/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.SelectByKeyMapLogicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;

final class SelectByKeyMapLogicalRules {
    static final RelOptRule INSTANCE = new RelOptRule(RelOptRule.operandJ(TableScan.class, null, scan -> !OptUtils.requiresJob(scan) && OptUtils.hasTableType(scan, PartitionedMapTable.class), RelOptRule.none()), SelectByKeyMapLogicalRules.class.getSimpleName()){

        @Override
        public void onMatch(RelOptRuleCall call) {
            RexBuilder rexBuilder;
            TableScan scan = (TableScan)call.rel(0);
            RelOptTable table = scan.getTable();
            RexNode keyCondition = OptUtils.extractKeyConstantExpression(table, rexBuilder = scan.getCluster().getRexBuilder());
            if (keyCondition != null) {
                SelectByKeyMapLogicalRel rel = new SelectByKeyMapLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), scan.getRowType(), table, keyCondition, OptUtils.extractHazelcastTable(scan).getProjects());
                call.transformTo(rel);
            }
        }
    };

    private SelectByKeyMapLogicalRules() {
    }
}

